/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the configuration of a Amazon Bedrock knowledge base.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BedrockKnowledgeStoreConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<BedrockKnowledgeStoreConfiguration.Builder, BedrockKnowledgeStoreConfiguration> {
    private static final SdkField<String> BEDROCK_KNOWLEDGE_BASE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bedrockKnowledgeBaseArn").getter(getter(BedrockKnowledgeStoreConfiguration::bedrockKnowledgeBaseArn))
            .setter(setter(Builder::bedrockKnowledgeBaseArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bedrockKnowledgeBaseArn").build())
            .build();

    private static final SdkField<Boolean> EXACT_RESPONSE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("exactResponse").getter(getter(BedrockKnowledgeStoreConfiguration::exactResponse))
            .setter(setter(Builder::exactResponse))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exactResponse").build()).build();

    private static final SdkField<BedrockKnowledgeStoreExactResponseFields> EXACT_RESPONSE_FIELDS_FIELD = SdkField
            .<BedrockKnowledgeStoreExactResponseFields> builder(MarshallingType.SDK_POJO).memberName("exactResponseFields")
            .getter(getter(BedrockKnowledgeStoreConfiguration::exactResponseFields)).setter(setter(Builder::exactResponseFields))
            .constructor(BedrockKnowledgeStoreExactResponseFields::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exactResponseFields").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            BEDROCK_KNOWLEDGE_BASE_ARN_FIELD, EXACT_RESPONSE_FIELD, EXACT_RESPONSE_FIELDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String bedrockKnowledgeBaseArn;

    private final Boolean exactResponse;

    private final BedrockKnowledgeStoreExactResponseFields exactResponseFields;

    private BedrockKnowledgeStoreConfiguration(BuilderImpl builder) {
        this.bedrockKnowledgeBaseArn = builder.bedrockKnowledgeBaseArn;
        this.exactResponse = builder.exactResponse;
        this.exactResponseFields = builder.exactResponseFields;
    }

    /**
     * <p>
     * The base ARN of the knowledge base used.
     * </p>
     * 
     * @return The base ARN of the knowledge base used.
     */
    public final String bedrockKnowledgeBaseArn() {
        return bedrockKnowledgeBaseArn;
    }

    /**
     * <p>
     * Specifies whether to return an exact response, or to return an answer generated by the model, using the fields
     * you specify from the database.
     * </p>
     * 
     * @return Specifies whether to return an exact response, or to return an answer generated by the model, using the
     *         fields you specify from the database.
     */
    public final Boolean exactResponse() {
        return exactResponse;
    }

    /**
     * <p>
     * Contains the names of the fields used for an exact response to the user.
     * </p>
     * 
     * @return Contains the names of the fields used for an exact response to the user.
     */
    public final BedrockKnowledgeStoreExactResponseFields exactResponseFields() {
        return exactResponseFields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bedrockKnowledgeBaseArn());
        hashCode = 31 * hashCode + Objects.hashCode(exactResponse());
        hashCode = 31 * hashCode + Objects.hashCode(exactResponseFields());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BedrockKnowledgeStoreConfiguration)) {
            return false;
        }
        BedrockKnowledgeStoreConfiguration other = (BedrockKnowledgeStoreConfiguration) obj;
        return Objects.equals(bedrockKnowledgeBaseArn(), other.bedrockKnowledgeBaseArn())
                && Objects.equals(exactResponse(), other.exactResponse())
                && Objects.equals(exactResponseFields(), other.exactResponseFields());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BedrockKnowledgeStoreConfiguration").add("BedrockKnowledgeBaseArn", bedrockKnowledgeBaseArn())
                .add("ExactResponse", exactResponse()).add("ExactResponseFields", exactResponseFields()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bedrockKnowledgeBaseArn":
            return Optional.ofNullable(clazz.cast(bedrockKnowledgeBaseArn()));
        case "exactResponse":
            return Optional.ofNullable(clazz.cast(exactResponse()));
        case "exactResponseFields":
            return Optional.ofNullable(clazz.cast(exactResponseFields()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("bedrockKnowledgeBaseArn", BEDROCK_KNOWLEDGE_BASE_ARN_FIELD);
        map.put("exactResponse", EXACT_RESPONSE_FIELD);
        map.put("exactResponseFields", EXACT_RESPONSE_FIELDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BedrockKnowledgeStoreConfiguration, T> g) {
        return obj -> g.apply((BedrockKnowledgeStoreConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BedrockKnowledgeStoreConfiguration> {
        /**
         * <p>
         * The base ARN of the knowledge base used.
         * </p>
         * 
         * @param bedrockKnowledgeBaseArn
         *        The base ARN of the knowledge base used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bedrockKnowledgeBaseArn(String bedrockKnowledgeBaseArn);

        /**
         * <p>
         * Specifies whether to return an exact response, or to return an answer generated by the model, using the
         * fields you specify from the database.
         * </p>
         * 
         * @param exactResponse
         *        Specifies whether to return an exact response, or to return an answer generated by the model, using
         *        the fields you specify from the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exactResponse(Boolean exactResponse);

        /**
         * <p>
         * Contains the names of the fields used for an exact response to the user.
         * </p>
         * 
         * @param exactResponseFields
         *        Contains the names of the fields used for an exact response to the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exactResponseFields(BedrockKnowledgeStoreExactResponseFields exactResponseFields);

        /**
         * <p>
         * Contains the names of the fields used for an exact response to the user.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link BedrockKnowledgeStoreExactResponseFields.Builder} avoiding the need to create one manually via
         * {@link BedrockKnowledgeStoreExactResponseFields#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BedrockKnowledgeStoreExactResponseFields.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #exactResponseFields(BedrockKnowledgeStoreExactResponseFields)}.
         * 
         * @param exactResponseFields
         *        a consumer that will call methods on {@link BedrockKnowledgeStoreExactResponseFields.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exactResponseFields(BedrockKnowledgeStoreExactResponseFields)
         */
        default Builder exactResponseFields(Consumer<BedrockKnowledgeStoreExactResponseFields.Builder> exactResponseFields) {
            return exactResponseFields(BedrockKnowledgeStoreExactResponseFields.builder().applyMutation(exactResponseFields)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String bedrockKnowledgeBaseArn;

        private Boolean exactResponse;

        private BedrockKnowledgeStoreExactResponseFields exactResponseFields;

        private BuilderImpl() {
        }

        private BuilderImpl(BedrockKnowledgeStoreConfiguration model) {
            bedrockKnowledgeBaseArn(model.bedrockKnowledgeBaseArn);
            exactResponse(model.exactResponse);
            exactResponseFields(model.exactResponseFields);
        }

        public final String getBedrockKnowledgeBaseArn() {
            return bedrockKnowledgeBaseArn;
        }

        public final void setBedrockKnowledgeBaseArn(String bedrockKnowledgeBaseArn) {
            this.bedrockKnowledgeBaseArn = bedrockKnowledgeBaseArn;
        }

        @Override
        public final Builder bedrockKnowledgeBaseArn(String bedrockKnowledgeBaseArn) {
            this.bedrockKnowledgeBaseArn = bedrockKnowledgeBaseArn;
            return this;
        }

        public final Boolean getExactResponse() {
            return exactResponse;
        }

        public final void setExactResponse(Boolean exactResponse) {
            this.exactResponse = exactResponse;
        }

        @Override
        public final Builder exactResponse(Boolean exactResponse) {
            this.exactResponse = exactResponse;
            return this;
        }

        public final BedrockKnowledgeStoreExactResponseFields.Builder getExactResponseFields() {
            return exactResponseFields != null ? exactResponseFields.toBuilder() : null;
        }

        public final void setExactResponseFields(BedrockKnowledgeStoreExactResponseFields.BuilderImpl exactResponseFields) {
            this.exactResponseFields = exactResponseFields != null ? exactResponseFields.build() : null;
        }

        @Override
        public final Builder exactResponseFields(BedrockKnowledgeStoreExactResponseFields exactResponseFields) {
            this.exactResponseFields = exactResponseFields;
            return this;
        }

        @Override
        public BedrockKnowledgeStoreConfiguration build() {
            return new BedrockKnowledgeStoreConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
