/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains summary information about all the replication statuses applicable for global resiliency.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BotReplicaSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<BotReplicaSummary.Builder, BotReplicaSummary> {
    private static final SdkField<String> REPLICA_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("replicaRegion").getter(getter(BotReplicaSummary::replicaRegion)).setter(setter(Builder::replicaRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicaRegion").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(BotReplicaSummary::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<String> BOT_REPLICA_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botReplicaStatus").getter(getter(BotReplicaSummary::botReplicaStatusAsString))
            .setter(setter(Builder::botReplicaStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botReplicaStatus").build()).build();

    private static final SdkField<List<String>> FAILURE_REASONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("failureReasons")
            .getter(getter(BotReplicaSummary::failureReasons))
            .setter(setter(Builder::failureReasons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICA_REGION_FIELD,
            CREATION_DATE_TIME_FIELD, BOT_REPLICA_STATUS_FIELD, FAILURE_REASONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String replicaRegion;

    private final Instant creationDateTime;

    private final String botReplicaStatus;

    private final List<String> failureReasons;

    private BotReplicaSummary(BuilderImpl builder) {
        this.replicaRegion = builder.replicaRegion;
        this.creationDateTime = builder.creationDateTime;
        this.botReplicaStatus = builder.botReplicaStatus;
        this.failureReasons = builder.failureReasons;
    }

    /**
     * <p>
     * The replica region used in the replication statuses summary.
     * </p>
     * 
     * @return The replica region used in the replication statuses summary.
     */
    public final String replicaRegion() {
        return replicaRegion;
    }

    /**
     * <p>
     * The creation time and date for the replicated bots.
     * </p>
     * 
     * @return The creation time and date for the replicated bots.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The operation status for the replicated bot applicable.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botReplicaStatus}
     * will return {@link BotReplicaStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #botReplicaStatusAsString}.
     * </p>
     * 
     * @return The operation status for the replicated bot applicable.
     * @see BotReplicaStatus
     */
    public final BotReplicaStatus botReplicaStatus() {
        return BotReplicaStatus.fromValue(botReplicaStatus);
    }

    /**
     * <p>
     * The operation status for the replicated bot applicable.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botReplicaStatus}
     * will return {@link BotReplicaStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #botReplicaStatusAsString}.
     * </p>
     * 
     * @return The operation status for the replicated bot applicable.
     * @see BotReplicaStatus
     */
    public final String botReplicaStatusAsString() {
        return botReplicaStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailureReasons property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFailureReasons() {
        return failureReasons != null && !(failureReasons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The reasons for the failure for the replicated bot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailureReasons} method.
     * </p>
     * 
     * @return The reasons for the failure for the replicated bot.
     */
    public final List<String> failureReasons() {
        return failureReasons;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(replicaRegion());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(botReplicaStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasFailureReasons() ? failureReasons() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BotReplicaSummary)) {
            return false;
        }
        BotReplicaSummary other = (BotReplicaSummary) obj;
        return Objects.equals(replicaRegion(), other.replicaRegion())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(botReplicaStatusAsString(), other.botReplicaStatusAsString())
                && hasFailureReasons() == other.hasFailureReasons() && Objects.equals(failureReasons(), other.failureReasons());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BotReplicaSummary").add("ReplicaRegion", replicaRegion())
                .add("CreationDateTime", creationDateTime()).add("BotReplicaStatus", botReplicaStatusAsString())
                .add("FailureReasons", hasFailureReasons() ? failureReasons() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "replicaRegion":
            return Optional.ofNullable(clazz.cast(replicaRegion()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "botReplicaStatus":
            return Optional.ofNullable(clazz.cast(botReplicaStatusAsString()));
        case "failureReasons":
            return Optional.ofNullable(clazz.cast(failureReasons()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("replicaRegion", REPLICA_REGION_FIELD);
        map.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        map.put("botReplicaStatus", BOT_REPLICA_STATUS_FIELD);
        map.put("failureReasons", FAILURE_REASONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BotReplicaSummary, T> g) {
        return obj -> g.apply((BotReplicaSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BotReplicaSummary> {
        /**
         * <p>
         * The replica region used in the replication statuses summary.
         * </p>
         * 
         * @param replicaRegion
         *        The replica region used in the replication statuses summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaRegion(String replicaRegion);

        /**
         * <p>
         * The creation time and date for the replicated bots.
         * </p>
         * 
         * @param creationDateTime
         *        The creation time and date for the replicated bots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The operation status for the replicated bot applicable.
         * </p>
         * 
         * @param botReplicaStatus
         *        The operation status for the replicated bot applicable.
         * @see BotReplicaStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotReplicaStatus
         */
        Builder botReplicaStatus(String botReplicaStatus);

        /**
         * <p>
         * The operation status for the replicated bot applicable.
         * </p>
         * 
         * @param botReplicaStatus
         *        The operation status for the replicated bot applicable.
         * @see BotReplicaStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotReplicaStatus
         */
        Builder botReplicaStatus(BotReplicaStatus botReplicaStatus);

        /**
         * <p>
         * The reasons for the failure for the replicated bot.
         * </p>
         * 
         * @param failureReasons
         *        The reasons for the failure for the replicated bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReasons(Collection<String> failureReasons);

        /**
         * <p>
         * The reasons for the failure for the replicated bot.
         * </p>
         * 
         * @param failureReasons
         *        The reasons for the failure for the replicated bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReasons(String... failureReasons);
    }

    static final class BuilderImpl implements Builder {
        private String replicaRegion;

        private Instant creationDateTime;

        private String botReplicaStatus;

        private List<String> failureReasons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BotReplicaSummary model) {
            replicaRegion(model.replicaRegion);
            creationDateTime(model.creationDateTime);
            botReplicaStatus(model.botReplicaStatus);
            failureReasons(model.failureReasons);
        }

        public final String getReplicaRegion() {
            return replicaRegion;
        }

        public final void setReplicaRegion(String replicaRegion) {
            this.replicaRegion = replicaRegion;
        }

        @Override
        public final Builder replicaRegion(String replicaRegion) {
            this.replicaRegion = replicaRegion;
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final String getBotReplicaStatus() {
            return botReplicaStatus;
        }

        public final void setBotReplicaStatus(String botReplicaStatus) {
            this.botReplicaStatus = botReplicaStatus;
        }

        @Override
        public final Builder botReplicaStatus(String botReplicaStatus) {
            this.botReplicaStatus = botReplicaStatus;
            return this;
        }

        @Override
        public final Builder botReplicaStatus(BotReplicaStatus botReplicaStatus) {
            this.botReplicaStatus(botReplicaStatus == null ? null : botReplicaStatus.toString());
            return this;
        }

        public final Collection<String> getFailureReasons() {
            if (failureReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return failureReasons;
        }

        public final void setFailureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
        }

        @Override
        public final Builder failureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failureReasons(String... failureReasons) {
            failureReasons(Arrays.asList(failureReasons));
            return this;
        }

        @Override
        public BotReplicaSummary build() {
            return new BotReplicaSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
