/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides summary information about a built-in intent for the <a
 * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListBuiltInIntents.html"> ListBuiltInIntents </a>
 * operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BuiltInIntentSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<BuiltInIntentSummary.Builder, BuiltInIntentSummary> {
    private static final SdkField<String> INTENT_SIGNATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("intentSignature").getter(getter(BuiltInIntentSummary::intentSignature))
            .setter(setter(Builder::intentSignature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentSignature").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(BuiltInIntentSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTENT_SIGNATURE_FIELD,
            DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String intentSignature;

    private final String description;

    private BuiltInIntentSummary(BuilderImpl builder) {
        this.intentSignature = builder.intentSignature;
        this.description = builder.description;
    }

    /**
     * <p>
     * The signature of the built-in intent. Use this to specify the parent intent of a derived intent.
     * </p>
     * 
     * @return The signature of the built-in intent. Use this to specify the parent intent of a derived intent.
     */
    public final String intentSignature() {
        return intentSignature;
    }

    /**
     * <p>
     * The description of the intent.
     * </p>
     * 
     * @return The description of the intent.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(intentSignature());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BuiltInIntentSummary)) {
            return false;
        }
        BuiltInIntentSummary other = (BuiltInIntentSummary) obj;
        return Objects.equals(intentSignature(), other.intentSignature()) && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BuiltInIntentSummary").add("IntentSignature", intentSignature())
                .add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "intentSignature":
            return Optional.ofNullable(clazz.cast(intentSignature()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("intentSignature", INTENT_SIGNATURE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BuiltInIntentSummary, T> g) {
        return obj -> g.apply((BuiltInIntentSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BuiltInIntentSummary> {
        /**
         * <p>
         * The signature of the built-in intent. Use this to specify the parent intent of a derived intent.
         * </p>
         * 
         * @param intentSignature
         *        The signature of the built-in intent. Use this to specify the parent intent of a derived intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentSignature(String intentSignature);

        /**
         * <p>
         * The description of the intent.
         * </p>
         * 
         * @param description
         *        The description of the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String intentSignature;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(BuiltInIntentSummary model) {
            intentSignature(model.intentSignature);
            description(model.description);
        }

        public final String getIntentSignature() {
            return intentSignature;
        }

        public final void setIntentSignature(String intentSignature) {
            this.intentSignature = intentSignature;
        }

        @Override
        public final Builder intentSignature(String intentSignature) {
            this.intentSignature = intentSignature;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public BuiltInIntentSummary build() {
            return new BuiltInIntentSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
