/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings that specify the dialog code hook that is called by Amazon Lex at a step of the conversation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DialogCodeHookInvocationSetting implements SdkPojo, Serializable,
        ToCopyableBuilder<DialogCodeHookInvocationSetting.Builder, DialogCodeHookInvocationSetting> {
    private static final SdkField<Boolean> ENABLE_CODE_HOOK_INVOCATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("enableCodeHookInvocation")
            .getter(getter(DialogCodeHookInvocationSetting::enableCodeHookInvocation))
            .setter(setter(Builder::enableCodeHookInvocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableCodeHookInvocation").build())
            .build();

    private static final SdkField<Boolean> ACTIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("active").getter(getter(DialogCodeHookInvocationSetting::active)).setter(setter(Builder::active))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("active").build()).build();

    private static final SdkField<String> INVOCATION_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("invocationLabel").getter(getter(DialogCodeHookInvocationSetting::invocationLabel))
            .setter(setter(Builder::invocationLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationLabel").build()).build();

    private static final SdkField<PostDialogCodeHookInvocationSpecification> POST_CODE_HOOK_SPECIFICATION_FIELD = SdkField
            .<PostDialogCodeHookInvocationSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("postCodeHookSpecification").getter(getter(DialogCodeHookInvocationSetting::postCodeHookSpecification))
            .setter(setter(Builder::postCodeHookSpecification)).constructor(PostDialogCodeHookInvocationSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postCodeHookSpecification").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ENABLE_CODE_HOOK_INVOCATION_FIELD, ACTIVE_FIELD, INVOCATION_LABEL_FIELD, POST_CODE_HOOK_SPECIFICATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enableCodeHookInvocation;

    private final Boolean active;

    private final String invocationLabel;

    private final PostDialogCodeHookInvocationSpecification postCodeHookSpecification;

    private DialogCodeHookInvocationSetting(BuilderImpl builder) {
        this.enableCodeHookInvocation = builder.enableCodeHookInvocation;
        this.active = builder.active;
        this.invocationLabel = builder.invocationLabel;
        this.postCodeHookSpecification = builder.postCodeHookSpecification;
    }

    /**
     * <p>
     * Indicates whether a Lambda function should be invoked for the dialog.
     * </p>
     * 
     * @return Indicates whether a Lambda function should be invoked for the dialog.
     */
    public final Boolean enableCodeHookInvocation() {
        return enableCodeHookInvocation;
    }

    /**
     * <p>
     * Determines whether a dialog code hook is used when the intent is activated.
     * </p>
     * 
     * @return Determines whether a dialog code hook is used when the intent is activated.
     */
    public final Boolean active() {
        return active;
    }

    /**
     * <p>
     * A label that indicates the dialog step from which the dialog code hook is happening.
     * </p>
     * 
     * @return A label that indicates the dialog step from which the dialog code hook is happening.
     */
    public final String invocationLabel() {
        return invocationLabel;
    }

    /**
     * <p>
     * Contains the responses and actions that Amazon Lex takes after the Lambda function is complete.
     * </p>
     * 
     * @return Contains the responses and actions that Amazon Lex takes after the Lambda function is complete.
     */
    public final PostDialogCodeHookInvocationSpecification postCodeHookSpecification() {
        return postCodeHookSpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enableCodeHookInvocation());
        hashCode = 31 * hashCode + Objects.hashCode(active());
        hashCode = 31 * hashCode + Objects.hashCode(invocationLabel());
        hashCode = 31 * hashCode + Objects.hashCode(postCodeHookSpecification());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DialogCodeHookInvocationSetting)) {
            return false;
        }
        DialogCodeHookInvocationSetting other = (DialogCodeHookInvocationSetting) obj;
        return Objects.equals(enableCodeHookInvocation(), other.enableCodeHookInvocation())
                && Objects.equals(active(), other.active()) && Objects.equals(invocationLabel(), other.invocationLabel())
                && Objects.equals(postCodeHookSpecification(), other.postCodeHookSpecification());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DialogCodeHookInvocationSetting").add("EnableCodeHookInvocation", enableCodeHookInvocation())
                .add("Active", active()).add("InvocationLabel", invocationLabel())
                .add("PostCodeHookSpecification", postCodeHookSpecification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enableCodeHookInvocation":
            return Optional.ofNullable(clazz.cast(enableCodeHookInvocation()));
        case "active":
            return Optional.ofNullable(clazz.cast(active()));
        case "invocationLabel":
            return Optional.ofNullable(clazz.cast(invocationLabel()));
        case "postCodeHookSpecification":
            return Optional.ofNullable(clazz.cast(postCodeHookSpecification()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("enableCodeHookInvocation", ENABLE_CODE_HOOK_INVOCATION_FIELD);
        map.put("active", ACTIVE_FIELD);
        map.put("invocationLabel", INVOCATION_LABEL_FIELD);
        map.put("postCodeHookSpecification", POST_CODE_HOOK_SPECIFICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DialogCodeHookInvocationSetting, T> g) {
        return obj -> g.apply((DialogCodeHookInvocationSetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DialogCodeHookInvocationSetting> {
        /**
         * <p>
         * Indicates whether a Lambda function should be invoked for the dialog.
         * </p>
         * 
         * @param enableCodeHookInvocation
         *        Indicates whether a Lambda function should be invoked for the dialog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableCodeHookInvocation(Boolean enableCodeHookInvocation);

        /**
         * <p>
         * Determines whether a dialog code hook is used when the intent is activated.
         * </p>
         * 
         * @param active
         *        Determines whether a dialog code hook is used when the intent is activated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder active(Boolean active);

        /**
         * <p>
         * A label that indicates the dialog step from which the dialog code hook is happening.
         * </p>
         * 
         * @param invocationLabel
         *        A label that indicates the dialog step from which the dialog code hook is happening.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationLabel(String invocationLabel);

        /**
         * <p>
         * Contains the responses and actions that Amazon Lex takes after the Lambda function is complete.
         * </p>
         * 
         * @param postCodeHookSpecification
         *        Contains the responses and actions that Amazon Lex takes after the Lambda function is complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postCodeHookSpecification(PostDialogCodeHookInvocationSpecification postCodeHookSpecification);

        /**
         * <p>
         * Contains the responses and actions that Amazon Lex takes after the Lambda function is complete.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PostDialogCodeHookInvocationSpecification.Builder} avoiding the need to create one manually via
         * {@link PostDialogCodeHookInvocationSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PostDialogCodeHookInvocationSpecification.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #postCodeHookSpecification(PostDialogCodeHookInvocationSpecification)}.
         * 
         * @param postCodeHookSpecification
         *        a consumer that will call methods on {@link PostDialogCodeHookInvocationSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #postCodeHookSpecification(PostDialogCodeHookInvocationSpecification)
         */
        default Builder postCodeHookSpecification(
                Consumer<PostDialogCodeHookInvocationSpecification.Builder> postCodeHookSpecification) {
            return postCodeHookSpecification(PostDialogCodeHookInvocationSpecification.builder()
                    .applyMutation(postCodeHookSpecification).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean enableCodeHookInvocation;

        private Boolean active;

        private String invocationLabel;

        private PostDialogCodeHookInvocationSpecification postCodeHookSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(DialogCodeHookInvocationSetting model) {
            enableCodeHookInvocation(model.enableCodeHookInvocation);
            active(model.active);
            invocationLabel(model.invocationLabel);
            postCodeHookSpecification(model.postCodeHookSpecification);
        }

        public final Boolean getEnableCodeHookInvocation() {
            return enableCodeHookInvocation;
        }

        public final void setEnableCodeHookInvocation(Boolean enableCodeHookInvocation) {
            this.enableCodeHookInvocation = enableCodeHookInvocation;
        }

        @Override
        public final Builder enableCodeHookInvocation(Boolean enableCodeHookInvocation) {
            this.enableCodeHookInvocation = enableCodeHookInvocation;
            return this;
        }

        public final Boolean getActive() {
            return active;
        }

        public final void setActive(Boolean active) {
            this.active = active;
        }

        @Override
        public final Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public final String getInvocationLabel() {
            return invocationLabel;
        }

        public final void setInvocationLabel(String invocationLabel) {
            this.invocationLabel = invocationLabel;
        }

        @Override
        public final Builder invocationLabel(String invocationLabel) {
            this.invocationLabel = invocationLabel;
            return this;
        }

        public final PostDialogCodeHookInvocationSpecification.Builder getPostCodeHookSpecification() {
            return postCodeHookSpecification != null ? postCodeHookSpecification.toBuilder() : null;
        }

        public final void setPostCodeHookSpecification(
                PostDialogCodeHookInvocationSpecification.BuilderImpl postCodeHookSpecification) {
            this.postCodeHookSpecification = postCodeHookSpecification != null ? postCodeHookSpecification.build() : null;
        }

        @Override
        public final Builder postCodeHookSpecification(PostDialogCodeHookInvocationSpecification postCodeHookSpecification) {
            this.postCodeHookSpecification = postCodeHookSpecification;
            return this;
        }

        @Override
        public DialogCodeHookInvocationSetting build() {
            return new DialogCodeHookInvocationSetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
