/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The object that contains transcript filter details that are associated with a bot recommendation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LexTranscriptFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<LexTranscriptFilter.Builder, LexTranscriptFilter> {
    private static final SdkField<DateRangeFilter> DATE_RANGE_FILTER_FIELD = SdkField
            .<DateRangeFilter> builder(MarshallingType.SDK_POJO).memberName("dateRangeFilter")
            .getter(getter(LexTranscriptFilter::dateRangeFilter)).setter(setter(Builder::dateRangeFilter))
            .constructor(DateRangeFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateRangeFilter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATE_RANGE_FILTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DateRangeFilter dateRangeFilter;

    private LexTranscriptFilter(BuilderImpl builder) {
        this.dateRangeFilter = builder.dateRangeFilter;
    }

    /**
     * <p>
     * The object that contains a date range filter that will be applied to the transcript. Specify this object if you
     * want Amazon Lex to only read the files that are within the date range.
     * </p>
     * 
     * @return The object that contains a date range filter that will be applied to the transcript. Specify this object
     *         if you want Amazon Lex to only read the files that are within the date range.
     */
    public final DateRangeFilter dateRangeFilter() {
        return dateRangeFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dateRangeFilter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LexTranscriptFilter)) {
            return false;
        }
        LexTranscriptFilter other = (LexTranscriptFilter) obj;
        return Objects.equals(dateRangeFilter(), other.dateRangeFilter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LexTranscriptFilter").add("DateRangeFilter", dateRangeFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dateRangeFilter":
            return Optional.ofNullable(clazz.cast(dateRangeFilter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dateRangeFilter", DATE_RANGE_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LexTranscriptFilter, T> g) {
        return obj -> g.apply((LexTranscriptFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LexTranscriptFilter> {
        /**
         * <p>
         * The object that contains a date range filter that will be applied to the transcript. Specify this object if
         * you want Amazon Lex to only read the files that are within the date range.
         * </p>
         * 
         * @param dateRangeFilter
         *        The object that contains a date range filter that will be applied to the transcript. Specify this
         *        object if you want Amazon Lex to only read the files that are within the date range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateRangeFilter(DateRangeFilter dateRangeFilter);

        /**
         * <p>
         * The object that contains a date range filter that will be applied to the transcript. Specify this object if
         * you want Amazon Lex to only read the files that are within the date range.
         * </p>
         * This is a convenience method that creates an instance of the {@link DateRangeFilter.Builder} avoiding the
         * need to create one manually via {@link DateRangeFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DateRangeFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #dateRangeFilter(DateRangeFilter)}.
         * 
         * @param dateRangeFilter
         *        a consumer that will call methods on {@link DateRangeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dateRangeFilter(DateRangeFilter)
         */
        default Builder dateRangeFilter(Consumer<DateRangeFilter.Builder> dateRangeFilter) {
            return dateRangeFilter(DateRangeFilter.builder().applyMutation(dateRangeFilter).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DateRangeFilter dateRangeFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(LexTranscriptFilter model) {
            dateRangeFilter(model.dateRangeFilter);
        }

        public final DateRangeFilter.Builder getDateRangeFilter() {
            return dateRangeFilter != null ? dateRangeFilter.toBuilder() : null;
        }

        public final void setDateRangeFilter(DateRangeFilter.BuilderImpl dateRangeFilter) {
            this.dateRangeFilter = dateRangeFilter != null ? dateRangeFilter.build() : null;
        }

        @Override
        public final Builder dateRangeFilter(DateRangeFilter dateRangeFilter) {
            this.dateRangeFilter = dateRangeFilter;
            return this;
        }

        @Override
        public LexTranscriptFilter build() {
            return new LexTranscriptFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
