/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the overall results for a test execution result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OverallTestResultItem implements SdkPojo, Serializable,
        ToCopyableBuilder<OverallTestResultItem.Builder, OverallTestResultItem> {
    private static final SdkField<Boolean> MULTI_TURN_CONVERSATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("multiTurnConversation").getter(getter(OverallTestResultItem::multiTurnConversation))
            .setter(setter(Builder::multiTurnConversation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiTurnConversation").build())
            .build();

    private static final SdkField<Integer> TOTAL_RESULT_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalResultCount").getter(getter(OverallTestResultItem::totalResultCount))
            .setter(setter(Builder::totalResultCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalResultCount").build()).build();

    private static final SdkField<Map<String, Integer>> SPEECH_TRANSCRIPTION_RESULT_COUNTS_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("speechTranscriptionResultCounts")
            .getter(getter(OverallTestResultItem::speechTranscriptionResultCountsAsStrings))
            .setter(setter(Builder::speechTranscriptionResultCountsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("speechTranscriptionResultCounts")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, Integer>> END_TO_END_RESULT_COUNTS_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("endToEndResultCounts")
            .getter(getter(OverallTestResultItem::endToEndResultCountsAsStrings))
            .setter(setter(Builder::endToEndResultCountsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endToEndResultCounts").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MULTI_TURN_CONVERSATION_FIELD,
            TOTAL_RESULT_COUNT_FIELD, SPEECH_TRANSCRIPTION_RESULT_COUNTS_FIELD, END_TO_END_RESULT_COUNTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean multiTurnConversation;

    private final Integer totalResultCount;

    private final Map<String, Integer> speechTranscriptionResultCounts;

    private final Map<String, Integer> endToEndResultCounts;

    private OverallTestResultItem(BuilderImpl builder) {
        this.multiTurnConversation = builder.multiTurnConversation;
        this.totalResultCount = builder.totalResultCount;
        this.speechTranscriptionResultCounts = builder.speechTranscriptionResultCounts;
        this.endToEndResultCounts = builder.endToEndResultCounts;
    }

    /**
     * <p>
     * Indicates whether the conversation contains multiple turns or not.
     * </p>
     * 
     * @return Indicates whether the conversation contains multiple turns or not.
     */
    public final Boolean multiTurnConversation() {
        return multiTurnConversation;
    }

    /**
     * <p>
     * The total number of overall results in the result of the test execution.
     * </p>
     * 
     * @return The total number of overall results in the result of the test execution.
     */
    public final Integer totalResultCount() {
        return totalResultCount;
    }

    /**
     * <p>
     * The number of speech transcription results in the overall test.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSpeechTranscriptionResultCounts}
     * method.
     * </p>
     * 
     * @return The number of speech transcription results in the overall test.
     */
    public final Map<TestResultMatchStatus, Integer> speechTranscriptionResultCounts() {
        return TestResultMatchStatusCountMapCopier.copyStringToEnum(speechTranscriptionResultCounts);
    }

    /**
     * For responses, this returns true if the service returned a value for the SpeechTranscriptionResultCounts
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasSpeechTranscriptionResultCounts() {
        return speechTranscriptionResultCounts != null && !(speechTranscriptionResultCounts instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The number of speech transcription results in the overall test.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSpeechTranscriptionResultCounts}
     * method.
     * </p>
     * 
     * @return The number of speech transcription results in the overall test.
     */
    public final Map<String, Integer> speechTranscriptionResultCountsAsStrings() {
        return speechTranscriptionResultCounts;
    }

    /**
     * <p>
     * The number of results that succeeded.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEndToEndResultCounts} method.
     * </p>
     * 
     * @return The number of results that succeeded.
     */
    public final Map<TestResultMatchStatus, Integer> endToEndResultCounts() {
        return TestResultMatchStatusCountMapCopier.copyStringToEnum(endToEndResultCounts);
    }

    /**
     * For responses, this returns true if the service returned a value for the EndToEndResultCounts property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEndToEndResultCounts() {
        return endToEndResultCounts != null && !(endToEndResultCounts instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The number of results that succeeded.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEndToEndResultCounts} method.
     * </p>
     * 
     * @return The number of results that succeeded.
     */
    public final Map<String, Integer> endToEndResultCountsAsStrings() {
        return endToEndResultCounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(multiTurnConversation());
        hashCode = 31 * hashCode + Objects.hashCode(totalResultCount());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasSpeechTranscriptionResultCounts() ? speechTranscriptionResultCountsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEndToEndResultCounts() ? endToEndResultCountsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OverallTestResultItem)) {
            return false;
        }
        OverallTestResultItem other = (OverallTestResultItem) obj;
        return Objects.equals(multiTurnConversation(), other.multiTurnConversation())
                && Objects.equals(totalResultCount(), other.totalResultCount())
                && hasSpeechTranscriptionResultCounts() == other.hasSpeechTranscriptionResultCounts()
                && Objects.equals(speechTranscriptionResultCountsAsStrings(), other.speechTranscriptionResultCountsAsStrings())
                && hasEndToEndResultCounts() == other.hasEndToEndResultCounts()
                && Objects.equals(endToEndResultCountsAsStrings(), other.endToEndResultCountsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("OverallTestResultItem")
                .add("MultiTurnConversation", multiTurnConversation())
                .add("TotalResultCount", totalResultCount())
                .add("SpeechTranscriptionResultCounts",
                        hasSpeechTranscriptionResultCounts() ? speechTranscriptionResultCountsAsStrings() : null)
                .add("EndToEndResultCounts", hasEndToEndResultCounts() ? endToEndResultCountsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "multiTurnConversation":
            return Optional.ofNullable(clazz.cast(multiTurnConversation()));
        case "totalResultCount":
            return Optional.ofNullable(clazz.cast(totalResultCount()));
        case "speechTranscriptionResultCounts":
            return Optional.ofNullable(clazz.cast(speechTranscriptionResultCountsAsStrings()));
        case "endToEndResultCounts":
            return Optional.ofNullable(clazz.cast(endToEndResultCountsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("multiTurnConversation", MULTI_TURN_CONVERSATION_FIELD);
        map.put("totalResultCount", TOTAL_RESULT_COUNT_FIELD);
        map.put("speechTranscriptionResultCounts", SPEECH_TRANSCRIPTION_RESULT_COUNTS_FIELD);
        map.put("endToEndResultCounts", END_TO_END_RESULT_COUNTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OverallTestResultItem, T> g) {
        return obj -> g.apply((OverallTestResultItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OverallTestResultItem> {
        /**
         * <p>
         * Indicates whether the conversation contains multiple turns or not.
         * </p>
         * 
         * @param multiTurnConversation
         *        Indicates whether the conversation contains multiple turns or not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiTurnConversation(Boolean multiTurnConversation);

        /**
         * <p>
         * The total number of overall results in the result of the test execution.
         * </p>
         * 
         * @param totalResultCount
         *        The total number of overall results in the result of the test execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalResultCount(Integer totalResultCount);

        /**
         * <p>
         * The number of speech transcription results in the overall test.
         * </p>
         * 
         * @param speechTranscriptionResultCounts
         *        The number of speech transcription results in the overall test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder speechTranscriptionResultCountsWithStrings(Map<String, Integer> speechTranscriptionResultCounts);

        /**
         * <p>
         * The number of speech transcription results in the overall test.
         * </p>
         * 
         * @param speechTranscriptionResultCounts
         *        The number of speech transcription results in the overall test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder speechTranscriptionResultCounts(Map<TestResultMatchStatus, Integer> speechTranscriptionResultCounts);

        /**
         * <p>
         * The number of results that succeeded.
         * </p>
         * 
         * @param endToEndResultCounts
         *        The number of results that succeeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endToEndResultCountsWithStrings(Map<String, Integer> endToEndResultCounts);

        /**
         * <p>
         * The number of results that succeeded.
         * </p>
         * 
         * @param endToEndResultCounts
         *        The number of results that succeeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endToEndResultCounts(Map<TestResultMatchStatus, Integer> endToEndResultCounts);
    }

    static final class BuilderImpl implements Builder {
        private Boolean multiTurnConversation;

        private Integer totalResultCount;

        private Map<String, Integer> speechTranscriptionResultCounts = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, Integer> endToEndResultCounts = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OverallTestResultItem model) {
            multiTurnConversation(model.multiTurnConversation);
            totalResultCount(model.totalResultCount);
            speechTranscriptionResultCountsWithStrings(model.speechTranscriptionResultCounts);
            endToEndResultCountsWithStrings(model.endToEndResultCounts);
        }

        public final Boolean getMultiTurnConversation() {
            return multiTurnConversation;
        }

        public final void setMultiTurnConversation(Boolean multiTurnConversation) {
            this.multiTurnConversation = multiTurnConversation;
        }

        @Override
        public final Builder multiTurnConversation(Boolean multiTurnConversation) {
            this.multiTurnConversation = multiTurnConversation;
            return this;
        }

        public final Integer getTotalResultCount() {
            return totalResultCount;
        }

        public final void setTotalResultCount(Integer totalResultCount) {
            this.totalResultCount = totalResultCount;
        }

        @Override
        public final Builder totalResultCount(Integer totalResultCount) {
            this.totalResultCount = totalResultCount;
            return this;
        }

        public final Map<String, Integer> getSpeechTranscriptionResultCounts() {
            if (speechTranscriptionResultCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return speechTranscriptionResultCounts;
        }

        public final void setSpeechTranscriptionResultCounts(Map<String, Integer> speechTranscriptionResultCounts) {
            this.speechTranscriptionResultCounts = TestResultMatchStatusCountMapCopier.copy(speechTranscriptionResultCounts);
        }

        @Override
        public final Builder speechTranscriptionResultCountsWithStrings(Map<String, Integer> speechTranscriptionResultCounts) {
            this.speechTranscriptionResultCounts = TestResultMatchStatusCountMapCopier.copy(speechTranscriptionResultCounts);
            return this;
        }

        @Override
        public final Builder speechTranscriptionResultCounts(Map<TestResultMatchStatus, Integer> speechTranscriptionResultCounts) {
            this.speechTranscriptionResultCounts = TestResultMatchStatusCountMapCopier
                    .copyEnumToString(speechTranscriptionResultCounts);
            return this;
        }

        public final Map<String, Integer> getEndToEndResultCounts() {
            if (endToEndResultCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return endToEndResultCounts;
        }

        public final void setEndToEndResultCounts(Map<String, Integer> endToEndResultCounts) {
            this.endToEndResultCounts = TestResultMatchStatusCountMapCopier.copy(endToEndResultCounts);
        }

        @Override
        public final Builder endToEndResultCountsWithStrings(Map<String, Integer> endToEndResultCounts) {
            this.endToEndResultCounts = TestResultMatchStatusCountMapCopier.copy(endToEndResultCounts);
            return this;
        }

        @Override
        public final Builder endToEndResultCounts(Map<TestResultMatchStatus, Integer> endToEndResultCounts) {
            this.endToEndResultCounts = TestResultMatchStatusCountMapCopier.copyEnumToString(endToEndResultCounts);
            return this;
        }

        @Override
        public OverallTestResultItem build() {
            return new OverallTestResultItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
