/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides an array of phrases that should be given preference when resolving values for a slot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuntimeHintDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<RuntimeHintDetails.Builder, RuntimeHintDetails> {
    private static final SdkField<List<RuntimeHintValue>> RUNTIME_HINT_VALUES_FIELD = SdkField
            .<List<RuntimeHintValue>> builder(MarshallingType.LIST)
            .memberName("runtimeHintValues")
            .getter(getter(RuntimeHintDetails::runtimeHintValues))
            .setter(setter(Builder::runtimeHintValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtimeHintValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RuntimeHintValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(RuntimeHintValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, RuntimeHintDetails>> SUB_SLOT_HINTS_FIELD = SdkField
            .<Map<String, RuntimeHintDetails>> builder(MarshallingType.MAP)
            .memberName("subSlotHints")
            .getter(getter(RuntimeHintDetails::subSlotHints))
            .setter(setter(Builder::subSlotHints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subSlotHints").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<RuntimeHintDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(RuntimeHintDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUNTIME_HINT_VALUES_FIELD,
            SUB_SLOT_HINTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<RuntimeHintValue> runtimeHintValues;

    private final Map<String, RuntimeHintDetails> subSlotHints;

    private RuntimeHintDetails(BuilderImpl builder) {
        this.runtimeHintValues = builder.runtimeHintValues;
        this.subSlotHints = builder.subSlotHints;
    }

    /**
     * For responses, this returns true if the service returned a value for the RuntimeHintValues property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRuntimeHintValues() {
        return runtimeHintValues != null && !(runtimeHintValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more strings that Amazon Lex should look for in the input to the bot. Each phrase is given preference when
     * deciding on slot values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRuntimeHintValues} method.
     * </p>
     * 
     * @return One or more strings that Amazon Lex should look for in the input to the bot. Each phrase is given
     *         preference when deciding on slot values.
     */
    public final List<RuntimeHintValue> runtimeHintValues() {
        return runtimeHintValues;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubSlotHints property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSubSlotHints() {
        return subSlotHints != null && !(subSlotHints instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of constituent sub slot names inside a composite slot in the intent and the phrases that should be added
     * for each sub slot. Inside each composite slot hints, this structure provides a mechanism to add granular sub slot
     * phrases. Only sub slot hints are supported for composite slots. The intent name, composite slot name and the
     * constituent sub slot names must exist.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubSlotHints} method.
     * </p>
     * 
     * @return A map of constituent sub slot names inside a composite slot in the intent and the phrases that should be
     *         added for each sub slot. Inside each composite slot hints, this structure provides a mechanism to add
     *         granular sub slot phrases. Only sub slot hints are supported for composite slots. The intent name,
     *         composite slot name and the constituent sub slot names must exist.
     */
    public final Map<String, RuntimeHintDetails> subSlotHints() {
        return subSlotHints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRuntimeHintValues() ? runtimeHintValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSubSlotHints() ? subSlotHints() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuntimeHintDetails)) {
            return false;
        }
        RuntimeHintDetails other = (RuntimeHintDetails) obj;
        return hasRuntimeHintValues() == other.hasRuntimeHintValues()
                && Objects.equals(runtimeHintValues(), other.runtimeHintValues()) && hasSubSlotHints() == other.hasSubSlotHints()
                && Objects.equals(subSlotHints(), other.subSlotHints());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuntimeHintDetails")
                .add("RuntimeHintValues", hasRuntimeHintValues() ? runtimeHintValues() : null)
                .add("SubSlotHints", hasSubSlotHints() ? subSlotHints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "runtimeHintValues":
            return Optional.ofNullable(clazz.cast(runtimeHintValues()));
        case "subSlotHints":
            return Optional.ofNullable(clazz.cast(subSlotHints()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("runtimeHintValues", RUNTIME_HINT_VALUES_FIELD);
        map.put("subSlotHints", SUB_SLOT_HINTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuntimeHintDetails, T> g) {
        return obj -> g.apply((RuntimeHintDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuntimeHintDetails> {
        /**
         * <p>
         * One or more strings that Amazon Lex should look for in the input to the bot. Each phrase is given preference
         * when deciding on slot values.
         * </p>
         * 
         * @param runtimeHintValues
         *        One or more strings that Amazon Lex should look for in the input to the bot. Each phrase is given
         *        preference when deciding on slot values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimeHintValues(Collection<RuntimeHintValue> runtimeHintValues);

        /**
         * <p>
         * One or more strings that Amazon Lex should look for in the input to the bot. Each phrase is given preference
         * when deciding on slot values.
         * </p>
         * 
         * @param runtimeHintValues
         *        One or more strings that Amazon Lex should look for in the input to the bot. Each phrase is given
         *        preference when deciding on slot values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimeHintValues(RuntimeHintValue... runtimeHintValues);

        /**
         * <p>
         * One or more strings that Amazon Lex should look for in the input to the bot. Each phrase is given preference
         * when deciding on slot values.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.RuntimeHintValue.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.lexmodelsv2.model.RuntimeHintValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.RuntimeHintValue.Builder#build()} is called
         * immediately and its result is passed to {@link #runtimeHintValues(List<RuntimeHintValue>)}.
         * 
         * @param runtimeHintValues
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.RuntimeHintValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #runtimeHintValues(java.util.Collection<RuntimeHintValue>)
         */
        Builder runtimeHintValues(Consumer<RuntimeHintValue.Builder>... runtimeHintValues);

        /**
         * <p>
         * A map of constituent sub slot names inside a composite slot in the intent and the phrases that should be
         * added for each sub slot. Inside each composite slot hints, this structure provides a mechanism to add
         * granular sub slot phrases. Only sub slot hints are supported for composite slots. The intent name, composite
         * slot name and the constituent sub slot names must exist.
         * </p>
         * 
         * @param subSlotHints
         *        A map of constituent sub slot names inside a composite slot in the intent and the phrases that should
         *        be added for each sub slot. Inside each composite slot hints, this structure provides a mechanism to
         *        add granular sub slot phrases. Only sub slot hints are supported for composite slots. The intent name,
         *        composite slot name and the constituent sub slot names must exist.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subSlotHints(Map<String, RuntimeHintDetails> subSlotHints);
    }

    static final class BuilderImpl implements Builder {
        private List<RuntimeHintValue> runtimeHintValues = DefaultSdkAutoConstructList.getInstance();

        private Map<String, RuntimeHintDetails> subSlotHints = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RuntimeHintDetails model) {
            runtimeHintValues(model.runtimeHintValues);
            subSlotHints(model.subSlotHints);
        }

        public final List<RuntimeHintValue.Builder> getRuntimeHintValues() {
            List<RuntimeHintValue.Builder> result = RuntimeHintValuesListCopier.copyToBuilder(this.runtimeHintValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuntimeHintValues(Collection<RuntimeHintValue.BuilderImpl> runtimeHintValues) {
            this.runtimeHintValues = RuntimeHintValuesListCopier.copyFromBuilder(runtimeHintValues);
        }

        @Override
        public final Builder runtimeHintValues(Collection<RuntimeHintValue> runtimeHintValues) {
            this.runtimeHintValues = RuntimeHintValuesListCopier.copy(runtimeHintValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runtimeHintValues(RuntimeHintValue... runtimeHintValues) {
            runtimeHintValues(Arrays.asList(runtimeHintValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runtimeHintValues(Consumer<RuntimeHintValue.Builder>... runtimeHintValues) {
            runtimeHintValues(Stream.of(runtimeHintValues).map(c -> RuntimeHintValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, Builder> getSubSlotHints() {
            Map<String, Builder> result = SlotHintsSlotMapCopier.copyToBuilder(this.subSlotHints);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setSubSlotHints(Map<String, BuilderImpl> subSlotHints) {
            this.subSlotHints = SlotHintsSlotMapCopier.copyFromBuilder(subSlotHints);
        }

        @Override
        public final Builder subSlotHints(Map<String, RuntimeHintDetails> subSlotHints) {
            this.subSlotHints = SlotHintsSlotMapCopier.copy(subSlotHints);
            return this;
        }

        @Override
        public RuntimeHintDetails build() {
            return new RuntimeHintDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
