/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains settings used by Amazon Lex to select a slot value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SlotValueSelectionSetting implements SdkPojo, Serializable,
        ToCopyableBuilder<SlotValueSelectionSetting.Builder, SlotValueSelectionSetting> {
    private static final SdkField<String> RESOLUTION_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resolutionStrategy").getter(getter(SlotValueSelectionSetting::resolutionStrategyAsString))
            .setter(setter(Builder::resolutionStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolutionStrategy").build())
            .build();

    private static final SdkField<SlotValueRegexFilter> REGEX_FILTER_FIELD = SdkField
            .<SlotValueRegexFilter> builder(MarshallingType.SDK_POJO).memberName("regexFilter")
            .getter(getter(SlotValueSelectionSetting::regexFilter)).setter(setter(Builder::regexFilter))
            .constructor(SlotValueRegexFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regexFilter").build()).build();

    private static final SdkField<AdvancedRecognitionSetting> ADVANCED_RECOGNITION_SETTING_FIELD = SdkField
            .<AdvancedRecognitionSetting> builder(MarshallingType.SDK_POJO)
            .memberName("advancedRecognitionSetting")
            .getter(getter(SlotValueSelectionSetting::advancedRecognitionSetting))
            .setter(setter(Builder::advancedRecognitionSetting))
            .constructor(AdvancedRecognitionSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("advancedRecognitionSetting").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOLUTION_STRATEGY_FIELD,
            REGEX_FILTER_FIELD, ADVANCED_RECOGNITION_SETTING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resolutionStrategy;

    private final SlotValueRegexFilter regexFilter;

    private final AdvancedRecognitionSetting advancedRecognitionSetting;

    private SlotValueSelectionSetting(BuilderImpl builder) {
        this.resolutionStrategy = builder.resolutionStrategy;
        this.regexFilter = builder.regexFilter;
        this.advancedRecognitionSetting = builder.advancedRecognitionSetting;
    }

    /**
     * <p>
     * Determines the slot resolution strategy that Amazon Lex uses to return slot type values. The field can be set to
     * one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ORIGINAL_VALUE</code> - Returns the value entered by the user, if the user value is similar to the slot
     * value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TOP_RESOLUTION</code> - If there is a resolution list for the slot, return the first value in the
     * resolution list as the slot type value. If there is no resolution list, null is returned.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you don't specify the <code>valueSelectionStrategy</code>, the default is <code>ORIGINAL_VALUE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #resolutionStrategy} will return {@link SlotValueResolutionStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #resolutionStrategyAsString}.
     * </p>
     * 
     * @return Determines the slot resolution strategy that Amazon Lex uses to return slot type values. The field can be
     *         set to one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ORIGINAL_VALUE</code> - Returns the value entered by the user, if the user value is similar to the
     *         slot value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TOP_RESOLUTION</code> - If there is a resolution list for the slot, return the first value in the
     *         resolution list as the slot type value. If there is no resolution list, null is returned.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you don't specify the <code>valueSelectionStrategy</code>, the default is <code>ORIGINAL_VALUE</code>.
     * @see SlotValueResolutionStrategy
     */
    public final SlotValueResolutionStrategy resolutionStrategy() {
        return SlotValueResolutionStrategy.fromValue(resolutionStrategy);
    }

    /**
     * <p>
     * Determines the slot resolution strategy that Amazon Lex uses to return slot type values. The field can be set to
     * one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ORIGINAL_VALUE</code> - Returns the value entered by the user, if the user value is similar to the slot
     * value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TOP_RESOLUTION</code> - If there is a resolution list for the slot, return the first value in the
     * resolution list as the slot type value. If there is no resolution list, null is returned.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you don't specify the <code>valueSelectionStrategy</code>, the default is <code>ORIGINAL_VALUE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #resolutionStrategy} will return {@link SlotValueResolutionStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #resolutionStrategyAsString}.
     * </p>
     * 
     * @return Determines the slot resolution strategy that Amazon Lex uses to return slot type values. The field can be
     *         set to one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ORIGINAL_VALUE</code> - Returns the value entered by the user, if the user value is similar to the
     *         slot value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TOP_RESOLUTION</code> - If there is a resolution list for the slot, return the first value in the
     *         resolution list as the slot type value. If there is no resolution list, null is returned.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you don't specify the <code>valueSelectionStrategy</code>, the default is <code>ORIGINAL_VALUE</code>.
     * @see SlotValueResolutionStrategy
     */
    public final String resolutionStrategyAsString() {
        return resolutionStrategy;
    }

    /**
     * <p>
     * A regular expression used to validate the value of a slot.
     * </p>
     * 
     * @return A regular expression used to validate the value of a slot.
     */
    public final SlotValueRegexFilter regexFilter() {
        return regexFilter;
    }

    /**
     * <p>
     * Provides settings that enable advanced recognition settings for slot values. You can use this to enable using
     * slot values as a custom vocabulary for recognizing user utterances.
     * </p>
     * 
     * @return Provides settings that enable advanced recognition settings for slot values. You can use this to enable
     *         using slot values as a custom vocabulary for recognizing user utterances.
     */
    public final AdvancedRecognitionSetting advancedRecognitionSetting() {
        return advancedRecognitionSetting;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resolutionStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(regexFilter());
        hashCode = 31 * hashCode + Objects.hashCode(advancedRecognitionSetting());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlotValueSelectionSetting)) {
            return false;
        }
        SlotValueSelectionSetting other = (SlotValueSelectionSetting) obj;
        return Objects.equals(resolutionStrategyAsString(), other.resolutionStrategyAsString())
                && Objects.equals(regexFilter(), other.regexFilter())
                && Objects.equals(advancedRecognitionSetting(), other.advancedRecognitionSetting());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SlotValueSelectionSetting").add("ResolutionStrategy", resolutionStrategyAsString())
                .add("RegexFilter", regexFilter()).add("AdvancedRecognitionSetting", advancedRecognitionSetting()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resolutionStrategy":
            return Optional.ofNullable(clazz.cast(resolutionStrategyAsString()));
        case "regexFilter":
            return Optional.ofNullable(clazz.cast(regexFilter()));
        case "advancedRecognitionSetting":
            return Optional.ofNullable(clazz.cast(advancedRecognitionSetting()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resolutionStrategy", RESOLUTION_STRATEGY_FIELD);
        map.put("regexFilter", REGEX_FILTER_FIELD);
        map.put("advancedRecognitionSetting", ADVANCED_RECOGNITION_SETTING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SlotValueSelectionSetting, T> g) {
        return obj -> g.apply((SlotValueSelectionSetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SlotValueSelectionSetting> {
        /**
         * <p>
         * Determines the slot resolution strategy that Amazon Lex uses to return slot type values. The field can be set
         * to one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ORIGINAL_VALUE</code> - Returns the value entered by the user, if the user value is similar to the slot
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TOP_RESOLUTION</code> - If there is a resolution list for the slot, return the first value in the
         * resolution list as the slot type value. If there is no resolution list, null is returned.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you don't specify the <code>valueSelectionStrategy</code>, the default is <code>ORIGINAL_VALUE</code>.
         * </p>
         * 
         * @param resolutionStrategy
         *        Determines the slot resolution strategy that Amazon Lex uses to return slot type values. The field can
         *        be set to one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ORIGINAL_VALUE</code> - Returns the value entered by the user, if the user value is similar to
         *        the slot value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TOP_RESOLUTION</code> - If there is a resolution list for the slot, return the first value in
         *        the resolution list as the slot type value. If there is no resolution list, null is returned.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you don't specify the <code>valueSelectionStrategy</code>, the default is
         *        <code>ORIGINAL_VALUE</code>.
         * @see SlotValueResolutionStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SlotValueResolutionStrategy
         */
        Builder resolutionStrategy(String resolutionStrategy);

        /**
         * <p>
         * Determines the slot resolution strategy that Amazon Lex uses to return slot type values. The field can be set
         * to one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ORIGINAL_VALUE</code> - Returns the value entered by the user, if the user value is similar to the slot
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TOP_RESOLUTION</code> - If there is a resolution list for the slot, return the first value in the
         * resolution list as the slot type value. If there is no resolution list, null is returned.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you don't specify the <code>valueSelectionStrategy</code>, the default is <code>ORIGINAL_VALUE</code>.
         * </p>
         * 
         * @param resolutionStrategy
         *        Determines the slot resolution strategy that Amazon Lex uses to return slot type values. The field can
         *        be set to one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ORIGINAL_VALUE</code> - Returns the value entered by the user, if the user value is similar to
         *        the slot value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TOP_RESOLUTION</code> - If there is a resolution list for the slot, return the first value in
         *        the resolution list as the slot type value. If there is no resolution list, null is returned.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you don't specify the <code>valueSelectionStrategy</code>, the default is
         *        <code>ORIGINAL_VALUE</code>.
         * @see SlotValueResolutionStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SlotValueResolutionStrategy
         */
        Builder resolutionStrategy(SlotValueResolutionStrategy resolutionStrategy);

        /**
         * <p>
         * A regular expression used to validate the value of a slot.
         * </p>
         * 
         * @param regexFilter
         *        A regular expression used to validate the value of a slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regexFilter(SlotValueRegexFilter regexFilter);

        /**
         * <p>
         * A regular expression used to validate the value of a slot.
         * </p>
         * This is a convenience method that creates an instance of the {@link SlotValueRegexFilter.Builder} avoiding
         * the need to create one manually via {@link SlotValueRegexFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SlotValueRegexFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #regexFilter(SlotValueRegexFilter)}.
         * 
         * @param regexFilter
         *        a consumer that will call methods on {@link SlotValueRegexFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #regexFilter(SlotValueRegexFilter)
         */
        default Builder regexFilter(Consumer<SlotValueRegexFilter.Builder> regexFilter) {
            return regexFilter(SlotValueRegexFilter.builder().applyMutation(regexFilter).build());
        }

        /**
         * <p>
         * Provides settings that enable advanced recognition settings for slot values. You can use this to enable using
         * slot values as a custom vocabulary for recognizing user utterances.
         * </p>
         * 
         * @param advancedRecognitionSetting
         *        Provides settings that enable advanced recognition settings for slot values. You can use this to
         *        enable using slot values as a custom vocabulary for recognizing user utterances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder advancedRecognitionSetting(AdvancedRecognitionSetting advancedRecognitionSetting);

        /**
         * <p>
         * Provides settings that enable advanced recognition settings for slot values. You can use this to enable using
         * slot values as a custom vocabulary for recognizing user utterances.
         * </p>
         * This is a convenience method that creates an instance of the {@link AdvancedRecognitionSetting.Builder}
         * avoiding the need to create one manually via {@link AdvancedRecognitionSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AdvancedRecognitionSetting.Builder#build()} is called immediately
         * and its result is passed to {@link #advancedRecognitionSetting(AdvancedRecognitionSetting)}.
         * 
         * @param advancedRecognitionSetting
         *        a consumer that will call methods on {@link AdvancedRecognitionSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #advancedRecognitionSetting(AdvancedRecognitionSetting)
         */
        default Builder advancedRecognitionSetting(Consumer<AdvancedRecognitionSetting.Builder> advancedRecognitionSetting) {
            return advancedRecognitionSetting(AdvancedRecognitionSetting.builder().applyMutation(advancedRecognitionSetting)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String resolutionStrategy;

        private SlotValueRegexFilter regexFilter;

        private AdvancedRecognitionSetting advancedRecognitionSetting;

        private BuilderImpl() {
        }

        private BuilderImpl(SlotValueSelectionSetting model) {
            resolutionStrategy(model.resolutionStrategy);
            regexFilter(model.regexFilter);
            advancedRecognitionSetting(model.advancedRecognitionSetting);
        }

        public final String getResolutionStrategy() {
            return resolutionStrategy;
        }

        public final void setResolutionStrategy(String resolutionStrategy) {
            this.resolutionStrategy = resolutionStrategy;
        }

        @Override
        public final Builder resolutionStrategy(String resolutionStrategy) {
            this.resolutionStrategy = resolutionStrategy;
            return this;
        }

        @Override
        public final Builder resolutionStrategy(SlotValueResolutionStrategy resolutionStrategy) {
            this.resolutionStrategy(resolutionStrategy == null ? null : resolutionStrategy.toString());
            return this;
        }

        public final SlotValueRegexFilter.Builder getRegexFilter() {
            return regexFilter != null ? regexFilter.toBuilder() : null;
        }

        public final void setRegexFilter(SlotValueRegexFilter.BuilderImpl regexFilter) {
            this.regexFilter = regexFilter != null ? regexFilter.build() : null;
        }

        @Override
        public final Builder regexFilter(SlotValueRegexFilter regexFilter) {
            this.regexFilter = regexFilter;
            return this;
        }

        public final AdvancedRecognitionSetting.Builder getAdvancedRecognitionSetting() {
            return advancedRecognitionSetting != null ? advancedRecognitionSetting.toBuilder() : null;
        }

        public final void setAdvancedRecognitionSetting(AdvancedRecognitionSetting.BuilderImpl advancedRecognitionSetting) {
            this.advancedRecognitionSetting = advancedRecognitionSetting != null ? advancedRecognitionSetting.build() : null;
        }

        @Override
        public final Builder advancedRecognitionSetting(AdvancedRecognitionSetting advancedRecognitionSetting) {
            this.advancedRecognitionSetting = advancedRecognitionSetting;
            return this;
        }

        @Override
        public SlotValueSelectionSetting build() {
            return new SlotValueSelectionSetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
