/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summarizes metadata about the test execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestExecutionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<TestExecutionSummary.Builder, TestExecutionSummary> {
    private static final SdkField<String> TEST_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testExecutionId").getter(getter(TestExecutionSummary::testExecutionId))
            .setter(setter(Builder::testExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testExecutionId").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(TestExecutionSummary::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(TestExecutionSummary::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final SdkField<String> TEST_EXECUTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testExecutionStatus").getter(getter(TestExecutionSummary::testExecutionStatusAsString))
            .setter(setter(Builder::testExecutionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testExecutionStatus").build())
            .build();

    private static final SdkField<String> TEST_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testSetId").getter(getter(TestExecutionSummary::testSetId)).setter(setter(Builder::testSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetId").build()).build();

    private static final SdkField<String> TEST_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testSetName").getter(getter(TestExecutionSummary::testSetName)).setter(setter(Builder::testSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetName").build()).build();

    private static final SdkField<TestExecutionTarget> TARGET_FIELD = SdkField
            .<TestExecutionTarget> builder(MarshallingType.SDK_POJO).memberName("target")
            .getter(getter(TestExecutionSummary::target)).setter(setter(Builder::target))
            .constructor(TestExecutionTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()).build();

    private static final SdkField<String> API_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("apiMode").getter(getter(TestExecutionSummary::apiModeAsString)).setter(setter(Builder::apiMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiMode").build()).build();

    private static final SdkField<String> TEST_EXECUTION_MODALITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testExecutionModality").getter(getter(TestExecutionSummary::testExecutionModalityAsString))
            .setter(setter(Builder::testExecutionModality))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testExecutionModality").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_EXECUTION_ID_FIELD,
            CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD, TEST_EXECUTION_STATUS_FIELD, TEST_SET_ID_FIELD,
            TEST_SET_NAME_FIELD, TARGET_FIELD, API_MODE_FIELD, TEST_EXECUTION_MODALITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String testExecutionId;

    private final Instant creationDateTime;

    private final Instant lastUpdatedDateTime;

    private final String testExecutionStatus;

    private final String testSetId;

    private final String testSetName;

    private final TestExecutionTarget target;

    private final String apiMode;

    private final String testExecutionModality;

    private TestExecutionSummary(BuilderImpl builder) {
        this.testExecutionId = builder.testExecutionId;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.testExecutionStatus = builder.testExecutionStatus;
        this.testSetId = builder.testSetId;
        this.testSetName = builder.testSetName;
        this.target = builder.target;
        this.apiMode = builder.apiMode;
        this.testExecutionModality = builder.testExecutionModality;
    }

    /**
     * <p>
     * The unique identifier of the test execution.
     * </p>
     * 
     * @return The unique identifier of the test execution.
     */
    public final String testExecutionId() {
        return testExecutionId;
    }

    /**
     * <p>
     * The date and time at which the test execution was created.
     * </p>
     * 
     * @return The date and time at which the test execution was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The date and time at which the test execution was last updated.
     * </p>
     * 
     * @return The date and time at which the test execution was last updated.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    /**
     * <p>
     * The current status of the test execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #testExecutionStatus} will return {@link TestExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #testExecutionStatusAsString}.
     * </p>
     * 
     * @return The current status of the test execution.
     * @see TestExecutionStatus
     */
    public final TestExecutionStatus testExecutionStatus() {
        return TestExecutionStatus.fromValue(testExecutionStatus);
    }

    /**
     * <p>
     * The current status of the test execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #testExecutionStatus} will return {@link TestExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #testExecutionStatusAsString}.
     * </p>
     * 
     * @return The current status of the test execution.
     * @see TestExecutionStatus
     */
    public final String testExecutionStatusAsString() {
        return testExecutionStatus;
    }

    /**
     * <p>
     * The unique identifier of the test set used in the test execution.
     * </p>
     * 
     * @return The unique identifier of the test set used in the test execution.
     */
    public final String testSetId() {
        return testSetId;
    }

    /**
     * <p>
     * The name of the test set used in the test execution.
     * </p>
     * 
     * @return The name of the test set used in the test execution.
     */
    public final String testSetName() {
        return testSetName;
    }

    /**
     * <p>
     * Contains information about the bot used for the test execution..
     * </p>
     * 
     * @return Contains information about the bot used for the test execution..
     */
    public final TestExecutionTarget target() {
        return target;
    }

    /**
     * <p>
     * Specifies whether the API mode for the test execution is streaming or non-streaming.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #apiMode} will
     * return {@link TestExecutionApiMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #apiModeAsString}.
     * </p>
     * 
     * @return Specifies whether the API mode for the test execution is streaming or non-streaming.
     * @see TestExecutionApiMode
     */
    public final TestExecutionApiMode apiMode() {
        return TestExecutionApiMode.fromValue(apiMode);
    }

    /**
     * <p>
     * Specifies whether the API mode for the test execution is streaming or non-streaming.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #apiMode} will
     * return {@link TestExecutionApiMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #apiModeAsString}.
     * </p>
     * 
     * @return Specifies whether the API mode for the test execution is streaming or non-streaming.
     * @see TestExecutionApiMode
     */
    public final String apiModeAsString() {
        return apiMode;
    }

    /**
     * <p>
     * Specifies whether the data used for the test execution is written or spoken.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #testExecutionModality} will return {@link TestExecutionModality#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #testExecutionModalityAsString}.
     * </p>
     * 
     * @return Specifies whether the data used for the test execution is written or spoken.
     * @see TestExecutionModality
     */
    public final TestExecutionModality testExecutionModality() {
        return TestExecutionModality.fromValue(testExecutionModality);
    }

    /**
     * <p>
     * Specifies whether the data used for the test execution is written or spoken.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #testExecutionModality} will return {@link TestExecutionModality#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #testExecutionModalityAsString}.
     * </p>
     * 
     * @return Specifies whether the data used for the test execution is written or spoken.
     * @see TestExecutionModality
     */
    public final String testExecutionModalityAsString() {
        return testExecutionModality;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(testExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(testExecutionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(testSetId());
        hashCode = 31 * hashCode + Objects.hashCode(testSetName());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(apiModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(testExecutionModalityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestExecutionSummary)) {
            return false;
        }
        TestExecutionSummary other = (TestExecutionSummary) obj;
        return Objects.equals(testExecutionId(), other.testExecutionId())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime())
                && Objects.equals(testExecutionStatusAsString(), other.testExecutionStatusAsString())
                && Objects.equals(testSetId(), other.testSetId()) && Objects.equals(testSetName(), other.testSetName())
                && Objects.equals(target(), other.target()) && Objects.equals(apiModeAsString(), other.apiModeAsString())
                && Objects.equals(testExecutionModalityAsString(), other.testExecutionModalityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestExecutionSummary").add("TestExecutionId", testExecutionId())
                .add("CreationDateTime", creationDateTime()).add("LastUpdatedDateTime", lastUpdatedDateTime())
                .add("TestExecutionStatus", testExecutionStatusAsString()).add("TestSetId", testSetId())
                .add("TestSetName", testSetName()).add("Target", target()).add("ApiMode", apiModeAsString())
                .add("TestExecutionModality", testExecutionModalityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testExecutionId":
            return Optional.ofNullable(clazz.cast(testExecutionId()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        case "testExecutionStatus":
            return Optional.ofNullable(clazz.cast(testExecutionStatusAsString()));
        case "testSetId":
            return Optional.ofNullable(clazz.cast(testSetId()));
        case "testSetName":
            return Optional.ofNullable(clazz.cast(testSetName()));
        case "target":
            return Optional.ofNullable(clazz.cast(target()));
        case "apiMode":
            return Optional.ofNullable(clazz.cast(apiModeAsString()));
        case "testExecutionModality":
            return Optional.ofNullable(clazz.cast(testExecutionModalityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("testExecutionId", TEST_EXECUTION_ID_FIELD);
        map.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        map.put("lastUpdatedDateTime", LAST_UPDATED_DATE_TIME_FIELD);
        map.put("testExecutionStatus", TEST_EXECUTION_STATUS_FIELD);
        map.put("testSetId", TEST_SET_ID_FIELD);
        map.put("testSetName", TEST_SET_NAME_FIELD);
        map.put("target", TARGET_FIELD);
        map.put("apiMode", API_MODE_FIELD);
        map.put("testExecutionModality", TEST_EXECUTION_MODALITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestExecutionSummary, T> g) {
        return obj -> g.apply((TestExecutionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TestExecutionSummary> {
        /**
         * <p>
         * The unique identifier of the test execution.
         * </p>
         * 
         * @param testExecutionId
         *        The unique identifier of the test execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testExecutionId(String testExecutionId);

        /**
         * <p>
         * The date and time at which the test execution was created.
         * </p>
         * 
         * @param creationDateTime
         *        The date and time at which the test execution was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The date and time at which the test execution was last updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The date and time at which the test execution was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);

        /**
         * <p>
         * The current status of the test execution.
         * </p>
         * 
         * @param testExecutionStatus
         *        The current status of the test execution.
         * @see TestExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestExecutionStatus
         */
        Builder testExecutionStatus(String testExecutionStatus);

        /**
         * <p>
         * The current status of the test execution.
         * </p>
         * 
         * @param testExecutionStatus
         *        The current status of the test execution.
         * @see TestExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestExecutionStatus
         */
        Builder testExecutionStatus(TestExecutionStatus testExecutionStatus);

        /**
         * <p>
         * The unique identifier of the test set used in the test execution.
         * </p>
         * 
         * @param testSetId
         *        The unique identifier of the test set used in the test execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testSetId(String testSetId);

        /**
         * <p>
         * The name of the test set used in the test execution.
         * </p>
         * 
         * @param testSetName
         *        The name of the test set used in the test execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testSetName(String testSetName);

        /**
         * <p>
         * Contains information about the bot used for the test execution..
         * </p>
         * 
         * @param target
         *        Contains information about the bot used for the test execution..
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(TestExecutionTarget target);

        /**
         * <p>
         * Contains information about the bot used for the test execution..
         * </p>
         * This is a convenience method that creates an instance of the {@link TestExecutionTarget.Builder} avoiding the
         * need to create one manually via {@link TestExecutionTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TestExecutionTarget.Builder#build()} is called immediately and
         * its result is passed to {@link #target(TestExecutionTarget)}.
         * 
         * @param target
         *        a consumer that will call methods on {@link TestExecutionTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #target(TestExecutionTarget)
         */
        default Builder target(Consumer<TestExecutionTarget.Builder> target) {
            return target(TestExecutionTarget.builder().applyMutation(target).build());
        }

        /**
         * <p>
         * Specifies whether the API mode for the test execution is streaming or non-streaming.
         * </p>
         * 
         * @param apiMode
         *        Specifies whether the API mode for the test execution is streaming or non-streaming.
         * @see TestExecutionApiMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestExecutionApiMode
         */
        Builder apiMode(String apiMode);

        /**
         * <p>
         * Specifies whether the API mode for the test execution is streaming or non-streaming.
         * </p>
         * 
         * @param apiMode
         *        Specifies whether the API mode for the test execution is streaming or non-streaming.
         * @see TestExecutionApiMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestExecutionApiMode
         */
        Builder apiMode(TestExecutionApiMode apiMode);

        /**
         * <p>
         * Specifies whether the data used for the test execution is written or spoken.
         * </p>
         * 
         * @param testExecutionModality
         *        Specifies whether the data used for the test execution is written or spoken.
         * @see TestExecutionModality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestExecutionModality
         */
        Builder testExecutionModality(String testExecutionModality);

        /**
         * <p>
         * Specifies whether the data used for the test execution is written or spoken.
         * </p>
         * 
         * @param testExecutionModality
         *        Specifies whether the data used for the test execution is written or spoken.
         * @see TestExecutionModality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestExecutionModality
         */
        Builder testExecutionModality(TestExecutionModality testExecutionModality);
    }

    static final class BuilderImpl implements Builder {
        private String testExecutionId;

        private Instant creationDateTime;

        private Instant lastUpdatedDateTime;

        private String testExecutionStatus;

        private String testSetId;

        private String testSetName;

        private TestExecutionTarget target;

        private String apiMode;

        private String testExecutionModality;

        private BuilderImpl() {
        }

        private BuilderImpl(TestExecutionSummary model) {
            testExecutionId(model.testExecutionId);
            creationDateTime(model.creationDateTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
            testExecutionStatus(model.testExecutionStatus);
            testSetId(model.testSetId);
            testSetName(model.testSetName);
            target(model.target);
            apiMode(model.apiMode);
            testExecutionModality(model.testExecutionModality);
        }

        public final String getTestExecutionId() {
            return testExecutionId;
        }

        public final void setTestExecutionId(String testExecutionId) {
            this.testExecutionId = testExecutionId;
        }

        @Override
        public final Builder testExecutionId(String testExecutionId) {
            this.testExecutionId = testExecutionId;
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final String getTestExecutionStatus() {
            return testExecutionStatus;
        }

        public final void setTestExecutionStatus(String testExecutionStatus) {
            this.testExecutionStatus = testExecutionStatus;
        }

        @Override
        public final Builder testExecutionStatus(String testExecutionStatus) {
            this.testExecutionStatus = testExecutionStatus;
            return this;
        }

        @Override
        public final Builder testExecutionStatus(TestExecutionStatus testExecutionStatus) {
            this.testExecutionStatus(testExecutionStatus == null ? null : testExecutionStatus.toString());
            return this;
        }

        public final String getTestSetId() {
            return testSetId;
        }

        public final void setTestSetId(String testSetId) {
            this.testSetId = testSetId;
        }

        @Override
        public final Builder testSetId(String testSetId) {
            this.testSetId = testSetId;
            return this;
        }

        public final String getTestSetName() {
            return testSetName;
        }

        public final void setTestSetName(String testSetName) {
            this.testSetName = testSetName;
        }

        @Override
        public final Builder testSetName(String testSetName) {
            this.testSetName = testSetName;
            return this;
        }

        public final TestExecutionTarget.Builder getTarget() {
            return target != null ? target.toBuilder() : null;
        }

        public final void setTarget(TestExecutionTarget.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public final Builder target(TestExecutionTarget target) {
            this.target = target;
            return this;
        }

        public final String getApiMode() {
            return apiMode;
        }

        public final void setApiMode(String apiMode) {
            this.apiMode = apiMode;
        }

        @Override
        public final Builder apiMode(String apiMode) {
            this.apiMode = apiMode;
            return this;
        }

        @Override
        public final Builder apiMode(TestExecutionApiMode apiMode) {
            this.apiMode(apiMode == null ? null : apiMode.toString());
            return this;
        }

        public final String getTestExecutionModality() {
            return testExecutionModality;
        }

        public final void setTestExecutionModality(String testExecutionModality) {
            this.testExecutionModality = testExecutionModality;
        }

        @Override
        public final Builder testExecutionModality(String testExecutionModality) {
            this.testExecutionModality = testExecutionModality;
            return this;
        }

        @Override
        public final Builder testExecutionModality(TestExecutionModality testExecutionModality) {
            this.testExecutionModality(testExecutionModality == null ? null : testExecutionModality.toString());
            return this;
        }

        @Override
        public TestExecutionSummary build() {
            return new TestExecutionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
