/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSlotRequest extends LexModelsV2Request implements
        ToCopyableBuilder<UpdateSlotRequest.Builder, UpdateSlotRequest> {
    private static final SdkField<String> SLOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("slotId")
            .getter(getter(UpdateSlotRequest::slotId)).setter(setter(Builder::slotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("slotId").build()).build();

    private static final SdkField<String> SLOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("slotName").getter(getter(UpdateSlotRequest::slotName)).setter(setter(Builder::slotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateSlotRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> SLOT_TYPE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("slotTypeId").getter(getter(UpdateSlotRequest::slotTypeId)).setter(setter(Builder::slotTypeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotTypeId").build()).build();

    private static final SdkField<SlotValueElicitationSetting> VALUE_ELICITATION_SETTING_FIELD = SdkField
            .<SlotValueElicitationSetting> builder(MarshallingType.SDK_POJO).memberName("valueElicitationSetting")
            .getter(getter(UpdateSlotRequest::valueElicitationSetting)).setter(setter(Builder::valueElicitationSetting))
            .constructor(SlotValueElicitationSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("valueElicitationSetting").build())
            .build();

    private static final SdkField<ObfuscationSetting> OBFUSCATION_SETTING_FIELD = SdkField
            .<ObfuscationSetting> builder(MarshallingType.SDK_POJO).memberName("obfuscationSetting")
            .getter(getter(UpdateSlotRequest::obfuscationSetting)).setter(setter(Builder::obfuscationSetting))
            .constructor(ObfuscationSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("obfuscationSetting").build())
            .build();

    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(UpdateSlotRequest::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(UpdateSlotRequest::botVersion)).setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botVersion").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(UpdateSlotRequest::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("localeId").build()).build();

    private static final SdkField<String> INTENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("intentId").getter(getter(UpdateSlotRequest::intentId)).setter(setter(Builder::intentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("intentId").build()).build();

    private static final SdkField<MultipleValuesSetting> MULTIPLE_VALUES_SETTING_FIELD = SdkField
            .<MultipleValuesSetting> builder(MarshallingType.SDK_POJO).memberName("multipleValuesSetting")
            .getter(getter(UpdateSlotRequest::multipleValuesSetting)).setter(setter(Builder::multipleValuesSetting))
            .constructor(MultipleValuesSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multipleValuesSetting").build())
            .build();

    private static final SdkField<SubSlotSetting> SUB_SLOT_SETTING_FIELD = SdkField
            .<SubSlotSetting> builder(MarshallingType.SDK_POJO).memberName("subSlotSetting")
            .getter(getter(UpdateSlotRequest::subSlotSetting)).setter(setter(Builder::subSlotSetting))
            .constructor(SubSlotSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subSlotSetting").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLOT_ID_FIELD,
            SLOT_NAME_FIELD, DESCRIPTION_FIELD, SLOT_TYPE_ID_FIELD, VALUE_ELICITATION_SETTING_FIELD, OBFUSCATION_SETTING_FIELD,
            BOT_ID_FIELD, BOT_VERSION_FIELD, LOCALE_ID_FIELD, INTENT_ID_FIELD, MULTIPLE_VALUES_SETTING_FIELD,
            SUB_SLOT_SETTING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String slotId;

    private final String slotName;

    private final String description;

    private final String slotTypeId;

    private final SlotValueElicitationSetting valueElicitationSetting;

    private final ObfuscationSetting obfuscationSetting;

    private final String botId;

    private final String botVersion;

    private final String localeId;

    private final String intentId;

    private final MultipleValuesSetting multipleValuesSetting;

    private final SubSlotSetting subSlotSetting;

    private UpdateSlotRequest(BuilderImpl builder) {
        super(builder);
        this.slotId = builder.slotId;
        this.slotName = builder.slotName;
        this.description = builder.description;
        this.slotTypeId = builder.slotTypeId;
        this.valueElicitationSetting = builder.valueElicitationSetting;
        this.obfuscationSetting = builder.obfuscationSetting;
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.intentId = builder.intentId;
        this.multipleValuesSetting = builder.multipleValuesSetting;
        this.subSlotSetting = builder.subSlotSetting;
    }

    /**
     * <p>
     * The unique identifier for the slot to update.
     * </p>
     * 
     * @return The unique identifier for the slot to update.
     */
    public final String slotId() {
        return slotId;
    }

    /**
     * <p>
     * The new name for the slot.
     * </p>
     * 
     * @return The new name for the slot.
     */
    public final String slotName() {
        return slotName;
    }

    /**
     * <p>
     * The new description for the slot.
     * </p>
     * 
     * @return The new description for the slot.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The unique identifier of the new slot type to associate with this slot.
     * </p>
     * 
     * @return The unique identifier of the new slot type to associate with this slot.
     */
    public final String slotTypeId() {
        return slotTypeId;
    }

    /**
     * <p>
     * A new set of prompts that Amazon Lex sends to the user to elicit a response the provides a value for the slot.
     * </p>
     * 
     * @return A new set of prompts that Amazon Lex sends to the user to elicit a response the provides a value for the
     *         slot.
     */
    public final SlotValueElicitationSetting valueElicitationSetting() {
        return valueElicitationSetting;
    }

    /**
     * <p>
     * New settings that determine how slot values are formatted in Amazon CloudWatch logs.
     * </p>
     * 
     * @return New settings that determine how slot values are formatted in Amazon CloudWatch logs.
     */
    public final ObfuscationSetting obfuscationSetting() {
        return obfuscationSetting;
    }

    /**
     * <p>
     * The unique identifier of the bot that contains the slot.
     * </p>
     * 
     * @return The unique identifier of the bot that contains the slot.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The version of the bot that contains the slot. Must always be <code>DRAFT</code>.
     * </p>
     * 
     * @return The version of the bot that contains the slot. Must always be <code>DRAFT</code>.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The identifier of the language and locale that contains the slot. The string must match one of the supported
     * locales. For more information, see <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.
     * </p>
     * 
     * @return The identifier of the language and locale that contains the slot. The string must match one of the
     *         supported locales. For more information, see <a
     *         href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * <p>
     * The identifier of the intent that contains the slot.
     * </p>
     * 
     * @return The identifier of the intent that contains the slot.
     */
    public final String intentId() {
        return intentId;
    }

    /**
     * <p>
     * Determines whether the slot accepts multiple values in one response. Multiple value slots are only available in
     * the en-US locale. If you set this value to <code>true</code> in any other locale, Amazon Lex throws a
     * <code>ValidationException</code>.
     * </p>
     * <p>
     * If the <code>multipleValuesSetting</code> is not set, the default value is <code>false</code>.
     * </p>
     * 
     * @return Determines whether the slot accepts multiple values in one response. Multiple value slots are only
     *         available in the en-US locale. If you set this value to <code>true</code> in any other locale, Amazon Lex
     *         throws a <code>ValidationException</code>.</p>
     *         <p>
     *         If the <code>multipleValuesSetting</code> is not set, the default value is <code>false</code>.
     */
    public final MultipleValuesSetting multipleValuesSetting() {
        return multipleValuesSetting;
    }

    /**
     * <p>
     * Specifications for the constituent sub slots and the expression for the composite slot.
     * </p>
     * 
     * @return Specifications for the constituent sub slots and the expression for the composite slot.
     */
    public final SubSlotSetting subSlotSetting() {
        return subSlotSetting;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(slotId());
        hashCode = 31 * hashCode + Objects.hashCode(slotName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(slotTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(valueElicitationSetting());
        hashCode = 31 * hashCode + Objects.hashCode(obfuscationSetting());
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(intentId());
        hashCode = 31 * hashCode + Objects.hashCode(multipleValuesSetting());
        hashCode = 31 * hashCode + Objects.hashCode(subSlotSetting());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSlotRequest)) {
            return false;
        }
        UpdateSlotRequest other = (UpdateSlotRequest) obj;
        return Objects.equals(slotId(), other.slotId()) && Objects.equals(slotName(), other.slotName())
                && Objects.equals(description(), other.description()) && Objects.equals(slotTypeId(), other.slotTypeId())
                && Objects.equals(valueElicitationSetting(), other.valueElicitationSetting())
                && Objects.equals(obfuscationSetting(), other.obfuscationSetting()) && Objects.equals(botId(), other.botId())
                && Objects.equals(botVersion(), other.botVersion()) && Objects.equals(localeId(), other.localeId())
                && Objects.equals(intentId(), other.intentId())
                && Objects.equals(multipleValuesSetting(), other.multipleValuesSetting())
                && Objects.equals(subSlotSetting(), other.subSlotSetting());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSlotRequest").add("SlotId", slotId()).add("SlotName", slotName())
                .add("Description", description()).add("SlotTypeId", slotTypeId())
                .add("ValueElicitationSetting", valueElicitationSetting()).add("ObfuscationSetting", obfuscationSetting())
                .add("BotId", botId()).add("BotVersion", botVersion()).add("LocaleId", localeId()).add("IntentId", intentId())
                .add("MultipleValuesSetting", multipleValuesSetting()).add("SubSlotSetting", subSlotSetting()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "slotId":
            return Optional.ofNullable(clazz.cast(slotId()));
        case "slotName":
            return Optional.ofNullable(clazz.cast(slotName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "slotTypeId":
            return Optional.ofNullable(clazz.cast(slotTypeId()));
        case "valueElicitationSetting":
            return Optional.ofNullable(clazz.cast(valueElicitationSetting()));
        case "obfuscationSetting":
            return Optional.ofNullable(clazz.cast(obfuscationSetting()));
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "intentId":
            return Optional.ofNullable(clazz.cast(intentId()));
        case "multipleValuesSetting":
            return Optional.ofNullable(clazz.cast(multipleValuesSetting()));
        case "subSlotSetting":
            return Optional.ofNullable(clazz.cast(subSlotSetting()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("slotId", SLOT_ID_FIELD);
        map.put("slotName", SLOT_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("slotTypeId", SLOT_TYPE_ID_FIELD);
        map.put("valueElicitationSetting", VALUE_ELICITATION_SETTING_FIELD);
        map.put("obfuscationSetting", OBFUSCATION_SETTING_FIELD);
        map.put("botId", BOT_ID_FIELD);
        map.put("botVersion", BOT_VERSION_FIELD);
        map.put("localeId", LOCALE_ID_FIELD);
        map.put("intentId", INTENT_ID_FIELD);
        map.put("multipleValuesSetting", MULTIPLE_VALUES_SETTING_FIELD);
        map.put("subSlotSetting", SUB_SLOT_SETTING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSlotRequest, T> g) {
        return obj -> g.apply((UpdateSlotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Request.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSlotRequest> {
        /**
         * <p>
         * The unique identifier for the slot to update.
         * </p>
         * 
         * @param slotId
         *        The unique identifier for the slot to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotId(String slotId);

        /**
         * <p>
         * The new name for the slot.
         * </p>
         * 
         * @param slotName
         *        The new name for the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotName(String slotName);

        /**
         * <p>
         * The new description for the slot.
         * </p>
         * 
         * @param description
         *        The new description for the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The unique identifier of the new slot type to associate with this slot.
         * </p>
         * 
         * @param slotTypeId
         *        The unique identifier of the new slot type to associate with this slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotTypeId(String slotTypeId);

        /**
         * <p>
         * A new set of prompts that Amazon Lex sends to the user to elicit a response the provides a value for the
         * slot.
         * </p>
         * 
         * @param valueElicitationSetting
         *        A new set of prompts that Amazon Lex sends to the user to elicit a response the provides a value for
         *        the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueElicitationSetting(SlotValueElicitationSetting valueElicitationSetting);

        /**
         * <p>
         * A new set of prompts that Amazon Lex sends to the user to elicit a response the provides a value for the
         * slot.
         * </p>
         * This is a convenience method that creates an instance of the {@link SlotValueElicitationSetting.Builder}
         * avoiding the need to create one manually via {@link SlotValueElicitationSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SlotValueElicitationSetting.Builder#build()} is called
         * immediately and its result is passed to {@link #valueElicitationSetting(SlotValueElicitationSetting)}.
         * 
         * @param valueElicitationSetting
         *        a consumer that will call methods on {@link SlotValueElicitationSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #valueElicitationSetting(SlotValueElicitationSetting)
         */
        default Builder valueElicitationSetting(Consumer<SlotValueElicitationSetting.Builder> valueElicitationSetting) {
            return valueElicitationSetting(SlotValueElicitationSetting.builder().applyMutation(valueElicitationSetting).build());
        }

        /**
         * <p>
         * New settings that determine how slot values are formatted in Amazon CloudWatch logs.
         * </p>
         * 
         * @param obfuscationSetting
         *        New settings that determine how slot values are formatted in Amazon CloudWatch logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder obfuscationSetting(ObfuscationSetting obfuscationSetting);

        /**
         * <p>
         * New settings that determine how slot values are formatted in Amazon CloudWatch logs.
         * </p>
         * This is a convenience method that creates an instance of the {@link ObfuscationSetting.Builder} avoiding the
         * need to create one manually via {@link ObfuscationSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ObfuscationSetting.Builder#build()} is called immediately and its
         * result is passed to {@link #obfuscationSetting(ObfuscationSetting)}.
         * 
         * @param obfuscationSetting
         *        a consumer that will call methods on {@link ObfuscationSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #obfuscationSetting(ObfuscationSetting)
         */
        default Builder obfuscationSetting(Consumer<ObfuscationSetting.Builder> obfuscationSetting) {
            return obfuscationSetting(ObfuscationSetting.builder().applyMutation(obfuscationSetting).build());
        }

        /**
         * <p>
         * The unique identifier of the bot that contains the slot.
         * </p>
         * 
         * @param botId
         *        The unique identifier of the bot that contains the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The version of the bot that contains the slot. Must always be <code>DRAFT</code>.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot that contains the slot. Must always be <code>DRAFT</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The identifier of the language and locale that contains the slot. The string must match one of the supported
         * locales. For more information, see <a
         * href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.
         * </p>
         * 
         * @param localeId
         *        The identifier of the language and locale that contains the slot. The string must match one of the
         *        supported locales. For more information, see <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * The identifier of the intent that contains the slot.
         * </p>
         * 
         * @param intentId
         *        The identifier of the intent that contains the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentId(String intentId);

        /**
         * <p>
         * Determines whether the slot accepts multiple values in one response. Multiple value slots are only available
         * in the en-US locale. If you set this value to <code>true</code> in any other locale, Amazon Lex throws a
         * <code>ValidationException</code>.
         * </p>
         * <p>
         * If the <code>multipleValuesSetting</code> is not set, the default value is <code>false</code>.
         * </p>
         * 
         * @param multipleValuesSetting
         *        Determines whether the slot accepts multiple values in one response. Multiple value slots are only
         *        available in the en-US locale. If you set this value to <code>true</code> in any other locale, Amazon
         *        Lex throws a <code>ValidationException</code>.</p>
         *        <p>
         *        If the <code>multipleValuesSetting</code> is not set, the default value is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multipleValuesSetting(MultipleValuesSetting multipleValuesSetting);

        /**
         * <p>
         * Determines whether the slot accepts multiple values in one response. Multiple value slots are only available
         * in the en-US locale. If you set this value to <code>true</code> in any other locale, Amazon Lex throws a
         * <code>ValidationException</code>.
         * </p>
         * <p>
         * If the <code>multipleValuesSetting</code> is not set, the default value is <code>false</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link MultipleValuesSetting.Builder} avoiding
         * the need to create one manually via {@link MultipleValuesSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MultipleValuesSetting.Builder#build()} is called immediately and
         * its result is passed to {@link #multipleValuesSetting(MultipleValuesSetting)}.
         * 
         * @param multipleValuesSetting
         *        a consumer that will call methods on {@link MultipleValuesSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multipleValuesSetting(MultipleValuesSetting)
         */
        default Builder multipleValuesSetting(Consumer<MultipleValuesSetting.Builder> multipleValuesSetting) {
            return multipleValuesSetting(MultipleValuesSetting.builder().applyMutation(multipleValuesSetting).build());
        }

        /**
         * <p>
         * Specifications for the constituent sub slots and the expression for the composite slot.
         * </p>
         * 
         * @param subSlotSetting
         *        Specifications for the constituent sub slots and the expression for the composite slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subSlotSetting(SubSlotSetting subSlotSetting);

        /**
         * <p>
         * Specifications for the constituent sub slots and the expression for the composite slot.
         * </p>
         * This is a convenience method that creates an instance of the {@link SubSlotSetting.Builder} avoiding the need
         * to create one manually via {@link SubSlotSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SubSlotSetting.Builder#build()} is called immediately and its
         * result is passed to {@link #subSlotSetting(SubSlotSetting)}.
         * 
         * @param subSlotSetting
         *        a consumer that will call methods on {@link SubSlotSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subSlotSetting(SubSlotSetting)
         */
        default Builder subSlotSetting(Consumer<SubSlotSetting.Builder> subSlotSetting) {
            return subSlotSetting(SubSlotSetting.builder().applyMutation(subSlotSetting).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelsV2Request.BuilderImpl implements Builder {
        private String slotId;

        private String slotName;

        private String description;

        private String slotTypeId;

        private SlotValueElicitationSetting valueElicitationSetting;

        private ObfuscationSetting obfuscationSetting;

        private String botId;

        private String botVersion;

        private String localeId;

        private String intentId;

        private MultipleValuesSetting multipleValuesSetting;

        private SubSlotSetting subSlotSetting;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSlotRequest model) {
            super(model);
            slotId(model.slotId);
            slotName(model.slotName);
            description(model.description);
            slotTypeId(model.slotTypeId);
            valueElicitationSetting(model.valueElicitationSetting);
            obfuscationSetting(model.obfuscationSetting);
            botId(model.botId);
            botVersion(model.botVersion);
            localeId(model.localeId);
            intentId(model.intentId);
            multipleValuesSetting(model.multipleValuesSetting);
            subSlotSetting(model.subSlotSetting);
        }

        public final String getSlotId() {
            return slotId;
        }

        public final void setSlotId(String slotId) {
            this.slotId = slotId;
        }

        @Override
        public final Builder slotId(String slotId) {
            this.slotId = slotId;
            return this;
        }

        public final String getSlotName() {
            return slotName;
        }

        public final void setSlotName(String slotName) {
            this.slotName = slotName;
        }

        @Override
        public final Builder slotName(String slotName) {
            this.slotName = slotName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSlotTypeId() {
            return slotTypeId;
        }

        public final void setSlotTypeId(String slotTypeId) {
            this.slotTypeId = slotTypeId;
        }

        @Override
        public final Builder slotTypeId(String slotTypeId) {
            this.slotTypeId = slotTypeId;
            return this;
        }

        public final SlotValueElicitationSetting.Builder getValueElicitationSetting() {
            return valueElicitationSetting != null ? valueElicitationSetting.toBuilder() : null;
        }

        public final void setValueElicitationSetting(SlotValueElicitationSetting.BuilderImpl valueElicitationSetting) {
            this.valueElicitationSetting = valueElicitationSetting != null ? valueElicitationSetting.build() : null;
        }

        @Override
        public final Builder valueElicitationSetting(SlotValueElicitationSetting valueElicitationSetting) {
            this.valueElicitationSetting = valueElicitationSetting;
            return this;
        }

        public final ObfuscationSetting.Builder getObfuscationSetting() {
            return obfuscationSetting != null ? obfuscationSetting.toBuilder() : null;
        }

        public final void setObfuscationSetting(ObfuscationSetting.BuilderImpl obfuscationSetting) {
            this.obfuscationSetting = obfuscationSetting != null ? obfuscationSetting.build() : null;
        }

        @Override
        public final Builder obfuscationSetting(ObfuscationSetting obfuscationSetting) {
            this.obfuscationSetting = obfuscationSetting;
            return this;
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final String getIntentId() {
            return intentId;
        }

        public final void setIntentId(String intentId) {
            this.intentId = intentId;
        }

        @Override
        public final Builder intentId(String intentId) {
            this.intentId = intentId;
            return this;
        }

        public final MultipleValuesSetting.Builder getMultipleValuesSetting() {
            return multipleValuesSetting != null ? multipleValuesSetting.toBuilder() : null;
        }

        public final void setMultipleValuesSetting(MultipleValuesSetting.BuilderImpl multipleValuesSetting) {
            this.multipleValuesSetting = multipleValuesSetting != null ? multipleValuesSetting.build() : null;
        }

        @Override
        public final Builder multipleValuesSetting(MultipleValuesSetting multipleValuesSetting) {
            this.multipleValuesSetting = multipleValuesSetting;
            return this;
        }

        public final SubSlotSetting.Builder getSubSlotSetting() {
            return subSlotSetting != null ? subSlotSetting.toBuilder() : null;
        }

        public final void setSubSlotSetting(SubSlotSetting.BuilderImpl subSlotSetting) {
            this.subSlotSetting = subSlotSetting != null ? subSlotSetting.build() : null;
        }

        @Override
        public final Builder subSlotSetting(SubSlotSetting subSlotSetting) {
            this.subSlotSetting = subSlotSetting;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSlotRequest build() {
            return new UpdateSlotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
