/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the results for the user turn by the test execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserTurnResult implements SdkPojo, Serializable, ToCopyableBuilder<UserTurnResult.Builder, UserTurnResult> {
    private static final SdkField<UserTurnInputSpecification> INPUT_FIELD = SdkField
            .<UserTurnInputSpecification> builder(MarshallingType.SDK_POJO).memberName("input")
            .getter(getter(UserTurnResult::input)).setter(setter(Builder::input))
            .constructor(UserTurnInputSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()).build();

    private static final SdkField<UserTurnOutputSpecification> EXPECTED_OUTPUT_FIELD = SdkField
            .<UserTurnOutputSpecification> builder(MarshallingType.SDK_POJO).memberName("expectedOutput")
            .getter(getter(UserTurnResult::expectedOutput)).setter(setter(Builder::expectedOutput))
            .constructor(UserTurnOutputSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedOutput").build()).build();

    private static final SdkField<UserTurnOutputSpecification> ACTUAL_OUTPUT_FIELD = SdkField
            .<UserTurnOutputSpecification> builder(MarshallingType.SDK_POJO).memberName("actualOutput")
            .getter(getter(UserTurnResult::actualOutput)).setter(setter(Builder::actualOutput))
            .constructor(UserTurnOutputSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actualOutput").build()).build();

    private static final SdkField<ExecutionErrorDetails> ERROR_DETAILS_FIELD = SdkField
            .<ExecutionErrorDetails> builder(MarshallingType.SDK_POJO).memberName("errorDetails")
            .getter(getter(UserTurnResult::errorDetails)).setter(setter(Builder::errorDetails))
            .constructor(ExecutionErrorDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorDetails").build()).build();

    private static final SdkField<String> END_TO_END_RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endToEndResult").getter(getter(UserTurnResult::endToEndResultAsString))
            .setter(setter(Builder::endToEndResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endToEndResult").build()).build();

    private static final SdkField<String> INTENT_MATCH_RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("intentMatchResult").getter(getter(UserTurnResult::intentMatchResultAsString))
            .setter(setter(Builder::intentMatchResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentMatchResult").build()).build();

    private static final SdkField<String> SLOT_MATCH_RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("slotMatchResult").getter(getter(UserTurnResult::slotMatchResultAsString))
            .setter(setter(Builder::slotMatchResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotMatchResult").build()).build();

    private static final SdkField<String> SPEECH_TRANSCRIPTION_RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("speechTranscriptionResult").getter(getter(UserTurnResult::speechTranscriptionResultAsString))
            .setter(setter(Builder::speechTranscriptionResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("speechTranscriptionResult").build())
            .build();

    private static final SdkField<ConversationLevelResultDetail> CONVERSATION_LEVEL_RESULT_FIELD = SdkField
            .<ConversationLevelResultDetail> builder(MarshallingType.SDK_POJO).memberName("conversationLevelResult")
            .getter(getter(UserTurnResult::conversationLevelResult)).setter(setter(Builder::conversationLevelResult))
            .constructor(ConversationLevelResultDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationLevelResult").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_FIELD,
            EXPECTED_OUTPUT_FIELD, ACTUAL_OUTPUT_FIELD, ERROR_DETAILS_FIELD, END_TO_END_RESULT_FIELD, INTENT_MATCH_RESULT_FIELD,
            SLOT_MATCH_RESULT_FIELD, SPEECH_TRANSCRIPTION_RESULT_FIELD, CONVERSATION_LEVEL_RESULT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final UserTurnInputSpecification input;

    private final UserTurnOutputSpecification expectedOutput;

    private final UserTurnOutputSpecification actualOutput;

    private final ExecutionErrorDetails errorDetails;

    private final String endToEndResult;

    private final String intentMatchResult;

    private final String slotMatchResult;

    private final String speechTranscriptionResult;

    private final ConversationLevelResultDetail conversationLevelResult;

    private UserTurnResult(BuilderImpl builder) {
        this.input = builder.input;
        this.expectedOutput = builder.expectedOutput;
        this.actualOutput = builder.actualOutput;
        this.errorDetails = builder.errorDetails;
        this.endToEndResult = builder.endToEndResult;
        this.intentMatchResult = builder.intentMatchResult;
        this.slotMatchResult = builder.slotMatchResult;
        this.speechTranscriptionResult = builder.speechTranscriptionResult;
        this.conversationLevelResult = builder.conversationLevelResult;
    }

    /**
     * <p>
     * Contains information about the user messages in the turn in the input.
     * </p>
     * 
     * @return Contains information about the user messages in the turn in the input.
     */
    public final UserTurnInputSpecification input() {
        return input;
    }

    /**
     * <p>
     * Contains information about the expected output for the user turn.
     * </p>
     * 
     * @return Contains information about the expected output for the user turn.
     */
    public final UserTurnOutputSpecification expectedOutput() {
        return expectedOutput;
    }

    /**
     * <p>
     * Contains information about the actual output for the user turn.
     * </p>
     * 
     * @return Contains information about the actual output for the user turn.
     */
    public final UserTurnOutputSpecification actualOutput() {
        return actualOutput;
    }

    /**
     * Returns the value of the ErrorDetails property for this object.
     * 
     * @return The value of the ErrorDetails property for this object.
     */
    public final ExecutionErrorDetails errorDetails() {
        return errorDetails;
    }

    /**
     * <p>
     * Specifies whether the expected and actual outputs match or not, or if there is an error in execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endToEndResult}
     * will return {@link TestResultMatchStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #endToEndResultAsString}.
     * </p>
     * 
     * @return Specifies whether the expected and actual outputs match or not, or if there is an error in execution.
     * @see TestResultMatchStatus
     */
    public final TestResultMatchStatus endToEndResult() {
        return TestResultMatchStatus.fromValue(endToEndResult);
    }

    /**
     * <p>
     * Specifies whether the expected and actual outputs match or not, or if there is an error in execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endToEndResult}
     * will return {@link TestResultMatchStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #endToEndResultAsString}.
     * </p>
     * 
     * @return Specifies whether the expected and actual outputs match or not, or if there is an error in execution.
     * @see TestResultMatchStatus
     */
    public final String endToEndResultAsString() {
        return endToEndResult;
    }

    /**
     * <p>
     * Specifies whether the expected and actual intents match or not.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #intentMatchResult}
     * will return {@link TestResultMatchStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #intentMatchResultAsString}.
     * </p>
     * 
     * @return Specifies whether the expected and actual intents match or not.
     * @see TestResultMatchStatus
     */
    public final TestResultMatchStatus intentMatchResult() {
        return TestResultMatchStatus.fromValue(intentMatchResult);
    }

    /**
     * <p>
     * Specifies whether the expected and actual intents match or not.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #intentMatchResult}
     * will return {@link TestResultMatchStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #intentMatchResultAsString}.
     * </p>
     * 
     * @return Specifies whether the expected and actual intents match or not.
     * @see TestResultMatchStatus
     */
    public final String intentMatchResultAsString() {
        return intentMatchResult;
    }

    /**
     * <p>
     * Specifies whether the expected and actual slots match or not.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #slotMatchResult}
     * will return {@link TestResultMatchStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #slotMatchResultAsString}.
     * </p>
     * 
     * @return Specifies whether the expected and actual slots match or not.
     * @see TestResultMatchStatus
     */
    public final TestResultMatchStatus slotMatchResult() {
        return TestResultMatchStatus.fromValue(slotMatchResult);
    }

    /**
     * <p>
     * Specifies whether the expected and actual slots match or not.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #slotMatchResult}
     * will return {@link TestResultMatchStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #slotMatchResultAsString}.
     * </p>
     * 
     * @return Specifies whether the expected and actual slots match or not.
     * @see TestResultMatchStatus
     */
    public final String slotMatchResultAsString() {
        return slotMatchResult;
    }

    /**
     * <p>
     * Specifies whether the expected and actual speech transcriptions match or not, or if there is an error in
     * execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #speechTranscriptionResult} will return {@link TestResultMatchStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #speechTranscriptionResultAsString}.
     * </p>
     * 
     * @return Specifies whether the expected and actual speech transcriptions match or not, or if there is an error in
     *         execution.
     * @see TestResultMatchStatus
     */
    public final TestResultMatchStatus speechTranscriptionResult() {
        return TestResultMatchStatus.fromValue(speechTranscriptionResult);
    }

    /**
     * <p>
     * Specifies whether the expected and actual speech transcriptions match or not, or if there is an error in
     * execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #speechTranscriptionResult} will return {@link TestResultMatchStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #speechTranscriptionResultAsString}.
     * </p>
     * 
     * @return Specifies whether the expected and actual speech transcriptions match or not, or if there is an error in
     *         execution.
     * @see TestResultMatchStatus
     */
    public final String speechTranscriptionResultAsString() {
        return speechTranscriptionResult;
    }

    /**
     * <p>
     * Contains information about the results related to the conversation associated with the user turn.
     * </p>
     * 
     * @return Contains information about the results related to the conversation associated with the user turn.
     */
    public final ConversationLevelResultDetail conversationLevelResult() {
        return conversationLevelResult;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(expectedOutput());
        hashCode = 31 * hashCode + Objects.hashCode(actualOutput());
        hashCode = 31 * hashCode + Objects.hashCode(errorDetails());
        hashCode = 31 * hashCode + Objects.hashCode(endToEndResultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(intentMatchResultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(slotMatchResultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(speechTranscriptionResultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(conversationLevelResult());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserTurnResult)) {
            return false;
        }
        UserTurnResult other = (UserTurnResult) obj;
        return Objects.equals(input(), other.input()) && Objects.equals(expectedOutput(), other.expectedOutput())
                && Objects.equals(actualOutput(), other.actualOutput()) && Objects.equals(errorDetails(), other.errorDetails())
                && Objects.equals(endToEndResultAsString(), other.endToEndResultAsString())
                && Objects.equals(intentMatchResultAsString(), other.intentMatchResultAsString())
                && Objects.equals(slotMatchResultAsString(), other.slotMatchResultAsString())
                && Objects.equals(speechTranscriptionResultAsString(), other.speechTranscriptionResultAsString())
                && Objects.equals(conversationLevelResult(), other.conversationLevelResult());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserTurnResult").add("Input", input()).add("ExpectedOutput", expectedOutput())
                .add("ActualOutput", actualOutput()).add("ErrorDetails", errorDetails())
                .add("EndToEndResult", endToEndResultAsString()).add("IntentMatchResult", intentMatchResultAsString())
                .add("SlotMatchResult", slotMatchResultAsString())
                .add("SpeechTranscriptionResult", speechTranscriptionResultAsString())
                .add("ConversationLevelResult", conversationLevelResult()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "input":
            return Optional.ofNullable(clazz.cast(input()));
        case "expectedOutput":
            return Optional.ofNullable(clazz.cast(expectedOutput()));
        case "actualOutput":
            return Optional.ofNullable(clazz.cast(actualOutput()));
        case "errorDetails":
            return Optional.ofNullable(clazz.cast(errorDetails()));
        case "endToEndResult":
            return Optional.ofNullable(clazz.cast(endToEndResultAsString()));
        case "intentMatchResult":
            return Optional.ofNullable(clazz.cast(intentMatchResultAsString()));
        case "slotMatchResult":
            return Optional.ofNullable(clazz.cast(slotMatchResultAsString()));
        case "speechTranscriptionResult":
            return Optional.ofNullable(clazz.cast(speechTranscriptionResultAsString()));
        case "conversationLevelResult":
            return Optional.ofNullable(clazz.cast(conversationLevelResult()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("input", INPUT_FIELD);
        map.put("expectedOutput", EXPECTED_OUTPUT_FIELD);
        map.put("actualOutput", ACTUAL_OUTPUT_FIELD);
        map.put("errorDetails", ERROR_DETAILS_FIELD);
        map.put("endToEndResult", END_TO_END_RESULT_FIELD);
        map.put("intentMatchResult", INTENT_MATCH_RESULT_FIELD);
        map.put("slotMatchResult", SLOT_MATCH_RESULT_FIELD);
        map.put("speechTranscriptionResult", SPEECH_TRANSCRIPTION_RESULT_FIELD);
        map.put("conversationLevelResult", CONVERSATION_LEVEL_RESULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UserTurnResult, T> g) {
        return obj -> g.apply((UserTurnResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserTurnResult> {
        /**
         * <p>
         * Contains information about the user messages in the turn in the input.
         * </p>
         * 
         * @param input
         *        Contains information about the user messages in the turn in the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(UserTurnInputSpecification input);

        /**
         * <p>
         * Contains information about the user messages in the turn in the input.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserTurnInputSpecification.Builder}
         * avoiding the need to create one manually via {@link UserTurnInputSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserTurnInputSpecification.Builder#build()} is called immediately
         * and its result is passed to {@link #input(UserTurnInputSpecification)}.
         * 
         * @param input
         *        a consumer that will call methods on {@link UserTurnInputSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #input(UserTurnInputSpecification)
         */
        default Builder input(Consumer<UserTurnInputSpecification.Builder> input) {
            return input(UserTurnInputSpecification.builder().applyMutation(input).build());
        }

        /**
         * <p>
         * Contains information about the expected output for the user turn.
         * </p>
         * 
         * @param expectedOutput
         *        Contains information about the expected output for the user turn.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedOutput(UserTurnOutputSpecification expectedOutput);

        /**
         * <p>
         * Contains information about the expected output for the user turn.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserTurnOutputSpecification.Builder}
         * avoiding the need to create one manually via {@link UserTurnOutputSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserTurnOutputSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #expectedOutput(UserTurnOutputSpecification)}.
         * 
         * @param expectedOutput
         *        a consumer that will call methods on {@link UserTurnOutputSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #expectedOutput(UserTurnOutputSpecification)
         */
        default Builder expectedOutput(Consumer<UserTurnOutputSpecification.Builder> expectedOutput) {
            return expectedOutput(UserTurnOutputSpecification.builder().applyMutation(expectedOutput).build());
        }

        /**
         * <p>
         * Contains information about the actual output for the user turn.
         * </p>
         * 
         * @param actualOutput
         *        Contains information about the actual output for the user turn.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actualOutput(UserTurnOutputSpecification actualOutput);

        /**
         * <p>
         * Contains information about the actual output for the user turn.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserTurnOutputSpecification.Builder}
         * avoiding the need to create one manually via {@link UserTurnOutputSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserTurnOutputSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #actualOutput(UserTurnOutputSpecification)}.
         * 
         * @param actualOutput
         *        a consumer that will call methods on {@link UserTurnOutputSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actualOutput(UserTurnOutputSpecification)
         */
        default Builder actualOutput(Consumer<UserTurnOutputSpecification.Builder> actualOutput) {
            return actualOutput(UserTurnOutputSpecification.builder().applyMutation(actualOutput).build());
        }

        /**
         * Sets the value of the ErrorDetails property for this object.
         *
         * @param errorDetails
         *        The new value for the ErrorDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDetails(ExecutionErrorDetails errorDetails);

        /**
         * Sets the value of the ErrorDetails property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ExecutionErrorDetails.Builder} avoiding
         * the need to create one manually via {@link ExecutionErrorDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExecutionErrorDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #errorDetails(ExecutionErrorDetails)}.
         * 
         * @param errorDetails
         *        a consumer that will call methods on {@link ExecutionErrorDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorDetails(ExecutionErrorDetails)
         */
        default Builder errorDetails(Consumer<ExecutionErrorDetails.Builder> errorDetails) {
            return errorDetails(ExecutionErrorDetails.builder().applyMutation(errorDetails).build());
        }

        /**
         * <p>
         * Specifies whether the expected and actual outputs match or not, or if there is an error in execution.
         * </p>
         * 
         * @param endToEndResult
         *        Specifies whether the expected and actual outputs match or not, or if there is an error in execution.
         * @see TestResultMatchStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestResultMatchStatus
         */
        Builder endToEndResult(String endToEndResult);

        /**
         * <p>
         * Specifies whether the expected and actual outputs match or not, or if there is an error in execution.
         * </p>
         * 
         * @param endToEndResult
         *        Specifies whether the expected and actual outputs match or not, or if there is an error in execution.
         * @see TestResultMatchStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestResultMatchStatus
         */
        Builder endToEndResult(TestResultMatchStatus endToEndResult);

        /**
         * <p>
         * Specifies whether the expected and actual intents match or not.
         * </p>
         * 
         * @param intentMatchResult
         *        Specifies whether the expected and actual intents match or not.
         * @see TestResultMatchStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestResultMatchStatus
         */
        Builder intentMatchResult(String intentMatchResult);

        /**
         * <p>
         * Specifies whether the expected and actual intents match or not.
         * </p>
         * 
         * @param intentMatchResult
         *        Specifies whether the expected and actual intents match or not.
         * @see TestResultMatchStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestResultMatchStatus
         */
        Builder intentMatchResult(TestResultMatchStatus intentMatchResult);

        /**
         * <p>
         * Specifies whether the expected and actual slots match or not.
         * </p>
         * 
         * @param slotMatchResult
         *        Specifies whether the expected and actual slots match or not.
         * @see TestResultMatchStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestResultMatchStatus
         */
        Builder slotMatchResult(String slotMatchResult);

        /**
         * <p>
         * Specifies whether the expected and actual slots match or not.
         * </p>
         * 
         * @param slotMatchResult
         *        Specifies whether the expected and actual slots match or not.
         * @see TestResultMatchStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestResultMatchStatus
         */
        Builder slotMatchResult(TestResultMatchStatus slotMatchResult);

        /**
         * <p>
         * Specifies whether the expected and actual speech transcriptions match or not, or if there is an error in
         * execution.
         * </p>
         * 
         * @param speechTranscriptionResult
         *        Specifies whether the expected and actual speech transcriptions match or not, or if there is an error
         *        in execution.
         * @see TestResultMatchStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestResultMatchStatus
         */
        Builder speechTranscriptionResult(String speechTranscriptionResult);

        /**
         * <p>
         * Specifies whether the expected and actual speech transcriptions match or not, or if there is an error in
         * execution.
         * </p>
         * 
         * @param speechTranscriptionResult
         *        Specifies whether the expected and actual speech transcriptions match or not, or if there is an error
         *        in execution.
         * @see TestResultMatchStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestResultMatchStatus
         */
        Builder speechTranscriptionResult(TestResultMatchStatus speechTranscriptionResult);

        /**
         * <p>
         * Contains information about the results related to the conversation associated with the user turn.
         * </p>
         * 
         * @param conversationLevelResult
         *        Contains information about the results related to the conversation associated with the user turn.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversationLevelResult(ConversationLevelResultDetail conversationLevelResult);

        /**
         * <p>
         * Contains information about the results related to the conversation associated with the user turn.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConversationLevelResultDetail.Builder}
         * avoiding the need to create one manually via {@link ConversationLevelResultDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConversationLevelResultDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #conversationLevelResult(ConversationLevelResultDetail)}.
         * 
         * @param conversationLevelResult
         *        a consumer that will call methods on {@link ConversationLevelResultDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conversationLevelResult(ConversationLevelResultDetail)
         */
        default Builder conversationLevelResult(Consumer<ConversationLevelResultDetail.Builder> conversationLevelResult) {
            return conversationLevelResult(ConversationLevelResultDetail.builder().applyMutation(conversationLevelResult).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private UserTurnInputSpecification input;

        private UserTurnOutputSpecification expectedOutput;

        private UserTurnOutputSpecification actualOutput;

        private ExecutionErrorDetails errorDetails;

        private String endToEndResult;

        private String intentMatchResult;

        private String slotMatchResult;

        private String speechTranscriptionResult;

        private ConversationLevelResultDetail conversationLevelResult;

        private BuilderImpl() {
        }

        private BuilderImpl(UserTurnResult model) {
            input(model.input);
            expectedOutput(model.expectedOutput);
            actualOutput(model.actualOutput);
            errorDetails(model.errorDetails);
            endToEndResult(model.endToEndResult);
            intentMatchResult(model.intentMatchResult);
            slotMatchResult(model.slotMatchResult);
            speechTranscriptionResult(model.speechTranscriptionResult);
            conversationLevelResult(model.conversationLevelResult);
        }

        public final UserTurnInputSpecification.Builder getInput() {
            return input != null ? input.toBuilder() : null;
        }

        public final void setInput(UserTurnInputSpecification.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        @Override
        public final Builder input(UserTurnInputSpecification input) {
            this.input = input;
            return this;
        }

        public final UserTurnOutputSpecification.Builder getExpectedOutput() {
            return expectedOutput != null ? expectedOutput.toBuilder() : null;
        }

        public final void setExpectedOutput(UserTurnOutputSpecification.BuilderImpl expectedOutput) {
            this.expectedOutput = expectedOutput != null ? expectedOutput.build() : null;
        }

        @Override
        public final Builder expectedOutput(UserTurnOutputSpecification expectedOutput) {
            this.expectedOutput = expectedOutput;
            return this;
        }

        public final UserTurnOutputSpecification.Builder getActualOutput() {
            return actualOutput != null ? actualOutput.toBuilder() : null;
        }

        public final void setActualOutput(UserTurnOutputSpecification.BuilderImpl actualOutput) {
            this.actualOutput = actualOutput != null ? actualOutput.build() : null;
        }

        @Override
        public final Builder actualOutput(UserTurnOutputSpecification actualOutput) {
            this.actualOutput = actualOutput;
            return this;
        }

        public final ExecutionErrorDetails.Builder getErrorDetails() {
            return errorDetails != null ? errorDetails.toBuilder() : null;
        }

        public final void setErrorDetails(ExecutionErrorDetails.BuilderImpl errorDetails) {
            this.errorDetails = errorDetails != null ? errorDetails.build() : null;
        }

        @Override
        public final Builder errorDetails(ExecutionErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public final String getEndToEndResult() {
            return endToEndResult;
        }

        public final void setEndToEndResult(String endToEndResult) {
            this.endToEndResult = endToEndResult;
        }

        @Override
        public final Builder endToEndResult(String endToEndResult) {
            this.endToEndResult = endToEndResult;
            return this;
        }

        @Override
        public final Builder endToEndResult(TestResultMatchStatus endToEndResult) {
            this.endToEndResult(endToEndResult == null ? null : endToEndResult.toString());
            return this;
        }

        public final String getIntentMatchResult() {
            return intentMatchResult;
        }

        public final void setIntentMatchResult(String intentMatchResult) {
            this.intentMatchResult = intentMatchResult;
        }

        @Override
        public final Builder intentMatchResult(String intentMatchResult) {
            this.intentMatchResult = intentMatchResult;
            return this;
        }

        @Override
        public final Builder intentMatchResult(TestResultMatchStatus intentMatchResult) {
            this.intentMatchResult(intentMatchResult == null ? null : intentMatchResult.toString());
            return this;
        }

        public final String getSlotMatchResult() {
            return slotMatchResult;
        }

        public final void setSlotMatchResult(String slotMatchResult) {
            this.slotMatchResult = slotMatchResult;
        }

        @Override
        public final Builder slotMatchResult(String slotMatchResult) {
            this.slotMatchResult = slotMatchResult;
            return this;
        }

        @Override
        public final Builder slotMatchResult(TestResultMatchStatus slotMatchResult) {
            this.slotMatchResult(slotMatchResult == null ? null : slotMatchResult.toString());
            return this;
        }

        public final String getSpeechTranscriptionResult() {
            return speechTranscriptionResult;
        }

        public final void setSpeechTranscriptionResult(String speechTranscriptionResult) {
            this.speechTranscriptionResult = speechTranscriptionResult;
        }

        @Override
        public final Builder speechTranscriptionResult(String speechTranscriptionResult) {
            this.speechTranscriptionResult = speechTranscriptionResult;
            return this;
        }

        @Override
        public final Builder speechTranscriptionResult(TestResultMatchStatus speechTranscriptionResult) {
            this.speechTranscriptionResult(speechTranscriptionResult == null ? null : speechTranscriptionResult.toString());
            return this;
        }

        public final ConversationLevelResultDetail.Builder getConversationLevelResult() {
            return conversationLevelResult != null ? conversationLevelResult.toBuilder() : null;
        }

        public final void setConversationLevelResult(ConversationLevelResultDetail.BuilderImpl conversationLevelResult) {
            this.conversationLevelResult = conversationLevelResult != null ? conversationLevelResult.build() : null;
        }

        @Override
        public final Builder conversationLevelResult(ConversationLevelResultDetail conversationLevelResult) {
            this.conversationLevelResult = conversationLevelResult;
            return this;
        }

        @Override
        public UserTurnResult build() {
            return new UserTurnResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
