/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the expected and input values for the user turn.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserTurnSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<UserTurnSpecification.Builder, UserTurnSpecification> {
    private static final SdkField<UserTurnInputSpecification> INPUT_FIELD = SdkField
            .<UserTurnInputSpecification> builder(MarshallingType.SDK_POJO).memberName("input")
            .getter(getter(UserTurnSpecification::input)).setter(setter(Builder::input))
            .constructor(UserTurnInputSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()).build();

    private static final SdkField<UserTurnOutputSpecification> EXPECTED_FIELD = SdkField
            .<UserTurnOutputSpecification> builder(MarshallingType.SDK_POJO).memberName("expected")
            .getter(getter(UserTurnSpecification::expected)).setter(setter(Builder::expected))
            .constructor(UserTurnOutputSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expected").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_FIELD, EXPECTED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final UserTurnInputSpecification input;

    private final UserTurnOutputSpecification expected;

    private UserTurnSpecification(BuilderImpl builder) {
        this.input = builder.input;
        this.expected = builder.expected;
    }

    /**
     * <p>
     * Contains information about the user messages in the turn in the input.
     * </p>
     * 
     * @return Contains information about the user messages in the turn in the input.
     */
    public final UserTurnInputSpecification input() {
        return input;
    }

    /**
     * <p>
     * Contains results about the expected output for the user turn.
     * </p>
     * 
     * @return Contains results about the expected output for the user turn.
     */
    public final UserTurnOutputSpecification expected() {
        return expected;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(expected());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserTurnSpecification)) {
            return false;
        }
        UserTurnSpecification other = (UserTurnSpecification) obj;
        return Objects.equals(input(), other.input()) && Objects.equals(expected(), other.expected());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserTurnSpecification").add("Input", input()).add("Expected", expected()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "input":
            return Optional.ofNullable(clazz.cast(input()));
        case "expected":
            return Optional.ofNullable(clazz.cast(expected()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("input", INPUT_FIELD);
        map.put("expected", EXPECTED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UserTurnSpecification, T> g) {
        return obj -> g.apply((UserTurnSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserTurnSpecification> {
        /**
         * <p>
         * Contains information about the user messages in the turn in the input.
         * </p>
         * 
         * @param input
         *        Contains information about the user messages in the turn in the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(UserTurnInputSpecification input);

        /**
         * <p>
         * Contains information about the user messages in the turn in the input.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserTurnInputSpecification.Builder}
         * avoiding the need to create one manually via {@link UserTurnInputSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserTurnInputSpecification.Builder#build()} is called immediately
         * and its result is passed to {@link #input(UserTurnInputSpecification)}.
         * 
         * @param input
         *        a consumer that will call methods on {@link UserTurnInputSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #input(UserTurnInputSpecification)
         */
        default Builder input(Consumer<UserTurnInputSpecification.Builder> input) {
            return input(UserTurnInputSpecification.builder().applyMutation(input).build());
        }

        /**
         * <p>
         * Contains results about the expected output for the user turn.
         * </p>
         * 
         * @param expected
         *        Contains results about the expected output for the user turn.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expected(UserTurnOutputSpecification expected);

        /**
         * <p>
         * Contains results about the expected output for the user turn.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserTurnOutputSpecification.Builder}
         * avoiding the need to create one manually via {@link UserTurnOutputSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserTurnOutputSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #expected(UserTurnOutputSpecification)}.
         * 
         * @param expected
         *        a consumer that will call methods on {@link UserTurnOutputSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #expected(UserTurnOutputSpecification)
         */
        default Builder expected(Consumer<UserTurnOutputSpecification.Builder> expected) {
            return expected(UserTurnOutputSpecification.builder().applyMutation(expected).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private UserTurnInputSpecification input;

        private UserTurnOutputSpecification expected;

        private BuilderImpl() {
        }

        private BuilderImpl(UserTurnSpecification model) {
            input(model.input);
            expected(model.expected);
        }

        public final UserTurnInputSpecification.Builder getInput() {
            return input != null ? input.toBuilder() : null;
        }

        public final void setInput(UserTurnInputSpecification.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        @Override
        public final Builder input(UserTurnInputSpecification input) {
            this.input = input;
            return this;
        }

        public final UserTurnOutputSpecification.Builder getExpected() {
            return expected != null ? expected.toBuilder() : null;
        }

        public final void setExpected(UserTurnOutputSpecification.BuilderImpl expected) {
            this.expected = expected != null ? expected.build() : null;
        }

        @Override
        public final Builder expected(UserTurnOutputSpecification expected) {
            this.expected = expected;
            return this;
        }

        @Override
        public UserTurnSpecification build() {
            return new UserTurnSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
