/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2Client;
import software.amazon.awssdk.services.lexmodelsv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotResourceGenerationsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotResourceGenerationsResponse;

public class ListBotResourceGenerationsIterable
implements SdkIterable<ListBotResourceGenerationsResponse> {
    private final LexModelsV2Client client;
    private final ListBotResourceGenerationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBotResourceGenerationsIterable(LexModelsV2Client client, ListBotResourceGenerationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListBotResourceGenerationsResponseFetcher();
    }

    public Iterator<ListBotResourceGenerationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListBotResourceGenerationsResponseFetcher
    implements SyncPageFetcher<ListBotResourceGenerationsResponse> {
        private ListBotResourceGenerationsResponseFetcher() {
        }

        public boolean hasNextPage(ListBotResourceGenerationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBotResourceGenerationsResponse nextPage(ListBotResourceGenerationsResponse previousPage) {
            if (previousPage == null) {
                return ListBotResourceGenerationsIterable.this.client.listBotResourceGenerations(ListBotResourceGenerationsIterable.this.firstRequest);
            }
            return ListBotResourceGenerationsIterable.this.client.listBotResourceGenerations((ListBotResourceGenerationsRequest)((Object)ListBotResourceGenerationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

