/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinKey;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinKeysCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceAttributeResult;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceAttributeResultsCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceGroupByKey;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceGroupByKeysCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceMetricResult;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceMetricResultsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnalyticsUtteranceResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnalyticsUtteranceResult> {
    private static final SdkField<List<AnalyticsBinKey>> BIN_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("binKeys").getter(AnalyticsUtteranceResult.getter(AnalyticsUtteranceResult::binKeys)).setter(AnalyticsUtteranceResult.setter(Builder::binKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("binKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalyticsBinKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AnalyticsUtteranceGroupByKey>> GROUP_BY_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("groupByKeys").getter(AnalyticsUtteranceResult.getter(AnalyticsUtteranceResult::groupByKeys)).setter(AnalyticsUtteranceResult.setter(Builder::groupByKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupByKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalyticsUtteranceGroupByKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AnalyticsUtteranceMetricResult>> METRICS_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metricsResults").getter(AnalyticsUtteranceResult.getter(AnalyticsUtteranceResult::metricsResults)).setter(AnalyticsUtteranceResult.setter(Builder::metricsResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricsResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalyticsUtteranceMetricResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AnalyticsUtteranceAttributeResult>> ATTRIBUTE_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("attributeResults").getter(AnalyticsUtteranceResult.getter(AnalyticsUtteranceResult::attributeResults)).setter(AnalyticsUtteranceResult.setter(Builder::attributeResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalyticsUtteranceAttributeResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BIN_KEYS_FIELD, GROUP_BY_KEYS_FIELD, METRICS_RESULTS_FIELD, ATTRIBUTE_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AnalyticsUtteranceResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<AnalyticsBinKey> binKeys;
    private final List<AnalyticsUtteranceGroupByKey> groupByKeys;
    private final List<AnalyticsUtteranceMetricResult> metricsResults;
    private final List<AnalyticsUtteranceAttributeResult> attributeResults;

    private AnalyticsUtteranceResult(BuilderImpl builder) {
        this.binKeys = builder.binKeys;
        this.groupByKeys = builder.groupByKeys;
        this.metricsResults = builder.metricsResults;
        this.attributeResults = builder.attributeResults;
    }

    public final boolean hasBinKeys() {
        return this.binKeys != null && !(this.binKeys instanceof SdkAutoConstructList);
    }

    public final List<AnalyticsBinKey> binKeys() {
        return this.binKeys;
    }

    public final boolean hasGroupByKeys() {
        return this.groupByKeys != null && !(this.groupByKeys instanceof SdkAutoConstructList);
    }

    public final List<AnalyticsUtteranceGroupByKey> groupByKeys() {
        return this.groupByKeys;
    }

    public final boolean hasMetricsResults() {
        return this.metricsResults != null && !(this.metricsResults instanceof SdkAutoConstructList);
    }

    public final List<AnalyticsUtteranceMetricResult> metricsResults() {
        return this.metricsResults;
    }

    public final boolean hasAttributeResults() {
        return this.attributeResults != null && !(this.attributeResults instanceof SdkAutoConstructList);
    }

    public final List<AnalyticsUtteranceAttributeResult> attributeResults() {
        return this.attributeResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBinKeys() ? this.binKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupByKeys() ? this.groupByKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricsResults() ? this.metricsResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributeResults() ? this.attributeResults() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyticsUtteranceResult)) {
            return false;
        }
        AnalyticsUtteranceResult other = (AnalyticsUtteranceResult)obj;
        return this.hasBinKeys() == other.hasBinKeys() && Objects.equals(this.binKeys(), other.binKeys()) && this.hasGroupByKeys() == other.hasGroupByKeys() && Objects.equals(this.groupByKeys(), other.groupByKeys()) && this.hasMetricsResults() == other.hasMetricsResults() && Objects.equals(this.metricsResults(), other.metricsResults()) && this.hasAttributeResults() == other.hasAttributeResults() && Objects.equals(this.attributeResults(), other.attributeResults());
    }

    public final String toString() {
        return ToString.builder((String)"AnalyticsUtteranceResult").add("BinKeys", this.hasBinKeys() ? this.binKeys() : null).add("GroupByKeys", this.hasGroupByKeys() ? this.groupByKeys() : null).add("MetricsResults", this.hasMetricsResults() ? this.metricsResults() : null).add("AttributeResults", this.hasAttributeResults() ? this.attributeResults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "binKeys": {
                return Optional.ofNullable(clazz.cast(this.binKeys()));
            }
            case "groupByKeys": {
                return Optional.ofNullable(clazz.cast(this.groupByKeys()));
            }
            case "metricsResults": {
                return Optional.ofNullable(clazz.cast(this.metricsResults()));
            }
            case "attributeResults": {
                return Optional.ofNullable(clazz.cast(this.attributeResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("binKeys", BIN_KEYS_FIELD);
        map.put("groupByKeys", GROUP_BY_KEYS_FIELD);
        map.put("metricsResults", METRICS_RESULTS_FIELD);
        map.put("attributeResults", ATTRIBUTE_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnalyticsUtteranceResult, T> g) {
        return obj -> g.apply((AnalyticsUtteranceResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AnalyticsBinKey> binKeys = DefaultSdkAutoConstructList.getInstance();
        private List<AnalyticsUtteranceGroupByKey> groupByKeys = DefaultSdkAutoConstructList.getInstance();
        private List<AnalyticsUtteranceMetricResult> metricsResults = DefaultSdkAutoConstructList.getInstance();
        private List<AnalyticsUtteranceAttributeResult> attributeResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyticsUtteranceResult model) {
            this.binKeys(model.binKeys);
            this.groupByKeys(model.groupByKeys);
            this.metricsResults(model.metricsResults);
            this.attributeResults(model.attributeResults);
        }

        public final List<AnalyticsBinKey.Builder> getBinKeys() {
            List<AnalyticsBinKey.Builder> result = AnalyticsBinKeysCopier.copyToBuilder(this.binKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBinKeys(Collection<AnalyticsBinKey.BuilderImpl> binKeys) {
            this.binKeys = AnalyticsBinKeysCopier.copyFromBuilder(binKeys);
        }

        @Override
        public final Builder binKeys(Collection<AnalyticsBinKey> binKeys) {
            this.binKeys = AnalyticsBinKeysCopier.copy(binKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder binKeys(AnalyticsBinKey ... binKeys) {
            this.binKeys(Arrays.asList(binKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder binKeys(Consumer<AnalyticsBinKey.Builder> ... binKeys) {
            this.binKeys(Stream.of(binKeys).map(c -> (AnalyticsBinKey)((AnalyticsBinKey.Builder)AnalyticsBinKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AnalyticsUtteranceGroupByKey.Builder> getGroupByKeys() {
            List<AnalyticsUtteranceGroupByKey.Builder> result = AnalyticsUtteranceGroupByKeysCopier.copyToBuilder(this.groupByKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupByKeys(Collection<AnalyticsUtteranceGroupByKey.BuilderImpl> groupByKeys) {
            this.groupByKeys = AnalyticsUtteranceGroupByKeysCopier.copyFromBuilder(groupByKeys);
        }

        @Override
        public final Builder groupByKeys(Collection<AnalyticsUtteranceGroupByKey> groupByKeys) {
            this.groupByKeys = AnalyticsUtteranceGroupByKeysCopier.copy(groupByKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupByKeys(AnalyticsUtteranceGroupByKey ... groupByKeys) {
            this.groupByKeys(Arrays.asList(groupByKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupByKeys(Consumer<AnalyticsUtteranceGroupByKey.Builder> ... groupByKeys) {
            this.groupByKeys(Stream.of(groupByKeys).map(c -> (AnalyticsUtteranceGroupByKey)((AnalyticsUtteranceGroupByKey.Builder)AnalyticsUtteranceGroupByKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AnalyticsUtteranceMetricResult.Builder> getMetricsResults() {
            List<AnalyticsUtteranceMetricResult.Builder> result = AnalyticsUtteranceMetricResultsCopier.copyToBuilder(this.metricsResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricsResults(Collection<AnalyticsUtteranceMetricResult.BuilderImpl> metricsResults) {
            this.metricsResults = AnalyticsUtteranceMetricResultsCopier.copyFromBuilder(metricsResults);
        }

        @Override
        public final Builder metricsResults(Collection<AnalyticsUtteranceMetricResult> metricsResults) {
            this.metricsResults = AnalyticsUtteranceMetricResultsCopier.copy(metricsResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricsResults(AnalyticsUtteranceMetricResult ... metricsResults) {
            this.metricsResults(Arrays.asList(metricsResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricsResults(Consumer<AnalyticsUtteranceMetricResult.Builder> ... metricsResults) {
            this.metricsResults(Stream.of(metricsResults).map(c -> (AnalyticsUtteranceMetricResult)((AnalyticsUtteranceMetricResult.Builder)AnalyticsUtteranceMetricResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AnalyticsUtteranceAttributeResult.Builder> getAttributeResults() {
            List<AnalyticsUtteranceAttributeResult.Builder> result = AnalyticsUtteranceAttributeResultsCopier.copyToBuilder(this.attributeResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributeResults(Collection<AnalyticsUtteranceAttributeResult.BuilderImpl> attributeResults) {
            this.attributeResults = AnalyticsUtteranceAttributeResultsCopier.copyFromBuilder(attributeResults);
        }

        @Override
        public final Builder attributeResults(Collection<AnalyticsUtteranceAttributeResult> attributeResults) {
            this.attributeResults = AnalyticsUtteranceAttributeResultsCopier.copy(attributeResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeResults(AnalyticsUtteranceAttributeResult ... attributeResults) {
            this.attributeResults(Arrays.asList(attributeResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeResults(Consumer<AnalyticsUtteranceAttributeResult.Builder> ... attributeResults) {
            this.attributeResults(Stream.of(attributeResults).map(c -> (AnalyticsUtteranceAttributeResult)((AnalyticsUtteranceAttributeResult.Builder)AnalyticsUtteranceAttributeResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AnalyticsUtteranceResult build() {
            return new AnalyticsUtteranceResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnalyticsUtteranceResult> {
        public Builder binKeys(Collection<AnalyticsBinKey> var1);

        public Builder binKeys(AnalyticsBinKey ... var1);

        public Builder binKeys(Consumer<AnalyticsBinKey.Builder> ... var1);

        public Builder groupByKeys(Collection<AnalyticsUtteranceGroupByKey> var1);

        public Builder groupByKeys(AnalyticsUtteranceGroupByKey ... var1);

        public Builder groupByKeys(Consumer<AnalyticsUtteranceGroupByKey.Builder> ... var1);

        public Builder metricsResults(Collection<AnalyticsUtteranceMetricResult> var1);

        public Builder metricsResults(AnalyticsUtteranceMetricResult ... var1);

        public Builder metricsResults(Consumer<AnalyticsUtteranceMetricResult.Builder> ... var1);

        public Builder attributeResults(Collection<AnalyticsUtteranceAttributeResult> var1);

        public Builder attributeResults(AnalyticsUtteranceAttributeResult ... var1);

        public Builder attributeResults(Consumer<AnalyticsUtteranceAttributeResult.Builder> ... var1);
    }
}

