/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.BotMember;
import software.amazon.awssdk.services.lexmodelsv2.model.BotMembersCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.BotStatus;
import software.amazon.awssdk.services.lexmodelsv2.model.BotType;
import software.amazon.awssdk.services.lexmodelsv2.model.DataPrivacy;
import software.amazon.awssdk.services.lexmodelsv2.model.ErrorLogSettings;
import software.amazon.awssdk.services.lexmodelsv2.model.FailureReasonsCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeBotResponse
extends LexModelsV2Response
implements ToCopyableBuilder<Builder, DescribeBotResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(DescribeBotResponse.getter(DescribeBotResponse::botId)).setter(DescribeBotResponse.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()}).build();
    private static final SdkField<String> BOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botName").getter(DescribeBotResponse.getter(DescribeBotResponse::botName)).setter(DescribeBotResponse.setter(Builder::botName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(DescribeBotResponse.getter(DescribeBotResponse::description)).setter(DescribeBotResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(DescribeBotResponse.getter(DescribeBotResponse::roleArn)).setter(DescribeBotResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<DataPrivacy> DATA_PRIVACY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataPrivacy").getter(DescribeBotResponse.getter(DescribeBotResponse::dataPrivacy)).setter(DescribeBotResponse.setter(Builder::dataPrivacy)).constructor(DataPrivacy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataPrivacy").build()}).build();
    private static final SdkField<Integer> IDLE_SESSION_TTL_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("idleSessionTTLInSeconds").getter(DescribeBotResponse.getter(DescribeBotResponse::idleSessionTTLInSeconds)).setter(DescribeBotResponse.setter(Builder::idleSessionTTLInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idleSessionTTLInSeconds").build()}).build();
    private static final SdkField<String> BOT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botStatus").getter(DescribeBotResponse.getter(DescribeBotResponse::botStatusAsString)).setter(DescribeBotResponse.setter(Builder::botStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botStatus").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(DescribeBotResponse.getter(DescribeBotResponse::creationDateTime)).setter(DescribeBotResponse.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDateTime").getter(DescribeBotResponse.getter(DescribeBotResponse::lastUpdatedDateTime)).setter(DescribeBotResponse.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build()}).build();
    private static final SdkField<String> BOT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botType").getter(DescribeBotResponse.getter(DescribeBotResponse::botTypeAsString)).setter(DescribeBotResponse.setter(Builder::botType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botType").build()}).build();
    private static final SdkField<List<BotMember>> BOT_MEMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("botMembers").getter(DescribeBotResponse.getter(DescribeBotResponse::botMembers)).setter(DescribeBotResponse.setter(Builder::botMembers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botMembers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BotMember::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> FAILURE_REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failureReasons").getter(DescribeBotResponse.getter(DescribeBotResponse::failureReasons)).setter(DescribeBotResponse.setter(Builder::failureReasons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ErrorLogSettings> ERROR_LOG_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("errorLogSettings").getter(DescribeBotResponse.getter(DescribeBotResponse::errorLogSettings)).setter(DescribeBotResponse.setter(Builder::errorLogSettings)).constructor(ErrorLogSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorLogSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, BOT_NAME_FIELD, DESCRIPTION_FIELD, ROLE_ARN_FIELD, DATA_PRIVACY_FIELD, IDLE_SESSION_TTL_IN_SECONDS_FIELD, BOT_STATUS_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD, BOT_TYPE_FIELD, BOT_MEMBERS_FIELD, FAILURE_REASONS_FIELD, ERROR_LOG_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeBotResponse.memberNameToFieldInitializer();
    private final String botId;
    private final String botName;
    private final String description;
    private final String roleArn;
    private final DataPrivacy dataPrivacy;
    private final Integer idleSessionTTLInSeconds;
    private final String botStatus;
    private final Instant creationDateTime;
    private final Instant lastUpdatedDateTime;
    private final String botType;
    private final List<BotMember> botMembers;
    private final List<String> failureReasons;
    private final ErrorLogSettings errorLogSettings;

    private DescribeBotResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botName = builder.botName;
        this.description = builder.description;
        this.roleArn = builder.roleArn;
        this.dataPrivacy = builder.dataPrivacy;
        this.idleSessionTTLInSeconds = builder.idleSessionTTLInSeconds;
        this.botStatus = builder.botStatus;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.botType = builder.botType;
        this.botMembers = builder.botMembers;
        this.failureReasons = builder.failureReasons;
        this.errorLogSettings = builder.errorLogSettings;
    }

    public final String botId() {
        return this.botId;
    }

    public final String botName() {
        return this.botName;
    }

    public final String description() {
        return this.description;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final DataPrivacy dataPrivacy() {
        return this.dataPrivacy;
    }

    public final Integer idleSessionTTLInSeconds() {
        return this.idleSessionTTLInSeconds;
    }

    public final BotStatus botStatus() {
        return BotStatus.fromValue(this.botStatus);
    }

    public final String botStatusAsString() {
        return this.botStatus;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public final BotType botType() {
        return BotType.fromValue(this.botType);
    }

    public final String botTypeAsString() {
        return this.botType;
    }

    public final boolean hasBotMembers() {
        return this.botMembers != null && !(this.botMembers instanceof SdkAutoConstructList);
    }

    public final List<BotMember> botMembers() {
        return this.botMembers;
    }

    public final boolean hasFailureReasons() {
        return this.failureReasons != null && !(this.failureReasons instanceof SdkAutoConstructList);
    }

    public final List<String> failureReasons() {
        return this.failureReasons;
    }

    public final ErrorLogSettings errorLogSettings() {
        return this.errorLogSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataPrivacy());
        hashCode = 31 * hashCode + Objects.hashCode(this.idleSessionTTLInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.botStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.botTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBotMembers() ? this.botMembers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailureReasons() ? this.failureReasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.errorLogSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBotResponse)) {
            return false;
        }
        DescribeBotResponse other = (DescribeBotResponse)((Object)obj);
        return Objects.equals(this.botId(), other.botId()) && Objects.equals(this.botName(), other.botName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.dataPrivacy(), other.dataPrivacy()) && Objects.equals(this.idleSessionTTLInSeconds(), other.idleSessionTTLInSeconds()) && Objects.equals(this.botStatusAsString(), other.botStatusAsString()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime()) && Objects.equals(this.botTypeAsString(), other.botTypeAsString()) && this.hasBotMembers() == other.hasBotMembers() && Objects.equals(this.botMembers(), other.botMembers()) && this.hasFailureReasons() == other.hasFailureReasons() && Objects.equals(this.failureReasons(), other.failureReasons()) && Objects.equals(this.errorLogSettings(), other.errorLogSettings());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeBotResponse").add("BotId", (Object)this.botId()).add("BotName", (Object)this.botName()).add("Description", (Object)this.description()).add("RoleArn", (Object)this.roleArn()).add("DataPrivacy", (Object)this.dataPrivacy()).add("IdleSessionTTLInSeconds", (Object)this.idleSessionTTLInSeconds()).add("BotStatus", (Object)this.botStatusAsString()).add("CreationDateTime", (Object)this.creationDateTime()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).add("BotType", (Object)this.botTypeAsString()).add("BotMembers", this.hasBotMembers() ? this.botMembers() : null).add("FailureReasons", this.hasFailureReasons() ? this.failureReasons() : null).add("ErrorLogSettings", (Object)this.errorLogSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "botName": {
                return Optional.ofNullable(clazz.cast(this.botName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "dataPrivacy": {
                return Optional.ofNullable(clazz.cast(this.dataPrivacy()));
            }
            case "idleSessionTTLInSeconds": {
                return Optional.ofNullable(clazz.cast(this.idleSessionTTLInSeconds()));
            }
            case "botStatus": {
                return Optional.ofNullable(clazz.cast(this.botStatusAsString()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "lastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
            case "botType": {
                return Optional.ofNullable(clazz.cast(this.botTypeAsString()));
            }
            case "botMembers": {
                return Optional.ofNullable(clazz.cast(this.botMembers()));
            }
            case "failureReasons": {
                return Optional.ofNullable(clazz.cast(this.failureReasons()));
            }
            case "errorLogSettings": {
                return Optional.ofNullable(clazz.cast(this.errorLogSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("botId", BOT_ID_FIELD);
        map.put("botName", BOT_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("dataPrivacy", DATA_PRIVACY_FIELD);
        map.put("idleSessionTTLInSeconds", IDLE_SESSION_TTL_IN_SECONDS_FIELD);
        map.put("botStatus", BOT_STATUS_FIELD);
        map.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        map.put("lastUpdatedDateTime", LAST_UPDATED_DATE_TIME_FIELD);
        map.put("botType", BOT_TYPE_FIELD);
        map.put("botMembers", BOT_MEMBERS_FIELD);
        map.put("failureReasons", FAILURE_REASONS_FIELD);
        map.put("errorLogSettings", ERROR_LOG_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeBotResponse, T> g) {
        return obj -> g.apply((DescribeBotResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Response.BuilderImpl
    implements Builder {
        private String botId;
        private String botName;
        private String description;
        private String roleArn;
        private DataPrivacy dataPrivacy;
        private Integer idleSessionTTLInSeconds;
        private String botStatus;
        private Instant creationDateTime;
        private Instant lastUpdatedDateTime;
        private String botType;
        private List<BotMember> botMembers = DefaultSdkAutoConstructList.getInstance();
        private List<String> failureReasons = DefaultSdkAutoConstructList.getInstance();
        private ErrorLogSettings errorLogSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBotResponse model) {
            super(model);
            this.botId(model.botId);
            this.botName(model.botName);
            this.description(model.description);
            this.roleArn(model.roleArn);
            this.dataPrivacy(model.dataPrivacy);
            this.idleSessionTTLInSeconds(model.idleSessionTTLInSeconds);
            this.botStatus(model.botStatus);
            this.creationDateTime(model.creationDateTime);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
            this.botType(model.botType);
            this.botMembers(model.botMembers);
            this.failureReasons(model.failureReasons);
            this.errorLogSettings(model.errorLogSettings);
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotName() {
            return this.botName;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final DataPrivacy.Builder getDataPrivacy() {
            return this.dataPrivacy != null ? this.dataPrivacy.toBuilder() : null;
        }

        public final void setDataPrivacy(DataPrivacy.BuilderImpl dataPrivacy) {
            this.dataPrivacy = dataPrivacy != null ? dataPrivacy.build() : null;
        }

        @Override
        public final Builder dataPrivacy(DataPrivacy dataPrivacy) {
            this.dataPrivacy = dataPrivacy;
            return this;
        }

        public final Integer getIdleSessionTTLInSeconds() {
            return this.idleSessionTTLInSeconds;
        }

        public final void setIdleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
        }

        @Override
        public final Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
            return this;
        }

        public final String getBotStatus() {
            return this.botStatus;
        }

        public final void setBotStatus(String botStatus) {
            this.botStatus = botStatus;
        }

        @Override
        public final Builder botStatus(String botStatus) {
            this.botStatus = botStatus;
            return this;
        }

        @Override
        public final Builder botStatus(BotStatus botStatus) {
            this.botStatus(botStatus == null ? null : botStatus.toString());
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final String getBotType() {
            return this.botType;
        }

        public final void setBotType(String botType) {
            this.botType = botType;
        }

        @Override
        public final Builder botType(String botType) {
            this.botType = botType;
            return this;
        }

        @Override
        public final Builder botType(BotType botType) {
            this.botType(botType == null ? null : botType.toString());
            return this;
        }

        public final List<BotMember.Builder> getBotMembers() {
            List<BotMember.Builder> result = BotMembersCopier.copyToBuilder(this.botMembers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBotMembers(Collection<BotMember.BuilderImpl> botMembers) {
            this.botMembers = BotMembersCopier.copyFromBuilder(botMembers);
        }

        @Override
        public final Builder botMembers(Collection<BotMember> botMembers) {
            this.botMembers = BotMembersCopier.copy(botMembers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botMembers(BotMember ... botMembers) {
            this.botMembers(Arrays.asList(botMembers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botMembers(Consumer<BotMember.Builder> ... botMembers) {
            this.botMembers(Stream.of(botMembers).map(c -> (BotMember)((BotMember.Builder)BotMember.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getFailureReasons() {
            if (this.failureReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return this.failureReasons;
        }

        public final void setFailureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
        }

        @Override
        public final Builder failureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failureReasons(String ... failureReasons) {
            this.failureReasons(Arrays.asList(failureReasons));
            return this;
        }

        public final ErrorLogSettings.Builder getErrorLogSettings() {
            return this.errorLogSettings != null ? this.errorLogSettings.toBuilder() : null;
        }

        public final void setErrorLogSettings(ErrorLogSettings.BuilderImpl errorLogSettings) {
            this.errorLogSettings = errorLogSettings != null ? errorLogSettings.build() : null;
        }

        @Override
        public final Builder errorLogSettings(ErrorLogSettings errorLogSettings) {
            this.errorLogSettings = errorLogSettings;
            return this;
        }

        @Override
        public DescribeBotResponse build() {
            return new DescribeBotResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LexModelsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeBotResponse> {
        public Builder botId(String var1);

        public Builder botName(String var1);

        public Builder description(String var1);

        public Builder roleArn(String var1);

        public Builder dataPrivacy(DataPrivacy var1);

        default public Builder dataPrivacy(Consumer<DataPrivacy.Builder> dataPrivacy) {
            return this.dataPrivacy((DataPrivacy)((DataPrivacy.Builder)DataPrivacy.builder().applyMutation(dataPrivacy)).build());
        }

        public Builder idleSessionTTLInSeconds(Integer var1);

        public Builder botStatus(String var1);

        public Builder botStatus(BotStatus var1);

        public Builder creationDateTime(Instant var1);

        public Builder lastUpdatedDateTime(Instant var1);

        public Builder botType(String var1);

        public Builder botType(BotType var1);

        public Builder botMembers(Collection<BotMember> var1);

        public Builder botMembers(BotMember ... var1);

        public Builder botMembers(Consumer<BotMember.Builder> ... var1);

        public Builder failureReasons(Collection<String> var1);

        public Builder failureReasons(String ... var1);

        public Builder errorLogSettings(ErrorLogSettings var1);

        default public Builder errorLogSettings(Consumer<ErrorLogSettings.Builder> errorLogSettings) {
            return this.errorLogSettings((ErrorLogSettings)((ErrorLogSettings.Builder)ErrorLogSettings.builder().applyMutation(errorLogSettings)).build());
        }
    }
}

