/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.ExportResourceSpecification;
import software.amazon.awssdk.services.lexmodelsv2.model.ExportStatus;
import software.amazon.awssdk.services.lexmodelsv2.model.FailureReasonsCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.ImportExportFileFormat;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeExportResponse
extends LexModelsV2Response
implements ToCopyableBuilder<Builder, DescribeExportResponse> {
    private static final SdkField<String> EXPORT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("exportId").getter(DescribeExportResponse.getter(DescribeExportResponse::exportId)).setter(DescribeExportResponse.setter(Builder::exportId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportId").build()}).build();
    private static final SdkField<ExportResourceSpecification> RESOURCE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourceSpecification").getter(DescribeExportResponse.getter(DescribeExportResponse::resourceSpecification)).setter(DescribeExportResponse.setter(Builder::resourceSpecification)).constructor(ExportResourceSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceSpecification").build()}).build();
    private static final SdkField<String> FILE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fileFormat").getter(DescribeExportResponse.getter(DescribeExportResponse::fileFormatAsString)).setter(DescribeExportResponse.setter(Builder::fileFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileFormat").build()}).build();
    private static final SdkField<String> EXPORT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("exportStatus").getter(DescribeExportResponse.getter(DescribeExportResponse::exportStatusAsString)).setter(DescribeExportResponse.setter(Builder::exportStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportStatus").build()}).build();
    private static final SdkField<List<String>> FAILURE_REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failureReasons").getter(DescribeExportResponse.getter(DescribeExportResponse::failureReasons)).setter(DescribeExportResponse.setter(Builder::failureReasons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DOWNLOAD_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("downloadUrl").getter(DescribeExportResponse.getter(DescribeExportResponse::downloadUrl)).setter(DescribeExportResponse.setter(Builder::downloadUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("downloadUrl").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(DescribeExportResponse.getter(DescribeExportResponse::creationDateTime)).setter(DescribeExportResponse.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDateTime").getter(DescribeExportResponse.getter(DescribeExportResponse::lastUpdatedDateTime)).setter(DescribeExportResponse.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_ID_FIELD, RESOURCE_SPECIFICATION_FIELD, FILE_FORMAT_FIELD, EXPORT_STATUS_FIELD, FAILURE_REASONS_FIELD, DOWNLOAD_URL_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeExportResponse.memberNameToFieldInitializer();
    private final String exportId;
    private final ExportResourceSpecification resourceSpecification;
    private final String fileFormat;
    private final String exportStatus;
    private final List<String> failureReasons;
    private final String downloadUrl;
    private final Instant creationDateTime;
    private final Instant lastUpdatedDateTime;

    private DescribeExportResponse(BuilderImpl builder) {
        super(builder);
        this.exportId = builder.exportId;
        this.resourceSpecification = builder.resourceSpecification;
        this.fileFormat = builder.fileFormat;
        this.exportStatus = builder.exportStatus;
        this.failureReasons = builder.failureReasons;
        this.downloadUrl = builder.downloadUrl;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    public final String exportId() {
        return this.exportId;
    }

    public final ExportResourceSpecification resourceSpecification() {
        return this.resourceSpecification;
    }

    public final ImportExportFileFormat fileFormat() {
        return ImportExportFileFormat.fromValue(this.fileFormat);
    }

    public final String fileFormatAsString() {
        return this.fileFormat;
    }

    public final ExportStatus exportStatus() {
        return ExportStatus.fromValue(this.exportStatus);
    }

    public final String exportStatusAsString() {
        return this.exportStatus;
    }

    public final boolean hasFailureReasons() {
        return this.failureReasons != null && !(this.failureReasons instanceof SdkAutoConstructList);
    }

    public final List<String> failureReasons() {
        return this.failureReasons;
    }

    public final String downloadUrl() {
        return this.downloadUrl;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.exportId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailureReasons() ? this.failureReasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.downloadUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExportResponse)) {
            return false;
        }
        DescribeExportResponse other = (DescribeExportResponse)((Object)obj);
        return Objects.equals(this.exportId(), other.exportId()) && Objects.equals(this.resourceSpecification(), other.resourceSpecification()) && Objects.equals(this.fileFormatAsString(), other.fileFormatAsString()) && Objects.equals(this.exportStatusAsString(), other.exportStatusAsString()) && this.hasFailureReasons() == other.hasFailureReasons() && Objects.equals(this.failureReasons(), other.failureReasons()) && Objects.equals(this.downloadUrl(), other.downloadUrl()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeExportResponse").add("ExportId", (Object)this.exportId()).add("ResourceSpecification", (Object)this.resourceSpecification()).add("FileFormat", (Object)this.fileFormatAsString()).add("ExportStatus", (Object)this.exportStatusAsString()).add("FailureReasons", this.hasFailureReasons() ? this.failureReasons() : null).add("DownloadUrl", (Object)this.downloadUrl()).add("CreationDateTime", (Object)this.creationDateTime()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "exportId": {
                return Optional.ofNullable(clazz.cast(this.exportId()));
            }
            case "resourceSpecification": {
                return Optional.ofNullable(clazz.cast(this.resourceSpecification()));
            }
            case "fileFormat": {
                return Optional.ofNullable(clazz.cast(this.fileFormatAsString()));
            }
            case "exportStatus": {
                return Optional.ofNullable(clazz.cast(this.exportStatusAsString()));
            }
            case "failureReasons": {
                return Optional.ofNullable(clazz.cast(this.failureReasons()));
            }
            case "downloadUrl": {
                return Optional.ofNullable(clazz.cast(this.downloadUrl()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "lastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("exportId", EXPORT_ID_FIELD);
        map.put("resourceSpecification", RESOURCE_SPECIFICATION_FIELD);
        map.put("fileFormat", FILE_FORMAT_FIELD);
        map.put("exportStatus", EXPORT_STATUS_FIELD);
        map.put("failureReasons", FAILURE_REASONS_FIELD);
        map.put("downloadUrl", DOWNLOAD_URL_FIELD);
        map.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        map.put("lastUpdatedDateTime", LAST_UPDATED_DATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeExportResponse, T> g) {
        return obj -> g.apply((DescribeExportResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Response.BuilderImpl
    implements Builder {
        private String exportId;
        private ExportResourceSpecification resourceSpecification;
        private String fileFormat;
        private String exportStatus;
        private List<String> failureReasons = DefaultSdkAutoConstructList.getInstance();
        private String downloadUrl;
        private Instant creationDateTime;
        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExportResponse model) {
            super(model);
            this.exportId(model.exportId);
            this.resourceSpecification(model.resourceSpecification);
            this.fileFormat(model.fileFormat);
            this.exportStatus(model.exportStatus);
            this.failureReasons(model.failureReasons);
            this.downloadUrl(model.downloadUrl);
            this.creationDateTime(model.creationDateTime);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getExportId() {
            return this.exportId;
        }

        public final void setExportId(String exportId) {
            this.exportId = exportId;
        }

        @Override
        public final Builder exportId(String exportId) {
            this.exportId = exportId;
            return this;
        }

        public final ExportResourceSpecification.Builder getResourceSpecification() {
            return this.resourceSpecification != null ? this.resourceSpecification.toBuilder() : null;
        }

        public final void setResourceSpecification(ExportResourceSpecification.BuilderImpl resourceSpecification) {
            this.resourceSpecification = resourceSpecification != null ? resourceSpecification.build() : null;
        }

        @Override
        public final Builder resourceSpecification(ExportResourceSpecification resourceSpecification) {
            this.resourceSpecification = resourceSpecification;
            return this;
        }

        public final String getFileFormat() {
            return this.fileFormat;
        }

        public final void setFileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
        }

        @Override
        public final Builder fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        @Override
        public final Builder fileFormat(ImportExportFileFormat fileFormat) {
            this.fileFormat(fileFormat == null ? null : fileFormat.toString());
            return this;
        }

        public final String getExportStatus() {
            return this.exportStatus;
        }

        public final void setExportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
        }

        @Override
        public final Builder exportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
            return this;
        }

        @Override
        public final Builder exportStatus(ExportStatus exportStatus) {
            this.exportStatus(exportStatus == null ? null : exportStatus.toString());
            return this;
        }

        public final Collection<String> getFailureReasons() {
            if (this.failureReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return this.failureReasons;
        }

        public final void setFailureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
        }

        @Override
        public final Builder failureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failureReasons(String ... failureReasons) {
            this.failureReasons(Arrays.asList(failureReasons));
            return this;
        }

        public final String getDownloadUrl() {
            return this.downloadUrl;
        }

        public final void setDownloadUrl(String downloadUrl) {
            this.downloadUrl = downloadUrl;
        }

        @Override
        public final Builder downloadUrl(String downloadUrl) {
            this.downloadUrl = downloadUrl;
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        @Override
        public DescribeExportResponse build() {
            return new DescribeExportResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LexModelsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeExportResponse> {
        public Builder exportId(String var1);

        public Builder resourceSpecification(ExportResourceSpecification var1);

        default public Builder resourceSpecification(Consumer<ExportResourceSpecification.Builder> resourceSpecification) {
            return this.resourceSpecification((ExportResourceSpecification)((ExportResourceSpecification.Builder)ExportResourceSpecification.builder().applyMutation(resourceSpecification)).build());
        }

        public Builder fileFormat(String var1);

        public Builder fileFormat(ImportExportFileFormat var1);

        public Builder exportStatus(String var1);

        public Builder exportStatus(ExportStatus var1);

        public Builder failureReasons(Collection<String> var1);

        public Builder failureReasons(String ... var1);

        public Builder downloadUrl(String var1);

        public Builder creationDateTime(Instant var1);

        public Builder lastUpdatedDateTime(Instant var1);
    }
}

