/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2Client;
import software.amazon.awssdk.services.lexmodelsv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentMetricsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentMetricsResponse;

public class ListIntentMetricsIterable
implements SdkIterable<ListIntentMetricsResponse> {
    private final LexModelsV2Client client;
    private final ListIntentMetricsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListIntentMetricsIterable(LexModelsV2Client client, ListIntentMetricsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListIntentMetricsResponseFetcher();
    }

    public Iterator<ListIntentMetricsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListIntentMetricsResponseFetcher
    implements SyncPageFetcher<ListIntentMetricsResponse> {
        private ListIntentMetricsResponseFetcher() {
        }

        public boolean hasNextPage(ListIntentMetricsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListIntentMetricsResponse nextPage(ListIntentMetricsResponse previousPage) {
            if (previousPage == null) {
                return ListIntentMetricsIterable.this.client.listIntentMetrics(ListIntentMetricsIterable.this.firstRequest);
            }
            return ListIntentMetricsIterable.this.client.listIntentMetrics((ListIntentMetricsRequest)((Object)ListIntentMetricsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

