/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsPathFilter;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsPathFiltersCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListIntentPathsRequest
extends LexModelsV2Request
implements ToCopyableBuilder<Builder, ListIntentPathsRequest> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(ListIntentPathsRequest.getter(ListIntentPathsRequest::botId)).setter(ListIntentPathsRequest.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()}).build();
    private static final SdkField<Instant> START_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startDateTime").getter(ListIntentPathsRequest.getter(ListIntentPathsRequest::startDateTime)).setter(ListIntentPathsRequest.setter(Builder::startDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startDateTime").build()}).build();
    private static final SdkField<Instant> END_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endDateTime").getter(ListIntentPathsRequest.getter(ListIntentPathsRequest::endDateTime)).setter(ListIntentPathsRequest.setter(Builder::endDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endDateTime").build()}).build();
    private static final SdkField<String> INTENT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("intentPath").getter(ListIntentPathsRequest.getter(ListIntentPathsRequest::intentPath)).setter(ListIntentPathsRequest.setter(Builder::intentPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentPath").build()}).build();
    private static final SdkField<List<AnalyticsPathFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("filters").getter(ListIntentPathsRequest.getter(ListIntentPathsRequest::filters)).setter(ListIntentPathsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalyticsPathFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, START_DATE_TIME_FIELD, END_DATE_TIME_FIELD, INTENT_PATH_FIELD, FILTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListIntentPathsRequest.memberNameToFieldInitializer();
    private final String botId;
    private final Instant startDateTime;
    private final Instant endDateTime;
    private final String intentPath;
    private final List<AnalyticsPathFilter> filters;

    private ListIntentPathsRequest(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.startDateTime = builder.startDateTime;
        this.endDateTime = builder.endDateTime;
        this.intentPath = builder.intentPath;
        this.filters = builder.filters;
    }

    public final String botId() {
        return this.botId;
    }

    public final Instant startDateTime() {
        return this.startDateTime;
    }

    public final Instant endDateTime() {
        return this.endDateTime;
    }

    public final String intentPath() {
        return this.intentPath;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<AnalyticsPathFilter> filters() {
        return this.filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.intentPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIntentPathsRequest)) {
            return false;
        }
        ListIntentPathsRequest other = (ListIntentPathsRequest)((Object)obj);
        return Objects.equals(this.botId(), other.botId()) && Objects.equals(this.startDateTime(), other.startDateTime()) && Objects.equals(this.endDateTime(), other.endDateTime()) && Objects.equals(this.intentPath(), other.intentPath()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters());
    }

    public final String toString() {
        return ToString.builder((String)"ListIntentPathsRequest").add("BotId", (Object)this.botId()).add("StartDateTime", (Object)this.startDateTime()).add("EndDateTime", (Object)this.endDateTime()).add("IntentPath", (Object)this.intentPath()).add("Filters", this.hasFilters() ? this.filters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "startDateTime": {
                return Optional.ofNullable(clazz.cast(this.startDateTime()));
            }
            case "endDateTime": {
                return Optional.ofNullable(clazz.cast(this.endDateTime()));
            }
            case "intentPath": {
                return Optional.ofNullable(clazz.cast(this.intentPath()));
            }
            case "filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("botId", BOT_ID_FIELD);
        map.put("startDateTime", START_DATE_TIME_FIELD);
        map.put("endDateTime", END_DATE_TIME_FIELD);
        map.put("intentPath", INTENT_PATH_FIELD);
        map.put("filters", FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListIntentPathsRequest, T> g) {
        return obj -> g.apply((ListIntentPathsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Request.BuilderImpl
    implements Builder {
        private String botId;
        private Instant startDateTime;
        private Instant endDateTime;
        private String intentPath;
        private List<AnalyticsPathFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListIntentPathsRequest model) {
            super(model);
            this.botId(model.botId);
            this.startDateTime(model.startDateTime);
            this.endDateTime(model.endDateTime);
            this.intentPath(model.intentPath);
            this.filters(model.filters);
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final Instant getStartDateTime() {
            return this.startDateTime;
        }

        public final void setStartDateTime(Instant startDateTime) {
            this.startDateTime = startDateTime;
        }

        @Override
        public final Builder startDateTime(Instant startDateTime) {
            this.startDateTime = startDateTime;
            return this;
        }

        public final Instant getEndDateTime() {
            return this.endDateTime;
        }

        public final void setEndDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
        }

        @Override
        public final Builder endDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
            return this;
        }

        public final String getIntentPath() {
            return this.intentPath;
        }

        public final void setIntentPath(String intentPath) {
            this.intentPath = intentPath;
        }

        @Override
        public final Builder intentPath(String intentPath) {
            this.intentPath = intentPath;
            return this;
        }

        public final List<AnalyticsPathFilter.Builder> getFilters() {
            List<AnalyticsPathFilter.Builder> result = AnalyticsPathFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<AnalyticsPathFilter.BuilderImpl> filters) {
            this.filters = AnalyticsPathFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<AnalyticsPathFilter> filters) {
            this.filters = AnalyticsPathFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(AnalyticsPathFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<AnalyticsPathFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (AnalyticsPathFilter)((AnalyticsPathFilter.Builder)AnalyticsPathFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListIntentPathsRequest build() {
            return new ListIntentPathsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LexModelsV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListIntentPathsRequest> {
        public Builder botId(String var1);

        public Builder startDateTime(Instant var1);

        public Builder endDateTime(Instant var1);

        public Builder intentPath(String var1);

        public Builder filters(Collection<AnalyticsPathFilter> var1);

        public Builder filters(AnalyticsPathFilter ... var1);

        public Builder filters(Consumer<AnalyticsPathFilter.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

