/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelsv2.model.BedrockGuardrailConfiguration;
import software.amazon.awssdk.services.lexmodelsv2.model.BedrockTraceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BedrockModelSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BedrockModelSpecification> {
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelArn").getter(BedrockModelSpecification.getter(BedrockModelSpecification::modelArn)).setter(BedrockModelSpecification.setter(Builder::modelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelArn").build()}).build();
    private static final SdkField<BedrockGuardrailConfiguration> GUARDRAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("guardrail").getter(BedrockModelSpecification.getter(BedrockModelSpecification::guardrail)).setter(BedrockModelSpecification.setter(Builder::guardrail)).constructor(BedrockGuardrailConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrail").build()}).build();
    private static final SdkField<String> TRACE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("traceStatus").getter(BedrockModelSpecification.getter(BedrockModelSpecification::traceStatusAsString)).setter(BedrockModelSpecification.setter(Builder::traceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("traceStatus").build()}).build();
    private static final SdkField<String> CUSTOM_PROMPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customPrompt").getter(BedrockModelSpecification.getter(BedrockModelSpecification::customPrompt)).setter(BedrockModelSpecification.setter(Builder::customPrompt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customPrompt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ARN_FIELD, GUARDRAIL_FIELD, TRACE_STATUS_FIELD, CUSTOM_PROMPT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BedrockModelSpecification.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String modelArn;
    private final BedrockGuardrailConfiguration guardrail;
    private final String traceStatus;
    private final String customPrompt;

    private BedrockModelSpecification(BuilderImpl builder) {
        this.modelArn = builder.modelArn;
        this.guardrail = builder.guardrail;
        this.traceStatus = builder.traceStatus;
        this.customPrompt = builder.customPrompt;
    }

    public final String modelArn() {
        return this.modelArn;
    }

    public final BedrockGuardrailConfiguration guardrail() {
        return this.guardrail;
    }

    public final BedrockTraceStatus traceStatus() {
        return BedrockTraceStatus.fromValue(this.traceStatus);
    }

    public final String traceStatusAsString() {
        return this.traceStatus;
    }

    public final String customPrompt() {
        return this.customPrompt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrail());
        hashCode = 31 * hashCode + Objects.hashCode(this.traceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.customPrompt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BedrockModelSpecification)) {
            return false;
        }
        BedrockModelSpecification other = (BedrockModelSpecification)obj;
        return Objects.equals(this.modelArn(), other.modelArn()) && Objects.equals(this.guardrail(), other.guardrail()) && Objects.equals(this.traceStatusAsString(), other.traceStatusAsString()) && Objects.equals(this.customPrompt(), other.customPrompt());
    }

    public final String toString() {
        return ToString.builder((String)"BedrockModelSpecification").add("ModelArn", (Object)this.modelArn()).add("Guardrail", (Object)this.guardrail()).add("TraceStatus", (Object)this.traceStatusAsString()).add("CustomPrompt", (Object)this.customPrompt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "modelArn": {
                return Optional.ofNullable(clazz.cast(this.modelArn()));
            }
            case "guardrail": {
                return Optional.ofNullable(clazz.cast(this.guardrail()));
            }
            case "traceStatus": {
                return Optional.ofNullable(clazz.cast(this.traceStatusAsString()));
            }
            case "customPrompt": {
                return Optional.ofNullable(clazz.cast(this.customPrompt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("modelArn", MODEL_ARN_FIELD);
        map.put("guardrail", GUARDRAIL_FIELD);
        map.put("traceStatus", TRACE_STATUS_FIELD);
        map.put("customPrompt", CUSTOM_PROMPT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BedrockModelSpecification, T> g) {
        return obj -> g.apply((BedrockModelSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelArn;
        private BedrockGuardrailConfiguration guardrail;
        private String traceStatus;
        private String customPrompt;

        private BuilderImpl() {
        }

        private BuilderImpl(BedrockModelSpecification model) {
            this.modelArn(model.modelArn);
            this.guardrail(model.guardrail);
            this.traceStatus(model.traceStatus);
            this.customPrompt(model.customPrompt);
        }

        public final String getModelArn() {
            return this.modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final BedrockGuardrailConfiguration.Builder getGuardrail() {
            return this.guardrail != null ? this.guardrail.toBuilder() : null;
        }

        public final void setGuardrail(BedrockGuardrailConfiguration.BuilderImpl guardrail) {
            this.guardrail = guardrail != null ? guardrail.build() : null;
        }

        @Override
        public final Builder guardrail(BedrockGuardrailConfiguration guardrail) {
            this.guardrail = guardrail;
            return this;
        }

        public final String getTraceStatus() {
            return this.traceStatus;
        }

        public final void setTraceStatus(String traceStatus) {
            this.traceStatus = traceStatus;
        }

        @Override
        public final Builder traceStatus(String traceStatus) {
            this.traceStatus = traceStatus;
            return this;
        }

        @Override
        public final Builder traceStatus(BedrockTraceStatus traceStatus) {
            this.traceStatus(traceStatus == null ? null : traceStatus.toString());
            return this;
        }

        public final String getCustomPrompt() {
            return this.customPrompt;
        }

        public final void setCustomPrompt(String customPrompt) {
            this.customPrompt = customPrompt;
        }

        @Override
        public final Builder customPrompt(String customPrompt) {
            this.customPrompt = customPrompt;
            return this;
        }

        public BedrockModelSpecification build() {
            return new BedrockModelSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BedrockModelSpecification> {
        public Builder modelArn(String var1);

        public Builder guardrail(BedrockGuardrailConfiguration var1);

        default public Builder guardrail(Consumer<BedrockGuardrailConfiguration.Builder> guardrail) {
            return this.guardrail((BedrockGuardrailConfiguration)((BedrockGuardrailConfiguration.Builder)BedrockGuardrailConfiguration.builder().applyMutation(guardrail)).build());
        }

        public Builder traceStatus(String var1);

        public Builder traceStatus(BedrockTraceStatus var1);

        public Builder customPrompt(String var1);
    }
}

