/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinByListCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinBySpecification;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentStageFilter;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentStageFiltersCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentStageGroupByListCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentStageGroupBySpecification;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentStageMetric;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentStageMetricsCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListIntentStageMetricsRequest
extends LexModelsV2Request
implements ToCopyableBuilder<Builder, ListIntentStageMetricsRequest> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(ListIntentStageMetricsRequest.getter(ListIntentStageMetricsRequest::botId)).setter(ListIntentStageMetricsRequest.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()}).build();
    private static final SdkField<Instant> START_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startDateTime").getter(ListIntentStageMetricsRequest.getter(ListIntentStageMetricsRequest::startDateTime)).setter(ListIntentStageMetricsRequest.setter(Builder::startDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startDateTime").build()}).build();
    private static final SdkField<Instant> END_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endDateTime").getter(ListIntentStageMetricsRequest.getter(ListIntentStageMetricsRequest::endDateTime)).setter(ListIntentStageMetricsRequest.setter(Builder::endDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endDateTime").build()}).build();
    private static final SdkField<List<AnalyticsIntentStageMetric>> METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metrics").getter(ListIntentStageMetricsRequest.getter(ListIntentStageMetricsRequest::metrics)).setter(ListIntentStageMetricsRequest.setter(Builder::metrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalyticsIntentStageMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AnalyticsBinBySpecification>> BIN_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("binBy").getter(ListIntentStageMetricsRequest.getter(ListIntentStageMetricsRequest::binBy)).setter(ListIntentStageMetricsRequest.setter(Builder::binBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("binBy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalyticsBinBySpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AnalyticsIntentStageGroupBySpecification>> GROUP_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("groupBy").getter(ListIntentStageMetricsRequest.getter(ListIntentStageMetricsRequest::groupBy)).setter(ListIntentStageMetricsRequest.setter(Builder::groupBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupBy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalyticsIntentStageGroupBySpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AnalyticsIntentStageFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("filters").getter(ListIntentStageMetricsRequest.getter(ListIntentStageMetricsRequest::filters)).setter(ListIntentStageMetricsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalyticsIntentStageFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListIntentStageMetricsRequest.getter(ListIntentStageMetricsRequest::maxResults)).setter(ListIntentStageMetricsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListIntentStageMetricsRequest.getter(ListIntentStageMetricsRequest::nextToken)).setter(ListIntentStageMetricsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, START_DATE_TIME_FIELD, END_DATE_TIME_FIELD, METRICS_FIELD, BIN_BY_FIELD, GROUP_BY_FIELD, FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListIntentStageMetricsRequest.memberNameToFieldInitializer();
    private final String botId;
    private final Instant startDateTime;
    private final Instant endDateTime;
    private final List<AnalyticsIntentStageMetric> metrics;
    private final List<AnalyticsBinBySpecification> binBy;
    private final List<AnalyticsIntentStageGroupBySpecification> groupBy;
    private final List<AnalyticsIntentStageFilter> filters;
    private final Integer maxResults;
    private final String nextToken;

    private ListIntentStageMetricsRequest(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.startDateTime = builder.startDateTime;
        this.endDateTime = builder.endDateTime;
        this.metrics = builder.metrics;
        this.binBy = builder.binBy;
        this.groupBy = builder.groupBy;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String botId() {
        return this.botId;
    }

    public final Instant startDateTime() {
        return this.startDateTime;
    }

    public final Instant endDateTime() {
        return this.endDateTime;
    }

    public final boolean hasMetrics() {
        return this.metrics != null && !(this.metrics instanceof SdkAutoConstructList);
    }

    public final List<AnalyticsIntentStageMetric> metrics() {
        return this.metrics;
    }

    public final boolean hasBinBy() {
        return this.binBy != null && !(this.binBy instanceof SdkAutoConstructList);
    }

    public final List<AnalyticsBinBySpecification> binBy() {
        return this.binBy;
    }

    public final boolean hasGroupBy() {
        return this.groupBy != null && !(this.groupBy instanceof SdkAutoConstructList);
    }

    public final List<AnalyticsIntentStageGroupBySpecification> groupBy() {
        return this.groupBy;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<AnalyticsIntentStageFilter> filters() {
        return this.filters;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetrics() ? this.metrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBinBy() ? this.binBy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupBy() ? this.groupBy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIntentStageMetricsRequest)) {
            return false;
        }
        ListIntentStageMetricsRequest other = (ListIntentStageMetricsRequest)((Object)obj);
        return Objects.equals(this.botId(), other.botId()) && Objects.equals(this.startDateTime(), other.startDateTime()) && Objects.equals(this.endDateTime(), other.endDateTime()) && this.hasMetrics() == other.hasMetrics() && Objects.equals(this.metrics(), other.metrics()) && this.hasBinBy() == other.hasBinBy() && Objects.equals(this.binBy(), other.binBy()) && this.hasGroupBy() == other.hasGroupBy() && Objects.equals(this.groupBy(), other.groupBy()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListIntentStageMetricsRequest").add("BotId", (Object)this.botId()).add("StartDateTime", (Object)this.startDateTime()).add("EndDateTime", (Object)this.endDateTime()).add("Metrics", this.hasMetrics() ? this.metrics() : null).add("BinBy", this.hasBinBy() ? this.binBy() : null).add("GroupBy", this.hasGroupBy() ? this.groupBy() : null).add("Filters", this.hasFilters() ? this.filters() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "startDateTime": {
                return Optional.ofNullable(clazz.cast(this.startDateTime()));
            }
            case "endDateTime": {
                return Optional.ofNullable(clazz.cast(this.endDateTime()));
            }
            case "metrics": {
                return Optional.ofNullable(clazz.cast(this.metrics()));
            }
            case "binBy": {
                return Optional.ofNullable(clazz.cast(this.binBy()));
            }
            case "groupBy": {
                return Optional.ofNullable(clazz.cast(this.groupBy()));
            }
            case "filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("botId", BOT_ID_FIELD);
        map.put("startDateTime", START_DATE_TIME_FIELD);
        map.put("endDateTime", END_DATE_TIME_FIELD);
        map.put("metrics", METRICS_FIELD);
        map.put("binBy", BIN_BY_FIELD);
        map.put("groupBy", GROUP_BY_FIELD);
        map.put("filters", FILTERS_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListIntentStageMetricsRequest, T> g) {
        return obj -> g.apply((ListIntentStageMetricsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Request.BuilderImpl
    implements Builder {
        private String botId;
        private Instant startDateTime;
        private Instant endDateTime;
        private List<AnalyticsIntentStageMetric> metrics = DefaultSdkAutoConstructList.getInstance();
        private List<AnalyticsBinBySpecification> binBy = DefaultSdkAutoConstructList.getInstance();
        private List<AnalyticsIntentStageGroupBySpecification> groupBy = DefaultSdkAutoConstructList.getInstance();
        private List<AnalyticsIntentStageFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIntentStageMetricsRequest model) {
            super(model);
            this.botId(model.botId);
            this.startDateTime(model.startDateTime);
            this.endDateTime(model.endDateTime);
            this.metrics(model.metrics);
            this.binBy(model.binBy);
            this.groupBy(model.groupBy);
            this.filters(model.filters);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final Instant getStartDateTime() {
            return this.startDateTime;
        }

        public final void setStartDateTime(Instant startDateTime) {
            this.startDateTime = startDateTime;
        }

        @Override
        public final Builder startDateTime(Instant startDateTime) {
            this.startDateTime = startDateTime;
            return this;
        }

        public final Instant getEndDateTime() {
            return this.endDateTime;
        }

        public final void setEndDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
        }

        @Override
        public final Builder endDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
            return this;
        }

        public final List<AnalyticsIntentStageMetric.Builder> getMetrics() {
            List<AnalyticsIntentStageMetric.Builder> result = AnalyticsIntentStageMetricsCopier.copyToBuilder(this.metrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetrics(Collection<AnalyticsIntentStageMetric.BuilderImpl> metrics) {
            this.metrics = AnalyticsIntentStageMetricsCopier.copyFromBuilder(metrics);
        }

        @Override
        public final Builder metrics(Collection<AnalyticsIntentStageMetric> metrics) {
            this.metrics = AnalyticsIntentStageMetricsCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(AnalyticsIntentStageMetric ... metrics) {
            this.metrics(Arrays.asList(metrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(Consumer<AnalyticsIntentStageMetric.Builder> ... metrics) {
            this.metrics(Stream.of(metrics).map(c -> (AnalyticsIntentStageMetric)((AnalyticsIntentStageMetric.Builder)AnalyticsIntentStageMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AnalyticsBinBySpecification.Builder> getBinBy() {
            List<AnalyticsBinBySpecification.Builder> result = AnalyticsBinByListCopier.copyToBuilder(this.binBy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBinBy(Collection<AnalyticsBinBySpecification.BuilderImpl> binBy) {
            this.binBy = AnalyticsBinByListCopier.copyFromBuilder(binBy);
        }

        @Override
        public final Builder binBy(Collection<AnalyticsBinBySpecification> binBy) {
            this.binBy = AnalyticsBinByListCopier.copy(binBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder binBy(AnalyticsBinBySpecification ... binBy) {
            this.binBy(Arrays.asList(binBy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder binBy(Consumer<AnalyticsBinBySpecification.Builder> ... binBy) {
            this.binBy(Stream.of(binBy).map(c -> (AnalyticsBinBySpecification)((AnalyticsBinBySpecification.Builder)AnalyticsBinBySpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AnalyticsIntentStageGroupBySpecification.Builder> getGroupBy() {
            List<AnalyticsIntentStageGroupBySpecification.Builder> result = AnalyticsIntentStageGroupByListCopier.copyToBuilder(this.groupBy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupBy(Collection<AnalyticsIntentStageGroupBySpecification.BuilderImpl> groupBy) {
            this.groupBy = AnalyticsIntentStageGroupByListCopier.copyFromBuilder(groupBy);
        }

        @Override
        public final Builder groupBy(Collection<AnalyticsIntentStageGroupBySpecification> groupBy) {
            this.groupBy = AnalyticsIntentStageGroupByListCopier.copy(groupBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupBy(AnalyticsIntentStageGroupBySpecification ... groupBy) {
            this.groupBy(Arrays.asList(groupBy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupBy(Consumer<AnalyticsIntentStageGroupBySpecification.Builder> ... groupBy) {
            this.groupBy(Stream.of(groupBy).map(c -> (AnalyticsIntentStageGroupBySpecification)((AnalyticsIntentStageGroupBySpecification.Builder)AnalyticsIntentStageGroupBySpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AnalyticsIntentStageFilter.Builder> getFilters() {
            List<AnalyticsIntentStageFilter.Builder> result = AnalyticsIntentStageFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<AnalyticsIntentStageFilter.BuilderImpl> filters) {
            this.filters = AnalyticsIntentStageFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<AnalyticsIntentStageFilter> filters) {
            this.filters = AnalyticsIntentStageFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(AnalyticsIntentStageFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<AnalyticsIntentStageFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (AnalyticsIntentStageFilter)((AnalyticsIntentStageFilter.Builder)AnalyticsIntentStageFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListIntentStageMetricsRequest build() {
            return new ListIntentStageMetricsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LexModelsV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListIntentStageMetricsRequest> {
        public Builder botId(String var1);

        public Builder startDateTime(Instant var1);

        public Builder endDateTime(Instant var1);

        public Builder metrics(Collection<AnalyticsIntentStageMetric> var1);

        public Builder metrics(AnalyticsIntentStageMetric ... var1);

        public Builder metrics(Consumer<AnalyticsIntentStageMetric.Builder> ... var1);

        public Builder binBy(Collection<AnalyticsBinBySpecification> var1);

        public Builder binBy(AnalyticsBinBySpecification ... var1);

        public Builder binBy(Consumer<AnalyticsBinBySpecification.Builder> ... var1);

        public Builder groupBy(Collection<AnalyticsIntentStageGroupBySpecification> var1);

        public Builder groupBy(AnalyticsIntentStageGroupBySpecification ... var1);

        public Builder groupBy(Consumer<AnalyticsIntentStageGroupBySpecification.Builder> ... var1);

        public Builder filters(Collection<AnalyticsIntentStageFilter> var1);

        public Builder filters(AnalyticsIntentStageFilter ... var1);

        public Builder filters(Consumer<AnalyticsIntentStageFilter.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

