/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsFilterOperator;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsFilterValuesCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentStageFilterName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnalyticsIntentStageFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnalyticsIntentStageFilter> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(AnalyticsIntentStageFilter.getter(AnalyticsIntentStageFilter::nameAsString)).setter(AnalyticsIntentStageFilter.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operator").getter(AnalyticsIntentStageFilter.getter(AnalyticsIntentStageFilter::operatorAsString)).setter(AnalyticsIntentStageFilter.setter(Builder::operator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operator").build()}).build();
    private static final SdkField<List<String>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("values").getter(AnalyticsIntentStageFilter.getter(AnalyticsIntentStageFilter::values)).setter(AnalyticsIntentStageFilter.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, OPERATOR_FIELD, VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AnalyticsIntentStageFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String operator;
    private final List<String> values;

    private AnalyticsIntentStageFilter(BuilderImpl builder) {
        this.name = builder.name;
        this.operator = builder.operator;
        this.values = builder.values;
    }

    public final AnalyticsIntentStageFilterName name() {
        return AnalyticsIntentStageFilterName.fromValue(this.name);
    }

    public final String nameAsString() {
        return this.name;
    }

    public final AnalyticsFilterOperator operator() {
        return AnalyticsFilterOperator.fromValue(this.operator);
    }

    public final String operatorAsString() {
        return this.operator;
    }

    public final boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public final List<String> values() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValues() ? this.values() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyticsIntentStageFilter)) {
            return false;
        }
        AnalyticsIntentStageFilter other = (AnalyticsIntentStageFilter)obj;
        return Objects.equals(this.nameAsString(), other.nameAsString()) && Objects.equals(this.operatorAsString(), other.operatorAsString()) && this.hasValues() == other.hasValues() && Objects.equals(this.values(), other.values());
    }

    public final String toString() {
        return ToString.builder((String)"AnalyticsIntentStageFilter").add("Name", (Object)this.nameAsString()).add("Operator", (Object)this.operatorAsString()).add("Values", this.hasValues() ? this.values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.nameAsString()));
            }
            case "operator": {
                return Optional.ofNullable(clazz.cast(this.operatorAsString()));
            }
            case "values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("operator", OPERATOR_FIELD);
        map.put("values", VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnalyticsIntentStageFilter, T> g) {
        return obj -> g.apply((AnalyticsIntentStageFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String operator;
        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyticsIntentStageFilter model) {
            this.name(model.name);
            this.operator(model.operator);
            this.values(model.values);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(AnalyticsIntentStageFilterName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final String getOperator() {
            return this.operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(AnalyticsFilterOperator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public final Collection<String> getValues() {
            if (this.values instanceof SdkAutoConstructList) {
                return null;
            }
            return this.values;
        }

        public final void setValues(Collection<String> values) {
            this.values = AnalyticsFilterValuesCopier.copy(values);
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = AnalyticsFilterValuesCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public AnalyticsIntentStageFilter build() {
            return new AnalyticsIntentStageFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnalyticsIntentStageFilter> {
        public Builder name(String var1);

        public Builder name(AnalyticsIntentStageFilterName var1);

        public Builder operator(String var1);

        public Builder operator(AnalyticsFilterOperator var1);

        public Builder values(Collection<String> var1);

        public Builder values(String ... var1);
    }
}

