/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The object representing the passwords that were used to encrypt the data related to the bot recommendation, as well
 * as the KMS key ARN used to encrypt the associated metadata.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EncryptionSetting implements SdkPojo, Serializable,
        ToCopyableBuilder<EncryptionSetting.Builder, EncryptionSetting> {
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyArn").getter(getter(EncryptionSetting::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()).build();

    private static final SdkField<String> BOT_LOCALE_EXPORT_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botLocaleExportPassword").getter(getter(EncryptionSetting::botLocaleExportPassword))
            .setter(setter(Builder::botLocaleExportPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botLocaleExportPassword").build())
            .build();

    private static final SdkField<String> ASSOCIATED_TRANSCRIPTS_PASSWORD_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("associatedTranscriptsPassword")
            .getter(getter(EncryptionSetting::associatedTranscriptsPassword))
            .setter(setter(Builder::associatedTranscriptsPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedTranscriptsPassword")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ARN_FIELD,
            BOT_LOCALE_EXPORT_PASSWORD_FIELD, ASSOCIATED_TRANSCRIPTS_PASSWORD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String kmsKeyArn;

    private final String botLocaleExportPassword;

    private final String associatedTranscriptsPassword;

    private EncryptionSetting(BuilderImpl builder) {
        this.kmsKeyArn = builder.kmsKeyArn;
        this.botLocaleExportPassword = builder.botLocaleExportPassword;
        this.associatedTranscriptsPassword = builder.associatedTranscriptsPassword;
    }

    /**
     * <p>
     * The KMS key ARN used to encrypt the metadata associated with the bot recommendation.
     * </p>
     * 
     * @return The KMS key ARN used to encrypt the metadata associated with the bot recommendation.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * <p>
     * The password used to encrypt the recommended bot recommendation file.
     * </p>
     * 
     * @return The password used to encrypt the recommended bot recommendation file.
     */
    public final String botLocaleExportPassword() {
        return botLocaleExportPassword;
    }

    /**
     * <p>
     * The password used to encrypt the associated transcript file.
     * </p>
     * 
     * @return The password used to encrypt the associated transcript file.
     */
    public final String associatedTranscriptsPassword() {
        return associatedTranscriptsPassword;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(botLocaleExportPassword());
        hashCode = 31 * hashCode + Objects.hashCode(associatedTranscriptsPassword());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionSetting)) {
            return false;
        }
        EncryptionSetting other = (EncryptionSetting) obj;
        return Objects.equals(kmsKeyArn(), other.kmsKeyArn())
                && Objects.equals(botLocaleExportPassword(), other.botLocaleExportPassword())
                && Objects.equals(associatedTranscriptsPassword(), other.associatedTranscriptsPassword());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("EncryptionSetting")
                .add("KmsKeyArn", kmsKeyArn())
                .add("BotLocaleExportPassword", botLocaleExportPassword() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AssociatedTranscriptsPassword",
                        associatedTranscriptsPassword() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "kmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "botLocaleExportPassword":
            return Optional.ofNullable(clazz.cast(botLocaleExportPassword()));
        case "associatedTranscriptsPassword":
            return Optional.ofNullable(clazz.cast(associatedTranscriptsPassword()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("kmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("botLocaleExportPassword", BOT_LOCALE_EXPORT_PASSWORD_FIELD);
        map.put("associatedTranscriptsPassword", ASSOCIATED_TRANSCRIPTS_PASSWORD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EncryptionSetting, T> g) {
        return obj -> g.apply((EncryptionSetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EncryptionSetting> {
        /**
         * <p>
         * The KMS key ARN used to encrypt the metadata associated with the bot recommendation.
         * </p>
         * 
         * @param kmsKeyArn
         *        The KMS key ARN used to encrypt the metadata associated with the bot recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * The password used to encrypt the recommended bot recommendation file.
         * </p>
         * 
         * @param botLocaleExportPassword
         *        The password used to encrypt the recommended bot recommendation file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botLocaleExportPassword(String botLocaleExportPassword);

        /**
         * <p>
         * The password used to encrypt the associated transcript file.
         * </p>
         * 
         * @param associatedTranscriptsPassword
         *        The password used to encrypt the associated transcript file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedTranscriptsPassword(String associatedTranscriptsPassword);
    }

    static final class BuilderImpl implements Builder {
        private String kmsKeyArn;

        private String botLocaleExportPassword;

        private String associatedTranscriptsPassword;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionSetting model) {
            kmsKeyArn(model.kmsKeyArn);
            botLocaleExportPassword(model.botLocaleExportPassword);
            associatedTranscriptsPassword(model.associatedTranscriptsPassword);
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final String getBotLocaleExportPassword() {
            return botLocaleExportPassword;
        }

        public final void setBotLocaleExportPassword(String botLocaleExportPassword) {
            this.botLocaleExportPassword = botLocaleExportPassword;
        }

        @Override
        public final Builder botLocaleExportPassword(String botLocaleExportPassword) {
            this.botLocaleExportPassword = botLocaleExportPassword;
            return this;
        }

        public final String getAssociatedTranscriptsPassword() {
            return associatedTranscriptsPassword;
        }

        public final void setAssociatedTranscriptsPassword(String associatedTranscriptsPassword) {
            this.associatedTranscriptsPassword = associatedTranscriptsPassword;
        }

        @Override
        public final Builder associatedTranscriptsPassword(String associatedTranscriptsPassword) {
            this.associatedTranscriptsPassword = associatedTranscriptsPassword;
            return this;
        }

        @Override
        public EncryptionSetting build() {
            return new EncryptionSetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
