/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a prompt for making sure that the user is ready for the intent to be fulfilled.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IntentConfirmationSetting implements SdkPojo, Serializable,
        ToCopyableBuilder<IntentConfirmationSetting.Builder, IntentConfirmationSetting> {
    private static final SdkField<PromptSpecification> PROMPT_SPECIFICATION_FIELD = SdkField
            .<PromptSpecification> builder(MarshallingType.SDK_POJO).memberName("promptSpecification")
            .getter(getter(IntentConfirmationSetting::promptSpecification)).setter(setter(Builder::promptSpecification))
            .constructor(PromptSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptSpecification").build())
            .build();

    private static final SdkField<ResponseSpecification> DECLINATION_RESPONSE_FIELD = SdkField
            .<ResponseSpecification> builder(MarshallingType.SDK_POJO).memberName("declinationResponse")
            .getter(getter(IntentConfirmationSetting::declinationResponse)).setter(setter(Builder::declinationResponse))
            .constructor(ResponseSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("declinationResponse").build())
            .build();

    private static final SdkField<Boolean> ACTIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("active").getter(getter(IntentConfirmationSetting::active)).setter(setter(Builder::active))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("active").build()).build();

    private static final SdkField<ResponseSpecification> CONFIRMATION_RESPONSE_FIELD = SdkField
            .<ResponseSpecification> builder(MarshallingType.SDK_POJO).memberName("confirmationResponse")
            .getter(getter(IntentConfirmationSetting::confirmationResponse)).setter(setter(Builder::confirmationResponse))
            .constructor(ResponseSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confirmationResponse").build())
            .build();

    private static final SdkField<DialogState> CONFIRMATION_NEXT_STEP_FIELD = SdkField
            .<DialogState> builder(MarshallingType.SDK_POJO).memberName("confirmationNextStep")
            .getter(getter(IntentConfirmationSetting::confirmationNextStep)).setter(setter(Builder::confirmationNextStep))
            .constructor(DialogState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confirmationNextStep").build())
            .build();

    private static final SdkField<ConditionalSpecification> CONFIRMATION_CONDITIONAL_FIELD = SdkField
            .<ConditionalSpecification> builder(MarshallingType.SDK_POJO).memberName("confirmationConditional")
            .getter(getter(IntentConfirmationSetting::confirmationConditional)).setter(setter(Builder::confirmationConditional))
            .constructor(ConditionalSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confirmationConditional").build())
            .build();

    private static final SdkField<DialogState> DECLINATION_NEXT_STEP_FIELD = SdkField
            .<DialogState> builder(MarshallingType.SDK_POJO).memberName("declinationNextStep")
            .getter(getter(IntentConfirmationSetting::declinationNextStep)).setter(setter(Builder::declinationNextStep))
            .constructor(DialogState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("declinationNextStep").build())
            .build();

    private static final SdkField<ConditionalSpecification> DECLINATION_CONDITIONAL_FIELD = SdkField
            .<ConditionalSpecification> builder(MarshallingType.SDK_POJO).memberName("declinationConditional")
            .getter(getter(IntentConfirmationSetting::declinationConditional)).setter(setter(Builder::declinationConditional))
            .constructor(ConditionalSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("declinationConditional").build())
            .build();

    private static final SdkField<ResponseSpecification> FAILURE_RESPONSE_FIELD = SdkField
            .<ResponseSpecification> builder(MarshallingType.SDK_POJO).memberName("failureResponse")
            .getter(getter(IntentConfirmationSetting::failureResponse)).setter(setter(Builder::failureResponse))
            .constructor(ResponseSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureResponse").build()).build();

    private static final SdkField<DialogState> FAILURE_NEXT_STEP_FIELD = SdkField.<DialogState> builder(MarshallingType.SDK_POJO)
            .memberName("failureNextStep").getter(getter(IntentConfirmationSetting::failureNextStep))
            .setter(setter(Builder::failureNextStep)).constructor(DialogState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureNextStep").build()).build();

    private static final SdkField<ConditionalSpecification> FAILURE_CONDITIONAL_FIELD = SdkField
            .<ConditionalSpecification> builder(MarshallingType.SDK_POJO).memberName("failureConditional")
            .getter(getter(IntentConfirmationSetting::failureConditional)).setter(setter(Builder::failureConditional))
            .constructor(ConditionalSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureConditional").build())
            .build();

    private static final SdkField<DialogCodeHookInvocationSetting> CODE_HOOK_FIELD = SdkField
            .<DialogCodeHookInvocationSetting> builder(MarshallingType.SDK_POJO).memberName("codeHook")
            .getter(getter(IntentConfirmationSetting::codeHook)).setter(setter(Builder::codeHook))
            .constructor(DialogCodeHookInvocationSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeHook").build()).build();

    private static final SdkField<ElicitationCodeHookInvocationSetting> ELICITATION_CODE_HOOK_FIELD = SdkField
            .<ElicitationCodeHookInvocationSetting> builder(MarshallingType.SDK_POJO).memberName("elicitationCodeHook")
            .getter(getter(IntentConfirmationSetting::elicitationCodeHook)).setter(setter(Builder::elicitationCodeHook))
            .constructor(ElicitationCodeHookInvocationSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elicitationCodeHook").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROMPT_SPECIFICATION_FIELD,
            DECLINATION_RESPONSE_FIELD, ACTIVE_FIELD, CONFIRMATION_RESPONSE_FIELD, CONFIRMATION_NEXT_STEP_FIELD,
            CONFIRMATION_CONDITIONAL_FIELD, DECLINATION_NEXT_STEP_FIELD, DECLINATION_CONDITIONAL_FIELD, FAILURE_RESPONSE_FIELD,
            FAILURE_NEXT_STEP_FIELD, FAILURE_CONDITIONAL_FIELD, CODE_HOOK_FIELD, ELICITATION_CODE_HOOK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final PromptSpecification promptSpecification;

    private final ResponseSpecification declinationResponse;

    private final Boolean active;

    private final ResponseSpecification confirmationResponse;

    private final DialogState confirmationNextStep;

    private final ConditionalSpecification confirmationConditional;

    private final DialogState declinationNextStep;

    private final ConditionalSpecification declinationConditional;

    private final ResponseSpecification failureResponse;

    private final DialogState failureNextStep;

    private final ConditionalSpecification failureConditional;

    private final DialogCodeHookInvocationSetting codeHook;

    private final ElicitationCodeHookInvocationSetting elicitationCodeHook;

    private IntentConfirmationSetting(BuilderImpl builder) {
        this.promptSpecification = builder.promptSpecification;
        this.declinationResponse = builder.declinationResponse;
        this.active = builder.active;
        this.confirmationResponse = builder.confirmationResponse;
        this.confirmationNextStep = builder.confirmationNextStep;
        this.confirmationConditional = builder.confirmationConditional;
        this.declinationNextStep = builder.declinationNextStep;
        this.declinationConditional = builder.declinationConditional;
        this.failureResponse = builder.failureResponse;
        this.failureNextStep = builder.failureNextStep;
        this.failureConditional = builder.failureConditional;
        this.codeHook = builder.codeHook;
        this.elicitationCodeHook = builder.elicitationCodeHook;
    }

    /**
     * <p>
     * Prompts the user to confirm the intent. This question should have a yes or no answer.
     * </p>
     * <p>
     * Amazon Lex uses this prompt to ensure that the user acknowledges that the intent is ready for fulfillment. For
     * example, with the <code>OrderPizza</code> intent, you might want to confirm that the order is correct before
     * placing it. For other intents, such as intents that simply respond to user questions, you might not need to ask
     * the user for confirmation before providing the information.
     * </p>
     * 
     * @return Prompts the user to confirm the intent. This question should have a yes or no answer.</p>
     *         <p>
     *         Amazon Lex uses this prompt to ensure that the user acknowledges that the intent is ready for
     *         fulfillment. For example, with the <code>OrderPizza</code> intent, you might want to confirm that the
     *         order is correct before placing it. For other intents, such as intents that simply respond to user
     *         questions, you might not need to ask the user for confirmation before providing the information.
     */
    public final PromptSpecification promptSpecification() {
        return promptSpecification;
    }

    /**
     * <p>
     * When the user answers "no" to the question defined in <code>promptSpecification</code>, Amazon Lex responds with
     * this response to acknowledge that the intent was canceled.
     * </p>
     * 
     * @return When the user answers "no" to the question defined in <code>promptSpecification</code>, Amazon Lex
     *         responds with this response to acknowledge that the intent was canceled.
     */
    public final ResponseSpecification declinationResponse() {
        return declinationResponse;
    }

    /**
     * <p>
     * Specifies whether the intent's confirmation is sent to the user. When this field is false, confirmation and
     * declination responses aren't sent. If the <code>active</code> field isn't specified, the default is true.
     * </p>
     * 
     * @return Specifies whether the intent's confirmation is sent to the user. When this field is false, confirmation
     *         and declination responses aren't sent. If the <code>active</code> field isn't specified, the default is
     *         true.
     */
    public final Boolean active() {
        return active;
    }

    /**
     * Returns the value of the ConfirmationResponse property for this object.
     * 
     * @return The value of the ConfirmationResponse property for this object.
     */
    public final ResponseSpecification confirmationResponse() {
        return confirmationResponse;
    }

    /**
     * <p>
     * Specifies the next step that the bot executes when the customer confirms the intent.
     * </p>
     * 
     * @return Specifies the next step that the bot executes when the customer confirms the intent.
     */
    public final DialogState confirmationNextStep() {
        return confirmationNextStep;
    }

    /**
     * <p>
     * A list of conditional branches to evaluate after the intent is closed.
     * </p>
     * 
     * @return A list of conditional branches to evaluate after the intent is closed.
     */
    public final ConditionalSpecification confirmationConditional() {
        return confirmationConditional;
    }

    /**
     * <p>
     * Specifies the next step that the bot executes when the customer declines the intent.
     * </p>
     * 
     * @return Specifies the next step that the bot executes when the customer declines the intent.
     */
    public final DialogState declinationNextStep() {
        return declinationNextStep;
    }

    /**
     * <p>
     * A list of conditional branches to evaluate after the intent is declined.
     * </p>
     * 
     * @return A list of conditional branches to evaluate after the intent is declined.
     */
    public final ConditionalSpecification declinationConditional() {
        return declinationConditional;
    }

    /**
     * Returns the value of the FailureResponse property for this object.
     * 
     * @return The value of the FailureResponse property for this object.
     */
    public final ResponseSpecification failureResponse() {
        return failureResponse;
    }

    /**
     * <p>
     * The next step to take in the conversation if the confirmation step fails.
     * </p>
     * 
     * @return The next step to take in the conversation if the confirmation step fails.
     */
    public final DialogState failureNextStep() {
        return failureNextStep;
    }

    /**
     * Returns the value of the FailureConditional property for this object.
     * 
     * @return The value of the FailureConditional property for this object.
     */
    public final ConditionalSpecification failureConditional() {
        return failureConditional;
    }

    /**
     * <p>
     * The <code>DialogCodeHookInvocationSetting</code> object associated with intent's confirmation step. The dialog
     * code hook is triggered based on these invocation settings when the confirmation next step or declination next
     * step or failure next step is <code>InvokeDialogCodeHook</code>.
     * </p>
     * 
     * @return The <code>DialogCodeHookInvocationSetting</code> object associated with intent's confirmation step. The
     *         dialog code hook is triggered based on these invocation settings when the confirmation next step or
     *         declination next step or failure next step is <code>InvokeDialogCodeHook</code>.
     */
    public final DialogCodeHookInvocationSetting codeHook() {
        return codeHook;
    }

    /**
     * <p>
     * The <code>DialogCodeHookInvocationSetting</code> used when the code hook is invoked during confirmation prompt
     * retries.
     * </p>
     * 
     * @return The <code>DialogCodeHookInvocationSetting</code> used when the code hook is invoked during confirmation
     *         prompt retries.
     */
    public final ElicitationCodeHookInvocationSetting elicitationCodeHook() {
        return elicitationCodeHook;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(promptSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(declinationResponse());
        hashCode = 31 * hashCode + Objects.hashCode(active());
        hashCode = 31 * hashCode + Objects.hashCode(confirmationResponse());
        hashCode = 31 * hashCode + Objects.hashCode(confirmationNextStep());
        hashCode = 31 * hashCode + Objects.hashCode(confirmationConditional());
        hashCode = 31 * hashCode + Objects.hashCode(declinationNextStep());
        hashCode = 31 * hashCode + Objects.hashCode(declinationConditional());
        hashCode = 31 * hashCode + Objects.hashCode(failureResponse());
        hashCode = 31 * hashCode + Objects.hashCode(failureNextStep());
        hashCode = 31 * hashCode + Objects.hashCode(failureConditional());
        hashCode = 31 * hashCode + Objects.hashCode(codeHook());
        hashCode = 31 * hashCode + Objects.hashCode(elicitationCodeHook());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntentConfirmationSetting)) {
            return false;
        }
        IntentConfirmationSetting other = (IntentConfirmationSetting) obj;
        return Objects.equals(promptSpecification(), other.promptSpecification())
                && Objects.equals(declinationResponse(), other.declinationResponse()) && Objects.equals(active(), other.active())
                && Objects.equals(confirmationResponse(), other.confirmationResponse())
                && Objects.equals(confirmationNextStep(), other.confirmationNextStep())
                && Objects.equals(confirmationConditional(), other.confirmationConditional())
                && Objects.equals(declinationNextStep(), other.declinationNextStep())
                && Objects.equals(declinationConditional(), other.declinationConditional())
                && Objects.equals(failureResponse(), other.failureResponse())
                && Objects.equals(failureNextStep(), other.failureNextStep())
                && Objects.equals(failureConditional(), other.failureConditional())
                && Objects.equals(codeHook(), other.codeHook())
                && Objects.equals(elicitationCodeHook(), other.elicitationCodeHook());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IntentConfirmationSetting").add("PromptSpecification", promptSpecification())
                .add("DeclinationResponse", declinationResponse()).add("Active", active())
                .add("ConfirmationResponse", confirmationResponse()).add("ConfirmationNextStep", confirmationNextStep())
                .add("ConfirmationConditional", confirmationConditional()).add("DeclinationNextStep", declinationNextStep())
                .add("DeclinationConditional", declinationConditional()).add("FailureResponse", failureResponse())
                .add("FailureNextStep", failureNextStep()).add("FailureConditional", failureConditional())
                .add("CodeHook", codeHook()).add("ElicitationCodeHook", elicitationCodeHook()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "promptSpecification":
            return Optional.ofNullable(clazz.cast(promptSpecification()));
        case "declinationResponse":
            return Optional.ofNullable(clazz.cast(declinationResponse()));
        case "active":
            return Optional.ofNullable(clazz.cast(active()));
        case "confirmationResponse":
            return Optional.ofNullable(clazz.cast(confirmationResponse()));
        case "confirmationNextStep":
            return Optional.ofNullable(clazz.cast(confirmationNextStep()));
        case "confirmationConditional":
            return Optional.ofNullable(clazz.cast(confirmationConditional()));
        case "declinationNextStep":
            return Optional.ofNullable(clazz.cast(declinationNextStep()));
        case "declinationConditional":
            return Optional.ofNullable(clazz.cast(declinationConditional()));
        case "failureResponse":
            return Optional.ofNullable(clazz.cast(failureResponse()));
        case "failureNextStep":
            return Optional.ofNullable(clazz.cast(failureNextStep()));
        case "failureConditional":
            return Optional.ofNullable(clazz.cast(failureConditional()));
        case "codeHook":
            return Optional.ofNullable(clazz.cast(codeHook()));
        case "elicitationCodeHook":
            return Optional.ofNullable(clazz.cast(elicitationCodeHook()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("promptSpecification", PROMPT_SPECIFICATION_FIELD);
        map.put("declinationResponse", DECLINATION_RESPONSE_FIELD);
        map.put("active", ACTIVE_FIELD);
        map.put("confirmationResponse", CONFIRMATION_RESPONSE_FIELD);
        map.put("confirmationNextStep", CONFIRMATION_NEXT_STEP_FIELD);
        map.put("confirmationConditional", CONFIRMATION_CONDITIONAL_FIELD);
        map.put("declinationNextStep", DECLINATION_NEXT_STEP_FIELD);
        map.put("declinationConditional", DECLINATION_CONDITIONAL_FIELD);
        map.put("failureResponse", FAILURE_RESPONSE_FIELD);
        map.put("failureNextStep", FAILURE_NEXT_STEP_FIELD);
        map.put("failureConditional", FAILURE_CONDITIONAL_FIELD);
        map.put("codeHook", CODE_HOOK_FIELD);
        map.put("elicitationCodeHook", ELICITATION_CODE_HOOK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IntentConfirmationSetting, T> g) {
        return obj -> g.apply((IntentConfirmationSetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IntentConfirmationSetting> {
        /**
         * <p>
         * Prompts the user to confirm the intent. This question should have a yes or no answer.
         * </p>
         * <p>
         * Amazon Lex uses this prompt to ensure that the user acknowledges that the intent is ready for fulfillment.
         * For example, with the <code>OrderPizza</code> intent, you might want to confirm that the order is correct
         * before placing it. For other intents, such as intents that simply respond to user questions, you might not
         * need to ask the user for confirmation before providing the information.
         * </p>
         * 
         * @param promptSpecification
         *        Prompts the user to confirm the intent. This question should have a yes or no answer.</p>
         *        <p>
         *        Amazon Lex uses this prompt to ensure that the user acknowledges that the intent is ready for
         *        fulfillment. For example, with the <code>OrderPizza</code> intent, you might want to confirm that the
         *        order is correct before placing it. For other intents, such as intents that simply respond to user
         *        questions, you might not need to ask the user for confirmation before providing the information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promptSpecification(PromptSpecification promptSpecification);

        /**
         * <p>
         * Prompts the user to confirm the intent. This question should have a yes or no answer.
         * </p>
         * <p>
         * Amazon Lex uses this prompt to ensure that the user acknowledges that the intent is ready for fulfillment.
         * For example, with the <code>OrderPizza</code> intent, you might want to confirm that the order is correct
         * before placing it. For other intents, such as intents that simply respond to user questions, you might not
         * need to ask the user for confirmation before providing the information.
         * </p>
         * This is a convenience method that creates an instance of the {@link PromptSpecification.Builder} avoiding the
         * need to create one manually via {@link PromptSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PromptSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #promptSpecification(PromptSpecification)}.
         * 
         * @param promptSpecification
         *        a consumer that will call methods on {@link PromptSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #promptSpecification(PromptSpecification)
         */
        default Builder promptSpecification(Consumer<PromptSpecification.Builder> promptSpecification) {
            return promptSpecification(PromptSpecification.builder().applyMutation(promptSpecification).build());
        }

        /**
         * <p>
         * When the user answers "no" to the question defined in <code>promptSpecification</code>, Amazon Lex responds
         * with this response to acknowledge that the intent was canceled.
         * </p>
         * 
         * @param declinationResponse
         *        When the user answers "no" to the question defined in <code>promptSpecification</code>, Amazon Lex
         *        responds with this response to acknowledge that the intent was canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder declinationResponse(ResponseSpecification declinationResponse);

        /**
         * <p>
         * When the user answers "no" to the question defined in <code>promptSpecification</code>, Amazon Lex responds
         * with this response to acknowledge that the intent was canceled.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResponseSpecification.Builder} avoiding
         * the need to create one manually via {@link ResponseSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResponseSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #declinationResponse(ResponseSpecification)}.
         * 
         * @param declinationResponse
         *        a consumer that will call methods on {@link ResponseSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #declinationResponse(ResponseSpecification)
         */
        default Builder declinationResponse(Consumer<ResponseSpecification.Builder> declinationResponse) {
            return declinationResponse(ResponseSpecification.builder().applyMutation(declinationResponse).build());
        }

        /**
         * <p>
         * Specifies whether the intent's confirmation is sent to the user. When this field is false, confirmation and
         * declination responses aren't sent. If the <code>active</code> field isn't specified, the default is true.
         * </p>
         * 
         * @param active
         *        Specifies whether the intent's confirmation is sent to the user. When this field is false,
         *        confirmation and declination responses aren't sent. If the <code>active</code> field isn't specified,
         *        the default is true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder active(Boolean active);

        /**
         * Sets the value of the ConfirmationResponse property for this object.
         *
         * @param confirmationResponse
         *        The new value for the ConfirmationResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confirmationResponse(ResponseSpecification confirmationResponse);

        /**
         * Sets the value of the ConfirmationResponse property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ResponseSpecification.Builder} avoiding
         * the need to create one manually via {@link ResponseSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResponseSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #confirmationResponse(ResponseSpecification)}.
         * 
         * @param confirmationResponse
         *        a consumer that will call methods on {@link ResponseSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #confirmationResponse(ResponseSpecification)
         */
        default Builder confirmationResponse(Consumer<ResponseSpecification.Builder> confirmationResponse) {
            return confirmationResponse(ResponseSpecification.builder().applyMutation(confirmationResponse).build());
        }

        /**
         * <p>
         * Specifies the next step that the bot executes when the customer confirms the intent.
         * </p>
         * 
         * @param confirmationNextStep
         *        Specifies the next step that the bot executes when the customer confirms the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confirmationNextStep(DialogState confirmationNextStep);

        /**
         * <p>
         * Specifies the next step that the bot executes when the customer confirms the intent.
         * </p>
         * This is a convenience method that creates an instance of the {@link DialogState.Builder} avoiding the need to
         * create one manually via {@link DialogState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DialogState.Builder#build()} is called immediately and its result
         * is passed to {@link #confirmationNextStep(DialogState)}.
         * 
         * @param confirmationNextStep
         *        a consumer that will call methods on {@link DialogState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #confirmationNextStep(DialogState)
         */
        default Builder confirmationNextStep(Consumer<DialogState.Builder> confirmationNextStep) {
            return confirmationNextStep(DialogState.builder().applyMutation(confirmationNextStep).build());
        }

        /**
         * <p>
         * A list of conditional branches to evaluate after the intent is closed.
         * </p>
         * 
         * @param confirmationConditional
         *        A list of conditional branches to evaluate after the intent is closed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confirmationConditional(ConditionalSpecification confirmationConditional);

        /**
         * <p>
         * A list of conditional branches to evaluate after the intent is closed.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConditionalSpecification.Builder}
         * avoiding the need to create one manually via {@link ConditionalSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConditionalSpecification.Builder#build()} is called immediately
         * and its result is passed to {@link #confirmationConditional(ConditionalSpecification)}.
         * 
         * @param confirmationConditional
         *        a consumer that will call methods on {@link ConditionalSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #confirmationConditional(ConditionalSpecification)
         */
        default Builder confirmationConditional(Consumer<ConditionalSpecification.Builder> confirmationConditional) {
            return confirmationConditional(ConditionalSpecification.builder().applyMutation(confirmationConditional).build());
        }

        /**
         * <p>
         * Specifies the next step that the bot executes when the customer declines the intent.
         * </p>
         * 
         * @param declinationNextStep
         *        Specifies the next step that the bot executes when the customer declines the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder declinationNextStep(DialogState declinationNextStep);

        /**
         * <p>
         * Specifies the next step that the bot executes when the customer declines the intent.
         * </p>
         * This is a convenience method that creates an instance of the {@link DialogState.Builder} avoiding the need to
         * create one manually via {@link DialogState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DialogState.Builder#build()} is called immediately and its result
         * is passed to {@link #declinationNextStep(DialogState)}.
         * 
         * @param declinationNextStep
         *        a consumer that will call methods on {@link DialogState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #declinationNextStep(DialogState)
         */
        default Builder declinationNextStep(Consumer<DialogState.Builder> declinationNextStep) {
            return declinationNextStep(DialogState.builder().applyMutation(declinationNextStep).build());
        }

        /**
         * <p>
         * A list of conditional branches to evaluate after the intent is declined.
         * </p>
         * 
         * @param declinationConditional
         *        A list of conditional branches to evaluate after the intent is declined.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder declinationConditional(ConditionalSpecification declinationConditional);

        /**
         * <p>
         * A list of conditional branches to evaluate after the intent is declined.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConditionalSpecification.Builder}
         * avoiding the need to create one manually via {@link ConditionalSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConditionalSpecification.Builder#build()} is called immediately
         * and its result is passed to {@link #declinationConditional(ConditionalSpecification)}.
         * 
         * @param declinationConditional
         *        a consumer that will call methods on {@link ConditionalSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #declinationConditional(ConditionalSpecification)
         */
        default Builder declinationConditional(Consumer<ConditionalSpecification.Builder> declinationConditional) {
            return declinationConditional(ConditionalSpecification.builder().applyMutation(declinationConditional).build());
        }

        /**
         * Sets the value of the FailureResponse property for this object.
         *
         * @param failureResponse
         *        The new value for the FailureResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureResponse(ResponseSpecification failureResponse);

        /**
         * Sets the value of the FailureResponse property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ResponseSpecification.Builder} avoiding
         * the need to create one manually via {@link ResponseSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResponseSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #failureResponse(ResponseSpecification)}.
         * 
         * @param failureResponse
         *        a consumer that will call methods on {@link ResponseSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failureResponse(ResponseSpecification)
         */
        default Builder failureResponse(Consumer<ResponseSpecification.Builder> failureResponse) {
            return failureResponse(ResponseSpecification.builder().applyMutation(failureResponse).build());
        }

        /**
         * <p>
         * The next step to take in the conversation if the confirmation step fails.
         * </p>
         * 
         * @param failureNextStep
         *        The next step to take in the conversation if the confirmation step fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureNextStep(DialogState failureNextStep);

        /**
         * <p>
         * The next step to take in the conversation if the confirmation step fails.
         * </p>
         * This is a convenience method that creates an instance of the {@link DialogState.Builder} avoiding the need to
         * create one manually via {@link DialogState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DialogState.Builder#build()} is called immediately and its result
         * is passed to {@link #failureNextStep(DialogState)}.
         * 
         * @param failureNextStep
         *        a consumer that will call methods on {@link DialogState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failureNextStep(DialogState)
         */
        default Builder failureNextStep(Consumer<DialogState.Builder> failureNextStep) {
            return failureNextStep(DialogState.builder().applyMutation(failureNextStep).build());
        }

        /**
         * Sets the value of the FailureConditional property for this object.
         *
         * @param failureConditional
         *        The new value for the FailureConditional property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureConditional(ConditionalSpecification failureConditional);

        /**
         * Sets the value of the FailureConditional property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ConditionalSpecification.Builder}
         * avoiding the need to create one manually via {@link ConditionalSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConditionalSpecification.Builder#build()} is called immediately
         * and its result is passed to {@link #failureConditional(ConditionalSpecification)}.
         * 
         * @param failureConditional
         *        a consumer that will call methods on {@link ConditionalSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failureConditional(ConditionalSpecification)
         */
        default Builder failureConditional(Consumer<ConditionalSpecification.Builder> failureConditional) {
            return failureConditional(ConditionalSpecification.builder().applyMutation(failureConditional).build());
        }

        /**
         * <p>
         * The <code>DialogCodeHookInvocationSetting</code> object associated with intent's confirmation step. The
         * dialog code hook is triggered based on these invocation settings when the confirmation next step or
         * declination next step or failure next step is <code>InvokeDialogCodeHook</code>.
         * </p>
         * 
         * @param codeHook
         *        The <code>DialogCodeHookInvocationSetting</code> object associated with intent's confirmation step.
         *        The dialog code hook is triggered based on these invocation settings when the confirmation next step
         *        or declination next step or failure next step is <code>InvokeDialogCodeHook</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeHook(DialogCodeHookInvocationSetting codeHook);

        /**
         * <p>
         * The <code>DialogCodeHookInvocationSetting</code> object associated with intent's confirmation step. The
         * dialog code hook is triggered based on these invocation settings when the confirmation next step or
         * declination next step or failure next step is <code>InvokeDialogCodeHook</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link DialogCodeHookInvocationSetting.Builder}
         * avoiding the need to create one manually via {@link DialogCodeHookInvocationSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DialogCodeHookInvocationSetting.Builder#build()} is called
         * immediately and its result is passed to {@link #codeHook(DialogCodeHookInvocationSetting)}.
         * 
         * @param codeHook
         *        a consumer that will call methods on {@link DialogCodeHookInvocationSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeHook(DialogCodeHookInvocationSetting)
         */
        default Builder codeHook(Consumer<DialogCodeHookInvocationSetting.Builder> codeHook) {
            return codeHook(DialogCodeHookInvocationSetting.builder().applyMutation(codeHook).build());
        }

        /**
         * <p>
         * The <code>DialogCodeHookInvocationSetting</code> used when the code hook is invoked during confirmation
         * prompt retries.
         * </p>
         * 
         * @param elicitationCodeHook
         *        The <code>DialogCodeHookInvocationSetting</code> used when the code hook is invoked during
         *        confirmation prompt retries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elicitationCodeHook(ElicitationCodeHookInvocationSetting elicitationCodeHook);

        /**
         * <p>
         * The <code>DialogCodeHookInvocationSetting</code> used when the code hook is invoked during confirmation
         * prompt retries.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ElicitationCodeHookInvocationSetting.Builder} avoiding the need to create one manually via
         * {@link ElicitationCodeHookInvocationSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ElicitationCodeHookInvocationSetting.Builder#build()} is called
         * immediately and its result is passed to {@link #elicitationCodeHook(ElicitationCodeHookInvocationSetting)}.
         * 
         * @param elicitationCodeHook
         *        a consumer that will call methods on {@link ElicitationCodeHookInvocationSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elicitationCodeHook(ElicitationCodeHookInvocationSetting)
         */
        default Builder elicitationCodeHook(Consumer<ElicitationCodeHookInvocationSetting.Builder> elicitationCodeHook) {
            return elicitationCodeHook(ElicitationCodeHookInvocationSetting.builder().applyMutation(elicitationCodeHook).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PromptSpecification promptSpecification;

        private ResponseSpecification declinationResponse;

        private Boolean active;

        private ResponseSpecification confirmationResponse;

        private DialogState confirmationNextStep;

        private ConditionalSpecification confirmationConditional;

        private DialogState declinationNextStep;

        private ConditionalSpecification declinationConditional;

        private ResponseSpecification failureResponse;

        private DialogState failureNextStep;

        private ConditionalSpecification failureConditional;

        private DialogCodeHookInvocationSetting codeHook;

        private ElicitationCodeHookInvocationSetting elicitationCodeHook;

        private BuilderImpl() {
        }

        private BuilderImpl(IntentConfirmationSetting model) {
            promptSpecification(model.promptSpecification);
            declinationResponse(model.declinationResponse);
            active(model.active);
            confirmationResponse(model.confirmationResponse);
            confirmationNextStep(model.confirmationNextStep);
            confirmationConditional(model.confirmationConditional);
            declinationNextStep(model.declinationNextStep);
            declinationConditional(model.declinationConditional);
            failureResponse(model.failureResponse);
            failureNextStep(model.failureNextStep);
            failureConditional(model.failureConditional);
            codeHook(model.codeHook);
            elicitationCodeHook(model.elicitationCodeHook);
        }

        public final PromptSpecification.Builder getPromptSpecification() {
            return promptSpecification != null ? promptSpecification.toBuilder() : null;
        }

        public final void setPromptSpecification(PromptSpecification.BuilderImpl promptSpecification) {
            this.promptSpecification = promptSpecification != null ? promptSpecification.build() : null;
        }

        @Override
        public final Builder promptSpecification(PromptSpecification promptSpecification) {
            this.promptSpecification = promptSpecification;
            return this;
        }

        public final ResponseSpecification.Builder getDeclinationResponse() {
            return declinationResponse != null ? declinationResponse.toBuilder() : null;
        }

        public final void setDeclinationResponse(ResponseSpecification.BuilderImpl declinationResponse) {
            this.declinationResponse = declinationResponse != null ? declinationResponse.build() : null;
        }

        @Override
        public final Builder declinationResponse(ResponseSpecification declinationResponse) {
            this.declinationResponse = declinationResponse;
            return this;
        }

        public final Boolean getActive() {
            return active;
        }

        public final void setActive(Boolean active) {
            this.active = active;
        }

        @Override
        public final Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public final ResponseSpecification.Builder getConfirmationResponse() {
            return confirmationResponse != null ? confirmationResponse.toBuilder() : null;
        }

        public final void setConfirmationResponse(ResponseSpecification.BuilderImpl confirmationResponse) {
            this.confirmationResponse = confirmationResponse != null ? confirmationResponse.build() : null;
        }

        @Override
        public final Builder confirmationResponse(ResponseSpecification confirmationResponse) {
            this.confirmationResponse = confirmationResponse;
            return this;
        }

        public final DialogState.Builder getConfirmationNextStep() {
            return confirmationNextStep != null ? confirmationNextStep.toBuilder() : null;
        }

        public final void setConfirmationNextStep(DialogState.BuilderImpl confirmationNextStep) {
            this.confirmationNextStep = confirmationNextStep != null ? confirmationNextStep.build() : null;
        }

        @Override
        public final Builder confirmationNextStep(DialogState confirmationNextStep) {
            this.confirmationNextStep = confirmationNextStep;
            return this;
        }

        public final ConditionalSpecification.Builder getConfirmationConditional() {
            return confirmationConditional != null ? confirmationConditional.toBuilder() : null;
        }

        public final void setConfirmationConditional(ConditionalSpecification.BuilderImpl confirmationConditional) {
            this.confirmationConditional = confirmationConditional != null ? confirmationConditional.build() : null;
        }

        @Override
        public final Builder confirmationConditional(ConditionalSpecification confirmationConditional) {
            this.confirmationConditional = confirmationConditional;
            return this;
        }

        public final DialogState.Builder getDeclinationNextStep() {
            return declinationNextStep != null ? declinationNextStep.toBuilder() : null;
        }

        public final void setDeclinationNextStep(DialogState.BuilderImpl declinationNextStep) {
            this.declinationNextStep = declinationNextStep != null ? declinationNextStep.build() : null;
        }

        @Override
        public final Builder declinationNextStep(DialogState declinationNextStep) {
            this.declinationNextStep = declinationNextStep;
            return this;
        }

        public final ConditionalSpecification.Builder getDeclinationConditional() {
            return declinationConditional != null ? declinationConditional.toBuilder() : null;
        }

        public final void setDeclinationConditional(ConditionalSpecification.BuilderImpl declinationConditional) {
            this.declinationConditional = declinationConditional != null ? declinationConditional.build() : null;
        }

        @Override
        public final Builder declinationConditional(ConditionalSpecification declinationConditional) {
            this.declinationConditional = declinationConditional;
            return this;
        }

        public final ResponseSpecification.Builder getFailureResponse() {
            return failureResponse != null ? failureResponse.toBuilder() : null;
        }

        public final void setFailureResponse(ResponseSpecification.BuilderImpl failureResponse) {
            this.failureResponse = failureResponse != null ? failureResponse.build() : null;
        }

        @Override
        public final Builder failureResponse(ResponseSpecification failureResponse) {
            this.failureResponse = failureResponse;
            return this;
        }

        public final DialogState.Builder getFailureNextStep() {
            return failureNextStep != null ? failureNextStep.toBuilder() : null;
        }

        public final void setFailureNextStep(DialogState.BuilderImpl failureNextStep) {
            this.failureNextStep = failureNextStep != null ? failureNextStep.build() : null;
        }

        @Override
        public final Builder failureNextStep(DialogState failureNextStep) {
            this.failureNextStep = failureNextStep;
            return this;
        }

        public final ConditionalSpecification.Builder getFailureConditional() {
            return failureConditional != null ? failureConditional.toBuilder() : null;
        }

        public final void setFailureConditional(ConditionalSpecification.BuilderImpl failureConditional) {
            this.failureConditional = failureConditional != null ? failureConditional.build() : null;
        }

        @Override
        public final Builder failureConditional(ConditionalSpecification failureConditional) {
            this.failureConditional = failureConditional;
            return this;
        }

        public final DialogCodeHookInvocationSetting.Builder getCodeHook() {
            return codeHook != null ? codeHook.toBuilder() : null;
        }

        public final void setCodeHook(DialogCodeHookInvocationSetting.BuilderImpl codeHook) {
            this.codeHook = codeHook != null ? codeHook.build() : null;
        }

        @Override
        public final Builder codeHook(DialogCodeHookInvocationSetting codeHook) {
            this.codeHook = codeHook;
            return this;
        }

        public final ElicitationCodeHookInvocationSetting.Builder getElicitationCodeHook() {
            return elicitationCodeHook != null ? elicitationCodeHook.toBuilder() : null;
        }

        public final void setElicitationCodeHook(ElicitationCodeHookInvocationSetting.BuilderImpl elicitationCodeHook) {
            this.elicitationCodeHook = elicitationCodeHook != null ? elicitationCodeHook.build() : null;
        }

        @Override
        public final Builder elicitationCodeHook(ElicitationCodeHookInvocationSetting elicitationCodeHook) {
            this.elicitationCodeHook = elicitationCodeHook;
            return this;
        }

        @Override
        public IntentConfirmationSetting build() {
            return new IntentConfirmationSetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
