/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListImportsResponse extends LexModelsV2Response implements
        ToCopyableBuilder<ListImportsResponse.Builder, ListImportsResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(ListImportsResponse::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(ListImportsResponse::botVersion)).setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()).build();

    private static final SdkField<List<ImportSummary>> IMPORT_SUMMARIES_FIELD = SdkField
            .<List<ImportSummary>> builder(MarshallingType.LIST)
            .memberName("importSummaries")
            .getter(getter(ListImportsResponse::importSummaries))
            .setter(setter(Builder::importSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImportSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImportSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListImportsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(ListImportsResponse::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            BOT_VERSION_FIELD, IMPORT_SUMMARIES_FIELD, NEXT_TOKEN_FIELD, LOCALE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String botId;

    private final String botVersion;

    private final List<ImportSummary> importSummaries;

    private final String nextToken;

    private final String localeId;

    private ListImportsResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.importSummaries = builder.importSummaries;
        this.nextToken = builder.nextToken;
        this.localeId = builder.localeId;
    }

    /**
     * <p>
     * The unique identifier assigned by Amazon Lex to the bot.
     * </p>
     * 
     * @return The unique identifier assigned by Amazon Lex to the bot.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The version of the bot that was imported. It will always be <code>DRAFT</code>.
     * </p>
     * 
     * @return The version of the bot that was imported. It will always be <code>DRAFT</code>.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImportSummaries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasImportSummaries() {
        return importSummaries != null && !(importSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summary information for the imports that meet the filter criteria specified in the request. The length of the
     * list is specified in the <code>maxResults</code> parameter. If there are more imports available, the
     * <code>nextToken</code> field contains a token to get the next page of results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImportSummaries} method.
     * </p>
     * 
     * @return Summary information for the imports that meet the filter criteria specified in the request. The length of
     *         the list is specified in the <code>maxResults</code> parameter. If there are more imports available, the
     *         <code>nextToken</code> field contains a token to get the next page of results.
     */
    public final List<ImportSummary> importSummaries() {
        return importSummaries;
    }

    /**
     * <p>
     * A token that indicates whether there are more results to return in a response to the <code>ListImports</code>
     * operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code>
     * parameter of a <code>ListImports</code> operation request to get the next page of results.
     * </p>
     * 
     * @return A token that indicates whether there are more results to return in a response to the
     *         <code>ListImports</code> operation. If the <code>nextToken</code> field is present, you send the contents
     *         as the <code>nextToken</code> parameter of a <code>ListImports</code> operation request to get the next
     *         page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The locale specified in the request.
     * </p>
     * 
     * @return The locale specified in the request.
     */
    public final String localeId() {
        return localeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasImportSummaries() ? importSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImportsResponse)) {
            return false;
        }
        ListImportsResponse other = (ListImportsResponse) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botVersion(), other.botVersion())
                && hasImportSummaries() == other.hasImportSummaries()
                && Objects.equals(importSummaries(), other.importSummaries()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(localeId(), other.localeId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListImportsResponse").add("BotId", botId()).add("BotVersion", botVersion())
                .add("ImportSummaries", hasImportSummaries() ? importSummaries() : null).add("NextToken", nextToken())
                .add("LocaleId", localeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "importSummaries":
            return Optional.ofNullable(clazz.cast(importSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("botId", BOT_ID_FIELD);
        map.put("botVersion", BOT_VERSION_FIELD);
        map.put("importSummaries", IMPORT_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("localeId", LOCALE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListImportsResponse, T> g) {
        return obj -> g.apply((ListImportsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, ListImportsResponse> {
        /**
         * <p>
         * The unique identifier assigned by Amazon Lex to the bot.
         * </p>
         * 
         * @param botId
         *        The unique identifier assigned by Amazon Lex to the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The version of the bot that was imported. It will always be <code>DRAFT</code>.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot that was imported. It will always be <code>DRAFT</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * Summary information for the imports that meet the filter criteria specified in the request. The length of the
         * list is specified in the <code>maxResults</code> parameter. If there are more imports available, the
         * <code>nextToken</code> field contains a token to get the next page of results.
         * </p>
         * 
         * @param importSummaries
         *        Summary information for the imports that meet the filter criteria specified in the request. The length
         *        of the list is specified in the <code>maxResults</code> parameter. If there are more imports
         *        available, the <code>nextToken</code> field contains a token to get the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importSummaries(Collection<ImportSummary> importSummaries);

        /**
         * <p>
         * Summary information for the imports that meet the filter criteria specified in the request. The length of the
         * list is specified in the <code>maxResults</code> parameter. If there are more imports available, the
         * <code>nextToken</code> field contains a token to get the next page of results.
         * </p>
         * 
         * @param importSummaries
         *        Summary information for the imports that meet the filter criteria specified in the request. The length
         *        of the list is specified in the <code>maxResults</code> parameter. If there are more imports
         *        available, the <code>nextToken</code> field contains a token to get the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importSummaries(ImportSummary... importSummaries);

        /**
         * <p>
         * Summary information for the imports that meet the filter criteria specified in the request. The length of the
         * list is specified in the <code>maxResults</code> parameter. If there are more imports available, the
         * <code>nextToken</code> field contains a token to get the next page of results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.ImportSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.lexmodelsv2.model.ImportSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.ImportSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #importSummaries(List<ImportSummary>)}.
         * 
         * @param importSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ImportSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importSummaries(java.util.Collection<ImportSummary>)
         */
        Builder importSummaries(Consumer<ImportSummary.Builder>... importSummaries);

        /**
         * <p>
         * A token that indicates whether there are more results to return in a response to the <code>ListImports</code>
         * operation. If the <code>nextToken</code> field is present, you send the contents as the
         * <code>nextToken</code> parameter of a <code>ListImports</code> operation request to get the next page of
         * results.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates whether there are more results to return in a response to the
         *        <code>ListImports</code> operation. If the <code>nextToken</code> field is present, you send the
         *        contents as the <code>nextToken</code> parameter of a <code>ListImports</code> operation request to
         *        get the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The locale specified in the request.
         * </p>
         * 
         * @param localeId
         *        The locale specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String botId;

        private String botVersion;

        private List<ImportSummary> importSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private String localeId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListImportsResponse model) {
            super(model);
            botId(model.botId);
            botVersion(model.botVersion);
            importSummaries(model.importSummaries);
            nextToken(model.nextToken);
            localeId(model.localeId);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final List<ImportSummary.Builder> getImportSummaries() {
            List<ImportSummary.Builder> result = ImportSummaryListCopier.copyToBuilder(this.importSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImportSummaries(Collection<ImportSummary.BuilderImpl> importSummaries) {
            this.importSummaries = ImportSummaryListCopier.copyFromBuilder(importSummaries);
        }

        @Override
        public final Builder importSummaries(Collection<ImportSummary> importSummaries) {
            this.importSummaries = ImportSummaryListCopier.copy(importSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importSummaries(ImportSummary... importSummaries) {
            importSummaries(Arrays.asList(importSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importSummaries(Consumer<ImportSummary.Builder>... importSummaries) {
            importSummaries(Stream.of(importSummaries).map(c -> ImportSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getLocaleId() {
            return localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        @Override
        public ListImportsResponse build() {
            return new ListImportsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
