/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the configuration of the Amazon Kendra index used for the <code>AMAZON.QnAIntent</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QnAKendraConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<QnAKendraConfiguration.Builder, QnAKendraConfiguration> {
    private static final SdkField<String> KENDRA_INDEX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kendraIndex").getter(getter(QnAKendraConfiguration::kendraIndex)).setter(setter(Builder::kendraIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kendraIndex").build()).build();

    private static final SdkField<Boolean> QUERY_FILTER_STRING_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("queryFilterStringEnabled")
            .getter(getter(QnAKendraConfiguration::queryFilterStringEnabled)).setter(setter(Builder::queryFilterStringEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryFilterStringEnabled").build())
            .build();

    private static final SdkField<String> QUERY_FILTER_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queryFilterString").getter(getter(QnAKendraConfiguration::queryFilterString))
            .setter(setter(Builder::queryFilterString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryFilterString").build()).build();

    private static final SdkField<Boolean> EXACT_RESPONSE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("exactResponse").getter(getter(QnAKendraConfiguration::exactResponse))
            .setter(setter(Builder::exactResponse))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exactResponse").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KENDRA_INDEX_FIELD,
            QUERY_FILTER_STRING_ENABLED_FIELD, QUERY_FILTER_STRING_FIELD, EXACT_RESPONSE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String kendraIndex;

    private final Boolean queryFilterStringEnabled;

    private final String queryFilterString;

    private final Boolean exactResponse;

    private QnAKendraConfiguration(BuilderImpl builder) {
        this.kendraIndex = builder.kendraIndex;
        this.queryFilterStringEnabled = builder.queryFilterStringEnabled;
        this.queryFilterString = builder.queryFilterString;
        this.exactResponse = builder.exactResponse;
    }

    /**
     * <p>
     * The ARN of the Amazon Kendra index to use.
     * </p>
     * 
     * @return The ARN of the Amazon Kendra index to use.
     */
    public final String kendraIndex() {
        return kendraIndex;
    }

    /**
     * <p>
     * Specifies whether to enable an Amazon Kendra filter string or not.
     * </p>
     * 
     * @return Specifies whether to enable an Amazon Kendra filter string or not.
     */
    public final Boolean queryFilterStringEnabled() {
        return queryFilterStringEnabled;
    }

    /**
     * <p>
     * Contains the Amazon Kendra filter string to use if enabled. For more information on the Amazon Kendra search
     * filter JSON format, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/filtering.html#search-filtering">Using document attributes to
     * filter search results</a>.
     * </p>
     * 
     * @return Contains the Amazon Kendra filter string to use if enabled. For more information on the Amazon Kendra
     *         search filter JSON format, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/filtering.html#search-filtering">Using document
     *         attributes to filter search results</a>.
     */
    public final String queryFilterString() {
        return queryFilterString;
    }

    /**
     * <p>
     * Specifies whether to return an exact response from the Amazon Kendra index or to let the Amazon Bedrock model you
     * select generate a response based on the results. To use this feature, you must first add FAQ questions to your
     * index by following the steps at <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/in-creating-faq.html">Adding frequently asked questions (FAQs)
     * to an index</a>.
     * </p>
     * 
     * @return Specifies whether to return an exact response from the Amazon Kendra index or to let the Amazon Bedrock
     *         model you select generate a response based on the results. To use this feature, you must first add FAQ
     *         questions to your index by following the steps at <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/in-creating-faq.html">Adding frequently asked
     *         questions (FAQs) to an index</a>.
     */
    public final Boolean exactResponse() {
        return exactResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kendraIndex());
        hashCode = 31 * hashCode + Objects.hashCode(queryFilterStringEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(queryFilterString());
        hashCode = 31 * hashCode + Objects.hashCode(exactResponse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QnAKendraConfiguration)) {
            return false;
        }
        QnAKendraConfiguration other = (QnAKendraConfiguration) obj;
        return Objects.equals(kendraIndex(), other.kendraIndex())
                && Objects.equals(queryFilterStringEnabled(), other.queryFilterStringEnabled())
                && Objects.equals(queryFilterString(), other.queryFilterString())
                && Objects.equals(exactResponse(), other.exactResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QnAKendraConfiguration").add("KendraIndex", kendraIndex())
                .add("QueryFilterStringEnabled", queryFilterStringEnabled()).add("QueryFilterString", queryFilterString())
                .add("ExactResponse", exactResponse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "kendraIndex":
            return Optional.ofNullable(clazz.cast(kendraIndex()));
        case "queryFilterStringEnabled":
            return Optional.ofNullable(clazz.cast(queryFilterStringEnabled()));
        case "queryFilterString":
            return Optional.ofNullable(clazz.cast(queryFilterString()));
        case "exactResponse":
            return Optional.ofNullable(clazz.cast(exactResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("kendraIndex", KENDRA_INDEX_FIELD);
        map.put("queryFilterStringEnabled", QUERY_FILTER_STRING_ENABLED_FIELD);
        map.put("queryFilterString", QUERY_FILTER_STRING_FIELD);
        map.put("exactResponse", EXACT_RESPONSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QnAKendraConfiguration, T> g) {
        return obj -> g.apply((QnAKendraConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QnAKendraConfiguration> {
        /**
         * <p>
         * The ARN of the Amazon Kendra index to use.
         * </p>
         * 
         * @param kendraIndex
         *        The ARN of the Amazon Kendra index to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kendraIndex(String kendraIndex);

        /**
         * <p>
         * Specifies whether to enable an Amazon Kendra filter string or not.
         * </p>
         * 
         * @param queryFilterStringEnabled
         *        Specifies whether to enable an Amazon Kendra filter string or not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryFilterStringEnabled(Boolean queryFilterStringEnabled);

        /**
         * <p>
         * Contains the Amazon Kendra filter string to use if enabled. For more information on the Amazon Kendra search
         * filter JSON format, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/filtering.html#search-filtering">Using document attributes
         * to filter search results</a>.
         * </p>
         * 
         * @param queryFilterString
         *        Contains the Amazon Kendra filter string to use if enabled. For more information on the Amazon Kendra
         *        search filter JSON format, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/filtering.html#search-filtering">Using document
         *        attributes to filter search results</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryFilterString(String queryFilterString);

        /**
         * <p>
         * Specifies whether to return an exact response from the Amazon Kendra index or to let the Amazon Bedrock model
         * you select generate a response based on the results. To use this feature, you must first add FAQ questions to
         * your index by following the steps at <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/in-creating-faq.html">Adding frequently asked questions
         * (FAQs) to an index</a>.
         * </p>
         * 
         * @param exactResponse
         *        Specifies whether to return an exact response from the Amazon Kendra index or to let the Amazon
         *        Bedrock model you select generate a response based on the results. To use this feature, you must first
         *        add FAQ questions to your index by following the steps at <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/in-creating-faq.html">Adding frequently asked
         *        questions (FAQs) to an index</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exactResponse(Boolean exactResponse);
    }

    static final class BuilderImpl implements Builder {
        private String kendraIndex;

        private Boolean queryFilterStringEnabled;

        private String queryFilterString;

        private Boolean exactResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(QnAKendraConfiguration model) {
            kendraIndex(model.kendraIndex);
            queryFilterStringEnabled(model.queryFilterStringEnabled);
            queryFilterString(model.queryFilterString);
            exactResponse(model.exactResponse);
        }

        public final String getKendraIndex() {
            return kendraIndex;
        }

        public final void setKendraIndex(String kendraIndex) {
            this.kendraIndex = kendraIndex;
        }

        @Override
        public final Builder kendraIndex(String kendraIndex) {
            this.kendraIndex = kendraIndex;
            return this;
        }

        public final Boolean getQueryFilterStringEnabled() {
            return queryFilterStringEnabled;
        }

        public final void setQueryFilterStringEnabled(Boolean queryFilterStringEnabled) {
            this.queryFilterStringEnabled = queryFilterStringEnabled;
        }

        @Override
        public final Builder queryFilterStringEnabled(Boolean queryFilterStringEnabled) {
            this.queryFilterStringEnabled = queryFilterStringEnabled;
            return this;
        }

        public final String getQueryFilterString() {
            return queryFilterString;
        }

        public final void setQueryFilterString(String queryFilterString) {
            this.queryFilterString = queryFilterString;
        }

        @Override
        public final Builder queryFilterString(String queryFilterString) {
            this.queryFilterString = queryFilterString;
            return this;
        }

        public final Boolean getExactResponse() {
            return exactResponse;
        }

        public final void setExactResponse(Boolean exactResponse) {
            this.exactResponse = exactResponse;
        }

        @Override
        public final Builder exactResponse(Boolean exactResponse) {
            this.exactResponse = exactResponse;
            return this;
        }

        @Override
        public QnAKendraConfiguration build() {
            return new QnAKendraConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
