/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the resource used for the test set discrepancy report.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestSetDiscrepancyReportResourceTarget implements SdkPojo, Serializable,
        ToCopyableBuilder<TestSetDiscrepancyReportResourceTarget.Builder, TestSetDiscrepancyReportResourceTarget> {
    private static final SdkField<TestSetDiscrepancyReportBotAliasTarget> BOT_ALIAS_TARGET_FIELD = SdkField
            .<TestSetDiscrepancyReportBotAliasTarget> builder(MarshallingType.SDK_POJO).memberName("botAliasTarget")
            .getter(getter(TestSetDiscrepancyReportResourceTarget::botAliasTarget)).setter(setter(Builder::botAliasTarget))
            .constructor(TestSetDiscrepancyReportBotAliasTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAliasTarget").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ALIAS_TARGET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TestSetDiscrepancyReportBotAliasTarget botAliasTarget;

    private TestSetDiscrepancyReportResourceTarget(BuilderImpl builder) {
        this.botAliasTarget = builder.botAliasTarget;
    }

    /**
     * <p>
     * Contains information about the bot alias used as the resource for the test set discrepancy report.
     * </p>
     * 
     * @return Contains information about the bot alias used as the resource for the test set discrepancy report.
     */
    public final TestSetDiscrepancyReportBotAliasTarget botAliasTarget() {
        return botAliasTarget;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(botAliasTarget());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestSetDiscrepancyReportResourceTarget)) {
            return false;
        }
        TestSetDiscrepancyReportResourceTarget other = (TestSetDiscrepancyReportResourceTarget) obj;
        return Objects.equals(botAliasTarget(), other.botAliasTarget());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestSetDiscrepancyReportResourceTarget").add("BotAliasTarget", botAliasTarget()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botAliasTarget":
            return Optional.ofNullable(clazz.cast(botAliasTarget()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("botAliasTarget", BOT_ALIAS_TARGET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestSetDiscrepancyReportResourceTarget, T> g) {
        return obj -> g.apply((TestSetDiscrepancyReportResourceTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TestSetDiscrepancyReportResourceTarget> {
        /**
         * <p>
         * Contains information about the bot alias used as the resource for the test set discrepancy report.
         * </p>
         * 
         * @param botAliasTarget
         *        Contains information about the bot alias used as the resource for the test set discrepancy report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAliasTarget(TestSetDiscrepancyReportBotAliasTarget botAliasTarget);

        /**
         * <p>
         * Contains information about the bot alias used as the resource for the test set discrepancy report.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link TestSetDiscrepancyReportBotAliasTarget.Builder} avoiding the need to create one manually via
         * {@link TestSetDiscrepancyReportBotAliasTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TestSetDiscrepancyReportBotAliasTarget.Builder#build()} is called
         * immediately and its result is passed to {@link #botAliasTarget(TestSetDiscrepancyReportBotAliasTarget)}.
         * 
         * @param botAliasTarget
         *        a consumer that will call methods on {@link TestSetDiscrepancyReportBotAliasTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #botAliasTarget(TestSetDiscrepancyReportBotAliasTarget)
         */
        default Builder botAliasTarget(Consumer<TestSetDiscrepancyReportBotAliasTarget.Builder> botAliasTarget) {
            return botAliasTarget(TestSetDiscrepancyReportBotAliasTarget.builder().applyMutation(botAliasTarget).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TestSetDiscrepancyReportBotAliasTarget botAliasTarget;

        private BuilderImpl() {
        }

        private BuilderImpl(TestSetDiscrepancyReportResourceTarget model) {
            botAliasTarget(model.botAliasTarget);
        }

        public final TestSetDiscrepancyReportBotAliasTarget.Builder getBotAliasTarget() {
            return botAliasTarget != null ? botAliasTarget.toBuilder() : null;
        }

        public final void setBotAliasTarget(TestSetDiscrepancyReportBotAliasTarget.BuilderImpl botAliasTarget) {
            this.botAliasTarget = botAliasTarget != null ? botAliasTarget.build() : null;
        }

        @Override
        public final Builder botAliasTarget(TestSetDiscrepancyReportBotAliasTarget botAliasTarget) {
            this.botAliasTarget = botAliasTarget;
            return this;
        }

        @Override
        public TestSetDiscrepancyReportResourceTarget build() {
            return new TestSetDiscrepancyReportResourceTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
