/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateIntentResponse extends LexModelsV2Response implements
        ToCopyableBuilder<CreateIntentResponse.Builder, CreateIntentResponse> {
    private static final SdkField<String> INTENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("intentId").getter(getter(CreateIntentResponse::intentId)).setter(setter(Builder::intentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentId").build()).build();

    private static final SdkField<String> INTENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("intentName").getter(getter(CreateIntentResponse::intentName)).setter(setter(Builder::intentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateIntentResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> PARENT_INTENT_SIGNATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parentIntentSignature").getter(getter(CreateIntentResponse::parentIntentSignature))
            .setter(setter(Builder::parentIntentSignature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentIntentSignature").build())
            .build();

    private static final SdkField<List<SampleUtterance>> SAMPLE_UTTERANCES_FIELD = SdkField
            .<List<SampleUtterance>> builder(MarshallingType.LIST)
            .memberName("sampleUtterances")
            .getter(getter(CreateIntentResponse::sampleUtterances))
            .setter(setter(Builder::sampleUtterances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleUtterances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SampleUtterance> builder(MarshallingType.SDK_POJO)
                                            .constructor(SampleUtterance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DialogCodeHookSettings> DIALOG_CODE_HOOK_FIELD = SdkField
            .<DialogCodeHookSettings> builder(MarshallingType.SDK_POJO).memberName("dialogCodeHook")
            .getter(getter(CreateIntentResponse::dialogCodeHook)).setter(setter(Builder::dialogCodeHook))
            .constructor(DialogCodeHookSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dialogCodeHook").build()).build();

    private static final SdkField<FulfillmentCodeHookSettings> FULFILLMENT_CODE_HOOK_FIELD = SdkField
            .<FulfillmentCodeHookSettings> builder(MarshallingType.SDK_POJO).memberName("fulfillmentCodeHook")
            .getter(getter(CreateIntentResponse::fulfillmentCodeHook)).setter(setter(Builder::fulfillmentCodeHook))
            .constructor(FulfillmentCodeHookSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fulfillmentCodeHook").build())
            .build();

    private static final SdkField<IntentConfirmationSetting> INTENT_CONFIRMATION_SETTING_FIELD = SdkField
            .<IntentConfirmationSetting> builder(MarshallingType.SDK_POJO).memberName("intentConfirmationSetting")
            .getter(getter(CreateIntentResponse::intentConfirmationSetting)).setter(setter(Builder::intentConfirmationSetting))
            .constructor(IntentConfirmationSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentConfirmationSetting").build())
            .build();

    private static final SdkField<IntentClosingSetting> INTENT_CLOSING_SETTING_FIELD = SdkField
            .<IntentClosingSetting> builder(MarshallingType.SDK_POJO).memberName("intentClosingSetting")
            .getter(getter(CreateIntentResponse::intentClosingSetting)).setter(setter(Builder::intentClosingSetting))
            .constructor(IntentClosingSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentClosingSetting").build())
            .build();

    private static final SdkField<List<InputContext>> INPUT_CONTEXTS_FIELD = SdkField
            .<List<InputContext>> builder(MarshallingType.LIST)
            .memberName("inputContexts")
            .getter(getter(CreateIntentResponse::inputContexts))
            .setter(setter(Builder::inputContexts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputContexts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputContext> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputContext::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<OutputContext>> OUTPUT_CONTEXTS_FIELD = SdkField
            .<List<OutputContext>> builder(MarshallingType.LIST)
            .memberName("outputContexts")
            .getter(getter(CreateIntentResponse::outputContexts))
            .setter(setter(Builder::outputContexts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputContexts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OutputContext> builder(MarshallingType.SDK_POJO)
                                            .constructor(OutputContext::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<KendraConfiguration> KENDRA_CONFIGURATION_FIELD = SdkField
            .<KendraConfiguration> builder(MarshallingType.SDK_POJO).memberName("kendraConfiguration")
            .getter(getter(CreateIntentResponse::kendraConfiguration)).setter(setter(Builder::kendraConfiguration))
            .constructor(KendraConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kendraConfiguration").build())
            .build();

    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(CreateIntentResponse::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(CreateIntentResponse::botVersion)).setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(CreateIntentResponse::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(CreateIntentResponse::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<InitialResponseSetting> INITIAL_RESPONSE_SETTING_FIELD = SdkField
            .<InitialResponseSetting> builder(MarshallingType.SDK_POJO).memberName("initialResponseSetting")
            .getter(getter(CreateIntentResponse::initialResponseSetting)).setter(setter(Builder::initialResponseSetting))
            .constructor(InitialResponseSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initialResponseSetting").build())
            .build();

    private static final SdkField<QnAIntentConfiguration> QN_A_INTENT_CONFIGURATION_FIELD = SdkField
            .<QnAIntentConfiguration> builder(MarshallingType.SDK_POJO).memberName("qnAIntentConfiguration")
            .getter(getter(CreateIntentResponse::qnAIntentConfiguration)).setter(setter(Builder::qnAIntentConfiguration))
            .constructor(QnAIntentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qnAIntentConfiguration").build())
            .build();

    private static final SdkField<QInConnectIntentConfiguration> Q_IN_CONNECT_INTENT_CONFIGURATION_FIELD = SdkField
            .<QInConnectIntentConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("qInConnectIntentConfiguration")
            .getter(getter(CreateIntentResponse::qInConnectIntentConfiguration))
            .setter(setter(Builder::qInConnectIntentConfiguration))
            .constructor(QInConnectIntentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qInConnectIntentConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTENT_ID_FIELD,
            INTENT_NAME_FIELD, DESCRIPTION_FIELD, PARENT_INTENT_SIGNATURE_FIELD, SAMPLE_UTTERANCES_FIELD, DIALOG_CODE_HOOK_FIELD,
            FULFILLMENT_CODE_HOOK_FIELD, INTENT_CONFIRMATION_SETTING_FIELD, INTENT_CLOSING_SETTING_FIELD, INPUT_CONTEXTS_FIELD,
            OUTPUT_CONTEXTS_FIELD, KENDRA_CONFIGURATION_FIELD, BOT_ID_FIELD, BOT_VERSION_FIELD, LOCALE_ID_FIELD,
            CREATION_DATE_TIME_FIELD, INITIAL_RESPONSE_SETTING_FIELD, QN_A_INTENT_CONFIGURATION_FIELD,
            Q_IN_CONNECT_INTENT_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String intentId;

    private final String intentName;

    private final String description;

    private final String parentIntentSignature;

    private final List<SampleUtterance> sampleUtterances;

    private final DialogCodeHookSettings dialogCodeHook;

    private final FulfillmentCodeHookSettings fulfillmentCodeHook;

    private final IntentConfirmationSetting intentConfirmationSetting;

    private final IntentClosingSetting intentClosingSetting;

    private final List<InputContext> inputContexts;

    private final List<OutputContext> outputContexts;

    private final KendraConfiguration kendraConfiguration;

    private final String botId;

    private final String botVersion;

    private final String localeId;

    private final Instant creationDateTime;

    private final InitialResponseSetting initialResponseSetting;

    private final QnAIntentConfiguration qnAIntentConfiguration;

    private final QInConnectIntentConfiguration qInConnectIntentConfiguration;

    private CreateIntentResponse(BuilderImpl builder) {
        super(builder);
        this.intentId = builder.intentId;
        this.intentName = builder.intentName;
        this.description = builder.description;
        this.parentIntentSignature = builder.parentIntentSignature;
        this.sampleUtterances = builder.sampleUtterances;
        this.dialogCodeHook = builder.dialogCodeHook;
        this.fulfillmentCodeHook = builder.fulfillmentCodeHook;
        this.intentConfirmationSetting = builder.intentConfirmationSetting;
        this.intentClosingSetting = builder.intentClosingSetting;
        this.inputContexts = builder.inputContexts;
        this.outputContexts = builder.outputContexts;
        this.kendraConfiguration = builder.kendraConfiguration;
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.creationDateTime = builder.creationDateTime;
        this.initialResponseSetting = builder.initialResponseSetting;
        this.qnAIntentConfiguration = builder.qnAIntentConfiguration;
        this.qInConnectIntentConfiguration = builder.qInConnectIntentConfiguration;
    }

    /**
     * <p>
     * A unique identifier for the intent.
     * </p>
     * 
     * @return A unique identifier for the intent.
     */
    public final String intentId() {
        return intentId;
    }

    /**
     * <p>
     * The name specified for the intent.
     * </p>
     * 
     * @return The name specified for the intent.
     */
    public final String intentName() {
        return intentName;
    }

    /**
     * <p>
     * The description specified for the intent.
     * </p>
     * 
     * @return The description specified for the intent.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The signature of the parent intent specified for the intent.
     * </p>
     * 
     * @return The signature of the parent intent specified for the intent.
     */
    public final String parentIntentSignature() {
        return parentIntentSignature;
    }

    /**
     * For responses, this returns true if the service returned a value for the SampleUtterances property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSampleUtterances() {
        return sampleUtterances != null && !(sampleUtterances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The sample utterances specified for the intent.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSampleUtterances} method.
     * </p>
     * 
     * @return The sample utterances specified for the intent.
     */
    public final List<SampleUtterance> sampleUtterances() {
        return sampleUtterances;
    }

    /**
     * <p>
     * The dialog Lambda function specified for the intent.
     * </p>
     * 
     * @return The dialog Lambda function specified for the intent.
     */
    public final DialogCodeHookSettings dialogCodeHook() {
        return dialogCodeHook;
    }

    /**
     * <p>
     * The fulfillment Lambda function specified for the intent.
     * </p>
     * 
     * @return The fulfillment Lambda function specified for the intent.
     */
    public final FulfillmentCodeHookSettings fulfillmentCodeHook() {
        return fulfillmentCodeHook;
    }

    /**
     * <p>
     * The confirmation setting specified for the intent.
     * </p>
     * 
     * @return The confirmation setting specified for the intent.
     */
    public final IntentConfirmationSetting intentConfirmationSetting() {
        return intentConfirmationSetting;
    }

    /**
     * <p>
     * The closing setting specified for the intent.
     * </p>
     * 
     * @return The closing setting specified for the intent.
     */
    public final IntentClosingSetting intentClosingSetting() {
        return intentClosingSetting;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputContexts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputContexts() {
        return inputContexts != null && !(inputContexts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of input contexts specified for the intent.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputContexts} method.
     * </p>
     * 
     * @return The list of input contexts specified for the intent.
     */
    public final List<InputContext> inputContexts() {
        return inputContexts;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputContexts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutputContexts() {
        return outputContexts != null && !(outputContexts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of output contexts specified for the intent.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputContexts} method.
     * </p>
     * 
     * @return The list of output contexts specified for the intent.
     */
    public final List<OutputContext> outputContexts() {
        return outputContexts;
    }

    /**
     * <p>
     * Configuration for searching a Amazon Kendra index specified for the intent.
     * </p>
     * 
     * @return Configuration for searching a Amazon Kendra index specified for the intent.
     */
    public final KendraConfiguration kendraConfiguration() {
        return kendraConfiguration;
    }

    /**
     * <p>
     * The identifier of the bot associated with the intent.
     * </p>
     * 
     * @return The identifier of the bot associated with the intent.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The version of the bot associated with the intent.
     * </p>
     * 
     * @return The version of the bot associated with the intent.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The locale that the intent is specified to use.
     * </p>
     * 
     * @return The locale that the intent is specified to use.
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * <p>
     * A timestamp of the date and time that the intent was created.
     * </p>
     * 
     * @return A timestamp of the date and time that the intent was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * Configuration settings for the response that is sent to the user at the beginning of a conversation, before
     * eliciting slot values.
     * </p>
     * 
     * @return Configuration settings for the response that is sent to the user at the beginning of a conversation,
     *         before eliciting slot values.
     */
    public final InitialResponseSetting initialResponseSetting() {
        return initialResponseSetting;
    }

    /**
     * <p>
     * Details about the the configuration of the built-in <code>Amazon.QnAIntent</code>.
     * </p>
     * 
     * @return Details about the the configuration of the built-in <code>Amazon.QnAIntent</code>.
     */
    public final QnAIntentConfiguration qnAIntentConfiguration() {
        return qnAIntentConfiguration;
    }

    /**
     * <p>
     * Qinconnect intent configuration details for the create intent response.
     * </p>
     * 
     * @return Qinconnect intent configuration details for the create intent response.
     */
    public final QInConnectIntentConfiguration qInConnectIntentConfiguration() {
        return qInConnectIntentConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(intentId());
        hashCode = 31 * hashCode + Objects.hashCode(intentName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(parentIntentSignature());
        hashCode = 31 * hashCode + Objects.hashCode(hasSampleUtterances() ? sampleUtterances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dialogCodeHook());
        hashCode = 31 * hashCode + Objects.hashCode(fulfillmentCodeHook());
        hashCode = 31 * hashCode + Objects.hashCode(intentConfirmationSetting());
        hashCode = 31 * hashCode + Objects.hashCode(intentClosingSetting());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputContexts() ? inputContexts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputContexts() ? outputContexts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(kendraConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(initialResponseSetting());
        hashCode = 31 * hashCode + Objects.hashCode(qnAIntentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(qInConnectIntentConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIntentResponse)) {
            return false;
        }
        CreateIntentResponse other = (CreateIntentResponse) obj;
        return Objects.equals(intentId(), other.intentId()) && Objects.equals(intentName(), other.intentName())
                && Objects.equals(description(), other.description())
                && Objects.equals(parentIntentSignature(), other.parentIntentSignature())
                && hasSampleUtterances() == other.hasSampleUtterances()
                && Objects.equals(sampleUtterances(), other.sampleUtterances())
                && Objects.equals(dialogCodeHook(), other.dialogCodeHook())
                && Objects.equals(fulfillmentCodeHook(), other.fulfillmentCodeHook())
                && Objects.equals(intentConfirmationSetting(), other.intentConfirmationSetting())
                && Objects.equals(intentClosingSetting(), other.intentClosingSetting())
                && hasInputContexts() == other.hasInputContexts() && Objects.equals(inputContexts(), other.inputContexts())
                && hasOutputContexts() == other.hasOutputContexts() && Objects.equals(outputContexts(), other.outputContexts())
                && Objects.equals(kendraConfiguration(), other.kendraConfiguration()) && Objects.equals(botId(), other.botId())
                && Objects.equals(botVersion(), other.botVersion()) && Objects.equals(localeId(), other.localeId())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(initialResponseSetting(), other.initialResponseSetting())
                && Objects.equals(qnAIntentConfiguration(), other.qnAIntentConfiguration())
                && Objects.equals(qInConnectIntentConfiguration(), other.qInConnectIntentConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateIntentResponse").add("IntentId", intentId()).add("IntentName", intentName())
                .add("Description", description()).add("ParentIntentSignature", parentIntentSignature())
                .add("SampleUtterances", hasSampleUtterances() ? sampleUtterances() : null)
                .add("DialogCodeHook", dialogCodeHook()).add("FulfillmentCodeHook", fulfillmentCodeHook())
                .add("IntentConfirmationSetting", intentConfirmationSetting())
                .add("IntentClosingSetting", intentClosingSetting())
                .add("InputContexts", hasInputContexts() ? inputContexts() : null)
                .add("OutputContexts", hasOutputContexts() ? outputContexts() : null)
                .add("KendraConfiguration", kendraConfiguration()).add("BotId", botId()).add("BotVersion", botVersion())
                .add("LocaleId", localeId()).add("CreationDateTime", creationDateTime())
                .add("InitialResponseSetting", initialResponseSetting()).add("QnAIntentConfiguration", qnAIntentConfiguration())
                .add("QInConnectIntentConfiguration", qInConnectIntentConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "intentId":
            return Optional.ofNullable(clazz.cast(intentId()));
        case "intentName":
            return Optional.ofNullable(clazz.cast(intentName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "parentIntentSignature":
            return Optional.ofNullable(clazz.cast(parentIntentSignature()));
        case "sampleUtterances":
            return Optional.ofNullable(clazz.cast(sampleUtterances()));
        case "dialogCodeHook":
            return Optional.ofNullable(clazz.cast(dialogCodeHook()));
        case "fulfillmentCodeHook":
            return Optional.ofNullable(clazz.cast(fulfillmentCodeHook()));
        case "intentConfirmationSetting":
            return Optional.ofNullable(clazz.cast(intentConfirmationSetting()));
        case "intentClosingSetting":
            return Optional.ofNullable(clazz.cast(intentClosingSetting()));
        case "inputContexts":
            return Optional.ofNullable(clazz.cast(inputContexts()));
        case "outputContexts":
            return Optional.ofNullable(clazz.cast(outputContexts()));
        case "kendraConfiguration":
            return Optional.ofNullable(clazz.cast(kendraConfiguration()));
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "initialResponseSetting":
            return Optional.ofNullable(clazz.cast(initialResponseSetting()));
        case "qnAIntentConfiguration":
            return Optional.ofNullable(clazz.cast(qnAIntentConfiguration()));
        case "qInConnectIntentConfiguration":
            return Optional.ofNullable(clazz.cast(qInConnectIntentConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("intentId", INTENT_ID_FIELD);
        map.put("intentName", INTENT_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("parentIntentSignature", PARENT_INTENT_SIGNATURE_FIELD);
        map.put("sampleUtterances", SAMPLE_UTTERANCES_FIELD);
        map.put("dialogCodeHook", DIALOG_CODE_HOOK_FIELD);
        map.put("fulfillmentCodeHook", FULFILLMENT_CODE_HOOK_FIELD);
        map.put("intentConfirmationSetting", INTENT_CONFIRMATION_SETTING_FIELD);
        map.put("intentClosingSetting", INTENT_CLOSING_SETTING_FIELD);
        map.put("inputContexts", INPUT_CONTEXTS_FIELD);
        map.put("outputContexts", OUTPUT_CONTEXTS_FIELD);
        map.put("kendraConfiguration", KENDRA_CONFIGURATION_FIELD);
        map.put("botId", BOT_ID_FIELD);
        map.put("botVersion", BOT_VERSION_FIELD);
        map.put("localeId", LOCALE_ID_FIELD);
        map.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        map.put("initialResponseSetting", INITIAL_RESPONSE_SETTING_FIELD);
        map.put("qnAIntentConfiguration", QN_A_INTENT_CONFIGURATION_FIELD);
        map.put("qInConnectIntentConfiguration", Q_IN_CONNECT_INTENT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateIntentResponse, T> g) {
        return obj -> g.apply((CreateIntentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateIntentResponse> {
        /**
         * <p>
         * A unique identifier for the intent.
         * </p>
         * 
         * @param intentId
         *        A unique identifier for the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentId(String intentId);

        /**
         * <p>
         * The name specified for the intent.
         * </p>
         * 
         * @param intentName
         *        The name specified for the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentName(String intentName);

        /**
         * <p>
         * The description specified for the intent.
         * </p>
         * 
         * @param description
         *        The description specified for the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The signature of the parent intent specified for the intent.
         * </p>
         * 
         * @param parentIntentSignature
         *        The signature of the parent intent specified for the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentIntentSignature(String parentIntentSignature);

        /**
         * <p>
         * The sample utterances specified for the intent.
         * </p>
         * 
         * @param sampleUtterances
         *        The sample utterances specified for the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleUtterances(Collection<SampleUtterance> sampleUtterances);

        /**
         * <p>
         * The sample utterances specified for the intent.
         * </p>
         * 
         * @param sampleUtterances
         *        The sample utterances specified for the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleUtterances(SampleUtterance... sampleUtterances);

        /**
         * <p>
         * The sample utterances specified for the intent.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.SampleUtterance.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.lexmodelsv2.model.SampleUtterance#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.SampleUtterance.Builder#build()} is called
         * immediately and its result is passed to {@link #sampleUtterances(List<SampleUtterance>)}.
         * 
         * @param sampleUtterances
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.SampleUtterance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sampleUtterances(java.util.Collection<SampleUtterance>)
         */
        Builder sampleUtterances(Consumer<SampleUtterance.Builder>... sampleUtterances);

        /**
         * <p>
         * The dialog Lambda function specified for the intent.
         * </p>
         * 
         * @param dialogCodeHook
         *        The dialog Lambda function specified for the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dialogCodeHook(DialogCodeHookSettings dialogCodeHook);

        /**
         * <p>
         * The dialog Lambda function specified for the intent.
         * </p>
         * This is a convenience method that creates an instance of the {@link DialogCodeHookSettings.Builder} avoiding
         * the need to create one manually via {@link DialogCodeHookSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DialogCodeHookSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #dialogCodeHook(DialogCodeHookSettings)}.
         * 
         * @param dialogCodeHook
         *        a consumer that will call methods on {@link DialogCodeHookSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dialogCodeHook(DialogCodeHookSettings)
         */
        default Builder dialogCodeHook(Consumer<DialogCodeHookSettings.Builder> dialogCodeHook) {
            return dialogCodeHook(DialogCodeHookSettings.builder().applyMutation(dialogCodeHook).build());
        }

        /**
         * <p>
         * The fulfillment Lambda function specified for the intent.
         * </p>
         * 
         * @param fulfillmentCodeHook
         *        The fulfillment Lambda function specified for the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fulfillmentCodeHook(FulfillmentCodeHookSettings fulfillmentCodeHook);

        /**
         * <p>
         * The fulfillment Lambda function specified for the intent.
         * </p>
         * This is a convenience method that creates an instance of the {@link FulfillmentCodeHookSettings.Builder}
         * avoiding the need to create one manually via {@link FulfillmentCodeHookSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FulfillmentCodeHookSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #fulfillmentCodeHook(FulfillmentCodeHookSettings)}.
         * 
         * @param fulfillmentCodeHook
         *        a consumer that will call methods on {@link FulfillmentCodeHookSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fulfillmentCodeHook(FulfillmentCodeHookSettings)
         */
        default Builder fulfillmentCodeHook(Consumer<FulfillmentCodeHookSettings.Builder> fulfillmentCodeHook) {
            return fulfillmentCodeHook(FulfillmentCodeHookSettings.builder().applyMutation(fulfillmentCodeHook).build());
        }

        /**
         * <p>
         * The confirmation setting specified for the intent.
         * </p>
         * 
         * @param intentConfirmationSetting
         *        The confirmation setting specified for the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentConfirmationSetting(IntentConfirmationSetting intentConfirmationSetting);

        /**
         * <p>
         * The confirmation setting specified for the intent.
         * </p>
         * This is a convenience method that creates an instance of the {@link IntentConfirmationSetting.Builder}
         * avoiding the need to create one manually via {@link IntentConfirmationSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IntentConfirmationSetting.Builder#build()} is called immediately
         * and its result is passed to {@link #intentConfirmationSetting(IntentConfirmationSetting)}.
         * 
         * @param intentConfirmationSetting
         *        a consumer that will call methods on {@link IntentConfirmationSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #intentConfirmationSetting(IntentConfirmationSetting)
         */
        default Builder intentConfirmationSetting(Consumer<IntentConfirmationSetting.Builder> intentConfirmationSetting) {
            return intentConfirmationSetting(IntentConfirmationSetting.builder().applyMutation(intentConfirmationSetting).build());
        }

        /**
         * <p>
         * The closing setting specified for the intent.
         * </p>
         * 
         * @param intentClosingSetting
         *        The closing setting specified for the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentClosingSetting(IntentClosingSetting intentClosingSetting);

        /**
         * <p>
         * The closing setting specified for the intent.
         * </p>
         * This is a convenience method that creates an instance of the {@link IntentClosingSetting.Builder} avoiding
         * the need to create one manually via {@link IntentClosingSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IntentClosingSetting.Builder#build()} is called immediately and
         * its result is passed to {@link #intentClosingSetting(IntentClosingSetting)}.
         * 
         * @param intentClosingSetting
         *        a consumer that will call methods on {@link IntentClosingSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #intentClosingSetting(IntentClosingSetting)
         */
        default Builder intentClosingSetting(Consumer<IntentClosingSetting.Builder> intentClosingSetting) {
            return intentClosingSetting(IntentClosingSetting.builder().applyMutation(intentClosingSetting).build());
        }

        /**
         * <p>
         * The list of input contexts specified for the intent.
         * </p>
         * 
         * @param inputContexts
         *        The list of input contexts specified for the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputContexts(Collection<InputContext> inputContexts);

        /**
         * <p>
         * The list of input contexts specified for the intent.
         * </p>
         * 
         * @param inputContexts
         *        The list of input contexts specified for the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputContexts(InputContext... inputContexts);

        /**
         * <p>
         * The list of input contexts specified for the intent.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.InputContext.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.lexmodelsv2.model.InputContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.InputContext.Builder#build()} is called immediately
         * and its result is passed to {@link #inputContexts(List<InputContext>)}.
         * 
         * @param inputContexts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.InputContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputContexts(java.util.Collection<InputContext>)
         */
        Builder inputContexts(Consumer<InputContext.Builder>... inputContexts);

        /**
         * <p>
         * The list of output contexts specified for the intent.
         * </p>
         * 
         * @param outputContexts
         *        The list of output contexts specified for the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputContexts(Collection<OutputContext> outputContexts);

        /**
         * <p>
         * The list of output contexts specified for the intent.
         * </p>
         * 
         * @param outputContexts
         *        The list of output contexts specified for the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputContexts(OutputContext... outputContexts);

        /**
         * <p>
         * The list of output contexts specified for the intent.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.OutputContext.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.lexmodelsv2.model.OutputContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.OutputContext.Builder#build()} is called immediately
         * and its result is passed to {@link #outputContexts(List<OutputContext>)}.
         * 
         * @param outputContexts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.OutputContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputContexts(java.util.Collection<OutputContext>)
         */
        Builder outputContexts(Consumer<OutputContext.Builder>... outputContexts);

        /**
         * <p>
         * Configuration for searching a Amazon Kendra index specified for the intent.
         * </p>
         * 
         * @param kendraConfiguration
         *        Configuration for searching a Amazon Kendra index specified for the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kendraConfiguration(KendraConfiguration kendraConfiguration);

        /**
         * <p>
         * Configuration for searching a Amazon Kendra index specified for the intent.
         * </p>
         * This is a convenience method that creates an instance of the {@link KendraConfiguration.Builder} avoiding the
         * need to create one manually via {@link KendraConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KendraConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #kendraConfiguration(KendraConfiguration)}.
         * 
         * @param kendraConfiguration
         *        a consumer that will call methods on {@link KendraConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kendraConfiguration(KendraConfiguration)
         */
        default Builder kendraConfiguration(Consumer<KendraConfiguration.Builder> kendraConfiguration) {
            return kendraConfiguration(KendraConfiguration.builder().applyMutation(kendraConfiguration).build());
        }

        /**
         * <p>
         * The identifier of the bot associated with the intent.
         * </p>
         * 
         * @param botId
         *        The identifier of the bot associated with the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The version of the bot associated with the intent.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot associated with the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The locale that the intent is specified to use.
         * </p>
         * 
         * @param localeId
         *        The locale that the intent is specified to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * A timestamp of the date and time that the intent was created.
         * </p>
         * 
         * @param creationDateTime
         *        A timestamp of the date and time that the intent was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * Configuration settings for the response that is sent to the user at the beginning of a conversation, before
         * eliciting slot values.
         * </p>
         * 
         * @param initialResponseSetting
         *        Configuration settings for the response that is sent to the user at the beginning of a conversation,
         *        before eliciting slot values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialResponseSetting(InitialResponseSetting initialResponseSetting);

        /**
         * <p>
         * Configuration settings for the response that is sent to the user at the beginning of a conversation, before
         * eliciting slot values.
         * </p>
         * This is a convenience method that creates an instance of the {@link InitialResponseSetting.Builder} avoiding
         * the need to create one manually via {@link InitialResponseSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InitialResponseSetting.Builder#build()} is called immediately and
         * its result is passed to {@link #initialResponseSetting(InitialResponseSetting)}.
         * 
         * @param initialResponseSetting
         *        a consumer that will call methods on {@link InitialResponseSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #initialResponseSetting(InitialResponseSetting)
         */
        default Builder initialResponseSetting(Consumer<InitialResponseSetting.Builder> initialResponseSetting) {
            return initialResponseSetting(InitialResponseSetting.builder().applyMutation(initialResponseSetting).build());
        }

        /**
         * <p>
         * Details about the the configuration of the built-in <code>Amazon.QnAIntent</code>.
         * </p>
         * 
         * @param qnAIntentConfiguration
         *        Details about the the configuration of the built-in <code>Amazon.QnAIntent</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qnAIntentConfiguration(QnAIntentConfiguration qnAIntentConfiguration);

        /**
         * <p>
         * Details about the the configuration of the built-in <code>Amazon.QnAIntent</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link QnAIntentConfiguration.Builder} avoiding
         * the need to create one manually via {@link QnAIntentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QnAIntentConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #qnAIntentConfiguration(QnAIntentConfiguration)}.
         * 
         * @param qnAIntentConfiguration
         *        a consumer that will call methods on {@link QnAIntentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #qnAIntentConfiguration(QnAIntentConfiguration)
         */
        default Builder qnAIntentConfiguration(Consumer<QnAIntentConfiguration.Builder> qnAIntentConfiguration) {
            return qnAIntentConfiguration(QnAIntentConfiguration.builder().applyMutation(qnAIntentConfiguration).build());
        }

        /**
         * <p>
         * Qinconnect intent configuration details for the create intent response.
         * </p>
         * 
         * @param qInConnectIntentConfiguration
         *        Qinconnect intent configuration details for the create intent response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qInConnectIntentConfiguration(QInConnectIntentConfiguration qInConnectIntentConfiguration);

        /**
         * <p>
         * Qinconnect intent configuration details for the create intent response.
         * </p>
         * This is a convenience method that creates an instance of the {@link QInConnectIntentConfiguration.Builder}
         * avoiding the need to create one manually via {@link QInConnectIntentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QInConnectIntentConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #qInConnectIntentConfiguration(QInConnectIntentConfiguration)}.
         * 
         * @param qInConnectIntentConfiguration
         *        a consumer that will call methods on {@link QInConnectIntentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #qInConnectIntentConfiguration(QInConnectIntentConfiguration)
         */
        default Builder qInConnectIntentConfiguration(
                Consumer<QInConnectIntentConfiguration.Builder> qInConnectIntentConfiguration) {
            return qInConnectIntentConfiguration(QInConnectIntentConfiguration.builder()
                    .applyMutation(qInConnectIntentConfiguration).build());
        }
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String intentId;

        private String intentName;

        private String description;

        private String parentIntentSignature;

        private List<SampleUtterance> sampleUtterances = DefaultSdkAutoConstructList.getInstance();

        private DialogCodeHookSettings dialogCodeHook;

        private FulfillmentCodeHookSettings fulfillmentCodeHook;

        private IntentConfirmationSetting intentConfirmationSetting;

        private IntentClosingSetting intentClosingSetting;

        private List<InputContext> inputContexts = DefaultSdkAutoConstructList.getInstance();

        private List<OutputContext> outputContexts = DefaultSdkAutoConstructList.getInstance();

        private KendraConfiguration kendraConfiguration;

        private String botId;

        private String botVersion;

        private String localeId;

        private Instant creationDateTime;

        private InitialResponseSetting initialResponseSetting;

        private QnAIntentConfiguration qnAIntentConfiguration;

        private QInConnectIntentConfiguration qInConnectIntentConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIntentResponse model) {
            super(model);
            intentId(model.intentId);
            intentName(model.intentName);
            description(model.description);
            parentIntentSignature(model.parentIntentSignature);
            sampleUtterances(model.sampleUtterances);
            dialogCodeHook(model.dialogCodeHook);
            fulfillmentCodeHook(model.fulfillmentCodeHook);
            intentConfirmationSetting(model.intentConfirmationSetting);
            intentClosingSetting(model.intentClosingSetting);
            inputContexts(model.inputContexts);
            outputContexts(model.outputContexts);
            kendraConfiguration(model.kendraConfiguration);
            botId(model.botId);
            botVersion(model.botVersion);
            localeId(model.localeId);
            creationDateTime(model.creationDateTime);
            initialResponseSetting(model.initialResponseSetting);
            qnAIntentConfiguration(model.qnAIntentConfiguration);
            qInConnectIntentConfiguration(model.qInConnectIntentConfiguration);
        }

        public final String getIntentId() {
            return intentId;
        }

        public final void setIntentId(String intentId) {
            this.intentId = intentId;
        }

        @Override
        public final Builder intentId(String intentId) {
            this.intentId = intentId;
            return this;
        }

        public final String getIntentName() {
            return intentName;
        }

        public final void setIntentName(String intentName) {
            this.intentName = intentName;
        }

        @Override
        public final Builder intentName(String intentName) {
            this.intentName = intentName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getParentIntentSignature() {
            return parentIntentSignature;
        }

        public final void setParentIntentSignature(String parentIntentSignature) {
            this.parentIntentSignature = parentIntentSignature;
        }

        @Override
        public final Builder parentIntentSignature(String parentIntentSignature) {
            this.parentIntentSignature = parentIntentSignature;
            return this;
        }

        public final List<SampleUtterance.Builder> getSampleUtterances() {
            List<SampleUtterance.Builder> result = SampleUtterancesListCopier.copyToBuilder(this.sampleUtterances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSampleUtterances(Collection<SampleUtterance.BuilderImpl> sampleUtterances) {
            this.sampleUtterances = SampleUtterancesListCopier.copyFromBuilder(sampleUtterances);
        }

        @Override
        public final Builder sampleUtterances(Collection<SampleUtterance> sampleUtterances) {
            this.sampleUtterances = SampleUtterancesListCopier.copy(sampleUtterances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sampleUtterances(SampleUtterance... sampleUtterances) {
            sampleUtterances(Arrays.asList(sampleUtterances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sampleUtterances(Consumer<SampleUtterance.Builder>... sampleUtterances) {
            sampleUtterances(Stream.of(sampleUtterances).map(c -> SampleUtterance.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final DialogCodeHookSettings.Builder getDialogCodeHook() {
            return dialogCodeHook != null ? dialogCodeHook.toBuilder() : null;
        }

        public final void setDialogCodeHook(DialogCodeHookSettings.BuilderImpl dialogCodeHook) {
            this.dialogCodeHook = dialogCodeHook != null ? dialogCodeHook.build() : null;
        }

        @Override
        public final Builder dialogCodeHook(DialogCodeHookSettings dialogCodeHook) {
            this.dialogCodeHook = dialogCodeHook;
            return this;
        }

        public final FulfillmentCodeHookSettings.Builder getFulfillmentCodeHook() {
            return fulfillmentCodeHook != null ? fulfillmentCodeHook.toBuilder() : null;
        }

        public final void setFulfillmentCodeHook(FulfillmentCodeHookSettings.BuilderImpl fulfillmentCodeHook) {
            this.fulfillmentCodeHook = fulfillmentCodeHook != null ? fulfillmentCodeHook.build() : null;
        }

        @Override
        public final Builder fulfillmentCodeHook(FulfillmentCodeHookSettings fulfillmentCodeHook) {
            this.fulfillmentCodeHook = fulfillmentCodeHook;
            return this;
        }

        public final IntentConfirmationSetting.Builder getIntentConfirmationSetting() {
            return intentConfirmationSetting != null ? intentConfirmationSetting.toBuilder() : null;
        }

        public final void setIntentConfirmationSetting(IntentConfirmationSetting.BuilderImpl intentConfirmationSetting) {
            this.intentConfirmationSetting = intentConfirmationSetting != null ? intentConfirmationSetting.build() : null;
        }

        @Override
        public final Builder intentConfirmationSetting(IntentConfirmationSetting intentConfirmationSetting) {
            this.intentConfirmationSetting = intentConfirmationSetting;
            return this;
        }

        public final IntentClosingSetting.Builder getIntentClosingSetting() {
            return intentClosingSetting != null ? intentClosingSetting.toBuilder() : null;
        }

        public final void setIntentClosingSetting(IntentClosingSetting.BuilderImpl intentClosingSetting) {
            this.intentClosingSetting = intentClosingSetting != null ? intentClosingSetting.build() : null;
        }

        @Override
        public final Builder intentClosingSetting(IntentClosingSetting intentClosingSetting) {
            this.intentClosingSetting = intentClosingSetting;
            return this;
        }

        public final List<InputContext.Builder> getInputContexts() {
            List<InputContext.Builder> result = InputContextsListCopier.copyToBuilder(this.inputContexts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputContexts(Collection<InputContext.BuilderImpl> inputContexts) {
            this.inputContexts = InputContextsListCopier.copyFromBuilder(inputContexts);
        }

        @Override
        public final Builder inputContexts(Collection<InputContext> inputContexts) {
            this.inputContexts = InputContextsListCopier.copy(inputContexts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputContexts(InputContext... inputContexts) {
            inputContexts(Arrays.asList(inputContexts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputContexts(Consumer<InputContext.Builder>... inputContexts) {
            inputContexts(Stream.of(inputContexts).map(c -> InputContext.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<OutputContext.Builder> getOutputContexts() {
            List<OutputContext.Builder> result = OutputContextsListCopier.copyToBuilder(this.outputContexts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputContexts(Collection<OutputContext.BuilderImpl> outputContexts) {
            this.outputContexts = OutputContextsListCopier.copyFromBuilder(outputContexts);
        }

        @Override
        public final Builder outputContexts(Collection<OutputContext> outputContexts) {
            this.outputContexts = OutputContextsListCopier.copy(outputContexts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputContexts(OutputContext... outputContexts) {
            outputContexts(Arrays.asList(outputContexts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputContexts(Consumer<OutputContext.Builder>... outputContexts) {
            outputContexts(Stream.of(outputContexts).map(c -> OutputContext.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final KendraConfiguration.Builder getKendraConfiguration() {
            return kendraConfiguration != null ? kendraConfiguration.toBuilder() : null;
        }

        public final void setKendraConfiguration(KendraConfiguration.BuilderImpl kendraConfiguration) {
            this.kendraConfiguration = kendraConfiguration != null ? kendraConfiguration.build() : null;
        }

        @Override
        public final Builder kendraConfiguration(KendraConfiguration kendraConfiguration) {
            this.kendraConfiguration = kendraConfiguration;
            return this;
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final InitialResponseSetting.Builder getInitialResponseSetting() {
            return initialResponseSetting != null ? initialResponseSetting.toBuilder() : null;
        }

        public final void setInitialResponseSetting(InitialResponseSetting.BuilderImpl initialResponseSetting) {
            this.initialResponseSetting = initialResponseSetting != null ? initialResponseSetting.build() : null;
        }

        @Override
        public final Builder initialResponseSetting(InitialResponseSetting initialResponseSetting) {
            this.initialResponseSetting = initialResponseSetting;
            return this;
        }

        public final QnAIntentConfiguration.Builder getQnAIntentConfiguration() {
            return qnAIntentConfiguration != null ? qnAIntentConfiguration.toBuilder() : null;
        }

        public final void setQnAIntentConfiguration(QnAIntentConfiguration.BuilderImpl qnAIntentConfiguration) {
            this.qnAIntentConfiguration = qnAIntentConfiguration != null ? qnAIntentConfiguration.build() : null;
        }

        @Override
        public final Builder qnAIntentConfiguration(QnAIntentConfiguration qnAIntentConfiguration) {
            this.qnAIntentConfiguration = qnAIntentConfiguration;
            return this;
        }

        public final QInConnectIntentConfiguration.Builder getQInConnectIntentConfiguration() {
            return qInConnectIntentConfiguration != null ? qInConnectIntentConfiguration.toBuilder() : null;
        }

        public final void setQInConnectIntentConfiguration(QInConnectIntentConfiguration.BuilderImpl qInConnectIntentConfiguration) {
            this.qInConnectIntentConfiguration = qInConnectIntentConfiguration != null ? qInConnectIntentConfiguration.build()
                    : null;
        }

        @Override
        public final Builder qInConnectIntentConfiguration(QInConnectIntentConfiguration qInConnectIntentConfiguration) {
            this.qInConnectIntentConfiguration = qInConnectIntentConfiguration;
            return this;
        }

        @Override
        public CreateIntentResponse build() {
            return new CreateIntentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
