/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteBotAliasResponse extends LexModelsV2Response implements
        ToCopyableBuilder<DeleteBotAliasResponse.Builder, DeleteBotAliasResponse> {
    private static final SdkField<String> BOT_ALIAS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botAliasId").getter(getter(DeleteBotAliasResponse::botAliasId)).setter(setter(Builder::botAliasId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAliasId").build()).build();

    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(DeleteBotAliasResponse::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<String> BOT_ALIAS_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botAliasStatus").getter(getter(DeleteBotAliasResponse::botAliasStatusAsString))
            .setter(setter(Builder::botAliasStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAliasStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ALIAS_ID_FIELD,
            BOT_ID_FIELD, BOT_ALIAS_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String botAliasId;

    private final String botId;

    private final String botAliasStatus;

    private DeleteBotAliasResponse(BuilderImpl builder) {
        super(builder);
        this.botAliasId = builder.botAliasId;
        this.botId = builder.botId;
        this.botAliasStatus = builder.botAliasStatus;
    }

    /**
     * <p>
     * The unique identifier of the bot alias to delete.
     * </p>
     * 
     * @return The unique identifier of the bot alias to delete.
     */
    public final String botAliasId() {
        return botAliasId;
    }

    /**
     * <p>
     * The unique identifier of the bot that contains the alias to delete.
     * </p>
     * 
     * @return The unique identifier of the bot that contains the alias to delete.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The current status of the alias. The status is <code>Deleting</code> while the alias is in the process of being
     * deleted. Once the alias is deleted, it will no longer appear in the list of aliases returned by the
     * <code>ListBotAliases</code> operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botAliasStatus}
     * will return {@link BotAliasStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #botAliasStatusAsString}.
     * </p>
     * 
     * @return The current status of the alias. The status is <code>Deleting</code> while the alias is in the process of
     *         being deleted. Once the alias is deleted, it will no longer appear in the list of aliases returned by the
     *         <code>ListBotAliases</code> operation.
     * @see BotAliasStatus
     */
    public final BotAliasStatus botAliasStatus() {
        return BotAliasStatus.fromValue(botAliasStatus);
    }

    /**
     * <p>
     * The current status of the alias. The status is <code>Deleting</code> while the alias is in the process of being
     * deleted. Once the alias is deleted, it will no longer appear in the list of aliases returned by the
     * <code>ListBotAliases</code> operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botAliasStatus}
     * will return {@link BotAliasStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #botAliasStatusAsString}.
     * </p>
     * 
     * @return The current status of the alias. The status is <code>Deleting</code> while the alias is in the process of
     *         being deleted. Once the alias is deleted, it will no longer appear in the list of aliases returned by the
     *         <code>ListBotAliases</code> operation.
     * @see BotAliasStatus
     */
    public final String botAliasStatusAsString() {
        return botAliasStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botAliasId());
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botAliasStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteBotAliasResponse)) {
            return false;
        }
        DeleteBotAliasResponse other = (DeleteBotAliasResponse) obj;
        return Objects.equals(botAliasId(), other.botAliasId()) && Objects.equals(botId(), other.botId())
                && Objects.equals(botAliasStatusAsString(), other.botAliasStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteBotAliasResponse").add("BotAliasId", botAliasId()).add("BotId", botId())
                .add("BotAliasStatus", botAliasStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botAliasId":
            return Optional.ofNullable(clazz.cast(botAliasId()));
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botAliasStatus":
            return Optional.ofNullable(clazz.cast(botAliasStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("botAliasId", BOT_ALIAS_ID_FIELD);
        map.put("botId", BOT_ID_FIELD);
        map.put("botAliasStatus", BOT_ALIAS_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteBotAliasResponse, T> g) {
        return obj -> g.apply((DeleteBotAliasResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, DeleteBotAliasResponse> {
        /**
         * <p>
         * The unique identifier of the bot alias to delete.
         * </p>
         * 
         * @param botAliasId
         *        The unique identifier of the bot alias to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAliasId(String botAliasId);

        /**
         * <p>
         * The unique identifier of the bot that contains the alias to delete.
         * </p>
         * 
         * @param botId
         *        The unique identifier of the bot that contains the alias to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The current status of the alias. The status is <code>Deleting</code> while the alias is in the process of
         * being deleted. Once the alias is deleted, it will no longer appear in the list of aliases returned by the
         * <code>ListBotAliases</code> operation.
         * </p>
         * 
         * @param botAliasStatus
         *        The current status of the alias. The status is <code>Deleting</code> while the alias is in the process
         *        of being deleted. Once the alias is deleted, it will no longer appear in the list of aliases returned
         *        by the <code>ListBotAliases</code> operation.
         * @see BotAliasStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotAliasStatus
         */
        Builder botAliasStatus(String botAliasStatus);

        /**
         * <p>
         * The current status of the alias. The status is <code>Deleting</code> while the alias is in the process of
         * being deleted. Once the alias is deleted, it will no longer appear in the list of aliases returned by the
         * <code>ListBotAliases</code> operation.
         * </p>
         * 
         * @param botAliasStatus
         *        The current status of the alias. The status is <code>Deleting</code> while the alias is in the process
         *        of being deleted. Once the alias is deleted, it will no longer appear in the list of aliases returned
         *        by the <code>ListBotAliases</code> operation.
         * @see BotAliasStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotAliasStatus
         */
        Builder botAliasStatus(BotAliasStatus botAliasStatus);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String botAliasId;

        private String botId;

        private String botAliasStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteBotAliasResponse model) {
            super(model);
            botAliasId(model.botAliasId);
            botId(model.botId);
            botAliasStatus(model.botAliasStatus);
        }

        public final String getBotAliasId() {
            return botAliasId;
        }

        public final void setBotAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
        }

        @Override
        public final Builder botAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
            return this;
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotAliasStatus() {
            return botAliasStatus;
        }

        public final void setBotAliasStatus(String botAliasStatus) {
            this.botAliasStatus = botAliasStatus;
        }

        @Override
        public final Builder botAliasStatus(String botAliasStatus) {
            this.botAliasStatus = botAliasStatus;
            return this;
        }

        @Override
        public final Builder botAliasStatus(BotAliasStatus botAliasStatus) {
            this.botAliasStatus(botAliasStatus == null ? null : botAliasStatus.toString());
            return this;
        }

        @Override
        public DeleteBotAliasResponse build() {
            return new DeleteBotAliasResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
