/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteBotLocaleResponse extends LexModelsV2Response implements
        ToCopyableBuilder<DeleteBotLocaleResponse.Builder, DeleteBotLocaleResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(DeleteBotLocaleResponse::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(DeleteBotLocaleResponse::botVersion)).setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(DeleteBotLocaleResponse::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()).build();

    private static final SdkField<String> BOT_LOCALE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botLocaleStatus").getter(getter(DeleteBotLocaleResponse::botLocaleStatusAsString))
            .setter(setter(Builder::botLocaleStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botLocaleStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            BOT_VERSION_FIELD, LOCALE_ID_FIELD, BOT_LOCALE_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String botId;

    private final String botVersion;

    private final String localeId;

    private final String botLocaleStatus;

    private DeleteBotLocaleResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.botLocaleStatus = builder.botLocaleStatus;
    }

    /**
     * <p>
     * The identifier of the bot that contained the deleted locale.
     * </p>
     * 
     * @return The identifier of the bot that contained the deleted locale.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The version of the bot that contained the deleted locale.
     * </p>
     * 
     * @return The version of the bot that contained the deleted locale.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The language and locale of the deleted locale.
     * </p>
     * 
     * @return The language and locale of the deleted locale.
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * <p>
     * The status of deleting the bot locale. The locale first enters the <code>Deleting</code> status. Once the locale
     * is deleted it no longer appears in the list of locales for the bot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botLocaleStatus}
     * will return {@link BotLocaleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #botLocaleStatusAsString}.
     * </p>
     * 
     * @return The status of deleting the bot locale. The locale first enters the <code>Deleting</code> status. Once the
     *         locale is deleted it no longer appears in the list of locales for the bot.
     * @see BotLocaleStatus
     */
    public final BotLocaleStatus botLocaleStatus() {
        return BotLocaleStatus.fromValue(botLocaleStatus);
    }

    /**
     * <p>
     * The status of deleting the bot locale. The locale first enters the <code>Deleting</code> status. Once the locale
     * is deleted it no longer appears in the list of locales for the bot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botLocaleStatus}
     * will return {@link BotLocaleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #botLocaleStatusAsString}.
     * </p>
     * 
     * @return The status of deleting the bot locale. The locale first enters the <code>Deleting</code> status. Once the
     *         locale is deleted it no longer appears in the list of locales for the bot.
     * @see BotLocaleStatus
     */
    public final String botLocaleStatusAsString() {
        return botLocaleStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(botLocaleStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteBotLocaleResponse)) {
            return false;
        }
        DeleteBotLocaleResponse other = (DeleteBotLocaleResponse) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botVersion(), other.botVersion())
                && Objects.equals(localeId(), other.localeId())
                && Objects.equals(botLocaleStatusAsString(), other.botLocaleStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteBotLocaleResponse").add("BotId", botId()).add("BotVersion", botVersion())
                .add("LocaleId", localeId()).add("BotLocaleStatus", botLocaleStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "botLocaleStatus":
            return Optional.ofNullable(clazz.cast(botLocaleStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("botId", BOT_ID_FIELD);
        map.put("botVersion", BOT_VERSION_FIELD);
        map.put("localeId", LOCALE_ID_FIELD);
        map.put("botLocaleStatus", BOT_LOCALE_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteBotLocaleResponse, T> g) {
        return obj -> g.apply((DeleteBotLocaleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, DeleteBotLocaleResponse> {
        /**
         * <p>
         * The identifier of the bot that contained the deleted locale.
         * </p>
         * 
         * @param botId
         *        The identifier of the bot that contained the deleted locale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The version of the bot that contained the deleted locale.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot that contained the deleted locale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The language and locale of the deleted locale.
         * </p>
         * 
         * @param localeId
         *        The language and locale of the deleted locale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * The status of deleting the bot locale. The locale first enters the <code>Deleting</code> status. Once the
         * locale is deleted it no longer appears in the list of locales for the bot.
         * </p>
         * 
         * @param botLocaleStatus
         *        The status of deleting the bot locale. The locale first enters the <code>Deleting</code> status. Once
         *        the locale is deleted it no longer appears in the list of locales for the bot.
         * @see BotLocaleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotLocaleStatus
         */
        Builder botLocaleStatus(String botLocaleStatus);

        /**
         * <p>
         * The status of deleting the bot locale. The locale first enters the <code>Deleting</code> status. Once the
         * locale is deleted it no longer appears in the list of locales for the bot.
         * </p>
         * 
         * @param botLocaleStatus
         *        The status of deleting the bot locale. The locale first enters the <code>Deleting</code> status. Once
         *        the locale is deleted it no longer appears in the list of locales for the bot.
         * @see BotLocaleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotLocaleStatus
         */
        Builder botLocaleStatus(BotLocaleStatus botLocaleStatus);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String botId;

        private String botVersion;

        private String localeId;

        private String botLocaleStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteBotLocaleResponse model) {
            super(model);
            botId(model.botId);
            botVersion(model.botVersion);
            localeId(model.localeId);
            botLocaleStatus(model.botLocaleStatus);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final String getBotLocaleStatus() {
            return botLocaleStatus;
        }

        public final void setBotLocaleStatus(String botLocaleStatus) {
            this.botLocaleStatus = botLocaleStatus;
        }

        @Override
        public final Builder botLocaleStatus(String botLocaleStatus) {
            this.botLocaleStatus = botLocaleStatus;
            return this;
        }

        @Override
        public final Builder botLocaleStatus(BotLocaleStatus botLocaleStatus) {
            this.botLocaleStatus(botLocaleStatus == null ? null : botLocaleStatus.toString());
            return this;
        }

        @Override
        public DeleteBotLocaleResponse build() {
            return new DeleteBotLocaleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
