/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteExportResponse extends LexModelsV2Response implements
        ToCopyableBuilder<DeleteExportResponse.Builder, DeleteExportResponse> {
    private static final SdkField<String> EXPORT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("exportId").getter(getter(DeleteExportResponse::exportId)).setter(setter(Builder::exportId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportId").build()).build();

    private static final SdkField<String> EXPORT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("exportStatus").getter(getter(DeleteExportResponse::exportStatusAsString))
            .setter(setter(Builder::exportStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_ID_FIELD,
            EXPORT_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String exportId;

    private final String exportStatus;

    private DeleteExportResponse(BuilderImpl builder) {
        super(builder);
        this.exportId = builder.exportId;
        this.exportStatus = builder.exportStatus;
    }

    /**
     * <p>
     * The unique identifier of the deleted export.
     * </p>
     * 
     * @return The unique identifier of the deleted export.
     */
    public final String exportId() {
        return exportId;
    }

    /**
     * <p>
     * The current status of the deletion. When the deletion is complete, the export will no longer be returned by the
     * <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListExports.html">ListExports</a> operation
     * and calls to the <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeExport.html">
     * DescribeExport</a> operation with the export identifier will fail.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportStatus} will
     * return {@link ExportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #exportStatusAsString}.
     * </p>
     * 
     * @return The current status of the deletion. When the deletion is complete, the export will no longer be returned
     *         by the <a
     *         href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListExports.html">ListExports</a>
     *         operation and calls to the <a
     *         href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeExport.html"> DescribeExport</a>
     *         operation with the export identifier will fail.
     * @see ExportStatus
     */
    public final ExportStatus exportStatus() {
        return ExportStatus.fromValue(exportStatus);
    }

    /**
     * <p>
     * The current status of the deletion. When the deletion is complete, the export will no longer be returned by the
     * <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListExports.html">ListExports</a> operation
     * and calls to the <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeExport.html">
     * DescribeExport</a> operation with the export identifier will fail.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportStatus} will
     * return {@link ExportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #exportStatusAsString}.
     * </p>
     * 
     * @return The current status of the deletion. When the deletion is complete, the export will no longer be returned
     *         by the <a
     *         href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListExports.html">ListExports</a>
     *         operation and calls to the <a
     *         href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeExport.html"> DescribeExport</a>
     *         operation with the export identifier will fail.
     * @see ExportStatus
     */
    public final String exportStatusAsString() {
        return exportStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(exportId());
        hashCode = 31 * hashCode + Objects.hashCode(exportStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteExportResponse)) {
            return false;
        }
        DeleteExportResponse other = (DeleteExportResponse) obj;
        return Objects.equals(exportId(), other.exportId())
                && Objects.equals(exportStatusAsString(), other.exportStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteExportResponse").add("ExportId", exportId()).add("ExportStatus", exportStatusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "exportId":
            return Optional.ofNullable(clazz.cast(exportId()));
        case "exportStatus":
            return Optional.ofNullable(clazz.cast(exportStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("exportId", EXPORT_ID_FIELD);
        map.put("exportStatus", EXPORT_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteExportResponse, T> g) {
        return obj -> g.apply((DeleteExportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, DeleteExportResponse> {
        /**
         * <p>
         * The unique identifier of the deleted export.
         * </p>
         * 
         * @param exportId
         *        The unique identifier of the deleted export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportId(String exportId);

        /**
         * <p>
         * The current status of the deletion. When the deletion is complete, the export will no longer be returned by
         * the <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListExports.html">ListExports</a>
         * operation and calls to the <a
         * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeExport.html"> DescribeExport</a>
         * operation with the export identifier will fail.
         * </p>
         * 
         * @param exportStatus
         *        The current status of the deletion. When the deletion is complete, the export will no longer be
         *        returned by the <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListExports.html">ListExports</a>
         *        operation and calls to the <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeExport.html">
         *        DescribeExport</a> operation with the export identifier will fail.
         * @see ExportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportStatus
         */
        Builder exportStatus(String exportStatus);

        /**
         * <p>
         * The current status of the deletion. When the deletion is complete, the export will no longer be returned by
         * the <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListExports.html">ListExports</a>
         * operation and calls to the <a
         * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeExport.html"> DescribeExport</a>
         * operation with the export identifier will fail.
         * </p>
         * 
         * @param exportStatus
         *        The current status of the deletion. When the deletion is complete, the export will no longer be
         *        returned by the <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListExports.html">ListExports</a>
         *        operation and calls to the <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeExport.html">
         *        DescribeExport</a> operation with the export identifier will fail.
         * @see ExportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportStatus
         */
        Builder exportStatus(ExportStatus exportStatus);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String exportId;

        private String exportStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteExportResponse model) {
            super(model);
            exportId(model.exportId);
            exportStatus(model.exportStatus);
        }

        public final String getExportId() {
            return exportId;
        }

        public final void setExportId(String exportId) {
            this.exportId = exportId;
        }

        @Override
        public final Builder exportId(String exportId) {
            this.exportId = exportId;
            return this;
        }

        public final String getExportStatus() {
            return exportStatus;
        }

        public final void setExportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
        }

        @Override
        public final Builder exportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
            return this;
        }

        @Override
        public final Builder exportStatus(ExportStatus exportStatus) {
            this.exportStatus(exportStatus == null ? null : exportStatus.toString());
            return this;
        }

        @Override
        public DeleteExportResponse build() {
            return new DeleteExportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
