/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeExportResponse extends LexModelsV2Response implements
        ToCopyableBuilder<DescribeExportResponse.Builder, DescribeExportResponse> {
    private static final SdkField<String> EXPORT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("exportId").getter(getter(DescribeExportResponse::exportId)).setter(setter(Builder::exportId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportId").build()).build();

    private static final SdkField<ExportResourceSpecification> RESOURCE_SPECIFICATION_FIELD = SdkField
            .<ExportResourceSpecification> builder(MarshallingType.SDK_POJO).memberName("resourceSpecification")
            .getter(getter(DescribeExportResponse::resourceSpecification)).setter(setter(Builder::resourceSpecification))
            .constructor(ExportResourceSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceSpecification").build())
            .build();

    private static final SdkField<String> FILE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileFormat").getter(getter(DescribeExportResponse::fileFormatAsString))
            .setter(setter(Builder::fileFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileFormat").build()).build();

    private static final SdkField<String> EXPORT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("exportStatus").getter(getter(DescribeExportResponse::exportStatusAsString))
            .setter(setter(Builder::exportStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportStatus").build()).build();

    private static final SdkField<List<String>> FAILURE_REASONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("failureReasons")
            .getter(getter(DescribeExportResponse::failureReasons))
            .setter(setter(Builder::failureReasons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DOWNLOAD_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("downloadUrl").getter(getter(DescribeExportResponse::downloadUrl)).setter(setter(Builder::downloadUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("downloadUrl").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(DescribeExportResponse::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(DescribeExportResponse::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_ID_FIELD,
            RESOURCE_SPECIFICATION_FIELD, FILE_FORMAT_FIELD, EXPORT_STATUS_FIELD, FAILURE_REASONS_FIELD, DOWNLOAD_URL_FIELD,
            CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String exportId;

    private final ExportResourceSpecification resourceSpecification;

    private final String fileFormat;

    private final String exportStatus;

    private final List<String> failureReasons;

    private final String downloadUrl;

    private final Instant creationDateTime;

    private final Instant lastUpdatedDateTime;

    private DescribeExportResponse(BuilderImpl builder) {
        super(builder);
        this.exportId = builder.exportId;
        this.resourceSpecification = builder.resourceSpecification;
        this.fileFormat = builder.fileFormat;
        this.exportStatus = builder.exportStatus;
        this.failureReasons = builder.failureReasons;
        this.downloadUrl = builder.downloadUrl;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    /**
     * <p>
     * The unique identifier of the described export.
     * </p>
     * 
     * @return The unique identifier of the described export.
     */
    public final String exportId() {
        return exportId;
    }

    /**
     * <p>
     * The bot, bot ID, and optional locale ID of the exported bot or bot locale.
     * </p>
     * 
     * @return The bot, bot ID, and optional locale ID of the exported bot or bot locale.
     */
    public final ExportResourceSpecification resourceSpecification() {
        return resourceSpecification;
    }

    /**
     * <p>
     * The file format used in the files that describe the resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileFormat} will
     * return {@link ImportExportFileFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fileFormatAsString}.
     * </p>
     * 
     * @return The file format used in the files that describe the resource.
     * @see ImportExportFileFormat
     */
    public final ImportExportFileFormat fileFormat() {
        return ImportExportFileFormat.fromValue(fileFormat);
    }

    /**
     * <p>
     * The file format used in the files that describe the resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileFormat} will
     * return {@link ImportExportFileFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fileFormatAsString}.
     * </p>
     * 
     * @return The file format used in the files that describe the resource.
     * @see ImportExportFileFormat
     */
    public final String fileFormatAsString() {
        return fileFormat;
    }

    /**
     * <p>
     * The status of the export. When the status is <code>Complete</code> the export archive file is available for
     * download.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportStatus} will
     * return {@link ExportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #exportStatusAsString}.
     * </p>
     * 
     * @return The status of the export. When the status is <code>Complete</code> the export archive file is available
     *         for download.
     * @see ExportStatus
     */
    public final ExportStatus exportStatus() {
        return ExportStatus.fromValue(exportStatus);
    }

    /**
     * <p>
     * The status of the export. When the status is <code>Complete</code> the export archive file is available for
     * download.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportStatus} will
     * return {@link ExportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #exportStatusAsString}.
     * </p>
     * 
     * @return The status of the export. When the status is <code>Complete</code> the export archive file is available
     *         for download.
     * @see ExportStatus
     */
    public final String exportStatusAsString() {
        return exportStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailureReasons property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFailureReasons() {
        return failureReasons != null && !(failureReasons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If the <code>exportStatus</code> is failed, contains one or more reasons why the export could not be completed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailureReasons} method.
     * </p>
     * 
     * @return If the <code>exportStatus</code> is failed, contains one or more reasons why the export could not be
     *         completed.
     */
    public final List<String> failureReasons() {
        return failureReasons;
    }

    /**
     * <p>
     * A pre-signed S3 URL that points to the bot or bot locale archive. The URL is only available for 5 minutes after
     * calling the <code>DescribeExport</code> operation.
     * </p>
     * 
     * @return A pre-signed S3 URL that points to the bot or bot locale archive. The URL is only available for 5 minutes
     *         after calling the <code>DescribeExport</code> operation.
     */
    public final String downloadUrl() {
        return downloadUrl;
    }

    /**
     * <p>
     * The date and time that the export was created.
     * </p>
     * 
     * @return The date and time that the export was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The last date and time that the export was updated.
     * </p>
     * 
     * @return The last date and time that the export was updated.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(exportId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(fileFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(exportStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasFailureReasons() ? failureReasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(downloadUrl());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExportResponse)) {
            return false;
        }
        DescribeExportResponse other = (DescribeExportResponse) obj;
        return Objects.equals(exportId(), other.exportId())
                && Objects.equals(resourceSpecification(), other.resourceSpecification())
                && Objects.equals(fileFormatAsString(), other.fileFormatAsString())
                && Objects.equals(exportStatusAsString(), other.exportStatusAsString())
                && hasFailureReasons() == other.hasFailureReasons() && Objects.equals(failureReasons(), other.failureReasons())
                && Objects.equals(downloadUrl(), other.downloadUrl())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeExportResponse").add("ExportId", exportId())
                .add("ResourceSpecification", resourceSpecification()).add("FileFormat", fileFormatAsString())
                .add("ExportStatus", exportStatusAsString()).add("FailureReasons", hasFailureReasons() ? failureReasons() : null)
                .add("DownloadUrl", downloadUrl()).add("CreationDateTime", creationDateTime())
                .add("LastUpdatedDateTime", lastUpdatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "exportId":
            return Optional.ofNullable(clazz.cast(exportId()));
        case "resourceSpecification":
            return Optional.ofNullable(clazz.cast(resourceSpecification()));
        case "fileFormat":
            return Optional.ofNullable(clazz.cast(fileFormatAsString()));
        case "exportStatus":
            return Optional.ofNullable(clazz.cast(exportStatusAsString()));
        case "failureReasons":
            return Optional.ofNullable(clazz.cast(failureReasons()));
        case "downloadUrl":
            return Optional.ofNullable(clazz.cast(downloadUrl()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("exportId", EXPORT_ID_FIELD);
        map.put("resourceSpecification", RESOURCE_SPECIFICATION_FIELD);
        map.put("fileFormat", FILE_FORMAT_FIELD);
        map.put("exportStatus", EXPORT_STATUS_FIELD);
        map.put("failureReasons", FAILURE_REASONS_FIELD);
        map.put("downloadUrl", DOWNLOAD_URL_FIELD);
        map.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        map.put("lastUpdatedDateTime", LAST_UPDATED_DATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeExportResponse, T> g) {
        return obj -> g.apply((DescribeExportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeExportResponse> {
        /**
         * <p>
         * The unique identifier of the described export.
         * </p>
         * 
         * @param exportId
         *        The unique identifier of the described export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportId(String exportId);

        /**
         * <p>
         * The bot, bot ID, and optional locale ID of the exported bot or bot locale.
         * </p>
         * 
         * @param resourceSpecification
         *        The bot, bot ID, and optional locale ID of the exported bot or bot locale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceSpecification(ExportResourceSpecification resourceSpecification);

        /**
         * <p>
         * The bot, bot ID, and optional locale ID of the exported bot or bot locale.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExportResourceSpecification.Builder}
         * avoiding the need to create one manually via {@link ExportResourceSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportResourceSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceSpecification(ExportResourceSpecification)}.
         * 
         * @param resourceSpecification
         *        a consumer that will call methods on {@link ExportResourceSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceSpecification(ExportResourceSpecification)
         */
        default Builder resourceSpecification(Consumer<ExportResourceSpecification.Builder> resourceSpecification) {
            return resourceSpecification(ExportResourceSpecification.builder().applyMutation(resourceSpecification).build());
        }

        /**
         * <p>
         * The file format used in the files that describe the resource.
         * </p>
         * 
         * @param fileFormat
         *        The file format used in the files that describe the resource.
         * @see ImportExportFileFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportExportFileFormat
         */
        Builder fileFormat(String fileFormat);

        /**
         * <p>
         * The file format used in the files that describe the resource.
         * </p>
         * 
         * @param fileFormat
         *        The file format used in the files that describe the resource.
         * @see ImportExportFileFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportExportFileFormat
         */
        Builder fileFormat(ImportExportFileFormat fileFormat);

        /**
         * <p>
         * The status of the export. When the status is <code>Complete</code> the export archive file is available for
         * download.
         * </p>
         * 
         * @param exportStatus
         *        The status of the export. When the status is <code>Complete</code> the export archive file is
         *        available for download.
         * @see ExportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportStatus
         */
        Builder exportStatus(String exportStatus);

        /**
         * <p>
         * The status of the export. When the status is <code>Complete</code> the export archive file is available for
         * download.
         * </p>
         * 
         * @param exportStatus
         *        The status of the export. When the status is <code>Complete</code> the export archive file is
         *        available for download.
         * @see ExportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportStatus
         */
        Builder exportStatus(ExportStatus exportStatus);

        /**
         * <p>
         * If the <code>exportStatus</code> is failed, contains one or more reasons why the export could not be
         * completed.
         * </p>
         * 
         * @param failureReasons
         *        If the <code>exportStatus</code> is failed, contains one or more reasons why the export could not be
         *        completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReasons(Collection<String> failureReasons);

        /**
         * <p>
         * If the <code>exportStatus</code> is failed, contains one or more reasons why the export could not be
         * completed.
         * </p>
         * 
         * @param failureReasons
         *        If the <code>exportStatus</code> is failed, contains one or more reasons why the export could not be
         *        completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReasons(String... failureReasons);

        /**
         * <p>
         * A pre-signed S3 URL that points to the bot or bot locale archive. The URL is only available for 5 minutes
         * after calling the <code>DescribeExport</code> operation.
         * </p>
         * 
         * @param downloadUrl
         *        A pre-signed S3 URL that points to the bot or bot locale archive. The URL is only available for 5
         *        minutes after calling the <code>DescribeExport</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder downloadUrl(String downloadUrl);

        /**
         * <p>
         * The date and time that the export was created.
         * </p>
         * 
         * @param creationDateTime
         *        The date and time that the export was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The last date and time that the export was updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The last date and time that the export was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String exportId;

        private ExportResourceSpecification resourceSpecification;

        private String fileFormat;

        private String exportStatus;

        private List<String> failureReasons = DefaultSdkAutoConstructList.getInstance();

        private String downloadUrl;

        private Instant creationDateTime;

        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExportResponse model) {
            super(model);
            exportId(model.exportId);
            resourceSpecification(model.resourceSpecification);
            fileFormat(model.fileFormat);
            exportStatus(model.exportStatus);
            failureReasons(model.failureReasons);
            downloadUrl(model.downloadUrl);
            creationDateTime(model.creationDateTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getExportId() {
            return exportId;
        }

        public final void setExportId(String exportId) {
            this.exportId = exportId;
        }

        @Override
        public final Builder exportId(String exportId) {
            this.exportId = exportId;
            return this;
        }

        public final ExportResourceSpecification.Builder getResourceSpecification() {
            return resourceSpecification != null ? resourceSpecification.toBuilder() : null;
        }

        public final void setResourceSpecification(ExportResourceSpecification.BuilderImpl resourceSpecification) {
            this.resourceSpecification = resourceSpecification != null ? resourceSpecification.build() : null;
        }

        @Override
        public final Builder resourceSpecification(ExportResourceSpecification resourceSpecification) {
            this.resourceSpecification = resourceSpecification;
            return this;
        }

        public final String getFileFormat() {
            return fileFormat;
        }

        public final void setFileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
        }

        @Override
        public final Builder fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        @Override
        public final Builder fileFormat(ImportExportFileFormat fileFormat) {
            this.fileFormat(fileFormat == null ? null : fileFormat.toString());
            return this;
        }

        public final String getExportStatus() {
            return exportStatus;
        }

        public final void setExportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
        }

        @Override
        public final Builder exportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
            return this;
        }

        @Override
        public final Builder exportStatus(ExportStatus exportStatus) {
            this.exportStatus(exportStatus == null ? null : exportStatus.toString());
            return this;
        }

        public final Collection<String> getFailureReasons() {
            if (failureReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return failureReasons;
        }

        public final void setFailureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
        }

        @Override
        public final Builder failureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failureReasons(String... failureReasons) {
            failureReasons(Arrays.asList(failureReasons));
            return this;
        }

        public final String getDownloadUrl() {
            return downloadUrl;
        }

        public final void setDownloadUrl(String downloadUrl) {
            this.downloadUrl = downloadUrl;
        }

        @Override
        public final Builder downloadUrl(String downloadUrl) {
            this.downloadUrl = downloadUrl;
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        @Override
        public DescribeExportResponse build() {
            return new DescribeExportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
