/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTestSetGenerationResponse extends LexModelsV2Response implements
        ToCopyableBuilder<DescribeTestSetGenerationResponse.Builder, DescribeTestSetGenerationResponse> {
    private static final SdkField<String> TEST_SET_GENERATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testSetGenerationId").getter(getter(DescribeTestSetGenerationResponse::testSetGenerationId))
            .setter(setter(Builder::testSetGenerationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetGenerationId").build())
            .build();

    private static final SdkField<String> TEST_SET_GENERATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testSetGenerationStatus")
            .getter(getter(DescribeTestSetGenerationResponse::testSetGenerationStatusAsString))
            .setter(setter(Builder::testSetGenerationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetGenerationStatus").build())
            .build();

    private static final SdkField<List<String>> FAILURE_REASONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("failureReasons")
            .getter(getter(DescribeTestSetGenerationResponse::failureReasons))
            .setter(setter(Builder::failureReasons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TEST_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testSetId").getter(getter(DescribeTestSetGenerationResponse::testSetId))
            .setter(setter(Builder::testSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetId").build()).build();

    private static final SdkField<String> TEST_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testSetName").getter(getter(DescribeTestSetGenerationResponse::testSetName))
            .setter(setter(Builder::testSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(DescribeTestSetGenerationResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<TestSetStorageLocation> STORAGE_LOCATION_FIELD = SdkField
            .<TestSetStorageLocation> builder(MarshallingType.SDK_POJO).memberName("storageLocation")
            .getter(getter(DescribeTestSetGenerationResponse::storageLocation)).setter(setter(Builder::storageLocation))
            .constructor(TestSetStorageLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageLocation").build()).build();

    private static final SdkField<TestSetGenerationDataSource> GENERATION_DATA_SOURCE_FIELD = SdkField
            .<TestSetGenerationDataSource> builder(MarshallingType.SDK_POJO).memberName("generationDataSource")
            .getter(getter(DescribeTestSetGenerationResponse::generationDataSource))
            .setter(setter(Builder::generationDataSource)).constructor(TestSetGenerationDataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generationDataSource").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(DescribeTestSetGenerationResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(DescribeTestSetGenerationResponse::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(DescribeTestSetGenerationResponse::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_SET_GENERATION_ID_FIELD,
            TEST_SET_GENERATION_STATUS_FIELD, FAILURE_REASONS_FIELD, TEST_SET_ID_FIELD, TEST_SET_NAME_FIELD, DESCRIPTION_FIELD,
            STORAGE_LOCATION_FIELD, GENERATION_DATA_SOURCE_FIELD, ROLE_ARN_FIELD, CREATION_DATE_TIME_FIELD,
            LAST_UPDATED_DATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String testSetGenerationId;

    private final String testSetGenerationStatus;

    private final List<String> failureReasons;

    private final String testSetId;

    private final String testSetName;

    private final String description;

    private final TestSetStorageLocation storageLocation;

    private final TestSetGenerationDataSource generationDataSource;

    private final String roleArn;

    private final Instant creationDateTime;

    private final Instant lastUpdatedDateTime;

    private DescribeTestSetGenerationResponse(BuilderImpl builder) {
        super(builder);
        this.testSetGenerationId = builder.testSetGenerationId;
        this.testSetGenerationStatus = builder.testSetGenerationStatus;
        this.failureReasons = builder.failureReasons;
        this.testSetId = builder.testSetId;
        this.testSetName = builder.testSetName;
        this.description = builder.description;
        this.storageLocation = builder.storageLocation;
        this.generationDataSource = builder.generationDataSource;
        this.roleArn = builder.roleArn;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    /**
     * <p>
     * The unique identifier of the test set generation.
     * </p>
     * 
     * @return The unique identifier of the test set generation.
     */
    public final String testSetGenerationId() {
        return testSetGenerationId;
    }

    /**
     * <p>
     * The status for the test set generation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #testSetGenerationStatus} will return {@link TestSetGenerationStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #testSetGenerationStatusAsString}.
     * </p>
     * 
     * @return The status for the test set generation.
     * @see TestSetGenerationStatus
     */
    public final TestSetGenerationStatus testSetGenerationStatus() {
        return TestSetGenerationStatus.fromValue(testSetGenerationStatus);
    }

    /**
     * <p>
     * The status for the test set generation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #testSetGenerationStatus} will return {@link TestSetGenerationStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #testSetGenerationStatusAsString}.
     * </p>
     * 
     * @return The status for the test set generation.
     * @see TestSetGenerationStatus
     */
    public final String testSetGenerationStatusAsString() {
        return testSetGenerationStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailureReasons property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFailureReasons() {
        return failureReasons != null && !(failureReasons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The reasons the test set generation failed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailureReasons} method.
     * </p>
     * 
     * @return The reasons the test set generation failed.
     */
    public final List<String> failureReasons() {
        return failureReasons;
    }

    /**
     * <p>
     * The unique identifier for the test set created for the generated test set.
     * </p>
     * 
     * @return The unique identifier for the test set created for the generated test set.
     */
    public final String testSetId() {
        return testSetId;
    }

    /**
     * <p>
     * The test set name for the generated test set.
     * </p>
     * 
     * @return The test set name for the generated test set.
     */
    public final String testSetName() {
        return testSetName;
    }

    /**
     * <p>
     * The test set description for the test set generation.
     * </p>
     * 
     * @return The test set description for the test set generation.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon S3 storage location for the test set generation.
     * </p>
     * 
     * @return The Amazon S3 storage location for the test set generation.
     */
    public final TestSetStorageLocation storageLocation() {
        return storageLocation;
    }

    /**
     * <p>
     * The data source of the test set used for the test set generation.
     * </p>
     * 
     * @return The data source of the test set used for the test set generation.
     */
    public final TestSetGenerationDataSource generationDataSource() {
        return generationDataSource;
    }

    /**
     * <p>
     * The roleARN of the test set used for the test set generation.
     * </p>
     * 
     * @return The roleARN of the test set used for the test set generation.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The creation date and time for the test set generation.
     * </p>
     * 
     * @return The creation date and time for the test set generation.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The date and time of the last update for the test set generation.
     * </p>
     * 
     * @return The date and time of the last update for the test set generation.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(testSetGenerationId());
        hashCode = 31 * hashCode + Objects.hashCode(testSetGenerationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasFailureReasons() ? failureReasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(testSetId());
        hashCode = 31 * hashCode + Objects.hashCode(testSetName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(storageLocation());
        hashCode = 31 * hashCode + Objects.hashCode(generationDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTestSetGenerationResponse)) {
            return false;
        }
        DescribeTestSetGenerationResponse other = (DescribeTestSetGenerationResponse) obj;
        return Objects.equals(testSetGenerationId(), other.testSetGenerationId())
                && Objects.equals(testSetGenerationStatusAsString(), other.testSetGenerationStatusAsString())
                && hasFailureReasons() == other.hasFailureReasons() && Objects.equals(failureReasons(), other.failureReasons())
                && Objects.equals(testSetId(), other.testSetId()) && Objects.equals(testSetName(), other.testSetName())
                && Objects.equals(description(), other.description())
                && Objects.equals(storageLocation(), other.storageLocation())
                && Objects.equals(generationDataSource(), other.generationDataSource())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTestSetGenerationResponse").add("TestSetGenerationId", testSetGenerationId())
                .add("TestSetGenerationStatus", testSetGenerationStatusAsString())
                .add("FailureReasons", hasFailureReasons() ? failureReasons() : null).add("TestSetId", testSetId())
                .add("TestSetName", testSetName()).add("Description", description()).add("StorageLocation", storageLocation())
                .add("GenerationDataSource", generationDataSource()).add("RoleArn", roleArn())
                .add("CreationDateTime", creationDateTime()).add("LastUpdatedDateTime", lastUpdatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testSetGenerationId":
            return Optional.ofNullable(clazz.cast(testSetGenerationId()));
        case "testSetGenerationStatus":
            return Optional.ofNullable(clazz.cast(testSetGenerationStatusAsString()));
        case "failureReasons":
            return Optional.ofNullable(clazz.cast(failureReasons()));
        case "testSetId":
            return Optional.ofNullable(clazz.cast(testSetId()));
        case "testSetName":
            return Optional.ofNullable(clazz.cast(testSetName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "storageLocation":
            return Optional.ofNullable(clazz.cast(storageLocation()));
        case "generationDataSource":
            return Optional.ofNullable(clazz.cast(generationDataSource()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("testSetGenerationId", TEST_SET_GENERATION_ID_FIELD);
        map.put("testSetGenerationStatus", TEST_SET_GENERATION_STATUS_FIELD);
        map.put("failureReasons", FAILURE_REASONS_FIELD);
        map.put("testSetId", TEST_SET_ID_FIELD);
        map.put("testSetName", TEST_SET_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("storageLocation", STORAGE_LOCATION_FIELD);
        map.put("generationDataSource", GENERATION_DATA_SOURCE_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        map.put("lastUpdatedDateTime", LAST_UPDATED_DATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeTestSetGenerationResponse, T> g) {
        return obj -> g.apply((DescribeTestSetGenerationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LexModelsV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTestSetGenerationResponse> {
        /**
         * <p>
         * The unique identifier of the test set generation.
         * </p>
         * 
         * @param testSetGenerationId
         *        The unique identifier of the test set generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testSetGenerationId(String testSetGenerationId);

        /**
         * <p>
         * The status for the test set generation.
         * </p>
         * 
         * @param testSetGenerationStatus
         *        The status for the test set generation.
         * @see TestSetGenerationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestSetGenerationStatus
         */
        Builder testSetGenerationStatus(String testSetGenerationStatus);

        /**
         * <p>
         * The status for the test set generation.
         * </p>
         * 
         * @param testSetGenerationStatus
         *        The status for the test set generation.
         * @see TestSetGenerationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestSetGenerationStatus
         */
        Builder testSetGenerationStatus(TestSetGenerationStatus testSetGenerationStatus);

        /**
         * <p>
         * The reasons the test set generation failed.
         * </p>
         * 
         * @param failureReasons
         *        The reasons the test set generation failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReasons(Collection<String> failureReasons);

        /**
         * <p>
         * The reasons the test set generation failed.
         * </p>
         * 
         * @param failureReasons
         *        The reasons the test set generation failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReasons(String... failureReasons);

        /**
         * <p>
         * The unique identifier for the test set created for the generated test set.
         * </p>
         * 
         * @param testSetId
         *        The unique identifier for the test set created for the generated test set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testSetId(String testSetId);

        /**
         * <p>
         * The test set name for the generated test set.
         * </p>
         * 
         * @param testSetName
         *        The test set name for the generated test set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testSetName(String testSetName);

        /**
         * <p>
         * The test set description for the test set generation.
         * </p>
         * 
         * @param description
         *        The test set description for the test set generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon S3 storage location for the test set generation.
         * </p>
         * 
         * @param storageLocation
         *        The Amazon S3 storage location for the test set generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageLocation(TestSetStorageLocation storageLocation);

        /**
         * <p>
         * The Amazon S3 storage location for the test set generation.
         * </p>
         * This is a convenience method that creates an instance of the {@link TestSetStorageLocation.Builder} avoiding
         * the need to create one manually via {@link TestSetStorageLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TestSetStorageLocation.Builder#build()} is called immediately and
         * its result is passed to {@link #storageLocation(TestSetStorageLocation)}.
         * 
         * @param storageLocation
         *        a consumer that will call methods on {@link TestSetStorageLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageLocation(TestSetStorageLocation)
         */
        default Builder storageLocation(Consumer<TestSetStorageLocation.Builder> storageLocation) {
            return storageLocation(TestSetStorageLocation.builder().applyMutation(storageLocation).build());
        }

        /**
         * <p>
         * The data source of the test set used for the test set generation.
         * </p>
         * 
         * @param generationDataSource
         *        The data source of the test set used for the test set generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generationDataSource(TestSetGenerationDataSource generationDataSource);

        /**
         * <p>
         * The data source of the test set used for the test set generation.
         * </p>
         * This is a convenience method that creates an instance of the {@link TestSetGenerationDataSource.Builder}
         * avoiding the need to create one manually via {@link TestSetGenerationDataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TestSetGenerationDataSource.Builder#build()} is called
         * immediately and its result is passed to {@link #generationDataSource(TestSetGenerationDataSource)}.
         * 
         * @param generationDataSource
         *        a consumer that will call methods on {@link TestSetGenerationDataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #generationDataSource(TestSetGenerationDataSource)
         */
        default Builder generationDataSource(Consumer<TestSetGenerationDataSource.Builder> generationDataSource) {
            return generationDataSource(TestSetGenerationDataSource.builder().applyMutation(generationDataSource).build());
        }

        /**
         * <p>
         * The roleARN of the test set used for the test set generation.
         * </p>
         * 
         * @param roleArn
         *        The roleARN of the test set used for the test set generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The creation date and time for the test set generation.
         * </p>
         * 
         * @param creationDateTime
         *        The creation date and time for the test set generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The date and time of the last update for the test set generation.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The date and time of the last update for the test set generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String testSetGenerationId;

        private String testSetGenerationStatus;

        private List<String> failureReasons = DefaultSdkAutoConstructList.getInstance();

        private String testSetId;

        private String testSetName;

        private String description;

        private TestSetStorageLocation storageLocation;

        private TestSetGenerationDataSource generationDataSource;

        private String roleArn;

        private Instant creationDateTime;

        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTestSetGenerationResponse model) {
            super(model);
            testSetGenerationId(model.testSetGenerationId);
            testSetGenerationStatus(model.testSetGenerationStatus);
            failureReasons(model.failureReasons);
            testSetId(model.testSetId);
            testSetName(model.testSetName);
            description(model.description);
            storageLocation(model.storageLocation);
            generationDataSource(model.generationDataSource);
            roleArn(model.roleArn);
            creationDateTime(model.creationDateTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getTestSetGenerationId() {
            return testSetGenerationId;
        }

        public final void setTestSetGenerationId(String testSetGenerationId) {
            this.testSetGenerationId = testSetGenerationId;
        }

        @Override
        public final Builder testSetGenerationId(String testSetGenerationId) {
            this.testSetGenerationId = testSetGenerationId;
            return this;
        }

        public final String getTestSetGenerationStatus() {
            return testSetGenerationStatus;
        }

        public final void setTestSetGenerationStatus(String testSetGenerationStatus) {
            this.testSetGenerationStatus = testSetGenerationStatus;
        }

        @Override
        public final Builder testSetGenerationStatus(String testSetGenerationStatus) {
            this.testSetGenerationStatus = testSetGenerationStatus;
            return this;
        }

        @Override
        public final Builder testSetGenerationStatus(TestSetGenerationStatus testSetGenerationStatus) {
            this.testSetGenerationStatus(testSetGenerationStatus == null ? null : testSetGenerationStatus.toString());
            return this;
        }

        public final Collection<String> getFailureReasons() {
            if (failureReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return failureReasons;
        }

        public final void setFailureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
        }

        @Override
        public final Builder failureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failureReasons(String... failureReasons) {
            failureReasons(Arrays.asList(failureReasons));
            return this;
        }

        public final String getTestSetId() {
            return testSetId;
        }

        public final void setTestSetId(String testSetId) {
            this.testSetId = testSetId;
        }

        @Override
        public final Builder testSetId(String testSetId) {
            this.testSetId = testSetId;
            return this;
        }

        public final String getTestSetName() {
            return testSetName;
        }

        public final void setTestSetName(String testSetName) {
            this.testSetName = testSetName;
        }

        @Override
        public final Builder testSetName(String testSetName) {
            this.testSetName = testSetName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final TestSetStorageLocation.Builder getStorageLocation() {
            return storageLocation != null ? storageLocation.toBuilder() : null;
        }

        public final void setStorageLocation(TestSetStorageLocation.BuilderImpl storageLocation) {
            this.storageLocation = storageLocation != null ? storageLocation.build() : null;
        }

        @Override
        public final Builder storageLocation(TestSetStorageLocation storageLocation) {
            this.storageLocation = storageLocation;
            return this;
        }

        public final TestSetGenerationDataSource.Builder getGenerationDataSource() {
            return generationDataSource != null ? generationDataSource.toBuilder() : null;
        }

        public final void setGenerationDataSource(TestSetGenerationDataSource.BuilderImpl generationDataSource) {
            this.generationDataSource = generationDataSource != null ? generationDataSource.build() : null;
        }

        @Override
        public final Builder generationDataSource(TestSetGenerationDataSource generationDataSource) {
            this.generationDataSource = generationDataSource;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        @Override
        public DescribeTestSetGenerationResponse build() {
            return new DescribeTestSetGenerationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
