/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBotVersionsResponse extends LexModelsV2Response implements
        ToCopyableBuilder<ListBotVersionsResponse.Builder, ListBotVersionsResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(ListBotVersionsResponse::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<List<BotVersionSummary>> BOT_VERSION_SUMMARIES_FIELD = SdkField
            .<List<BotVersionSummary>> builder(MarshallingType.LIST)
            .memberName("botVersionSummaries")
            .getter(getter(ListBotVersionsResponse::botVersionSummaries))
            .setter(setter(Builder::botVersionSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersionSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BotVersionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(BotVersionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListBotVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            BOT_VERSION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String botId;

    private final List<BotVersionSummary> botVersionSummaries;

    private final String nextToken;

    private ListBotVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersionSummaries = builder.botVersionSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The identifier of the bot to list versions for.
     * </p>
     * 
     * @return The identifier of the bot to list versions for.
     */
    public final String botId() {
        return botId;
    }

    /**
     * For responses, this returns true if the service returned a value for the BotVersionSummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBotVersionSummaries() {
        return botVersionSummaries != null && !(botVersionSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summary information for the bot versions that meet the filter criteria specified in the request. The length of
     * the list is specified in the <code>maxResults</code> parameter of the request. If there are more versions
     * available, the <code>nextToken</code> field contains a token to get the next page of results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBotVersionSummaries} method.
     * </p>
     * 
     * @return Summary information for the bot versions that meet the filter criteria specified in the request. The
     *         length of the list is specified in the <code>maxResults</code> parameter of the request. If there are
     *         more versions available, the <code>nextToken</code> field contains a token to get the next page of
     *         results.
     */
    public final List<BotVersionSummary> botVersionSummaries() {
        return botVersionSummaries;
    }

    /**
     * <p>
     * A token that indicates whether there are more results to return in a response to the <code>ListBotVersions</code>
     * operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code>
     * parameter of a <code>ListBotAliases</code> operation request to get the next page of results.
     * </p>
     * 
     * @return A token that indicates whether there are more results to return in a response to the
     *         <code>ListBotVersions</code> operation. If the <code>nextToken</code> field is present, you send the
     *         contents as the <code>nextToken</code> parameter of a <code>ListBotAliases</code> operation request to
     *         get the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(hasBotVersionSummaries() ? botVersionSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBotVersionsResponse)) {
            return false;
        }
        ListBotVersionsResponse other = (ListBotVersionsResponse) obj;
        return Objects.equals(botId(), other.botId()) && hasBotVersionSummaries() == other.hasBotVersionSummaries()
                && Objects.equals(botVersionSummaries(), other.botVersionSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBotVersionsResponse").add("BotId", botId())
                .add("BotVersionSummaries", hasBotVersionSummaries() ? botVersionSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botVersionSummaries":
            return Optional.ofNullable(clazz.cast(botVersionSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("botId", BOT_ID_FIELD);
        map.put("botVersionSummaries", BOT_VERSION_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBotVersionsResponse, T> g) {
        return obj -> g.apply((ListBotVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, ListBotVersionsResponse> {
        /**
         * <p>
         * The identifier of the bot to list versions for.
         * </p>
         * 
         * @param botId
         *        The identifier of the bot to list versions for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * Summary information for the bot versions that meet the filter criteria specified in the request. The length
         * of the list is specified in the <code>maxResults</code> parameter of the request. If there are more versions
         * available, the <code>nextToken</code> field contains a token to get the next page of results.
         * </p>
         * 
         * @param botVersionSummaries
         *        Summary information for the bot versions that meet the filter criteria specified in the request. The
         *        length of the list is specified in the <code>maxResults</code> parameter of the request. If there are
         *        more versions available, the <code>nextToken</code> field contains a token to get the next page of
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersionSummaries(Collection<BotVersionSummary> botVersionSummaries);

        /**
         * <p>
         * Summary information for the bot versions that meet the filter criteria specified in the request. The length
         * of the list is specified in the <code>maxResults</code> parameter of the request. If there are more versions
         * available, the <code>nextToken</code> field contains a token to get the next page of results.
         * </p>
         * 
         * @param botVersionSummaries
         *        Summary information for the bot versions that meet the filter criteria specified in the request. The
         *        length of the list is specified in the <code>maxResults</code> parameter of the request. If there are
         *        more versions available, the <code>nextToken</code> field contains a token to get the next page of
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersionSummaries(BotVersionSummary... botVersionSummaries);

        /**
         * <p>
         * Summary information for the bot versions that meet the filter criteria specified in the request. The length
         * of the list is specified in the <code>maxResults</code> parameter of the request. If there are more versions
         * available, the <code>nextToken</code> field contains a token to get the next page of results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.BotVersionSummary.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.lexmodelsv2.model.BotVersionSummary#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.BotVersionSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #botVersionSummaries(List<BotVersionSummary>)}.
         * 
         * @param botVersionSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.BotVersionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #botVersionSummaries(java.util.Collection<BotVersionSummary>)
         */
        Builder botVersionSummaries(Consumer<BotVersionSummary.Builder>... botVersionSummaries);

        /**
         * <p>
         * A token that indicates whether there are more results to return in a response to the
         * <code>ListBotVersions</code> operation. If the <code>nextToken</code> field is present, you send the contents
         * as the <code>nextToken</code> parameter of a <code>ListBotAliases</code> operation request to get the next
         * page of results.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates whether there are more results to return in a response to the
         *        <code>ListBotVersions</code> operation. If the <code>nextToken</code> field is present, you send the
         *        contents as the <code>nextToken</code> parameter of a <code>ListBotAliases</code> operation request to
         *        get the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String botId;

        private List<BotVersionSummary> botVersionSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBotVersionsResponse model) {
            super(model);
            botId(model.botId);
            botVersionSummaries(model.botVersionSummaries);
            nextToken(model.nextToken);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final List<BotVersionSummary.Builder> getBotVersionSummaries() {
            List<BotVersionSummary.Builder> result = BotVersionSummaryListCopier.copyToBuilder(this.botVersionSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBotVersionSummaries(Collection<BotVersionSummary.BuilderImpl> botVersionSummaries) {
            this.botVersionSummaries = BotVersionSummaryListCopier.copyFromBuilder(botVersionSummaries);
        }

        @Override
        public final Builder botVersionSummaries(Collection<BotVersionSummary> botVersionSummaries) {
            this.botVersionSummaries = BotVersionSummaryListCopier.copy(botVersionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botVersionSummaries(BotVersionSummary... botVersionSummaries) {
            botVersionSummaries(Arrays.asList(botVersionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botVersionSummaries(Consumer<BotVersionSummary.Builder>... botVersionSummaries) {
            botVersionSummaries(Stream.of(botVersionSummaries).map(c -> BotVersionSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBotVersionsResponse build() {
            return new ListBotVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
