/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCustomVocabularyItemsResponse extends LexModelsV2Response implements
        ToCopyableBuilder<ListCustomVocabularyItemsResponse.Builder, ListCustomVocabularyItemsResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(ListCustomVocabularyItemsResponse::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(ListCustomVocabularyItemsResponse::botVersion))
            .setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(ListCustomVocabularyItemsResponse::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()).build();

    private static final SdkField<List<CustomVocabularyItem>> CUSTOM_VOCABULARY_ITEMS_FIELD = SdkField
            .<List<CustomVocabularyItem>> builder(MarshallingType.LIST)
            .memberName("customVocabularyItems")
            .getter(getter(ListCustomVocabularyItemsResponse::customVocabularyItems))
            .setter(setter(Builder::customVocabularyItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customVocabularyItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomVocabularyItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomVocabularyItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListCustomVocabularyItemsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            BOT_VERSION_FIELD, LOCALE_ID_FIELD, CUSTOM_VOCABULARY_ITEMS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String botId;

    private final String botVersion;

    private final String localeId;

    private final List<CustomVocabularyItem> customVocabularyItems;

    private final String nextToken;

    private ListCustomVocabularyItemsResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.customVocabularyItems = builder.customVocabularyItems;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The identifier of the bot associated with this custom vocabulary.
     * </p>
     * 
     * @return The identifier of the bot associated with this custom vocabulary.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The identifier of the version of the bot associated with this custom vocabulary.
     * </p>
     * 
     * @return The identifier of the version of the bot associated with this custom vocabulary.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The identifier of the language and locale where this custom vocabulary is used. The string must match one of the
     * supported locales. For more information, see <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html"> Supported Languages </a>.
     * </p>
     * 
     * @return The identifier of the language and locale where this custom vocabulary is used. The string must match one
     *         of the supported locales. For more information, see <a
     *         href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html"> Supported Languages </a>.
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomVocabularyItems property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCustomVocabularyItems() {
        return customVocabularyItems != null && !(customVocabularyItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The custom vocabulary items from the list custom vocabulary response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomVocabularyItems} method.
     * </p>
     * 
     * @return The custom vocabulary items from the list custom vocabulary response.
     */
    public final List<CustomVocabularyItem> customVocabularyItems() {
        return customVocabularyItems;
    }

    /**
     * <p>
     * The nextToken identifier to the list custom vocabulary response.
     * </p>
     * 
     * @return The nextToken identifier to the list custom vocabulary response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomVocabularyItems() ? customVocabularyItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCustomVocabularyItemsResponse)) {
            return false;
        }
        ListCustomVocabularyItemsResponse other = (ListCustomVocabularyItemsResponse) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botVersion(), other.botVersion())
                && Objects.equals(localeId(), other.localeId()) && hasCustomVocabularyItems() == other.hasCustomVocabularyItems()
                && Objects.equals(customVocabularyItems(), other.customVocabularyItems())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCustomVocabularyItemsResponse").add("BotId", botId()).add("BotVersion", botVersion())
                .add("LocaleId", localeId())
                .add("CustomVocabularyItems", hasCustomVocabularyItems() ? customVocabularyItems() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "customVocabularyItems":
            return Optional.ofNullable(clazz.cast(customVocabularyItems()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("botId", BOT_ID_FIELD);
        map.put("botVersion", BOT_VERSION_FIELD);
        map.put("localeId", LOCALE_ID_FIELD);
        map.put("customVocabularyItems", CUSTOM_VOCABULARY_ITEMS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCustomVocabularyItemsResponse, T> g) {
        return obj -> g.apply((ListCustomVocabularyItemsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LexModelsV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCustomVocabularyItemsResponse> {
        /**
         * <p>
         * The identifier of the bot associated with this custom vocabulary.
         * </p>
         * 
         * @param botId
         *        The identifier of the bot associated with this custom vocabulary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The identifier of the version of the bot associated with this custom vocabulary.
         * </p>
         * 
         * @param botVersion
         *        The identifier of the version of the bot associated with this custom vocabulary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The identifier of the language and locale where this custom vocabulary is used. The string must match one of
         * the supported locales. For more information, see <a
         * href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html"> Supported Languages </a>.
         * </p>
         * 
         * @param localeId
         *        The identifier of the language and locale where this custom vocabulary is used. The string must match
         *        one of the supported locales. For more information, see <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html"> Supported Languages </a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * The custom vocabulary items from the list custom vocabulary response.
         * </p>
         * 
         * @param customVocabularyItems
         *        The custom vocabulary items from the list custom vocabulary response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customVocabularyItems(Collection<CustomVocabularyItem> customVocabularyItems);

        /**
         * <p>
         * The custom vocabulary items from the list custom vocabulary response.
         * </p>
         * 
         * @param customVocabularyItems
         *        The custom vocabulary items from the list custom vocabulary response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customVocabularyItems(CustomVocabularyItem... customVocabularyItems);

        /**
         * <p>
         * The custom vocabulary items from the list custom vocabulary response.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.CustomVocabularyItem.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.CustomVocabularyItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.CustomVocabularyItem.Builder#build()} is called
         * immediately and its result is passed to {@link #customVocabularyItems(List<CustomVocabularyItem>)}.
         * 
         * @param customVocabularyItems
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.CustomVocabularyItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customVocabularyItems(java.util.Collection<CustomVocabularyItem>)
         */
        Builder customVocabularyItems(Consumer<CustomVocabularyItem.Builder>... customVocabularyItems);

        /**
         * <p>
         * The nextToken identifier to the list custom vocabulary response.
         * </p>
         * 
         * @param nextToken
         *        The nextToken identifier to the list custom vocabulary response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String botId;

        private String botVersion;

        private String localeId;

        private List<CustomVocabularyItem> customVocabularyItems = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCustomVocabularyItemsResponse model) {
            super(model);
            botId(model.botId);
            botVersion(model.botVersion);
            localeId(model.localeId);
            customVocabularyItems(model.customVocabularyItems);
            nextToken(model.nextToken);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final List<CustomVocabularyItem.Builder> getCustomVocabularyItems() {
            List<CustomVocabularyItem.Builder> result = CustomVocabularyItemsCopier.copyToBuilder(this.customVocabularyItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomVocabularyItems(Collection<CustomVocabularyItem.BuilderImpl> customVocabularyItems) {
            this.customVocabularyItems = CustomVocabularyItemsCopier.copyFromBuilder(customVocabularyItems);
        }

        @Override
        public final Builder customVocabularyItems(Collection<CustomVocabularyItem> customVocabularyItems) {
            this.customVocabularyItems = CustomVocabularyItemsCopier.copy(customVocabularyItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customVocabularyItems(CustomVocabularyItem... customVocabularyItems) {
            customVocabularyItems(Arrays.asList(customVocabularyItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customVocabularyItems(Consumer<CustomVocabularyItem.Builder>... customVocabularyItems) {
            customVocabularyItems(Stream.of(customVocabularyItems)
                    .map(c -> CustomVocabularyItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCustomVocabularyItemsResponse build() {
            return new ListCustomVocabularyItemsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
