/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configures the Assisted Natural Language Understanding (NLU) feature for your bot. This specification determines
 * whether enhanced intent recognition and utterance understanding capabilities are active.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NluImprovementSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<NluImprovementSpecification.Builder, NluImprovementSpecification> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(NluImprovementSpecification::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<String> ASSISTED_NLU_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assistedNluMode").getter(getter(NluImprovementSpecification::assistedNluModeAsString))
            .setter(setter(Builder::assistedNluMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistedNluMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            ASSISTED_NLU_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final String assistedNluMode;

    private NluImprovementSpecification(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.assistedNluMode = builder.assistedNluMode;
    }

    /**
     * <p>
     * Determines whether the Assisted NLU feature is enabled for the bot. When set to <code>true</code>, Amazon Lex
     * uses advanced models to improve intent recognition and slot resolution, with the default being <code>false</code>
     * .
     * </p>
     * 
     * @return Determines whether the Assisted NLU feature is enabled for the bot. When set to <code>true</code>, Amazon
     *         Lex uses advanced models to improve intent recognition and slot resolution, with the default being
     *         <code>false</code>.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * Specifies the mode for Assisted NLU operation. Use <code>Primary</code> to make Assisted NLU the primary intent
     * recognition method, or <code>Fallback</code> to use it only when standard NLU confidence is low.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #assistedNluMode}
     * will return {@link AssistedNluMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #assistedNluModeAsString}.
     * </p>
     * 
     * @return Specifies the mode for Assisted NLU operation. Use <code>Primary</code> to make Assisted NLU the primary
     *         intent recognition method, or <code>Fallback</code> to use it only when standard NLU confidence is low.
     * @see AssistedNluMode
     */
    public final AssistedNluMode assistedNluMode() {
        return AssistedNluMode.fromValue(assistedNluMode);
    }

    /**
     * <p>
     * Specifies the mode for Assisted NLU operation. Use <code>Primary</code> to make Assisted NLU the primary intent
     * recognition method, or <code>Fallback</code> to use it only when standard NLU confidence is low.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #assistedNluMode}
     * will return {@link AssistedNluMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #assistedNluModeAsString}.
     * </p>
     * 
     * @return Specifies the mode for Assisted NLU operation. Use <code>Primary</code> to make Assisted NLU the primary
     *         intent recognition method, or <code>Fallback</code> to use it only when standard NLU confidence is low.
     * @see AssistedNluMode
     */
    public final String assistedNluModeAsString() {
        return assistedNluMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(assistedNluModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NluImprovementSpecification)) {
            return false;
        }
        NluImprovementSpecification other = (NluImprovementSpecification) obj;
        return Objects.equals(enabled(), other.enabled())
                && Objects.equals(assistedNluModeAsString(), other.assistedNluModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NluImprovementSpecification").add("Enabled", enabled())
                .add("AssistedNluMode", assistedNluModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "assistedNluMode":
            return Optional.ofNullable(clazz.cast(assistedNluModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("enabled", ENABLED_FIELD);
        map.put("assistedNluMode", ASSISTED_NLU_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NluImprovementSpecification, T> g) {
        return obj -> g.apply((NluImprovementSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NluImprovementSpecification> {
        /**
         * <p>
         * Determines whether the Assisted NLU feature is enabled for the bot. When set to <code>true</code>, Amazon Lex
         * uses advanced models to improve intent recognition and slot resolution, with the default being
         * <code>false</code>.
         * </p>
         * 
         * @param enabled
         *        Determines whether the Assisted NLU feature is enabled for the bot. When set to <code>true</code>,
         *        Amazon Lex uses advanced models to improve intent recognition and slot resolution, with the default
         *        being <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * Specifies the mode for Assisted NLU operation. Use <code>Primary</code> to make Assisted NLU the primary
         * intent recognition method, or <code>Fallback</code> to use it only when standard NLU confidence is low.
         * </p>
         * 
         * @param assistedNluMode
         *        Specifies the mode for Assisted NLU operation. Use <code>Primary</code> to make Assisted NLU the
         *        primary intent recognition method, or <code>Fallback</code> to use it only when standard NLU
         *        confidence is low.
         * @see AssistedNluMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssistedNluMode
         */
        Builder assistedNluMode(String assistedNluMode);

        /**
         * <p>
         * Specifies the mode for Assisted NLU operation. Use <code>Primary</code> to make Assisted NLU the primary
         * intent recognition method, or <code>Fallback</code> to use it only when standard NLU confidence is low.
         * </p>
         * 
         * @param assistedNluMode
         *        Specifies the mode for Assisted NLU operation. Use <code>Primary</code> to make Assisted NLU the
         *        primary intent recognition method, or <code>Fallback</code> to use it only when standard NLU
         *        confidence is low.
         * @see AssistedNluMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssistedNluMode
         */
        Builder assistedNluMode(AssistedNluMode assistedNluMode);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private String assistedNluMode;

        private BuilderImpl() {
        }

        private BuilderImpl(NluImprovementSpecification model) {
            enabled(model.enabled);
            assistedNluMode(model.assistedNluMode);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getAssistedNluMode() {
            return assistedNluMode;
        }

        public final void setAssistedNluMode(String assistedNluMode) {
            this.assistedNluMode = assistedNluMode;
        }

        @Override
        public final Builder assistedNluMode(String assistedNluMode) {
            this.assistedNluMode = assistedNluMode;
            return this;
        }

        @Override
        public final Builder assistedNluMode(AssistedNluMode assistedNluMode) {
            this.assistedNluMode(assistedNluMode == null ? null : assistedNluMode.toString());
            return this;
        }

        @Override
        public NluImprovementSpecification build() {
            return new NluImprovementSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
