/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Determines whether Amazon Lex obscures slot values in conversation logs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ObfuscationSetting implements SdkPojo, Serializable,
        ToCopyableBuilder<ObfuscationSetting.Builder, ObfuscationSetting> {
    private static final SdkField<String> OBFUSCATION_SETTING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("obfuscationSettingType").getter(getter(ObfuscationSetting::obfuscationSettingTypeAsString))
            .setter(setter(Builder::obfuscationSettingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("obfuscationSettingType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(OBFUSCATION_SETTING_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String obfuscationSettingType;

    private ObfuscationSetting(BuilderImpl builder) {
        this.obfuscationSettingType = builder.obfuscationSettingType;
    }

    /**
     * <p>
     * Value that determines whether Amazon Lex obscures slot values in conversation logs. The default is to obscure the
     * values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #obfuscationSettingType} will return {@link ObfuscationSettingType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #obfuscationSettingTypeAsString}.
     * </p>
     * 
     * @return Value that determines whether Amazon Lex obscures slot values in conversation logs. The default is to
     *         obscure the values.
     * @see ObfuscationSettingType
     */
    public final ObfuscationSettingType obfuscationSettingType() {
        return ObfuscationSettingType.fromValue(obfuscationSettingType);
    }

    /**
     * <p>
     * Value that determines whether Amazon Lex obscures slot values in conversation logs. The default is to obscure the
     * values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #obfuscationSettingType} will return {@link ObfuscationSettingType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #obfuscationSettingTypeAsString}.
     * </p>
     * 
     * @return Value that determines whether Amazon Lex obscures slot values in conversation logs. The default is to
     *         obscure the values.
     * @see ObfuscationSettingType
     */
    public final String obfuscationSettingTypeAsString() {
        return obfuscationSettingType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(obfuscationSettingTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObfuscationSetting)) {
            return false;
        }
        ObfuscationSetting other = (ObfuscationSetting) obj;
        return Objects.equals(obfuscationSettingTypeAsString(), other.obfuscationSettingTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ObfuscationSetting").add("ObfuscationSettingType", obfuscationSettingTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "obfuscationSettingType":
            return Optional.ofNullable(clazz.cast(obfuscationSettingTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("obfuscationSettingType", OBFUSCATION_SETTING_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ObfuscationSetting, T> g) {
        return obj -> g.apply((ObfuscationSetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ObfuscationSetting> {
        /**
         * <p>
         * Value that determines whether Amazon Lex obscures slot values in conversation logs. The default is to obscure
         * the values.
         * </p>
         * 
         * @param obfuscationSettingType
         *        Value that determines whether Amazon Lex obscures slot values in conversation logs. The default is to
         *        obscure the values.
         * @see ObfuscationSettingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObfuscationSettingType
         */
        Builder obfuscationSettingType(String obfuscationSettingType);

        /**
         * <p>
         * Value that determines whether Amazon Lex obscures slot values in conversation logs. The default is to obscure
         * the values.
         * </p>
         * 
         * @param obfuscationSettingType
         *        Value that determines whether Amazon Lex obscures slot values in conversation logs. The default is to
         *        obscure the values.
         * @see ObfuscationSettingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObfuscationSettingType
         */
        Builder obfuscationSettingType(ObfuscationSettingType obfuscationSettingType);
    }

    static final class BuilderImpl implements Builder {
        private String obfuscationSettingType;

        private BuilderImpl() {
        }

        private BuilderImpl(ObfuscationSetting model) {
            obfuscationSettingType(model.obfuscationSettingType);
        }

        public final String getObfuscationSettingType() {
            return obfuscationSettingType;
        }

        public final void setObfuscationSettingType(String obfuscationSettingType) {
            this.obfuscationSettingType = obfuscationSettingType;
        }

        @Override
        public final Builder obfuscationSettingType(String obfuscationSettingType) {
            this.obfuscationSettingType = obfuscationSettingType;
            return this;
        }

        @Override
        public final Builder obfuscationSettingType(ObfuscationSettingType obfuscationSettingType) {
            this.obfuscationSettingType(obfuscationSettingType == null ? null : obfuscationSettingType.toString());
            return this;
        }

        @Override
        public ObfuscationSetting build() {
            return new ObfuscationSetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
