/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the phrase that Amazon Lex should look for in the user's input to the bot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuntimeHintValue implements SdkPojo, Serializable,
        ToCopyableBuilder<RuntimeHintValue.Builder, RuntimeHintValue> {
    private static final SdkField<String> PHRASE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("phrase")
            .getter(getter(RuntimeHintValue::phrase)).setter(setter(Builder::phrase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("phrase").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHRASE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String phrase;

    private RuntimeHintValue(BuilderImpl builder) {
        this.phrase = builder.phrase;
    }

    /**
     * <p>
     * The phrase that Amazon Lex should look for in the user's input to the bot.
     * </p>
     * 
     * @return The phrase that Amazon Lex should look for in the user's input to the bot.
     */
    public final String phrase() {
        return phrase;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(phrase());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuntimeHintValue)) {
            return false;
        }
        RuntimeHintValue other = (RuntimeHintValue) obj;
        return Objects.equals(phrase(), other.phrase());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuntimeHintValue").add("Phrase", phrase()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "phrase":
            return Optional.ofNullable(clazz.cast(phrase()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("phrase", PHRASE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuntimeHintValue, T> g) {
        return obj -> g.apply((RuntimeHintValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuntimeHintValue> {
        /**
         * <p>
         * The phrase that Amazon Lex should look for in the user's input to the bot.
         * </p>
         * 
         * @param phrase
         *        The phrase that Amazon Lex should look for in the user's input to the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phrase(String phrase);
    }

    static final class BuilderImpl implements Builder {
        private String phrase;

        private BuilderImpl() {
        }

        private BuilderImpl(RuntimeHintValue model) {
            phrase(model.phrase);
        }

        public final String getPhrase() {
            return phrase;
        }

        public final void setPhrase(String phrase) {
            this.phrase = phrase;
        }

        @Override
        public final Builder phrase(String phrase) {
            this.phrase = phrase;
            return this;
        }

        @Override
        public RuntimeHintValue build() {
            return new RuntimeHintValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
