/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the success and failure rate of slot resolution in the results of a test execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SlotResolutionTestResultItem implements SdkPojo, Serializable,
        ToCopyableBuilder<SlotResolutionTestResultItem.Builder, SlotResolutionTestResultItem> {
    private static final SdkField<String> SLOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("slotName").getter(getter(SlotResolutionTestResultItem::slotName)).setter(setter(Builder::slotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotName").build()).build();

    private static final SdkField<SlotResolutionTestResultItemCounts> RESULT_COUNTS_FIELD = SdkField
            .<SlotResolutionTestResultItemCounts> builder(MarshallingType.SDK_POJO).memberName("resultCounts")
            .getter(getter(SlotResolutionTestResultItem::resultCounts)).setter(setter(Builder::resultCounts))
            .constructor(SlotResolutionTestResultItemCounts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resultCounts").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLOT_NAME_FIELD,
            RESULT_COUNTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String slotName;

    private final SlotResolutionTestResultItemCounts resultCounts;

    private SlotResolutionTestResultItem(BuilderImpl builder) {
        this.slotName = builder.slotName;
        this.resultCounts = builder.resultCounts;
    }

    /**
     * <p>
     * The name of the slot.
     * </p>
     * 
     * @return The name of the slot.
     */
    public final String slotName() {
        return slotName;
    }

    /**
     * <p>
     * A result for slot resolution in the results of a test execution.
     * </p>
     * 
     * @return A result for slot resolution in the results of a test execution.
     */
    public final SlotResolutionTestResultItemCounts resultCounts() {
        return resultCounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(slotName());
        hashCode = 31 * hashCode + Objects.hashCode(resultCounts());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlotResolutionTestResultItem)) {
            return false;
        }
        SlotResolutionTestResultItem other = (SlotResolutionTestResultItem) obj;
        return Objects.equals(slotName(), other.slotName()) && Objects.equals(resultCounts(), other.resultCounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SlotResolutionTestResultItem").add("SlotName", slotName()).add("ResultCounts", resultCounts())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "slotName":
            return Optional.ofNullable(clazz.cast(slotName()));
        case "resultCounts":
            return Optional.ofNullable(clazz.cast(resultCounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("slotName", SLOT_NAME_FIELD);
        map.put("resultCounts", RESULT_COUNTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SlotResolutionTestResultItem, T> g) {
        return obj -> g.apply((SlotResolutionTestResultItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SlotResolutionTestResultItem> {
        /**
         * <p>
         * The name of the slot.
         * </p>
         * 
         * @param slotName
         *        The name of the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotName(String slotName);

        /**
         * <p>
         * A result for slot resolution in the results of a test execution.
         * </p>
         * 
         * @param resultCounts
         *        A result for slot resolution in the results of a test execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultCounts(SlotResolutionTestResultItemCounts resultCounts);

        /**
         * <p>
         * A result for slot resolution in the results of a test execution.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SlotResolutionTestResultItemCounts.Builder} avoiding the need to create one manually via
         * {@link SlotResolutionTestResultItemCounts#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SlotResolutionTestResultItemCounts.Builder#build()} is called
         * immediately and its result is passed to {@link #resultCounts(SlotResolutionTestResultItemCounts)}.
         * 
         * @param resultCounts
         *        a consumer that will call methods on {@link SlotResolutionTestResultItemCounts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resultCounts(SlotResolutionTestResultItemCounts)
         */
        default Builder resultCounts(Consumer<SlotResolutionTestResultItemCounts.Builder> resultCounts) {
            return resultCounts(SlotResolutionTestResultItemCounts.builder().applyMutation(resultCounts).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String slotName;

        private SlotResolutionTestResultItemCounts resultCounts;

        private BuilderImpl() {
        }

        private BuilderImpl(SlotResolutionTestResultItem model) {
            slotName(model.slotName);
            resultCounts(model.resultCounts);
        }

        public final String getSlotName() {
            return slotName;
        }

        public final void setSlotName(String slotName) {
            this.slotName = slotName;
        }

        @Override
        public final Builder slotName(String slotName) {
            this.slotName = slotName;
            return this;
        }

        public final SlotResolutionTestResultItemCounts.Builder getResultCounts() {
            return resultCounts != null ? resultCounts.toBuilder() : null;
        }

        public final void setResultCounts(SlotResolutionTestResultItemCounts.BuilderImpl resultCounts) {
            this.resultCounts = resultCounts != null ? resultCounts.build() : null;
        }

        @Override
        public final Builder resultCounts(SlotResolutionTestResultItemCounts resultCounts) {
            this.resultCounts = resultCounts;
            return this;
        }

        @Override
        public SlotResolutionTestResultItem build() {
            return new SlotResolutionTestResultItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
