/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The value to set in a slot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SlotValue implements SdkPojo, Serializable, ToCopyableBuilder<SlotValue.Builder, SlotValue> {
    private static final SdkField<String> INTERPRETED_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("interpretedValue").getter(getter(SlotValue::interpretedValue)).setter(setter(Builder::interpretedValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interpretedValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERPRETED_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String interpretedValue;

    private SlotValue(BuilderImpl builder) {
        this.interpretedValue = builder.interpretedValue;
    }

    /**
     * <p>
     * The value that Amazon Lex determines for the slot. The actual value depends on the setting of the value selection
     * strategy for the bot. You can choose to use the value entered by the user, or you can have Amazon Lex choose the
     * first value in the <code>resolvedValues</code> list.
     * </p>
     * 
     * @return The value that Amazon Lex determines for the slot. The actual value depends on the setting of the value
     *         selection strategy for the bot. You can choose to use the value entered by the user, or you can have
     *         Amazon Lex choose the first value in the <code>resolvedValues</code> list.
     */
    public final String interpretedValue() {
        return interpretedValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(interpretedValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlotValue)) {
            return false;
        }
        SlotValue other = (SlotValue) obj;
        return Objects.equals(interpretedValue(), other.interpretedValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SlotValue").add("InterpretedValue", interpretedValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "interpretedValue":
            return Optional.ofNullable(clazz.cast(interpretedValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("interpretedValue", INTERPRETED_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SlotValue, T> g) {
        return obj -> g.apply((SlotValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SlotValue> {
        /**
         * <p>
         * The value that Amazon Lex determines for the slot. The actual value depends on the setting of the value
         * selection strategy for the bot. You can choose to use the value entered by the user, or you can have Amazon
         * Lex choose the first value in the <code>resolvedValues</code> list.
         * </p>
         * 
         * @param interpretedValue
         *        The value that Amazon Lex determines for the slot. The actual value depends on the setting of the
         *        value selection strategy for the bot. You can choose to use the value entered by the user, or you can
         *        have Amazon Lex choose the first value in the <code>resolvedValues</code> list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interpretedValue(String interpretedValue);
    }

    static final class BuilderImpl implements Builder {
        private String interpretedValue;

        private BuilderImpl() {
        }

        private BuilderImpl(SlotValue model) {
            interpretedValue(model.interpretedValue);
        }

        public final String getInterpretedValue() {
            return interpretedValue;
        }

        public final void setInterpretedValue(String interpretedValue) {
            this.interpretedValue = interpretedValue;
        }

        @Override
        public final Builder interpretedValue(String interpretedValue) {
            this.interpretedValue = interpretedValue;
            return this;
        }

        @Override
        public SlotValue build() {
            return new SlotValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
