/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the bot alias used for the test set discrepancy report.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestSetDiscrepancyReportBotAliasTarget implements SdkPojo, Serializable,
        ToCopyableBuilder<TestSetDiscrepancyReportBotAliasTarget.Builder, TestSetDiscrepancyReportBotAliasTarget> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(TestSetDiscrepancyReportBotAliasTarget::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<String> BOT_ALIAS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botAliasId").getter(getter(TestSetDiscrepancyReportBotAliasTarget::botAliasId))
            .setter(setter(Builder::botAliasId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAliasId").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(TestSetDiscrepancyReportBotAliasTarget::localeId))
            .setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            BOT_ALIAS_ID_FIELD, LOCALE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String botId;

    private final String botAliasId;

    private final String localeId;

    private TestSetDiscrepancyReportBotAliasTarget(BuilderImpl builder) {
        this.botId = builder.botId;
        this.botAliasId = builder.botAliasId;
        this.localeId = builder.localeId;
    }

    /**
     * <p>
     * The unique identifier for the bot alias.
     * </p>
     * 
     * @return The unique identifier for the bot alias.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The unique identifier for the bot associated with the bot alias.
     * </p>
     * 
     * @return The unique identifier for the bot associated with the bot alias.
     */
    public final String botAliasId() {
        return botAliasId;
    }

    /**
     * <p>
     * The unique identifier of the locale associated with the bot alias.
     * </p>
     * 
     * @return The unique identifier of the locale associated with the bot alias.
     */
    public final String localeId() {
        return localeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botAliasId());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestSetDiscrepancyReportBotAliasTarget)) {
            return false;
        }
        TestSetDiscrepancyReportBotAliasTarget other = (TestSetDiscrepancyReportBotAliasTarget) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botAliasId(), other.botAliasId())
                && Objects.equals(localeId(), other.localeId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestSetDiscrepancyReportBotAliasTarget").add("BotId", botId()).add("BotAliasId", botAliasId())
                .add("LocaleId", localeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botAliasId":
            return Optional.ofNullable(clazz.cast(botAliasId()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("botId", BOT_ID_FIELD);
        map.put("botAliasId", BOT_ALIAS_ID_FIELD);
        map.put("localeId", LOCALE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestSetDiscrepancyReportBotAliasTarget, T> g) {
        return obj -> g.apply((TestSetDiscrepancyReportBotAliasTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TestSetDiscrepancyReportBotAliasTarget> {
        /**
         * <p>
         * The unique identifier for the bot alias.
         * </p>
         * 
         * @param botId
         *        The unique identifier for the bot alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The unique identifier for the bot associated with the bot alias.
         * </p>
         * 
         * @param botAliasId
         *        The unique identifier for the bot associated with the bot alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAliasId(String botAliasId);

        /**
         * <p>
         * The unique identifier of the locale associated with the bot alias.
         * </p>
         * 
         * @param localeId
         *        The unique identifier of the locale associated with the bot alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);
    }

    static final class BuilderImpl implements Builder {
        private String botId;

        private String botAliasId;

        private String localeId;

        private BuilderImpl() {
        }

        private BuilderImpl(TestSetDiscrepancyReportBotAliasTarget model) {
            botId(model.botId);
            botAliasId(model.botAliasId);
            localeId(model.localeId);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotAliasId() {
            return botAliasId;
        }

        public final void setBotAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
        }

        @Override
        public final Builder botAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
            return this;
        }

        public final String getLocaleId() {
            return localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        @Override
        public TestSetDiscrepancyReportBotAliasTarget build() {
            return new TestSetDiscrepancyReportBotAliasTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
