/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateExportRequest extends LexModelsV2Request implements
        ToCopyableBuilder<UpdateExportRequest.Builder, UpdateExportRequest> {
    private static final SdkField<String> EXPORT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("exportId").getter(getter(UpdateExportRequest::exportId)).setter(setter(Builder::exportId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("exportId").build()).build();

    private static final SdkField<String> FILE_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filePassword").getter(getter(UpdateExportRequest::filePassword)).setter(setter(Builder::filePassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePassword").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_ID_FIELD,
            FILE_PASSWORD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String exportId;

    private final String filePassword;

    private UpdateExportRequest(BuilderImpl builder) {
        super(builder);
        this.exportId = builder.exportId;
        this.filePassword = builder.filePassword;
    }

    /**
     * <p>
     * The unique identifier Amazon Lex assigned to the export.
     * </p>
     * 
     * @return The unique identifier Amazon Lex assigned to the export.
     */
    public final String exportId() {
        return exportId;
    }

    /**
     * <p>
     * The new password to use to encrypt the export zip archive.
     * </p>
     * 
     * @return The new password to use to encrypt the export zip archive.
     */
    public final String filePassword() {
        return filePassword;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(exportId());
        hashCode = 31 * hashCode + Objects.hashCode(filePassword());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateExportRequest)) {
            return false;
        }
        UpdateExportRequest other = (UpdateExportRequest) obj;
        return Objects.equals(exportId(), other.exportId()) && Objects.equals(filePassword(), other.filePassword());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateExportRequest").add("ExportId", exportId())
                .add("FilePassword", filePassword() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "exportId":
            return Optional.ofNullable(clazz.cast(exportId()));
        case "filePassword":
            return Optional.ofNullable(clazz.cast(filePassword()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("exportId", EXPORT_ID_FIELD);
        map.put("filePassword", FILE_PASSWORD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateExportRequest, T> g) {
        return obj -> g.apply((UpdateExportRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LexModelsV2Request.Builder, SdkPojo, CopyableBuilder<Builder, UpdateExportRequest> {
        /**
         * <p>
         * The unique identifier Amazon Lex assigned to the export.
         * </p>
         * 
         * @param exportId
         *        The unique identifier Amazon Lex assigned to the export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportId(String exportId);

        /**
         * <p>
         * The new password to use to encrypt the export zip archive.
         * </p>
         * 
         * @param filePassword
         *        The new password to use to encrypt the export zip archive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filePassword(String filePassword);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelsV2Request.BuilderImpl implements Builder {
        private String exportId;

        private String filePassword;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateExportRequest model) {
            super(model);
            exportId(model.exportId);
            filePassword(model.filePassword);
        }

        public final String getExportId() {
            return exportId;
        }

        public final void setExportId(String exportId) {
            this.exportId = exportId;
        }

        @Override
        public final Builder exportId(String exportId) {
            this.exportId = exportId;
            return this;
        }

        public final String getFilePassword() {
            return filePassword;
        }

        public final void setFilePassword(String filePassword) {
            this.filePassword = filePassword;
        }

        @Override
        public final Builder filePassword(String filePassword) {
            this.filePassword = filePassword;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateExportRequest build() {
            return new UpdateExportRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
