/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntimev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The individual sentiment responses for the utterance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SentimentScore implements SdkPojo, Serializable, ToCopyableBuilder<SentimentScore.Builder, SentimentScore> {
    private static final SdkField<Double> POSITIVE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("positive").getter(getter(SentimentScore::positive)).setter(setter(Builder::positive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("positive").build()).build();

    private static final SdkField<Double> NEGATIVE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("negative").getter(getter(SentimentScore::negative)).setter(setter(Builder::negative))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("negative").build()).build();

    private static final SdkField<Double> NEUTRAL_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("neutral")
            .getter(getter(SentimentScore::neutral)).setter(setter(Builder::neutral))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("neutral").build()).build();

    private static final SdkField<Double> MIXED_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("mixed")
            .getter(getter(SentimentScore::mixed)).setter(setter(Builder::mixed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mixed").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POSITIVE_FIELD,
            NEGATIVE_FIELD, NEUTRAL_FIELD, MIXED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double positive;

    private final Double negative;

    private final Double neutral;

    private final Double mixed;

    private SentimentScore(BuilderImpl builder) {
        this.positive = builder.positive;
        this.negative = builder.negative;
        this.neutral = builder.neutral;
        this.mixed = builder.mixed;
    }

    /**
     * <p>
     * The level of confidence that Amazon Comprehend has in the accuracy of its detection of the <code>POSITIVE</code>
     * sentiment.
     * </p>
     * 
     * @return The level of confidence that Amazon Comprehend has in the accuracy of its detection of the
     *         <code>POSITIVE</code> sentiment.
     */
    public final Double positive() {
        return positive;
    }

    /**
     * <p>
     * The level of confidence that Amazon Comprehend has in the accuracy of its detection of the <code>NEGATIVE</code>
     * sentiment.
     * </p>
     * 
     * @return The level of confidence that Amazon Comprehend has in the accuracy of its detection of the
     *         <code>NEGATIVE</code> sentiment.
     */
    public final Double negative() {
        return negative;
    }

    /**
     * <p>
     * The level of confidence that Amazon Comprehend has in the accuracy of its detection of the <code>NEUTRAL</code>
     * sentiment.
     * </p>
     * 
     * @return The level of confidence that Amazon Comprehend has in the accuracy of its detection of the
     *         <code>NEUTRAL</code> sentiment.
     */
    public final Double neutral() {
        return neutral;
    }

    /**
     * <p>
     * The level of confidence that Amazon Comprehend has in the accuracy of its detection of the <code>MIXED</code>
     * sentiment.
     * </p>
     * 
     * @return The level of confidence that Amazon Comprehend has in the accuracy of its detection of the
     *         <code>MIXED</code> sentiment.
     */
    public final Double mixed() {
        return mixed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(positive());
        hashCode = 31 * hashCode + Objects.hashCode(negative());
        hashCode = 31 * hashCode + Objects.hashCode(neutral());
        hashCode = 31 * hashCode + Objects.hashCode(mixed());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SentimentScore)) {
            return false;
        }
        SentimentScore other = (SentimentScore) obj;
        return Objects.equals(positive(), other.positive()) && Objects.equals(negative(), other.negative())
                && Objects.equals(neutral(), other.neutral()) && Objects.equals(mixed(), other.mixed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SentimentScore").add("Positive", positive()).add("Negative", negative())
                .add("Neutral", neutral()).add("Mixed", mixed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "positive":
            return Optional.ofNullable(clazz.cast(positive()));
        case "negative":
            return Optional.ofNullable(clazz.cast(negative()));
        case "neutral":
            return Optional.ofNullable(clazz.cast(neutral()));
        case "mixed":
            return Optional.ofNullable(clazz.cast(mixed()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SentimentScore, T> g) {
        return obj -> g.apply((SentimentScore) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SentimentScore> {
        /**
         * <p>
         * The level of confidence that Amazon Comprehend has in the accuracy of its detection of the
         * <code>POSITIVE</code> sentiment.
         * </p>
         * 
         * @param positive
         *        The level of confidence that Amazon Comprehend has in the accuracy of its detection of the
         *        <code>POSITIVE</code> sentiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder positive(Double positive);

        /**
         * <p>
         * The level of confidence that Amazon Comprehend has in the accuracy of its detection of the
         * <code>NEGATIVE</code> sentiment.
         * </p>
         * 
         * @param negative
         *        The level of confidence that Amazon Comprehend has in the accuracy of its detection of the
         *        <code>NEGATIVE</code> sentiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder negative(Double negative);

        /**
         * <p>
         * The level of confidence that Amazon Comprehend has in the accuracy of its detection of the
         * <code>NEUTRAL</code> sentiment.
         * </p>
         * 
         * @param neutral
         *        The level of confidence that Amazon Comprehend has in the accuracy of its detection of the
         *        <code>NEUTRAL</code> sentiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder neutral(Double neutral);

        /**
         * <p>
         * The level of confidence that Amazon Comprehend has in the accuracy of its detection of the <code>MIXED</code>
         * sentiment.
         * </p>
         * 
         * @param mixed
         *        The level of confidence that Amazon Comprehend has in the accuracy of its detection of the
         *        <code>MIXED</code> sentiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mixed(Double mixed);
    }

    static final class BuilderImpl implements Builder {
        private Double positive;

        private Double negative;

        private Double neutral;

        private Double mixed;

        private BuilderImpl() {
        }

        private BuilderImpl(SentimentScore model) {
            positive(model.positive);
            negative(model.negative);
            neutral(model.neutral);
            mixed(model.mixed);
        }

        public final Double getPositive() {
            return positive;
        }

        @Override
        public final Builder positive(Double positive) {
            this.positive = positive;
            return this;
        }

        public final void setPositive(Double positive) {
            this.positive = positive;
        }

        public final Double getNegative() {
            return negative;
        }

        @Override
        public final Builder negative(Double negative) {
            this.negative = negative;
            return this;
        }

        public final void setNegative(Double negative) {
            this.negative = negative;
        }

        public final Double getNeutral() {
            return neutral;
        }

        @Override
        public final Builder neutral(Double neutral) {
            this.neutral = neutral;
            return this;
        }

        public final void setNeutral(Double neutral) {
            this.neutral = neutral;
        }

        public final Double getMixed() {
            return mixed;
        }

        @Override
        public final Builder mixed(Double mixed) {
            this.mixed = mixed;
            return this;
        }

        public final void setMixed(Double mixed) {
            this.mixed = mixed;
        }

        @Override
        public SentimentScore build() {
            return new SentimentScore(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
