/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntimev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecognizeTextRequest extends LexRuntimeV2Request implements
        ToCopyableBuilder<RecognizeTextRequest.Builder, RecognizeTextRequest> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(RecognizeTextRequest::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()).build();

    private static final SdkField<String> BOT_ALIAS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botAliasId").getter(getter(RecognizeTextRequest::botAliasId)).setter(setter(Builder::botAliasId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botAliasId").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(RecognizeTextRequest::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("localeId").build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(RecognizeTextRequest::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("sessionId").build()).build();

    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("text")
            .getter(getter(RecognizeTextRequest::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()).build();

    private static final SdkField<SessionState> SESSION_STATE_FIELD = SdkField.<SessionState> builder(MarshallingType.SDK_POJO)
            .memberName("sessionState").getter(getter(RecognizeTextRequest::sessionState)).setter(setter(Builder::sessionState))
            .constructor(SessionState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionState").build()).build();

    private static final SdkField<Map<String, String>> REQUEST_ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("requestAttributes")
            .getter(getter(RecognizeTextRequest::requestAttributes))
            .setter(setter(Builder::requestAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            BOT_ALIAS_ID_FIELD, LOCALE_ID_FIELD, SESSION_ID_FIELD, TEXT_FIELD, SESSION_STATE_FIELD, REQUEST_ATTRIBUTES_FIELD));

    private final String botId;

    private final String botAliasId;

    private final String localeId;

    private final String sessionId;

    private final String text;

    private final SessionState sessionState;

    private final Map<String, String> requestAttributes;

    private RecognizeTextRequest(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botAliasId = builder.botAliasId;
        this.localeId = builder.localeId;
        this.sessionId = builder.sessionId;
        this.text = builder.text;
        this.sessionState = builder.sessionState;
        this.requestAttributes = builder.requestAttributes;
    }

    /**
     * <p>
     * The identifier of the bot that processes the request.
     * </p>
     * 
     * @return The identifier of the bot that processes the request.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The alias identifier in use for the bot that processes the request.
     * </p>
     * 
     * @return The alias identifier in use for the bot that processes the request.
     */
    public final String botAliasId() {
        return botAliasId;
    }

    /**
     * <p>
     * The locale where the session is in use.
     * </p>
     * 
     * @return The locale where the session is in use.
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * <p>
     * The identifier of the user session that is having the conversation.
     * </p>
     * 
     * @return The identifier of the user session that is having the conversation.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The text that the user entered. Amazon Lex V2 interprets this text.
     * </p>
     * 
     * @return The text that the user entered. Amazon Lex V2 interprets this text.
     */
    public final String text() {
        return text;
    }

    /**
     * <p>
     * The current state of the dialog between the user and the bot.
     * </p>
     * 
     * @return The current state of the dialog between the user and the bot.
     */
    public final SessionState sessionState() {
        return sessionState;
    }

    /**
     * For responses, this returns true if the service returned a value for the RequestAttributes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRequestAttributes() {
        return requestAttributes != null && !(requestAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Request-specific information passed between the client application and Amazon Lex V2
     * </p>
     * <p>
     * The namespace <code>x-amz-lex:</code> is reserved for special attributes. Don't create any request attributes
     * with the prefix <code>x-amz-lex:</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRequestAttributes} method.
     * </p>
     * 
     * @return Request-specific information passed between the client application and Amazon Lex V2 </p>
     *         <p>
     *         The namespace <code>x-amz-lex:</code> is reserved for special attributes. Don't create any request
     *         attributes with the prefix <code>x-amz-lex:</code>.
     */
    public final Map<String, String> requestAttributes() {
        return requestAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botAliasId());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(sessionState());
        hashCode = 31 * hashCode + Objects.hashCode(hasRequestAttributes() ? requestAttributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecognizeTextRequest)) {
            return false;
        }
        RecognizeTextRequest other = (RecognizeTextRequest) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botAliasId(), other.botAliasId())
                && Objects.equals(localeId(), other.localeId()) && Objects.equals(sessionId(), other.sessionId())
                && Objects.equals(text(), other.text()) && Objects.equals(sessionState(), other.sessionState())
                && hasRequestAttributes() == other.hasRequestAttributes()
                && Objects.equals(requestAttributes(), other.requestAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecognizeTextRequest").add("BotId", botId()).add("BotAliasId", botAliasId())
                .add("LocaleId", localeId()).add("SessionId", sessionId())
                .add("Text", text() == null ? null : "*** Sensitive Data Redacted ***").add("SessionState", sessionState())
                .add("RequestAttributes", hasRequestAttributes() ? requestAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botAliasId":
            return Optional.ofNullable(clazz.cast(botAliasId()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "text":
            return Optional.ofNullable(clazz.cast(text()));
        case "sessionState":
            return Optional.ofNullable(clazz.cast(sessionState()));
        case "requestAttributes":
            return Optional.ofNullable(clazz.cast(requestAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecognizeTextRequest, T> g) {
        return obj -> g.apply((RecognizeTextRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexRuntimeV2Request.Builder, SdkPojo, CopyableBuilder<Builder, RecognizeTextRequest> {
        /**
         * <p>
         * The identifier of the bot that processes the request.
         * </p>
         * 
         * @param botId
         *        The identifier of the bot that processes the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The alias identifier in use for the bot that processes the request.
         * </p>
         * 
         * @param botAliasId
         *        The alias identifier in use for the bot that processes the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAliasId(String botAliasId);

        /**
         * <p>
         * The locale where the session is in use.
         * </p>
         * 
         * @param localeId
         *        The locale where the session is in use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * The identifier of the user session that is having the conversation.
         * </p>
         * 
         * @param sessionId
         *        The identifier of the user session that is having the conversation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The text that the user entered. Amazon Lex V2 interprets this text.
         * </p>
         * 
         * @param text
         *        The text that the user entered. Amazon Lex V2 interprets this text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * <p>
         * The current state of the dialog between the user and the bot.
         * </p>
         * 
         * @param sessionState
         *        The current state of the dialog between the user and the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionState(SessionState sessionState);

        /**
         * <p>
         * The current state of the dialog between the user and the bot.
         * </p>
         * This is a convenience method that creates an instance of the {@link SessionState.Builder} avoiding the need
         * to create one manually via {@link SessionState#builder()}.
         *
         * When the {@link Consumer} completes, {@link SessionState.Builder#build()} is called immediately and its
         * result is passed to {@link #sessionState(SessionState)}.
         * 
         * @param sessionState
         *        a consumer that will call methods on {@link SessionState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sessionState(SessionState)
         */
        default Builder sessionState(Consumer<SessionState.Builder> sessionState) {
            return sessionState(SessionState.builder().applyMutation(sessionState).build());
        }

        /**
         * <p>
         * Request-specific information passed between the client application and Amazon Lex V2
         * </p>
         * <p>
         * The namespace <code>x-amz-lex:</code> is reserved for special attributes. Don't create any request attributes
         * with the prefix <code>x-amz-lex:</code>.
         * </p>
         * 
         * @param requestAttributes
         *        Request-specific information passed between the client application and Amazon Lex V2 </p>
         *        <p>
         *        The namespace <code>x-amz-lex:</code> is reserved for special attributes. Don't create any request
         *        attributes with the prefix <code>x-amz-lex:</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestAttributes(Map<String, String> requestAttributes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexRuntimeV2Request.BuilderImpl implements Builder {
        private String botId;

        private String botAliasId;

        private String localeId;

        private String sessionId;

        private String text;

        private SessionState sessionState;

        private Map<String, String> requestAttributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RecognizeTextRequest model) {
            super(model);
            botId(model.botId);
            botAliasId(model.botAliasId);
            localeId(model.localeId);
            sessionId(model.sessionId);
            text(model.text);
            sessionState(model.sessionState);
            requestAttributes(model.requestAttributes);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotAliasId() {
            return botAliasId;
        }

        public final void setBotAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
        }

        @Override
        public final Builder botAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
            return this;
        }

        public final String getLocaleId() {
            return localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final SessionState.Builder getSessionState() {
            return sessionState != null ? sessionState.toBuilder() : null;
        }

        public final void setSessionState(SessionState.BuilderImpl sessionState) {
            this.sessionState = sessionState != null ? sessionState.build() : null;
        }

        @Override
        public final Builder sessionState(SessionState sessionState) {
            this.sessionState = sessionState;
            return this;
        }

        public final Map<String, String> getRequestAttributes() {
            if (requestAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return requestAttributes;
        }

        public final void setRequestAttributes(Map<String, String> requestAttributes) {
            this.requestAttributes = StringMapCopier.copy(requestAttributes);
        }

        @Override
        public final Builder requestAttributes(Map<String, String> requestAttributes) {
            this.requestAttributes = StringMapCopier.copy(requestAttributes);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RecognizeTextRequest build() {
            return new RecognizeTextRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
