/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntimev2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The next action that Amazon Lex V2 should take.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DialogAction implements SdkPojo, Serializable, ToCopyableBuilder<DialogAction.Builder, DialogAction> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(DialogAction::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> SLOT_TO_ELICIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("slotToElicit").getter(getter(DialogAction::slotToElicit)).setter(setter(Builder::slotToElicit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotToElicit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            SLOT_TO_ELICIT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String slotToElicit;

    private DialogAction(BuilderImpl builder) {
        this.type = builder.type;
        this.slotToElicit = builder.slotToElicit;
    }

    /**
     * <p>
     * The next action that the bot should take in its interaction with the user. The possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Close</code> - Indicates that there will not be a response from the user. For example, the statement
     * "Your order has been placed" does not require a response.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ConfirmIntent</code> - The next action is asking the user if the intent is complete and ready to be
     * fulfilled. This is a yes/no question such as "Place the order?"
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Delegate</code> - The next action is determined by Amazon Lex V2.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ElicitSlot</code> - The next action is to elicit a slot value from the user.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DialogActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The next action that the bot should take in its interaction with the user. The possible values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Close</code> - Indicates that there will not be a response from the user. For example, the
     *         statement "Your order has been placed" does not require a response.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ConfirmIntent</code> - The next action is asking the user if the intent is complete and ready to be
     *         fulfilled. This is a yes/no question such as "Place the order?"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Delegate</code> - The next action is determined by Amazon Lex V2.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ElicitSlot</code> - The next action is to elicit a slot value from the user.
     *         </p>
     *         </li>
     * @see DialogActionType
     */
    public final DialogActionType type() {
        return DialogActionType.fromValue(type);
    }

    /**
     * <p>
     * The next action that the bot should take in its interaction with the user. The possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Close</code> - Indicates that there will not be a response from the user. For example, the statement
     * "Your order has been placed" does not require a response.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ConfirmIntent</code> - The next action is asking the user if the intent is complete and ready to be
     * fulfilled. This is a yes/no question such as "Place the order?"
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Delegate</code> - The next action is determined by Amazon Lex V2.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ElicitSlot</code> - The next action is to elicit a slot value from the user.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DialogActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The next action that the bot should take in its interaction with the user. The possible values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Close</code> - Indicates that there will not be a response from the user. For example, the
     *         statement "Your order has been placed" does not require a response.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ConfirmIntent</code> - The next action is asking the user if the intent is complete and ready to be
     *         fulfilled. This is a yes/no question such as "Place the order?"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Delegate</code> - The next action is determined by Amazon Lex V2.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ElicitSlot</code> - The next action is to elicit a slot value from the user.
     *         </p>
     *         </li>
     * @see DialogActionType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The name of the slot that should be elicited from the user.
     * </p>
     * 
     * @return The name of the slot that should be elicited from the user.
     */
    public final String slotToElicit() {
        return slotToElicit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(slotToElicit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DialogAction)) {
            return false;
        }
        DialogAction other = (DialogAction) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(slotToElicit(), other.slotToElicit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DialogAction").add("Type", typeAsString()).add("SlotToElicit", slotToElicit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "slotToElicit":
            return Optional.ofNullable(clazz.cast(slotToElicit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DialogAction, T> g) {
        return obj -> g.apply((DialogAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DialogAction> {
        /**
         * <p>
         * The next action that the bot should take in its interaction with the user. The possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Close</code> - Indicates that there will not be a response from the user. For example, the statement
         * "Your order has been placed" does not require a response.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ConfirmIntent</code> - The next action is asking the user if the intent is complete and ready to be
         * fulfilled. This is a yes/no question such as "Place the order?"
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Delegate</code> - The next action is determined by Amazon Lex V2.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ElicitSlot</code> - The next action is to elicit a slot value from the user.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The next action that the bot should take in its interaction with the user. The possible values
         *        are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Close</code> - Indicates that there will not be a response from the user. For example, the
         *        statement "Your order has been placed" does not require a response.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ConfirmIntent</code> - The next action is asking the user if the intent is complete and ready to
         *        be fulfilled. This is a yes/no question such as "Place the order?"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Delegate</code> - The next action is determined by Amazon Lex V2.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ElicitSlot</code> - The next action is to elicit a slot value from the user.
         *        </p>
         *        </li>
         * @see DialogActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DialogActionType
         */
        Builder type(String type);

        /**
         * <p>
         * The next action that the bot should take in its interaction with the user. The possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Close</code> - Indicates that there will not be a response from the user. For example, the statement
         * "Your order has been placed" does not require a response.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ConfirmIntent</code> - The next action is asking the user if the intent is complete and ready to be
         * fulfilled. This is a yes/no question such as "Place the order?"
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Delegate</code> - The next action is determined by Amazon Lex V2.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ElicitSlot</code> - The next action is to elicit a slot value from the user.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The next action that the bot should take in its interaction with the user. The possible values
         *        are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Close</code> - Indicates that there will not be a response from the user. For example, the
         *        statement "Your order has been placed" does not require a response.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ConfirmIntent</code> - The next action is asking the user if the intent is complete and ready to
         *        be fulfilled. This is a yes/no question such as "Place the order?"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Delegate</code> - The next action is determined by Amazon Lex V2.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ElicitSlot</code> - The next action is to elicit a slot value from the user.
         *        </p>
         *        </li>
         * @see DialogActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DialogActionType
         */
        Builder type(DialogActionType type);

        /**
         * <p>
         * The name of the slot that should be elicited from the user.
         * </p>
         * 
         * @param slotToElicit
         *        The name of the slot that should be elicited from the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotToElicit(String slotToElicit);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String slotToElicit;

        private BuilderImpl() {
        }

        private BuilderImpl(DialogAction model) {
            type(model.type);
            slotToElicit(model.slotToElicit);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(DialogActionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getSlotToElicit() {
            return slotToElicit;
        }

        public final void setSlotToElicit(String slotToElicit) {
            this.slotToElicit = slotToElicit;
        }

        @Override
        @Transient
        public final Builder slotToElicit(String slotToElicit) {
            this.slotToElicit = slotToElicit;
            return this;
        }

        @Override
        public DialogAction build() {
            return new DialogAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
