/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntimev2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Event sent from Amazon Lex V2 to your client application that contains a transcript of voice audio.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TranscriptEvent implements SdkPojo, Serializable, ToCopyableBuilder<TranscriptEvent.Builder, TranscriptEvent>,
        StartConversationResponseEventStream {
    private static final SdkField<String> TRANSCRIPT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("transcript").getter(getter(TranscriptEvent::transcript)).setter(setter(Builder::transcript))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transcript").build()).build();

    private static final SdkField<String> EVENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventId").getter(getter(TranscriptEvent::eventId)).setter(setter(Builder::eventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSCRIPT_FIELD,
            EVENT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String transcript;

    private final String eventId;

    protected TranscriptEvent(BuilderImpl builder) {
        this.transcript = builder.transcript;
        this.eventId = builder.eventId;
    }

    /**
     * <p>
     * The transcript of the voice audio from the user.
     * </p>
     * 
     * @return The transcript of the voice audio from the user.
     */
    public final String transcript() {
        return transcript;
    }

    /**
     * <p>
     * A unique identifier of the event sent by Amazon Lex V2. The identifier is in the form <code>RESPONSE-N</code>,
     * where N is a number starting with one and incremented for each event sent by Amazon Lex V2 in the current
     * session.
     * </p>
     * 
     * @return A unique identifier of the event sent by Amazon Lex V2. The identifier is in the form
     *         <code>RESPONSE-N</code>, where N is a number starting with one and incremented for each event sent by
     *         Amazon Lex V2 in the current session.
     */
    public final String eventId() {
        return eventId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transcript());
        hashCode = 31 * hashCode + Objects.hashCode(eventId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TranscriptEvent)) {
            return false;
        }
        TranscriptEvent other = (TranscriptEvent) obj;
        return Objects.equals(transcript(), other.transcript()) && Objects.equals(eventId(), other.eventId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TranscriptEvent").add("Transcript", transcript()).add("EventId", eventId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "transcript":
            return Optional.ofNullable(clazz.cast(transcript()));
        case "eventId":
            return Optional.ofNullable(clazz.cast(eventId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final TranscriptEvent copy(Consumer<? super Builder> modifier) {
        return ToCopyableBuilder.super.copy(modifier);
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TranscriptEvent, T> g) {
        return obj -> g.apply((TranscriptEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    /**
     * Calls the appropriate visit method depending on the subtype of {@link TranscriptEvent}.
     *
     * @param visitor
     *        Visitor to invoke.
     */
    @Override
    public void accept(StartConversationResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TranscriptEvent> {
        /**
         * <p>
         * The transcript of the voice audio from the user.
         * </p>
         * 
         * @param transcript
         *        The transcript of the voice audio from the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transcript(String transcript);

        /**
         * <p>
         * A unique identifier of the event sent by Amazon Lex V2. The identifier is in the form <code>RESPONSE-N</code>
         * , where N is a number starting with one and incremented for each event sent by Amazon Lex V2 in the current
         * session.
         * </p>
         * 
         * @param eventId
         *        A unique identifier of the event sent by Amazon Lex V2. The identifier is in the form
         *        <code>RESPONSE-N</code>, where N is a number starting with one and incremented for each event sent by
         *        Amazon Lex V2 in the current session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);
    }

    protected static class BuilderImpl implements Builder {
        private String transcript;

        private String eventId;

        protected BuilderImpl() {
        }

        protected BuilderImpl(TranscriptEvent model) {
            transcript(model.transcript);
            eventId(model.eventId);
        }

        public final String getTranscript() {
            return transcript;
        }

        public final void setTranscript(String transcript) {
            this.transcript = transcript;
        }

        @Override
        @Transient
        public final Builder transcript(String transcript) {
            this.transcript = transcript;
            return this;
        }

        public final String getEventId() {
            return eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        @Transient
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        @Override
        public TranscriptEvent build() {
            return new TranscriptEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
