/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntimev2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecognizeUtteranceResponse extends LexRuntimeV2Response implements
        ToCopyableBuilder<RecognizeUtteranceResponse.Builder, RecognizeUtteranceResponse> {
    private static final SdkField<String> INPUT_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputMode").getter(getter(RecognizeUtteranceResponse::inputMode)).setter(setter(Builder::inputMode))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-input-mode").build())
            .build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentType").getter(getter(RecognizeUtteranceResponse::contentType))
            .setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()).build();

    private static final SdkField<String> MESSAGES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("messages").getter(getter(RecognizeUtteranceResponse::messages)).setter(setter(Builder::messages))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-messages").build()).build();

    private static final SdkField<String> INTERPRETATIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("interpretations").getter(getter(RecognizeUtteranceResponse::interpretations))
            .setter(setter(Builder::interpretations))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-interpretations").build())
            .build();

    private static final SdkField<String> SESSION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionState").getter(getter(RecognizeUtteranceResponse::sessionState))
            .setter(setter(Builder::sessionState))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-session-state").build())
            .build();

    private static final SdkField<String> REQUEST_ATTRIBUTES_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("requestAttributes")
            .getter(getter(RecognizeUtteranceResponse::requestAttributes))
            .setter(setter(Builder::requestAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-request-attributes")
                    .build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(RecognizeUtteranceResponse::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-session-id").build())
            .build();

    private static final SdkField<String> INPUT_TRANSCRIPT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputTranscript").getter(getter(RecognizeUtteranceResponse::inputTranscript))
            .setter(setter(Builder::inputTranscript))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-input-transcript").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_MODE_FIELD,
            CONTENT_TYPE_FIELD, MESSAGES_FIELD, INTERPRETATIONS_FIELD, SESSION_STATE_FIELD, REQUEST_ATTRIBUTES_FIELD,
            SESSION_ID_FIELD, INPUT_TRANSCRIPT_FIELD));

    private final String inputMode;

    private final String contentType;

    private final String messages;

    private final String interpretations;

    private final String sessionState;

    private final String requestAttributes;

    private final String sessionId;

    private final String inputTranscript;

    private RecognizeUtteranceResponse(BuilderImpl builder) {
        super(builder);
        this.inputMode = builder.inputMode;
        this.contentType = builder.contentType;
        this.messages = builder.messages;
        this.interpretations = builder.interpretations;
        this.sessionState = builder.sessionState;
        this.requestAttributes = builder.requestAttributes;
        this.sessionId = builder.sessionId;
        this.inputTranscript = builder.inputTranscript;
    }

    /**
     * <p>
     * Indicates whether the input mode to the operation was text or speech.
     * </p>
     * 
     * @return Indicates whether the input mode to the operation was text or speech.
     */
    public final String inputMode() {
        return inputMode;
    }

    /**
     * <p>
     * Content type as specified in the <code>responseContentType</code> in the request.
     * </p>
     * 
     * @return Content type as specified in the <code>responseContentType</code> in the request.
     */
    public final String contentType() {
        return contentType;
    }

    /**
     * <p>
     * A list of messages that were last sent to the user. The messages are ordered based on the order that you returned
     * the messages from your Lambda function or the order that the messages are defined in the bot.
     * </p>
     * <p>
     * The <code>messages</code> field is compressed with gzip and then base64 encoded. Before you can use the contents
     * of the field, you must decode and decompress the contents. See the example for a simple function to decode and
     * decompress the contents.
     * </p>
     * 
     * @return A list of messages that were last sent to the user. The messages are ordered based on the order that you
     *         returned the messages from your Lambda function or the order that the messages are defined in the
     *         bot.</p>
     *         <p>
     *         The <code>messages</code> field is compressed with gzip and then base64 encoded. Before you can use the
     *         contents of the field, you must decode and decompress the contents. See the example for a simple function
     *         to decode and decompress the contents.
     */
    public final String messages() {
        return messages;
    }

    /**
     * <p>
     * A list of intents that Amazon Lex V2 determined might satisfy the user's utterance.
     * </p>
     * <p>
     * Each interpretation includes the intent, a score that indicates how confident Amazon Lex V2 is that the
     * interpretation is the correct one, and an optional sentiment response that indicates the sentiment expressed in
     * the utterance.
     * </p>
     * <p>
     * The <code>interpretations</code> field is compressed with gzip and then base64 encoded. Before you can use the
     * contents of the field, you must decode and decompress the contents. See the example for a simple function to
     * decode and decompress the contents.
     * </p>
     * 
     * @return A list of intents that Amazon Lex V2 determined might satisfy the user's utterance.</p>
     *         <p>
     *         Each interpretation includes the intent, a score that indicates how confident Amazon Lex V2 is that the
     *         interpretation is the correct one, and an optional sentiment response that indicates the sentiment
     *         expressed in the utterance.
     *         </p>
     *         <p>
     *         The <code>interpretations</code> field is compressed with gzip and then base64 encoded. Before you can
     *         use the contents of the field, you must decode and decompress the contents. See the example for a simple
     *         function to decode and decompress the contents.
     */
    public final String interpretations() {
        return interpretations;
    }

    /**
     * <p>
     * Represents the current state of the dialog between the user and the bot.
     * </p>
     * <p>
     * Use this to determine the progress of the conversation and what the next action might be.
     * </p>
     * <p>
     * The <code>sessionState</code> field is compressed with gzip and then base64 encoded. Before you can use the
     * contents of the field, you must decode and decompress the contents. See the example for a simple function to
     * decode and decompress the contents.
     * </p>
     * 
     * @return Represents the current state of the dialog between the user and the bot.</p>
     *         <p>
     *         Use this to determine the progress of the conversation and what the next action might be.
     *         </p>
     *         <p>
     *         The <code>sessionState</code> field is compressed with gzip and then base64 encoded. Before you can use
     *         the contents of the field, you must decode and decompress the contents. See the example for a simple
     *         function to decode and decompress the contents.
     */
    public final String sessionState() {
        return sessionState;
    }

    /**
     * <p>
     * The attributes sent in the request.
     * </p>
     * <p>
     * The <code>requestAttributes</code> field is compressed with gzip and then base64 encoded. Before you can use the
     * contents of the field, you must decode and decompress the contents.
     * </p>
     * 
     * @return The attributes sent in the request.</p>
     *         <p>
     *         The <code>requestAttributes</code> field is compressed with gzip and then base64 encoded. Before you can
     *         use the contents of the field, you must decode and decompress the contents.
     */
    public final String requestAttributes() {
        return requestAttributes;
    }

    /**
     * <p>
     * The identifier of the session in use.
     * </p>
     * 
     * @return The identifier of the session in use.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The text used to process the request.
     * </p>
     * <p>
     * If the input was an audio stream, the <code>inputTranscript</code> field contains the text extracted from the
     * audio stream. This is the text that is actually processed to recognize intents and slot values. You can use this
     * information to determine if Amazon Lex V2 is correctly processing the audio that you send.
     * </p>
     * <p>
     * The <code>inputTranscript</code> field is compressed with gzip and then base64 encoded. Before you can use the
     * contents of the field, you must decode and decompress the contents. See the example for a simple function to
     * decode and decompress the contents.
     * </p>
     * 
     * @return The text used to process the request.</p>
     *         <p>
     *         If the input was an audio stream, the <code>inputTranscript</code> field contains the text extracted from
     *         the audio stream. This is the text that is actually processed to recognize intents and slot values. You
     *         can use this information to determine if Amazon Lex V2 is correctly processing the audio that you send.
     *         </p>
     *         <p>
     *         The <code>inputTranscript</code> field is compressed with gzip and then base64 encoded. Before you can
     *         use the contents of the field, you must decode and decompress the contents. See the example for a simple
     *         function to decode and decompress the contents.
     */
    public final String inputTranscript() {
        return inputTranscript;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(inputMode());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(messages());
        hashCode = 31 * hashCode + Objects.hashCode(interpretations());
        hashCode = 31 * hashCode + Objects.hashCode(sessionState());
        hashCode = 31 * hashCode + Objects.hashCode(requestAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(inputTranscript());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecognizeUtteranceResponse)) {
            return false;
        }
        RecognizeUtteranceResponse other = (RecognizeUtteranceResponse) obj;
        return Objects.equals(inputMode(), other.inputMode()) && Objects.equals(contentType(), other.contentType())
                && Objects.equals(messages(), other.messages()) && Objects.equals(interpretations(), other.interpretations())
                && Objects.equals(sessionState(), other.sessionState())
                && Objects.equals(requestAttributes(), other.requestAttributes())
                && Objects.equals(sessionId(), other.sessionId()) && Objects.equals(inputTranscript(), other.inputTranscript());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecognizeUtteranceResponse").add("InputMode", inputMode()).add("ContentType", contentType())
                .add("Messages", messages()).add("Interpretations", interpretations()).add("SessionState", sessionState())
                .add("RequestAttributes", requestAttributes()).add("SessionId", sessionId())
                .add("InputTranscript", inputTranscript()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inputMode":
            return Optional.ofNullable(clazz.cast(inputMode()));
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "messages":
            return Optional.ofNullable(clazz.cast(messages()));
        case "interpretations":
            return Optional.ofNullable(clazz.cast(interpretations()));
        case "sessionState":
            return Optional.ofNullable(clazz.cast(sessionState()));
        case "requestAttributes":
            return Optional.ofNullable(clazz.cast(requestAttributes()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "inputTranscript":
            return Optional.ofNullable(clazz.cast(inputTranscript()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecognizeUtteranceResponse, T> g) {
        return obj -> g.apply((RecognizeUtteranceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexRuntimeV2Response.Builder, SdkPojo, CopyableBuilder<Builder, RecognizeUtteranceResponse> {
        /**
         * <p>
         * Indicates whether the input mode to the operation was text or speech.
         * </p>
         * 
         * @param inputMode
         *        Indicates whether the input mode to the operation was text or speech.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputMode(String inputMode);

        /**
         * <p>
         * Content type as specified in the <code>responseContentType</code> in the request.
         * </p>
         * 
         * @param contentType
         *        Content type as specified in the <code>responseContentType</code> in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * A list of messages that were last sent to the user. The messages are ordered based on the order that you
         * returned the messages from your Lambda function or the order that the messages are defined in the bot.
         * </p>
         * <p>
         * The <code>messages</code> field is compressed with gzip and then base64 encoded. Before you can use the
         * contents of the field, you must decode and decompress the contents. See the example for a simple function to
         * decode and decompress the contents.
         * </p>
         * 
         * @param messages
         *        A list of messages that were last sent to the user. The messages are ordered based on the order that
         *        you returned the messages from your Lambda function or the order that the messages are defined in the
         *        bot.</p>
         *        <p>
         *        The <code>messages</code> field is compressed with gzip and then base64 encoded. Before you can use
         *        the contents of the field, you must decode and decompress the contents. See the example for a simple
         *        function to decode and decompress the contents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(String messages);

        /**
         * <p>
         * A list of intents that Amazon Lex V2 determined might satisfy the user's utterance.
         * </p>
         * <p>
         * Each interpretation includes the intent, a score that indicates how confident Amazon Lex V2 is that the
         * interpretation is the correct one, and an optional sentiment response that indicates the sentiment expressed
         * in the utterance.
         * </p>
         * <p>
         * The <code>interpretations</code> field is compressed with gzip and then base64 encoded. Before you can use
         * the contents of the field, you must decode and decompress the contents. See the example for a simple function
         * to decode and decompress the contents.
         * </p>
         * 
         * @param interpretations
         *        A list of intents that Amazon Lex V2 determined might satisfy the user's utterance.</p>
         *        <p>
         *        Each interpretation includes the intent, a score that indicates how confident Amazon Lex V2 is that
         *        the interpretation is the correct one, and an optional sentiment response that indicates the sentiment
         *        expressed in the utterance.
         *        </p>
         *        <p>
         *        The <code>interpretations</code> field is compressed with gzip and then base64 encoded. Before you can
         *        use the contents of the field, you must decode and decompress the contents. See the example for a
         *        simple function to decode and decompress the contents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interpretations(String interpretations);

        /**
         * <p>
         * Represents the current state of the dialog between the user and the bot.
         * </p>
         * <p>
         * Use this to determine the progress of the conversation and what the next action might be.
         * </p>
         * <p>
         * The <code>sessionState</code> field is compressed with gzip and then base64 encoded. Before you can use the
         * contents of the field, you must decode and decompress the contents. See the example for a simple function to
         * decode and decompress the contents.
         * </p>
         * 
         * @param sessionState
         *        Represents the current state of the dialog between the user and the bot.</p>
         *        <p>
         *        Use this to determine the progress of the conversation and what the next action might be.
         *        </p>
         *        <p>
         *        The <code>sessionState</code> field is compressed with gzip and then base64 encoded. Before you can
         *        use the contents of the field, you must decode and decompress the contents. See the example for a
         *        simple function to decode and decompress the contents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionState(String sessionState);

        /**
         * <p>
         * The attributes sent in the request.
         * </p>
         * <p>
         * The <code>requestAttributes</code> field is compressed with gzip and then base64 encoded. Before you can use
         * the contents of the field, you must decode and decompress the contents.
         * </p>
         * 
         * @param requestAttributes
         *        The attributes sent in the request.</p>
         *        <p>
         *        The <code>requestAttributes</code> field is compressed with gzip and then base64 encoded. Before you
         *        can use the contents of the field, you must decode and decompress the contents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestAttributes(String requestAttributes);

        /**
         * <p>
         * The identifier of the session in use.
         * </p>
         * 
         * @param sessionId
         *        The identifier of the session in use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The text used to process the request.
         * </p>
         * <p>
         * If the input was an audio stream, the <code>inputTranscript</code> field contains the text extracted from the
         * audio stream. This is the text that is actually processed to recognize intents and slot values. You can use
         * this information to determine if Amazon Lex V2 is correctly processing the audio that you send.
         * </p>
         * <p>
         * The <code>inputTranscript</code> field is compressed with gzip and then base64 encoded. Before you can use
         * the contents of the field, you must decode and decompress the contents. See the example for a simple function
         * to decode and decompress the contents.
         * </p>
         * 
         * @param inputTranscript
         *        The text used to process the request.</p>
         *        <p>
         *        If the input was an audio stream, the <code>inputTranscript</code> field contains the text extracted
         *        from the audio stream. This is the text that is actually processed to recognize intents and slot
         *        values. You can use this information to determine if Amazon Lex V2 is correctly processing the audio
         *        that you send.
         *        </p>
         *        <p>
         *        The <code>inputTranscript</code> field is compressed with gzip and then base64 encoded. Before you can
         *        use the contents of the field, you must decode and decompress the contents. See the example for a
         *        simple function to decode and decompress the contents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputTranscript(String inputTranscript);
    }

    static final class BuilderImpl extends LexRuntimeV2Response.BuilderImpl implements Builder {
        private String inputMode;

        private String contentType;

        private String messages;

        private String interpretations;

        private String sessionState;

        private String requestAttributes;

        private String sessionId;

        private String inputTranscript;

        private BuilderImpl() {
        }

        private BuilderImpl(RecognizeUtteranceResponse model) {
            super(model);
            inputMode(model.inputMode);
            contentType(model.contentType);
            messages(model.messages);
            interpretations(model.interpretations);
            sessionState(model.sessionState);
            requestAttributes(model.requestAttributes);
            sessionId(model.sessionId);
            inputTranscript(model.inputTranscript);
        }

        public final String getInputMode() {
            return inputMode;
        }

        public final void setInputMode(String inputMode) {
            this.inputMode = inputMode;
        }

        @Override
        @Transient
        public final Builder inputMode(String inputMode) {
            this.inputMode = inputMode;
            return this;
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        @Transient
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getMessages() {
            return messages;
        }

        public final void setMessages(String messages) {
            this.messages = messages;
        }

        @Override
        @Transient
        public final Builder messages(String messages) {
            this.messages = messages;
            return this;
        }

        public final String getInterpretations() {
            return interpretations;
        }

        public final void setInterpretations(String interpretations) {
            this.interpretations = interpretations;
        }

        @Override
        @Transient
        public final Builder interpretations(String interpretations) {
            this.interpretations = interpretations;
            return this;
        }

        public final String getSessionState() {
            return sessionState;
        }

        public final void setSessionState(String sessionState) {
            this.sessionState = sessionState;
        }

        @Override
        @Transient
        public final Builder sessionState(String sessionState) {
            this.sessionState = sessionState;
            return this;
        }

        public final String getRequestAttributes() {
            return requestAttributes;
        }

        public final void setRequestAttributes(String requestAttributes) {
            this.requestAttributes = requestAttributes;
        }

        @Override
        @Transient
        public final Builder requestAttributes(String requestAttributes) {
            this.requestAttributes = requestAttributes;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        @Transient
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getInputTranscript() {
            return inputTranscript;
        }

        public final void setInputTranscript(String inputTranscript) {
            this.inputTranscript = inputTranscript;
        }

        @Override
        @Transient
        public final Builder inputTranscript(String inputTranscript) {
            this.inputTranscript = inputTranscript;
            return this;
        }

        @Override
        public RecognizeUtteranceResponse build() {
            return new RecognizeUtteranceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
