/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntimev2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The state of the user's session with Amazon Lex V2.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SessionState implements SdkPojo, Serializable, ToCopyableBuilder<SessionState.Builder, SessionState> {
    private static final SdkField<DialogAction> DIALOG_ACTION_FIELD = SdkField.<DialogAction> builder(MarshallingType.SDK_POJO)
            .memberName("dialogAction").getter(getter(SessionState::dialogAction)).setter(setter(Builder::dialogAction))
            .constructor(DialogAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dialogAction").build()).build();

    private static final SdkField<Intent> INTENT_FIELD = SdkField.<Intent> builder(MarshallingType.SDK_POJO).memberName("intent")
            .getter(getter(SessionState::intent)).setter(setter(Builder::intent)).constructor(Intent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intent").build()).build();

    private static final SdkField<List<ActiveContext>> ACTIVE_CONTEXTS_FIELD = SdkField
            .<List<ActiveContext>> builder(MarshallingType.LIST)
            .memberName("activeContexts")
            .getter(getter(SessionState::activeContexts))
            .setter(setter(Builder::activeContexts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeContexts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ActiveContext> builder(MarshallingType.SDK_POJO)
                                            .constructor(ActiveContext::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> SESSION_ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("sessionAttributes")
            .getter(getter(SessionState::sessionAttributes))
            .setter(setter(Builder::sessionAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ORIGINATING_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("originatingRequestId").getter(getter(SessionState::originatingRequestId))
            .setter(setter(Builder::originatingRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originatingRequestId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIALOG_ACTION_FIELD,
            INTENT_FIELD, ACTIVE_CONTEXTS_FIELD, SESSION_ATTRIBUTES_FIELD, ORIGINATING_REQUEST_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final DialogAction dialogAction;

    private final Intent intent;

    private final List<ActiveContext> activeContexts;

    private final Map<String, String> sessionAttributes;

    private final String originatingRequestId;

    private SessionState(BuilderImpl builder) {
        this.dialogAction = builder.dialogAction;
        this.intent = builder.intent;
        this.activeContexts = builder.activeContexts;
        this.sessionAttributes = builder.sessionAttributes;
        this.originatingRequestId = builder.originatingRequestId;
    }

    /**
     * <p>
     * The next step that Amazon Lex V2 should take in the conversation with a user.
     * </p>
     * 
     * @return The next step that Amazon Lex V2 should take in the conversation with a user.
     */
    public final DialogAction dialogAction() {
        return dialogAction;
    }

    /**
     * <p>
     * The active intent that Amazon Lex V2 is processing.
     * </p>
     * 
     * @return The active intent that Amazon Lex V2 is processing.
     */
    public final Intent intent() {
        return intent;
    }

    /**
     * For responses, this returns true if the service returned a value for the ActiveContexts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasActiveContexts() {
        return activeContexts != null && !(activeContexts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more contexts that indicate to Amazon Lex V2 the context of a request. When a context is active, Amazon
     * Lex V2 considers intents with the matching context as a trigger as the next intent in a session.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActiveContexts} method.
     * </p>
     * 
     * @return One or more contexts that indicate to Amazon Lex V2 the context of a request. When a context is active,
     *         Amazon Lex V2 considers intents with the matching context as a trigger as the next intent in a session.
     */
    public final List<ActiveContext> activeContexts() {
        return activeContexts;
    }

    /**
     * For responses, this returns true if the service returned a value for the SessionAttributes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSessionAttributes() {
        return sessionAttributes != null && !(sessionAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Map of key/value pairs representing session-specific context information. It contains application information
     * passed between Amazon Lex V2 and a client application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSessionAttributes} method.
     * </p>
     * 
     * @return Map of key/value pairs representing session-specific context information. It contains application
     *         information passed between Amazon Lex V2 and a client application.
     */
    public final Map<String, String> sessionAttributes() {
        return sessionAttributes;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String originatingRequestId() {
        return originatingRequestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dialogAction());
        hashCode = 31 * hashCode + Objects.hashCode(intent());
        hashCode = 31 * hashCode + Objects.hashCode(hasActiveContexts() ? activeContexts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSessionAttributes() ? sessionAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(originatingRequestId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionState)) {
            return false;
        }
        SessionState other = (SessionState) obj;
        return Objects.equals(dialogAction(), other.dialogAction()) && Objects.equals(intent(), other.intent())
                && hasActiveContexts() == other.hasActiveContexts() && Objects.equals(activeContexts(), other.activeContexts())
                && hasSessionAttributes() == other.hasSessionAttributes()
                && Objects.equals(sessionAttributes(), other.sessionAttributes())
                && Objects.equals(originatingRequestId(), other.originatingRequestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SessionState").add("DialogAction", dialogAction()).add("Intent", intent())
                .add("ActiveContexts", hasActiveContexts() ? activeContexts() : null)
                .add("SessionAttributes", hasSessionAttributes() ? sessionAttributes() : null)
                .add("OriginatingRequestId", originatingRequestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dialogAction":
            return Optional.ofNullable(clazz.cast(dialogAction()));
        case "intent":
            return Optional.ofNullable(clazz.cast(intent()));
        case "activeContexts":
            return Optional.ofNullable(clazz.cast(activeContexts()));
        case "sessionAttributes":
            return Optional.ofNullable(clazz.cast(sessionAttributes()));
        case "originatingRequestId":
            return Optional.ofNullable(clazz.cast(originatingRequestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SessionState, T> g) {
        return obj -> g.apply((SessionState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SessionState> {
        /**
         * <p>
         * The next step that Amazon Lex V2 should take in the conversation with a user.
         * </p>
         * 
         * @param dialogAction
         *        The next step that Amazon Lex V2 should take in the conversation with a user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dialogAction(DialogAction dialogAction);

        /**
         * <p>
         * The next step that Amazon Lex V2 should take in the conversation with a user.
         * </p>
         * This is a convenience that creates an instance of the {@link DialogAction.Builder} avoiding the need to
         * create one manually via {@link DialogAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link DialogAction.Builder#build()} is called immediately and its
         * result is passed to {@link #dialogAction(DialogAction)}.
         * 
         * @param dialogAction
         *        a consumer that will call methods on {@link DialogAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dialogAction(DialogAction)
         */
        default Builder dialogAction(Consumer<DialogAction.Builder> dialogAction) {
            return dialogAction(DialogAction.builder().applyMutation(dialogAction).build());
        }

        /**
         * <p>
         * The active intent that Amazon Lex V2 is processing.
         * </p>
         * 
         * @param intent
         *        The active intent that Amazon Lex V2 is processing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intent(Intent intent);

        /**
         * <p>
         * The active intent that Amazon Lex V2 is processing.
         * </p>
         * This is a convenience that creates an instance of the {@link Intent.Builder} avoiding the need to create one
         * manually via {@link Intent#builder()}.
         *
         * When the {@link Consumer} completes, {@link Intent.Builder#build()} is called immediately and its result is
         * passed to {@link #intent(Intent)}.
         * 
         * @param intent
         *        a consumer that will call methods on {@link Intent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #intent(Intent)
         */
        default Builder intent(Consumer<Intent.Builder> intent) {
            return intent(Intent.builder().applyMutation(intent).build());
        }

        /**
         * <p>
         * One or more contexts that indicate to Amazon Lex V2 the context of a request. When a context is active,
         * Amazon Lex V2 considers intents with the matching context as a trigger as the next intent in a session.
         * </p>
         * 
         * @param activeContexts
         *        One or more contexts that indicate to Amazon Lex V2 the context of a request. When a context is
         *        active, Amazon Lex V2 considers intents with the matching context as a trigger as the next intent in a
         *        session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeContexts(Collection<ActiveContext> activeContexts);

        /**
         * <p>
         * One or more contexts that indicate to Amazon Lex V2 the context of a request. When a context is active,
         * Amazon Lex V2 considers intents with the matching context as a trigger as the next intent in a session.
         * </p>
         * 
         * @param activeContexts
         *        One or more contexts that indicate to Amazon Lex V2 the context of a request. When a context is
         *        active, Amazon Lex V2 considers intents with the matching context as a trigger as the next intent in a
         *        session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeContexts(ActiveContext... activeContexts);

        /**
         * <p>
         * One or more contexts that indicate to Amazon Lex V2 the context of a request. When a context is active,
         * Amazon Lex V2 considers intents with the matching context as a trigger as the next intent in a session.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ActiveContext>.Builder} avoiding the need
         * to create one manually via {@link List<ActiveContext>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ActiveContext>.Builder#build()} is called immediately and
         * its result is passed to {@link #activeContexts(List<ActiveContext>)}.
         * 
         * @param activeContexts
         *        a consumer that will call methods on {@link List<ActiveContext>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activeContexts(List<ActiveContext>)
         */
        Builder activeContexts(Consumer<ActiveContext.Builder>... activeContexts);

        /**
         * <p>
         * Map of key/value pairs representing session-specific context information. It contains application information
         * passed between Amazon Lex V2 and a client application.
         * </p>
         * 
         * @param sessionAttributes
         *        Map of key/value pairs representing session-specific context information. It contains application
         *        information passed between Amazon Lex V2 and a client application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionAttributes(Map<String, String> sessionAttributes);

        /**
         * <p/>
         * 
         * @param originatingRequestId
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originatingRequestId(String originatingRequestId);
    }

    static final class BuilderImpl implements Builder {
        private DialogAction dialogAction;

        private Intent intent;

        private List<ActiveContext> activeContexts = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> sessionAttributes = DefaultSdkAutoConstructMap.getInstance();

        private String originatingRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(SessionState model) {
            dialogAction(model.dialogAction);
            intent(model.intent);
            activeContexts(model.activeContexts);
            sessionAttributes(model.sessionAttributes);
            originatingRequestId(model.originatingRequestId);
        }

        public final DialogAction.Builder getDialogAction() {
            return dialogAction != null ? dialogAction.toBuilder() : null;
        }

        public final void setDialogAction(DialogAction.BuilderImpl dialogAction) {
            this.dialogAction = dialogAction != null ? dialogAction.build() : null;
        }

        @Override
        @Transient
        public final Builder dialogAction(DialogAction dialogAction) {
            this.dialogAction = dialogAction;
            return this;
        }

        public final Intent.Builder getIntent() {
            return intent != null ? intent.toBuilder() : null;
        }

        public final void setIntent(Intent.BuilderImpl intent) {
            this.intent = intent != null ? intent.build() : null;
        }

        @Override
        @Transient
        public final Builder intent(Intent intent) {
            this.intent = intent;
            return this;
        }

        public final List<ActiveContext.Builder> getActiveContexts() {
            List<ActiveContext.Builder> result = ActiveContextsListCopier.copyToBuilder(this.activeContexts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActiveContexts(Collection<ActiveContext.BuilderImpl> activeContexts) {
            this.activeContexts = ActiveContextsListCopier.copyFromBuilder(activeContexts);
        }

        @Override
        @Transient
        public final Builder activeContexts(Collection<ActiveContext> activeContexts) {
            this.activeContexts = ActiveContextsListCopier.copy(activeContexts);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder activeContexts(ActiveContext... activeContexts) {
            activeContexts(Arrays.asList(activeContexts));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder activeContexts(Consumer<ActiveContext.Builder>... activeContexts) {
            activeContexts(Stream.of(activeContexts).map(c -> ActiveContext.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getSessionAttributes() {
            if (sessionAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return sessionAttributes;
        }

        public final void setSessionAttributes(Map<String, String> sessionAttributes) {
            this.sessionAttributes = StringMapCopier.copy(sessionAttributes);
        }

        @Override
        @Transient
        public final Builder sessionAttributes(Map<String, String> sessionAttributes) {
            this.sessionAttributes = StringMapCopier.copy(sessionAttributes);
            return this;
        }

        public final String getOriginatingRequestId() {
            return originatingRequestId;
        }

        public final void setOriginatingRequestId(String originatingRequestId) {
            this.originatingRequestId = originatingRequestId;
        }

        @Override
        @Transient
        public final Builder originatingRequestId(String originatingRequestId) {
            this.originatingRequestId = originatingRequestId;
            return this;
        }

        @Override
        public SessionState build() {
            return new SessionState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
