/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntimev2.model.startconversationresponseeventstream;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.lexruntimev2.model.StartConversationResponseEventStream;
import software.amazon.awssdk.services.lexruntimev2.model.StartConversationResponseHandler;
import software.amazon.awssdk.services.lexruntimev2.model.TranscriptEvent;

/**
 * A specialization of {@code software.amazon.awssdk.services.lexruntimev2.model.TranscriptEvent} that represents the
 * {@code StartConversationResponseEventStream$TranscriptEvent} event. Do not use this class directly. Instead, use the
 * static builder methods on
 * {@link software.amazon.awssdk.services.lexruntimev2.model.StartConversationResponseEventStream}.
 */
@SdkInternalApi
@Generated("software.amazon.awssdk:codegen")
public final class DefaultTranscriptEvent extends TranscriptEvent {
    private static final long serialVersionUID = 1L;

    DefaultTranscriptEvent(BuilderImpl builderImpl) {
        super(builderImpl);
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    @Override
    public void accept(StartConversationResponseHandler.Visitor visitor) {
        visitor.visitTranscriptEvent(this);
    }

    @Override
    public StartConversationResponseEventStream.EventType sdkEventType() {
        return StartConversationResponseEventStream.EventType.TRANSCRIPT_EVENT;
    }

    public interface Builder extends TranscriptEvent.Builder {
        @Override
        DefaultTranscriptEvent build();
    }

    private static final class BuilderImpl extends TranscriptEvent.BuilderImpl implements Builder {
        private BuilderImpl() {
        }

        private BuilderImpl(DefaultTranscriptEvent event) {
            super(event);
        }

        @Override
        public DefaultTranscriptEvent build() {
            return new DefaultTranscriptEvent(this);
        }
    }
}
