/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntimev2.model;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;

@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultStartConversationVisitorBuilder implements StartConversationResponseHandler.Visitor.Builder {
    private Consumer<StartConversationResponseEventStream> onDefault;

    private Consumer<PlaybackInterruptionEvent> onPlaybackInterruptionEvent;

    private Consumer<TranscriptEvent> onTranscriptEvent;

    private Consumer<IntentResultEvent> onIntentResultEvent;

    private Consumer<TextResponseEvent> onTextResponseEvent;

    private Consumer<AudioResponseEvent> onAudioResponseEvent;

    private Consumer<HeartbeatEvent> onHeartbeatEvent;

    @Override
    public StartConversationResponseHandler.Visitor.Builder onDefault(Consumer<StartConversationResponseEventStream> c) {
        this.onDefault = c;
        return this;
    }

    @Override
    public StartConversationResponseHandler.Visitor build() {
        return new VisitorFromBuilder(this);
    }

    @Override
    public StartConversationResponseHandler.Visitor.Builder onPlaybackInterruptionEvent(Consumer<PlaybackInterruptionEvent> c) {
        this.onPlaybackInterruptionEvent = c;
        return this;
    }

    @Override
    public StartConversationResponseHandler.Visitor.Builder onTranscriptEvent(Consumer<TranscriptEvent> c) {
        this.onTranscriptEvent = c;
        return this;
    }

    @Override
    public StartConversationResponseHandler.Visitor.Builder onIntentResultEvent(Consumer<IntentResultEvent> c) {
        this.onIntentResultEvent = c;
        return this;
    }

    @Override
    public StartConversationResponseHandler.Visitor.Builder onTextResponseEvent(Consumer<TextResponseEvent> c) {
        this.onTextResponseEvent = c;
        return this;
    }

    @Override
    public StartConversationResponseHandler.Visitor.Builder onAudioResponseEvent(Consumer<AudioResponseEvent> c) {
        this.onAudioResponseEvent = c;
        return this;
    }

    @Override
    public StartConversationResponseHandler.Visitor.Builder onHeartbeatEvent(Consumer<HeartbeatEvent> c) {
        this.onHeartbeatEvent = c;
        return this;
    }

    @Generated("software.amazon.awssdk:codegen")
    static class VisitorFromBuilder implements StartConversationResponseHandler.Visitor {
        private final Consumer<StartConversationResponseEventStream> onDefault;

        private final Consumer<PlaybackInterruptionEvent> onPlaybackInterruptionEvent;

        private final Consumer<TranscriptEvent> onTranscriptEvent;

        private final Consumer<IntentResultEvent> onIntentResultEvent;

        private final Consumer<TextResponseEvent> onTextResponseEvent;

        private final Consumer<AudioResponseEvent> onAudioResponseEvent;

        private final Consumer<HeartbeatEvent> onHeartbeatEvent;

        VisitorFromBuilder(DefaultStartConversationVisitorBuilder builder) {
            this.onDefault = builder.onDefault != null ? builder.onDefault
                    : StartConversationResponseHandler.Visitor.super::visitDefault;
            this.onPlaybackInterruptionEvent = builder.onPlaybackInterruptionEvent != null ? builder.onPlaybackInterruptionEvent
                    : StartConversationResponseHandler.Visitor.super::visitPlaybackInterruptionEvent;
            this.onTranscriptEvent = builder.onTranscriptEvent != null ? builder.onTranscriptEvent
                    : StartConversationResponseHandler.Visitor.super::visitTranscriptEvent;
            this.onIntentResultEvent = builder.onIntentResultEvent != null ? builder.onIntentResultEvent
                    : StartConversationResponseHandler.Visitor.super::visitIntentResultEvent;
            this.onTextResponseEvent = builder.onTextResponseEvent != null ? builder.onTextResponseEvent
                    : StartConversationResponseHandler.Visitor.super::visitTextResponseEvent;
            this.onAudioResponseEvent = builder.onAudioResponseEvent != null ? builder.onAudioResponseEvent
                    : StartConversationResponseHandler.Visitor.super::visitAudioResponseEvent;
            this.onHeartbeatEvent = builder.onHeartbeatEvent != null ? builder.onHeartbeatEvent
                    : StartConversationResponseHandler.Visitor.super::visitHeartbeatEvent;
        }

        @Override
        public void visitDefault(StartConversationResponseEventStream event) {
            onDefault.accept(event);
        }

        @Override
        public void visitPlaybackInterruptionEvent(PlaybackInterruptionEvent event) {
            onPlaybackInterruptionEvent.accept(event);
        }

        @Override
        public void visitTranscriptEvent(TranscriptEvent event) {
            onTranscriptEvent.accept(event);
        }

        @Override
        public void visitIntentResultEvent(IntentResultEvent event) {
            onIntentResultEvent.accept(event);
        }

        @Override
        public void visitTextResponseEvent(TextResponseEvent event) {
            onTextResponseEvent.accept(event);
        }

        @Override
        public void visitAudioResponseEvent(AudioResponseEvent event) {
            onAudioResponseEvent.accept(event);
        }

        @Override
        public void visitHeartbeatEvent(HeartbeatEvent event) {
            onHeartbeatEvent.accept(event);
        }
    }
}
