/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntimev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteSessionResponse extends LexRuntimeV2Response implements
        ToCopyableBuilder<DeleteSessionResponse.Builder, DeleteSessionResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(DeleteSessionResponse::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<String> BOT_ALIAS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botAliasId").getter(getter(DeleteSessionResponse::botAliasId)).setter(setter(Builder::botAliasId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAliasId").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(DeleteSessionResponse::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(DeleteSessionResponse::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            BOT_ALIAS_ID_FIELD, LOCALE_ID_FIELD, SESSION_ID_FIELD));

    private final String botId;

    private final String botAliasId;

    private final String localeId;

    private final String sessionId;

    private DeleteSessionResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botAliasId = builder.botAliasId;
        this.localeId = builder.localeId;
        this.sessionId = builder.sessionId;
    }

    /**
     * <p>
     * The identifier of the bot that contained the session data.
     * </p>
     * 
     * @return The identifier of the bot that contained the session data.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The alias identifier in use for the bot that contained the session data.
     * </p>
     * 
     * @return The alias identifier in use for the bot that contained the session data.
     */
    public final String botAliasId() {
        return botAliasId;
    }

    /**
     * <p>
     * The locale where the session was used.
     * </p>
     * 
     * @return The locale where the session was used.
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * <p>
     * The identifier of the deleted session.
     * </p>
     * 
     * @return The identifier of the deleted session.
     */
    public final String sessionId() {
        return sessionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botAliasId());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteSessionResponse)) {
            return false;
        }
        DeleteSessionResponse other = (DeleteSessionResponse) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botAliasId(), other.botAliasId())
                && Objects.equals(localeId(), other.localeId()) && Objects.equals(sessionId(), other.sessionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteSessionResponse").add("BotId", botId()).add("BotAliasId", botAliasId())
                .add("LocaleId", localeId()).add("SessionId", sessionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botAliasId":
            return Optional.ofNullable(clazz.cast(botAliasId()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteSessionResponse, T> g) {
        return obj -> g.apply((DeleteSessionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexRuntimeV2Response.Builder, SdkPojo, CopyableBuilder<Builder, DeleteSessionResponse> {
        /**
         * <p>
         * The identifier of the bot that contained the session data.
         * </p>
         * 
         * @param botId
         *        The identifier of the bot that contained the session data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The alias identifier in use for the bot that contained the session data.
         * </p>
         * 
         * @param botAliasId
         *        The alias identifier in use for the bot that contained the session data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAliasId(String botAliasId);

        /**
         * <p>
         * The locale where the session was used.
         * </p>
         * 
         * @param localeId
         *        The locale where the session was used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * The identifier of the deleted session.
         * </p>
         * 
         * @param sessionId
         *        The identifier of the deleted session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);
    }

    static final class BuilderImpl extends LexRuntimeV2Response.BuilderImpl implements Builder {
        private String botId;

        private String botAliasId;

        private String localeId;

        private String sessionId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteSessionResponse model) {
            super(model);
            botId(model.botId);
            botAliasId(model.botAliasId);
            localeId(model.localeId);
            sessionId(model.sessionId);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotAliasId() {
            return botAliasId;
        }

        public final void setBotAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
        }

        @Override
        public final Builder botAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
            return this;
        }

        public final String getLocaleId() {
            return localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Override
        public DeleteSessionResponse build() {
            return new DeleteSessionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
